/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.converter.ArticlePriceContractStateConverter;
import ch.icit.pegasus.client.converter.ArticlePriceModificationStateEConverter;
import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.DateUnitEConverter;
import ch.icit.pegasus.client.converter.DeletedStateEConverter;
import ch.icit.pegasus.client.converter.FlightStateEConverter;
import ch.icit.pegasus.client.converter.InUseStateEConverter;
import ch.icit.pegasus.client.converter.InventoryStateEConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.NominatedStateEConverter;
import ch.icit.pegasus.client.converter.OrderPricingStateConverter;
import ch.icit.pegasus.client.converter.ProductTypeCompleteConverter;
import ch.icit.pegasus.client.converter.SafetyStockStateEConverter;
import ch.icit.pegasus.client.converter.TWMInvoiceReviewStateConverter;
import ch.icit.pegasus.client.converter.ThreeWayMatchStateConverter;
import ch.icit.pegasus.client.converter.TimeUnitEConverter;
import ch.icit.pegasus.client.converter.WeeklyPlanStoreTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.enums.DeleteStateE;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.FlightStateComboBox;
import ch.icit.pegasus.client.gui.utils.panels.KitchenForecastConfigPanel_ComboStyle;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentDecisionE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.RetailInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoCalculationStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPricingStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalStateE;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockStateE;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanStoreTypeE;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.ArticleHalalStateE;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceReviewStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeStateE;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.CalendarDateE;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.dtos.util.NominatedStateE;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ComboBoxFactory {
    public static ComboBox getInUseComboBox(boolean withAll) {
        ComboBox inUseOnly = new ComboBox();
        if (withAll) {
            inUseOnly.addItem(Words.ALL);
        }
        inUseOnly.addItem(Words.USE_ONLY);
        inUseOnly.addItem(Words.NOT_USE_ONLY);
        return inUseOnly;
    }

    public static ComboBox getInUseNodeComboBox(Node<InUseStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(InUseStateE.class), ConverterRegistry.getConverter(InUseStateEConverter.class));
        return b;
    }

    public static ComboBox getBondedComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(BondedStateE.ALL);
        }
        b.addItem(BondedStateE.NOT_BONDED);
        b.addItem(BondedStateE.ONLY_BONDED);
        return b;
    }

    public static ComboBox getNodeBondedComboBox(Node<BondedStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class));
        return b;
    }

    public static ComboBox getHasSubstitutions(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.NO_SUBSTITUTIONS);
        b.addItem(Words.HAS_SUBSTITUTIONS);
        return b;
    }

    public static ComboBox getNominatedComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.NOMINATED_ONLY);
        b.addItem(Words.NOT_NOMINATED);
        return b;
    }

    public static ComboBox getCustomerOwned(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.CUSTOMER_OWNED);
        b.addItem(Words.NOT_CUSTOMER_OWNED);
        return b;
    }

    public static ComboBox getHalal(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.HALAL_ONLY);
        b.addItem(Words.NOT_HALAL_ONLY);
        return b;
    }

    public static ComboBox getHalalCertificationState(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (ArticleHalalStateE value : ArticleHalalStateE.values()) {
            b.addItem(value);
        }
        return b;
    }

    public static ComboBox getArticleStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (ArticleModificationStateE articlePriceModificationStateE : ArticleModificationStateE.values()) {
            b.addItem(articlePriceModificationStateE.toString());
        }
        return b;
    }

    public static ComboBox getNodeNominatedComboBox(Node<NominatedStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(NominatedStateE.class), ConverterRegistry.getConverter(NominatedStateEConverter.class));
        return b;
    }

    public static ComboBox getDeletedComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(DeleteStateE.ALL);
        }
        b.addItem(DeleteStateE.DELETED);
        b.addItem(DeleteStateE.NOT_DELETED);
        return b;
    }

    public static ComboBox getNodeDeletedComboBox(Node<DeletedStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(DeletedStateE.class), ConverterRegistry.getConverter(DeletedStateEConverter.class));
        return b;
    }

    public static ComboBox getArticleContractStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(ArticlePriceContractStateE.PLANNED);
        b.addItem(ArticlePriceContractStateE.EXPORTED);
        b.addItem(ArticlePriceContractStateE.IMPORTED);
        b.addItem(ArticlePriceContractStateE.ACCPTED);
        return b;
    }

    public static ComboBox getNodeArticleContractStateComboBox(Node<ArticlePriceContractStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(ArticlePriceContractStateE.class), ConverterRegistry.getConverter(ArticlePriceContractStateConverter.class));
        return b;
    }

    public static ComboBox getNodeWeeklyPlanStoreTypeComboBox(Node<WeeklyPlanStoreTypeE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(WeeklyPlanStoreTypeE.class), ConverterRegistry.getConverter(WeeklyPlanStoreTypeConverter.class), true);
        return b;
    }

    public static ComboBox getArticlePriceCalculationStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(ArticlePriceModificationStateE.DRAFT);
        b.addItem(ArticlePriceModificationStateE.ACCEPTED);
        b.addItem(ArticlePriceModificationStateE.UPDATED);
        return b;
    }

    public static ComboBox getNodeArticlePriceCalculationStateComboBox(Node<ArticlePriceModificationStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(ArticlePriceModificationStateE.class), ConverterRegistry.getConverter(ArticlePriceModificationStateEConverter.class));
        return b;
    }

    public static ComboBox getStowageTypeComboBox(boolean withAll) {
        ComboBox stowageTypeCombo = new ComboBox();
        if (withAll) {
            stowageTypeCombo.addItem(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL);
        }
        stowageTypeCombo.addItem(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.REGULAR);
        stowageTypeCombo.addItem(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.SALES_ON_BOARD);
        return stowageTypeCombo;
    }

    public static ComboBox getYesNoComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.YES);
        b.addItem(Words.NO_ANSWER);
        return b;
    }

    public static ComboBox getOffOnComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.OFF);
        b.addItem(Words.ON);
        return b;
    }

    public static ComboBox getApprovedComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.APPROVED_SUM);
        b.addItem(Words.NOT_APPROVED);
        return b;
    }

    public static ComboBox getFlightStateComboBox(boolean withAll) {
        FlightStateComboBox stateCombo = new FlightStateComboBox();
        if (withAll) {
            stateCombo.addItem(Words.ALL);
        }
        stateCombo.addItem(FlightStateE.OPEN);
        stateCombo.addItem(FlightStateE.PLANNED);
        stateCombo.addItem(FlightStateE.EN_ROUTE);
        stateCombo.addItem(FlightStateE.DISPATCHED);
        stateCombo.addItem(FlightStateE.CANCELLED);
        stateCombo.addItem(FlightStateE.CLOSED);
        stateCombo.addItem(Words.ALL_EXCEPT_PLANNED);
        stateCombo.addItem(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED);
        return stateCombo;
    }

    public static ComboBox getFlightStateComboBoxWithoutPlanned() {
        FlightStateComboBox stateCombo = new FlightStateComboBox();
        stateCombo.addItem(FlightStateE.OPEN);
        stateCombo.addItem(FlightStateE.EN_ROUTE);
        stateCombo.addItem(FlightStateE.DISPATCHED);
        stateCombo.addItem(FlightStateE.CANCELLED);
        stateCombo.addItem(FlightStateE.CLOSED);
        stateCombo.addItem(Words.ALL_EXCEPT_PLANNED);
        stateCombo.addItem(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED);
        return stateCombo;
    }

    public static ComboBox getRetailStateComboBox(boolean withAll) {
        FlightStateComboBox stateCombo = new FlightStateComboBox();
        if (withAll) {
            stateCombo.addItem(Words.ALL);
        }
        stateCombo.addItem(FlightStateE.OPEN);
        stateCombo.addItem(FlightStateE.CANCELLED);
        stateCombo.addItem(FlightStateE.CLOSED);
        return stateCombo;
    }

    public static ComboBox getRetailInvoiceStateComboBox(boolean withAll) {
        FlightStateComboBox stateCombo = new FlightStateComboBox();
        if (withAll) {
            stateCombo.addItem(Words.ALL);
        }
        stateCombo.addItem(RetailInvoiceStateE.CLOSED);
        stateCombo.addItem(RetailInvoiceStateE.NOT_CLOSED);
        stateCombo.addItem(RetailInvoiceStateE.SENT);
        stateCombo.addItem(RetailInvoiceStateE.NOT_SENT);
        return stateCombo;
    }

    public static ComboBox getNodeFlightStateComboBox(Node<FlightStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(FlightStateE.class), ConverterRegistry.getConverter(FlightStateEConverter.class));
        return b;
    }

    public static ComboBox getModificationStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(ModificationStateE.ACCEPTED);
        b.addItem(ModificationStateE.DRAFT);
        return b;
    }

    public static ComboBox getSafetyStockStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(SafetyStockStateE.ACCEPTED);
        b.addItem(SafetyStockStateE.CALCULATED);
        b.addItem(SafetyStockStateE.PLANNED);
        return b;
    }

    public static ComboBox getNodeModificationStateComboBox(Node<ModificationStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(ModificationStateE.class), ConverterRegistry.getConverter(ModificationStateEConverter.class));
        return b;
    }

    public static ComboBox getNodeSafetyStockStateComboBox(Node<SafetyStockStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(SafetyStockStateE.class), ConverterRegistry.getConverter(SafetyStockStateEConverter.class));
        return b;
    }

    public static ComboBox getInventoryStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(InventoryStateE.PLANNED);
        b.addItem(InventoryStateE.STARTED);
        b.addItem(InventoryStateE.COUNTED);
        b.addItem(InventoryStateE.APPROVED);
        return b;
    }

    public static ComboBox getNodeInventoryStateComboBox(Node<InventoryStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(InventoryStateE.class), ConverterRegistry.getConverter(InventoryStateEConverter.class));
        return b;
    }

    public static ComboBox getThreeWayMatchStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(TWMModificationStateE.DRAFT);
        b.addItem(TWMModificationStateE.IN_PROGRESS);
        b.addItem(TWMModificationStateE.ACCEPTED);
        return b;
    }

    public static ComboBox getNodeThreeWayMatchStateComboBox(Node<TWMModificationStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(TWMModificationStateE.class), ConverterRegistry.getConverter(ThreeWayMatchStateConverter.class));
        return b;
    }

    public static ComboBox getNodeTWMInvoiceReviewStateComboBox(Node<TWMInvoiceReviewStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(TWMInvoiceReviewStateE.class), ConverterRegistry.getConverter(TWMInvoiceReviewStateConverter.class));
        return b;
    }

    public static ComboBox getInvoiceStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(InvoiceStateE.PLANNED);
        b.addItem(InvoiceStateE.CHECKED);
        b.addItem(InvoiceStateE.CLOSED);
        b.addItem(InvoiceStateE.CANCELLED);
        b.addItem(InvoiceStateE.CREDIT_NOTE);
        return b;
    }

    public static ComboBox getInvoiceTypeComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (InvoiceTypeE typeE : InvoiceTypeE.values()) {
            b.addItem(typeE);
        }
        return b;
    }

    public static ComboBox getNodeProductTypeCompleteComboBox(Node<InvoiceStateE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(ProductTypeComplete.class), ConverterRegistry.getConverter(ProductTypeCompleteConverter.class));
        return b;
    }

    public static ComboBox getProductCatalogTypeComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.ALA_CARTE);
        b.addItem(Words.SPML);
        b.addItem(Words.REGULAR);
        return b;
    }

    public static ComboBox getProductTypeComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.RECIPE);
        b.addItem(Words.ARTICLE);
        return b;
    }

    public static ComboBox getCountedComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.COUNTED_ONLY);
        b.addItem(Words.UNCOUNTED_ONLY);
        return b;
    }

    public static ComboBox getOrderStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.PLACED);
        b.addItem(Words.PENDING);
        b.addItem(Words.CLOSED);
        b.addItem(Words.CANCELLED);
        b.addItem(Words.CANCELED_OR_CLOSED);
        b.addItem(Words.OPEN_ORDER);
        return b;
    }

    public static ComboBox getOrderApprovalState(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (PurchaseApprovalStateE value : PurchaseApprovalStateE.values()) {
            b.addItem(value.toString());
        }
        return b;
    }

    public static ComboBox getPurchaseOrderReviewStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(OrderReviewStateE.UNCHECKED);
        b.addItem(OrderReviewStateE.APPROVED);
        b.addItem(OrderReviewStateE.NOT_APPROVED);
        return b;
    }

    public static ComboBox getPurchaseOrderPricingStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(OrderPricingStateE.UNCHECKED);
        b.addItem(OrderPricingStateE.IN_REVIEW);
        b.addItem(OrderPricingStateE.OK_WITH_SAVE);
        b.addItem(OrderPricingStateE.OK_WITH_MORE);
        return b;
    }

    public static ComboBox getNodePurchaseOrderPricingStateComboBox(Node<OrderPricingStateE> node, boolean withAll) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(OrderPricingStateE.class), ConverterRegistry.getConverter(OrderPricingStateConverter.class));
        return b;
    }

    public static ComboBox getStoreTypeComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(StoreTypeE.CIRCULATION);
        b.addItem(StoreTypeE.CONSUMPTION);
        b.addItem(StoreTypeE.WASTE_WITHOUT_CONSUMPTION);
        b.addItem(StoreTypeE.WASTE_WITH_CONSUMPTION);
        b.addItem(StoreTypeE.IRREGULARITY);
        b.addItem(StoreTypeE.NORMAL);
        return b;
    }

    public static ComboBox getJobType(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (JobType value : JobType.values()) {
            b.addItem(value);
        }
        return b;
    }

    public static ComboBox getJobDone(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.CLOSED);
        b.addItem(Words.OPEN);
        return b;
    }

    public static ComboBox getReturnCountStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(ReturnsCountStateE.COUNTING_COMPLETE);
        b.addItem(ReturnsCountStateE.NOT_COUNTED);
        b.addItem(ReturnsCountStateE.PARTIALLY_COUNTED);
        return b;
    }

    public static ComboBox getSobIRStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.IRREGULARITY_ONLY);
        b.addItem(Words.NO_IRREGULARITY);
        return b;
    }

    public static ComboBox getSobDataUploadStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(WordsToolkit.toCapitalLetter((String)Words.NONE));
        b.addItem(Words.SENT);
        b.addItem(Words.RECEIVED);
        return b;
    }

    public static ComboBox getDurationPopup(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(DateUnitE.DAY);
        b.addItem(DateUnitE.MONTH);
        b.addItem(DateUnitE.WEEK);
        b.addItem(DateUnitE.YEAR);
        return b;
    }

    public static ComboBox getWeeklyDayPopup(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.insertItemAt(DayOfWeekE.MONDAY, 0);
        b.insertItemAt(DayOfWeekE.TUESDAY, 1);
        b.insertItemAt(DayOfWeekE.WEDNESDAY, 2);
        b.insertItemAt(DayOfWeekE.THURSDAY, 3);
        b.insertItemAt(DayOfWeekE.FRIDAY, 4);
        b.insertItemAt(DayOfWeekE.SATURDAY, 5);
        b.insertItemAt(DayOfWeekE.SUNDAY, 6);
        return b;
    }

    public static ComboBox getCalendarDatePopup(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.insertItemAt(CalendarDateE.YESTERDAY, 0);
        b.insertItemAt(CalendarDateE.LAST_SEVEN_DAYS, 1);
        b.insertItemAt(CalendarDateE.LAST_WEEK, 2);
        b.insertItemAt(CalendarDateE.LAST_MONTH, 3);
        b.insertItemAt(CalendarDateE.LAST_THREE_MONTH, 4);
        b.insertItemAt(CalendarDateE.LAST_TWELVE_MONTH, 5);
        return b;
    }

    public static ComboBox getNodeDurationComboBox(Node<DateUnitE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(DateUnitE.class), ConverterRegistry.getConverter(DateUnitEConverter.class));
        return b;
    }

    public static ComboBox getNodeTimeDurationComboBox(Node<TimeUnitE> node) {
        ComboBox b = new ComboBox(node, NodeToolkit.getAffixList(TimeUnitE.class), ConverterRegistry.getConverter(TimeUnitEConverter.class));
        return b;
    }

    public static ComboBox getTimeDurationComboBox(Node<TimeUnitE> node, boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(TimeUnitE.NANOSECOND);
        b.addItem(TimeUnitE.MILLISECOND);
        b.addItem(TimeUnitE.SECOND);
        b.addItem(TimeUnitE.MINUTE);
        b.addItem(TimeUnitE.HOUR);
        return b;
    }

    public static ComboBox getDayOfMonthFixtime() {
        ComboBox b = new ComboBox();
        b.addItem(DayOfMonthE.FIFTH);
        b.addItem(DayOfMonthE.FOURTH);
        b.addItem(DayOfMonthE.THIRD);
        b.addItem(DayOfMonthE.SECOND);
        b.addItem(DayOfMonthE.FIRST);
        b.addItem(DayOfMonthE.LAST);
        return b;
    }

    public static ComboBox getTimeDurationComboBoxWithoutSeconds(Node<TimeUnitE> node, boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(TimeUnitE.MINUTE);
        b.addItem(TimeUnitE.HOUR);
        return b;
    }

    public static ComboBox getMatDispoStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        for (MatDispoCalculationStateE value : MatDispoCalculationStateE.values()) {
            b.addItem(value);
        }
        return b;
    }

    public static ComboBox getAISPrintNeededComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.NO_CHANGES);
        b.addItem(Words.HAS_CHANGES);
        return b;
    }

    public static ComboBox getRetailInMotionStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.NOT_ALL_MATCHED);
        return b;
    }

    public static ComboBox getArticleSwapStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.NOT_ALL_MATCHED);
        return b;
    }

    public static ComboBox getArticleSwapStateComboBox2(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.PERFORMED);
        b.addItem(Words.NOT_PERFORMED);
        return b;
    }

    public static ComboBox getArticleStockSwapStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.NOT_ALL_MATCHED);
        return b;
    }

    public static ComboBox getArticleStockSwapStateComboBox2(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.PERFORMED);
        b.addItem(Words.NOT_PERFORMED);
        return b;
    }

    public static ComboBox getArticleStockSwapStateComboBox3(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.STOCK_LOADED);
        b.addItem(Words.NOT_STOCK_LOADED);
        return b;
    }

    public static ComboBox getPickNPayStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.NOT_ALL_MATCHED);
        return b;
    }

    public static ComboBox getEdelweissStateComboBox(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.NOT_ALL_MATCHED);
        return b;
    }

    public static ComboBox getKitchenForecastTypeCombo(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        block5: for (KitchenForecastConfigPanel_ComboStyle.KitchenForecastType t : KitchenForecastConfigPanel_ComboStyle.KitchenForecastType.values()) {
            switch (t) {
                case PRODUCT: 
                case COMPONENT: 
                case ARTICLE: 
                case RECIPE: 
                case RECIPE_EXCEL: 
                case PRODUCTION_MAN_MINUTES: 
                case ARTICLE_USAGE: 
                case KITCHEN_READY_TIME: 
                case PRODUCTS_BY_FLIGHT: {
                    b.addItem(t);
                    continue block5;
                }
                case RECIPE_HACCP0304: 
                case COMPONENT_HACCP05: 
                case HACCP05: {
                    if (!Boolean.TRUE.equals(settings.getUseLsgQuality())) continue block5;
                    b.addItem(t);
                    continue block5;
                }
                case RECIPE_CCP0102: 
                case OPRP05: 
                case COMPONENT_OPRP05: {
                    if (!Boolean.TRUE.equals(settings.getUseGateGourmetQuality())) continue block5;
                    b.addItem(t);
                }
            }
        }
        return b;
    }

    public static ComboBox getKitchenForecastRecipeSelectionTypeComboBox() {
        ComboBox b = new ComboBox();
        for (KitchenForecastConfigPanel_ComboStyle.KitchenForecastRecipeTypeSelection t : KitchenForecastConfigPanel_ComboStyle.KitchenForecastRecipeTypeSelection.values()) {
            b.addItem(t);
        }
        return b;
    }

    public static ComboBox getProductTenderType(boolean all) {
        ComboBox b = new ComboBox();
        b.addItem(Words.PRODUCTIVE);
        b.addItem(Words.TENDER);
        if (all) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static ComboBox getPeriodTypeComboBox() {
        ComboBox b = new ComboBox();
        b.addItem(Words.BY_PERIOD);
        b.addItem(Words.BY_DATE);
        return b;
    }

    public static ComboBox getRequisitionReceiveStateBox() {
        ComboBox b = new ComboBox();
        b.addItem(OrderStateE.PLACED);
        b.addItem(OrderStateE.PENDING);
        b.addItem(OrderStateE.RECEIVED);
        b.addItem(Words.ALL);
        return b;
    }

    public static ComboBox getRequisitionDeliverStateBox() {
        ComboBox b = new ComboBox();
        b.addItem(OrderStateE.PLACED);
        b.addItem(OrderStateE.PENDING);
        b.addItem(OrderStateE.DELIVERED);
        b.addItem(Words.ALL);
        return b;
    }

    public static ComboBox getInternalConsumptionState(boolean withAll) {
        ComboBox b = new ComboBox();
        b.addItem(InternalConsumptionStateE.NOTHING);
        b.addItem(InternalConsumptionStateE.PARTLY);
        b.addItem(InternalConsumptionStateE.COMPLETE);
        if (withAll) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static ComboBox getIncidentState(boolean withAll) {
        ComboBox b = new ComboBox();
        for (IncidentStateE value : IncidentStateE.values()) {
            b.addItem(value);
        }
        if (withAll) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static ComboBox getKnifeState(boolean withAll) {
        ComboBox b = new ComboBox();
        for (KnifeStateE value : KnifeStateE.values()) {
            b.addItem(value);
        }
        if (withAll) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static ComboBox getIncidentType(boolean withAll) {
        ComboBox b = new ComboBox();
        for (IncidentTypeE value : IncidentTypeE.values()) {
            b.addItem(value);
        }
        if (withAll) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static ComboBox getIncidentDecision(boolean withAll) {
        ComboBox b = new ComboBox();
        for (IncidentDecisionE value : IncidentDecisionE.values()) {
            b.addItem(value);
        }
        if (withAll) {
            b.addItem(Words.ALL);
        }
        return b;
    }

    public static Node<List<CostCenterComplete>> filterDepartmentsALL(Node<List<CostCenterComplete>> affixList, Node currentSelection, DepartmentType type) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        for (CostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!(internalCostCenterComplete instanceof InternalCostCenterComplete)) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add((InternalCostCenterComplete)internalCostCenterComplete);
        }
        return ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)list, (Node<InternalCostCenterComplete>)currentSelection, type);
    }

    public static Node filterDepartmentsAll(Node affixList, Node currentSelection, DepartmentType type) {
        return ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)affixList, (Node<InternalCostCenterComplete>)currentSelection, type);
    }

    public static Node filterDepartments(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection, DepartmentType type) {
        switch (type) {
            case ALL: {
                return ComboBoxFactory.filterDepartmentsForAll(affixList, currentSelection);
            }
            case PRODUCTION: {
                return ComboBoxFactory.filterDepartmentsForProduction(affixList, currentSelection);
            }
            case NOT_PRODUCTION: {
                return ComboBoxFactory.filterDepartmentsForNotProduction(affixList, currentSelection);
            }
            case PRODUCT_UNIT: {
                return ComboBoxFactory.filterDepartmentsForProductUnitProduction(affixList, currentSelection);
            }
            case PRODUCT_MAN_MINUTE_UNIT: {
                return ComboBoxFactory.filterDepartmentsForProductManMinute(affixList, currentSelection);
            }
            case PRODUCT_GROUP_UNIT: {
                return ComboBoxFactory.filterDepartmentsForProductGroupUnitProduction(affixList, currentSelection);
            }
            case PRODUCT_GROUP_MAN_MINUTE_UNIT: {
                return ComboBoxFactory.filterDepartmentsForProductGroupManMinute(affixList, currentSelection);
            }
            case ARTICLE_PRODUCTION_UNIT: {
                return ComboBoxFactory.filterDepartmentsForArticlePreparation(affixList, currentSelection);
            }
            case ARTICLE_REQUISITION_UNIT: {
                return ComboBoxFactory.filterDepartmentsForArticleRequisition(affixList, currentSelection);
            }
            case ARTICLE_IN_PRODUCT_UNIT: {
                return ComboBoxFactory.filterDepartmentsForArticleInProductUnitProduction(affixList, currentSelection);
            }
            case ARTICLE_IN_PRODUCT_MAN_MINUTE_UNIT: {
                return ComboBoxFactory.filterDepartmentsForArticleInProductUnitManMinute(affixList, currentSelection);
            }
            case RECIPE_PREPARATION_UNIT: {
                return ComboBoxFactory.filterDepartmentsForRecipePreparation(affixList, currentSelection);
            }
            case RECIPE_IN_PRODUCT_UNIT: {
                return ComboBoxFactory.filterDepartmentsForRecipeInProductUnitProduction(affixList, currentSelection);
            }
            case RECIPE_IN_PRODUCT_MAN_MINUTE_UNIT: {
                return ComboBoxFactory.filterDepartmentsForRecipeInProductUnitManMinute(affixList, currentSelection);
            }
            case STOWING_LIST_EQUIPMENT_OWNER_UNIT: {
                return ComboBoxFactory.filterDepartmentsForStowingListEquipmentOwnerUnit(affixList, currentSelection);
            }
            case PURCHASE_ORDER: {
                return ComboBoxFactory.filterDepartmentsForPurchaseOrder(affixList, currentSelection);
            }
        }
        return affixList;
    }

    private static Node filterDepartmentsForAll(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        if (currentSelection == null || currentSelection.getValue() == null) {
            return affixList;
        }
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<Object> centers = new HashSet<Object>();
        Iterator it = affixList.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            centers.add(next.getValue());
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(next.getValue(), true, true), 0L);
            ((List)list.getValue()).add(next.getValue());
        }
        if (!centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForArticlePreparation(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getArticleDefaultPreparationUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForPurchaseOrder(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getPurchaseDepartment())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForRecipePreparation(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getRecipeDefaultPreparationUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForArticleRequisition(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getArticleDefaultRequisitionUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForProductGroupManMinute(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getProdcutGroupManMinuteUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForProductManMinute(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getProductManMinuteUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForStowingListEquipmentOwnerUnit(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getStowingListEquipmentOwnerUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForProductUnitProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getProductUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForProductGroupUnitProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        if (affixList != null && affixList.getValue() != null) {
            for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
                if (!Boolean.TRUE.equals(internalCostCenterComplete.getProductGroupUnit())) continue;
                list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
                ((List)list.getValue()).add(internalCostCenterComplete);
                centers.add(internalCostCenterComplete);
            }
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForArticleInProductUnitProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getArticleInProductUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForArticleInProductUnitManMinute(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getArticleInProductManMinuteUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForRecipeInProductUnitProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getRecipeInProductUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForRecipeInProductUnitManMinute(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!Boolean.TRUE.equals(internalCostCenterComplete.getRecipeInProductManMinuteUnit())) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (!internalCostCenterComplete.getIsProductionUnit().booleanValue()) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    private static Node filterDepartmentsForNotProduction(Node<List<InternalCostCenterComplete>> affixList, Node<InternalCostCenterComplete> currentSelection) {
        ListNode list = new ListNode();
        list.setValue(new ArrayList(), 0L);
        HashSet<InternalCostCenterComplete> centers = new HashSet<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)affixList.getValue()) {
            if (internalCostCenterComplete.getIsProductionUnit().booleanValue()) continue;
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)internalCostCenterComplete, true, true), 0L);
            ((List)list.getValue()).add(internalCostCenterComplete);
            centers.add(internalCostCenterComplete);
        }
        if (currentSelection != null && currentSelection.getValue() != null && !centers.contains(currentSelection.getValue())) {
            list.addChild(INodeCreator.getDefaultImpl().getNode4DTO(currentSelection.getValue(), true, true), 0L);
        }
        return list;
    }

    public static ComboBox getRecipeValidationCombo(boolean withAll) {
        ComboBox b = new ComboBox();
        if (withAll) {
            b.addItem(Words.ALL);
        }
        b.addItem(Words.VALID);
        b.addItem(Words.HAS_WARNINGS);
        return b;
    }

    public static ComboBox getChangeNotificationStateComboBox(boolean withAll) {
        ComboBox box = new ComboBox();
        if (withAll) {
            box.addItem(Words.ALL);
        }
        for (ChangeNotificationStateE e : ChangeNotificationStateE.values()) {
            box.addItem(e);
        }
        return box;
    }

    public static ComboBox getChangeNotificationTypeComboBox(boolean withAll) {
        ComboBox box = new ComboBox();
        if (withAll) {
            box.addItem(Words.ALL);
        }
        for (ChangeNotificationTypeE e : ChangeNotificationTypeE.values()) {
            box.addItem(e);
        }
        return box;
    }

    public static enum DepartmentType {
        ALL,
        PRODUCTION,
        NOT_PRODUCTION,
        PRODUCT_UNIT,
        PRODUCT_MAN_MINUTE_UNIT,
        PRODUCT_GROUP_UNIT,
        PRODUCT_GROUP_MAN_MINUTE_UNIT,
        ARTICLE_PRODUCTION_UNIT,
        ARTICLE_REQUISITION_UNIT,
        ARTICLE_IN_PRODUCT_UNIT,
        ARTICLE_IN_PRODUCT_MAN_MINUTE_UNIT,
        RECIPE_PREPARATION_UNIT,
        RECIPE_IN_PRODUCT_UNIT,
        RECIPE_IN_PRODUCT_MAN_MINUTE_UNIT,
        STOWING_LIST_EQUIPMENT_OWNER_UNIT,
        PURCHASE_ORDER;

    }

    public static enum JobType {
        ArticlePreparation,
        RecipeProduction,
        ProductProduction;

    }
}

