/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DoubleComboPanel
extends JPanelFadable
implements Movable,
Focusable,
Stringable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Component> boxes = new ArrayList();
    private int inner_horizontal_gap = 3;
    private int defaultComboBoxWidth = 40;
    private Mover<DoubleComboPanel> mover;
    private VisibleContainer visibleContainer;

    public DoubleComboPanel() {
        this.setOpaque(false);
        this.setLayout(new CheckBoxGroupLayout());
        this.mover = new Mover<DoubleComboPanel>(this);
    }

    public ComboBox getCombo(int index) {
        Component o = this.boxes.get(index);
        if (o instanceof ComboBox) {
            return (ComboBox)o;
        }
        if (o instanceof RDComboBox && ((RDComboBox)o).getEditor() != null) {
            return (ComboBox)((RDComboBox)o).getEditor();
        }
        return null;
    }

    public int getComboCount() {
        return this.boxes.size();
    }

    public String getValue() {
        String ret = "";
        int count = 0;
        for (Component box : this.boxes) {
            if (box instanceof ComboBox) {
                ret = ret + ((ComboBox)box).getSelectedItem();
            } else if (box instanceof RDComboBox) {
                if (((RDComboBox)box).getEditor() != null) {
                    ret = ret + ((ComboBox)((RDComboBox)box).getEditor()).getSelectedItem();
                }
            } else {
                --count;
            }
            if (++count >= this.boxes.size()) continue;
            ret = ret + ":";
        }
        return ret;
    }

    public void addComboBox(Component box) {
        this.boxes.add(box);
        this.add(box);
        if (this.visibleContainer != null && box instanceof Focusable) {
            ((Focusable)((Object)box)).setVisibleContainer(this.visibleContainer);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (Component c : this.boxes) {
            c.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    public Mover<DoubleComboPanel> getMover() {
        return this.mover;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component box : this.boxes) {
            if (!(box instanceof Focusable)) continue;
            CheckedListAdder.addToList(a, (Focusable)((Object)box));
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        for (Component box : this.boxes) {
            if (!(box instanceof Focusable)) continue;
            ((Focusable)((Object)box)).setVisibleContainer(pane);
        }
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.boxes.size() >= 1) {
            this.boxes.get(0).requestFocusInWindow();
        }
    }

    @Override
    public String getStringValue() {
        String t = "";
        for (Component b : this.boxes) {
            if (!(b instanceof Stringable)) continue;
            t = t + ((Stringable)((Object)b)).getStringValue() + " - ";
        }
        if (t.length() > 0) {
            t = t.substring(0, t.length() - 3);
        }
        return t;
    }

    private class CheckBoxGroupLayout
    extends DefaultLayout {
        private CheckBoxGroupLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int uw;
            int w = parent.getWidth();
            w -= (DoubleComboPanel.this.boxes.size() - 1) * DoubleComboPanel.this.inner_horizontal_gap;
            if ((w /= DoubleComboPanel.this.boxes.size()) > (uw = DoubleComboPanel.this.defaultComboBoxWidth)) {
                uw = w;
            }
            int currentX = 0;
            for (Component box : DoubleComboPanel.this.boxes) {
                box.setLocation(currentX, 0);
                box.setSize(uw, (int)box.getPreferredSize().getHeight());
                currentX += box.getWidth() + DoubleComboPanel.this.inner_horizontal_gap;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = 0;
            int height = 0;
            for (Component box : DoubleComboPanel.this.boxes) {
                currentX += DoubleComboPanel.this.defaultComboBoxWidth + DoubleComboPanel.this.inner_horizontal_gap;
                height = (int)box.getPreferredSize().getHeight();
            }
            return new Dimension(currentX -= DoubleComboPanel.this.inner_horizontal_gap, height);
        }
    }
}

