/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.ConfiguratableComparator;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.CostPerUnitConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.EnterListener;
import ch.icit.pegasus.client.gui.utils.Enterable;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.DefaultListViewPopupInsert;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.ISkin;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin5Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.InputComboBoxSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.gui.utils.tooltip.ToolTipCreator;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class InputComboBox
extends JPanelFadable
implements Movable,
Focusable,
Validatable,
MouseListener,
LafListener,
FocusListener,
InnerPopUpListener2,
Nodable,
Enterable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private InnerPopUp2 comboPopUp;
    private Button.ButtonState currentState = Button.ButtonState.UP;
    private Button.ButtonState newState = null;
    private Skin5Field skin;
    private int defaultUnitWidth = 75;
    private final List<EnterListener> enterListener = new ArrayList<EnterListener>();
    private Node amountNode;
    private Node unitNode;
    private Node secondUnitNode;
    private Node<?> possibleUnits;
    private static Color activTextColor;
    private static Color disabledTextColor;
    private DecimalFormat format;
    private int overrideUnitWith = 75;
    private TextField textField;
    private TextLabel textReadOnly;
    private TextLabel unitReadOnly;
    private ToolTipCreator toolTipCreator;
    private InputComboBoxType inputState;
    private AWTEventListener keyListener;
    private VisibleContainer visibleContainer;
    private boolean isDown;
    public static int minUnitWidth_editable;
    public static int minUnitWidth;
    public static int minAmountWidth;
    private String lastKeyEvents;
    private long lastKeyEventTime;
    private Comparator defaultSorter;
    private Object defaultSorterUserObject;
    private Node<?> node;
    private static long keyEventTimeWindow;

    private static void ensureMinUnitWidth(Component c) {
        ISkin skin;
        Font f;
        String t;
        if (minUnitWidth_editable == -1) {
            t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_unittext");
            f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            skin = SkinRegistry.getSkin(InputComboBoxSkin.class);
            int alphanumerics = c.getFontMetrics(f).stringWidth(t);
            int image = ((Skin5Field)skin).getImage51(Button.ButtonState.UP, InputComboBoxType.PRICE_AND_UNIT_DOUBLE.getNumber()).getWidth();
            minUnitWidth = alphanumerics;
            minUnitWidth_editable = alphanumerics + image + 8;
        }
        if (minAmountWidth == -1) {
            t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_amounttext");
            f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
            int image = ((Skin3Field)skin).getImageLeft(Button.ButtonState.UP).getWidth() + ((Skin3Field)skin).getImageRight(Button.ButtonState.UP).getWidth();
            int alphanuerics = c.getFontMetrics(f).stringWidth(t);
            minAmountWidth = alphanuerics + image + 4;
        }
    }

    public InputComboBox(Node amount, Node unit, InputComboBoxType inputState) {
        this(amount, unit, null, inputState);
    }

    public InputComboBox(Node amount, Node unit, DecimalFormat formatter, InputComboBoxType inputState) {
        this.initInputComboBox(amount, unit, formatter, inputState);
    }

    private void initInputComboBox(Node amount, Node unit, DecimalFormat formatter, InputComboBoxType inputState) {
        InputComboBox.ensureMinUnitWidth(this);
        this.format = formatter;
        if (formatter == null) {
            this.format = FormatterRegistry.getDecimalFormat(Words.DEFAULT_PRICE_PATTERN);
        }
        this.skin = SkinRegistry.getSkin(InputComboBoxSkin.class);
        this.unitReadOnly = new TextLabel();
        this.unitReadOnly.setProgress(1.0f);
        this.setCurrentState(inputState);
        this.setFocusable(true);
        if (this.inputState == InputComboBoxType.PRICE_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.textField = new NumberTextField(TextFieldType.LONG);
        } else if (this.inputState == InputComboBoxType.PRICE_INT || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            this.textField = new NumberTextField(TextFieldType.INT);
        } else if (this.inputState == InputComboBoxType.PRICE_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE) {
            this.textField = new NumberTextField(TextFieldType.DOUBLE);
            this.textField.setDecimalFormat(this.format);
        } else if (this.inputState == InputComboBoxType.NONE) {
            this.textReadOnly = new TextLabel(null, ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class));
        }
        if (this.textField != null) {
            this.textField.setProgress(1.0f);
            this.textField.addActionListener(this);
        }
        if (this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG) {
            if (this.inputState != InputComboBoxType.NONE) {
                this.textField.setPaintTexture(false);
                this.textField.disableInnerMouseEvents(true);
                this.textField.addMouseListener(this);
                this.textField.getTextField().addMouseListener(this);
                this.textField.getTextField().addFocusListener(this);
            } else if (this.inputState == InputComboBoxType.NONE) {
                this.textReadOnly.setReadOnlyTextField(true);
            }
        }
        if (amount != null && unit != null) {
            this.setNode(amount, unit);
        }
        this.lafAttributeChanged("All attribues changed");
        if (this.textField != null) {
            this.textField.setForeground(activTextColor);
        }
        this.addMouseListener(this);
        this.unitReadOnly.addMouseListener(this);
        this.addFocusListener(this);
        this.setLayout(new Layout());
        this.setOpaque(false);
        if (this.textField != null) {
            this.add(this.textField);
        }
        if (this.textReadOnly != null) {
            this.add(this.textReadOnly);
        }
        this.add(this.unitReadOnly);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public void addTextListener(TextFieldListener listener) {
        if (this.textField != null) {
            this.textField.addTextFieldListener(listener);
        }
    }

    public void setToolTipCreator(ToolTipCreator creator) {
        this.toolTipCreator = creator;
        this.toolTipCreator.setToolTippedComponent(this.unitReadOnly);
    }

    public void setPossibleUnits(Node possValues) {
        this.possibleUnits = possValues;
    }

    public Node getPossibleUnits() {
        return this.possibleUnits;
    }

    public void setDefaultSorterUserObject(Object o) {
        this.defaultSorterUserObject = o;
    }

    public void allowMinus(boolean b) {
        if (this.textField == null || !(this.textField instanceof NumberTextField)) {
            return;
        }
        if (b) {
            ((NumberTextField)this.textField).allowMinus();
        } else {
            ((NumberTextField)this.textField).disableMinus();
        }
    }

    public void setNode(Node value, Node unit) {
        if (this.textField != null) {
            this.textField.setNode(value);
        }
        if (this.textReadOnly != null) {
            this.textReadOnly.setNode(value);
        }
        if (unit != null && unit.getValue() != null) {
            if (unit.getValue() instanceof UnitComplete) {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(UnitConverter.class));
            } else {
                this.unitReadOnly.setViewConverter(null);
            }
        }
        this.unitReadOnly.setNode(unit);
        if (this.secondUnitNode != null && unit != null && value != null) {
            this.setSecondUnitNode((Node<UnitComplete>)this.secondUnitNode);
        }
        this.amountNode = value;
        this.unitNode = unit;
    }

    public int getTextFieldWidth() {
        return minAmountWidth;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (node != null && node.getValue() instanceof PriceComplete) {
            Node p = node.getChildNamed(PriceComplete_.price);
            Node u = node.getChildNamed(PriceComplete_.currency);
            this.setNode(p, u);
        } else if (node != null && node.getValue() instanceof QuantityComplete) {
            Node p = node.getChildNamed(QuantityComplete_.quantity);
            Node u = node.getChildNamed(QuantityComplete_.unit);
            this.setNode(p, u);
        } else if (node != null && node.getValue() instanceof StoreQuantityComplete) {
            Node p = node.getChildNamed(StoreQuantityComplete_.amount);
            Node u = node.getChildNamed(StoreQuantityComplete_.unit);
            this.setNode(p, u);
        }
        if (node == null) {
            this.setNode(null, null);
        }
    }

    public void setCurrentState(InputComboBoxType newState) {
        this.inputState = newState;
        if (this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            this.defaultUnitWidth = minUnitWidth_editable;
            if (this.textField != null) {
                this.textField.setPaintTexture(false);
                this.textField.disableInnerMouseEvents(true);
            }
        } else if (this.inputState == InputComboBoxType.PRICE_LONG || this.inputState == InputComboBoxType.PRICE_DOUBLE || this.inputState == InputComboBoxType.PRICE_INT) {
            this.defaultUnitWidth = this.overrideUnitWith;
            if (this.textField != null) {
                this.textField.setPaintTexture(true);
                this.textField.disableInnerMouseEvents(false);
            }
        }
    }

    public void setOverrideUnitWith(int overrideUnitWith) {
        this.overrideUnitWith = overrideUnitWith;
        this.setCurrentState(this.inputState);
    }

    public void setState(Button.ButtonState state) {
        this.currentState = state;
        this.repaint(32L);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            this.skin.paint(g2, this.getWidth(), this.getWidth() - this.defaultUnitWidth, this.currentState, this.inputState.getNumber());
        }
        this.paintChildren(g2);
    }

    public void setSecondUnitNode(Node<UnitComplete> secondUnit) {
        if (this.secondUnitNode != null && this.unitReadOnly != null) {
            this.unitReadOnly.addNodeToTextLabel(secondUnit);
        }
        this.secondUnitNode = secondUnit;
        if (this.unitReadOnly != null) {
            if (this.secondUnitNode != null) {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(CostPerUnitConverter.class));
                ((CostPerUnitConverter)this.unitReadOnly.getViewConverter()).setSecondNode((Node<UnitComplete>)this.secondUnitNode);
            } else {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(CurrencyConverter.class));
            }
            this.unitReadOnly.updateString();
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    public Mover<InputComboBox> getMover() {
        return null;
    }

    public Node getValueNode() {
        if (this.textField != null) {
            return this.textField.getNode();
        }
        return this.textReadOnly.getNode();
    }

    public Node getUnitNode() {
        return this.unitNode;
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.setLocation(endX, endY);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.textField);
        if (this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            a.add(this);
        }
        return a;
    }

    public TextField getEnterField() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (isEnabled) {
            this.setState(Button.ButtonState.UP);
        } else {
            this.setState(Button.ButtonState.DISABLED);
        }
        this.unitReadOnly.setEnabled(isEnabled);
        if (this.textField != null) {
            this.textField.setEnabled(isEnabled);
        }
        if (this.textReadOnly != null) {
            this.textReadOnly.setEnabled(isEnabled);
        }
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
        if (this.inputState != InputComboBoxType.PRICE_AND_UNIT_DOUBLE && this.inputState != InputComboBoxType.PRICE_AND_UNIT_LONG && this.inputState != InputComboBoxType.PRICE_AND_UNIT_INT && this.textField != null) {
            this.textField.setInvalid();
        }
    }

    @Override
    public void setValid() {
        if (this.currentState == Button.ButtonState.ERROR) {
            if (this.textField != null && this.textField.hasFocus()) {
                this.setState(Button.ButtonState.STATE_FOCUS_LEFT);
            } else if (this.hasFocus()) {
                this.setState(Button.ButtonState.STATE_FOCUS_RIGHT);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        }
    }

    @Override
    public void setWarning() {
    }

    private boolean ensurePopup() {
        if (this.comboPopUp == null && this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.comboPopUp == null && this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.comboPopUp == null && this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            this.showPopup();
            return true;
        }
        return false;
    }

    private void registerKeyEvents() {
        if (this.keyListener == null) {
            this.keyListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    KeyEvent ke;
                    if (event instanceof KeyEvent && (ke = (KeyEvent)event).getID() == 401 && !ke.isConsumed()) {
                        if (ke.getKeyCode() == 40) {
                            ke.consume();
                            if (!InputComboBox.this.ensurePopup() && InputComboBox.this.comboPopUp != null) {
                                if (InputComboBox.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                    ((DefaultListViewPopupInsert)InputComboBox.this.comboPopUp.getView()).selectLowerItem();
                                } else {
                                    InputComboBox.this.comboPopUp.hidePopUp(new Object[0]);
                                }
                            }
                        } else if (ke.getKeyCode() == 38) {
                            ke.consume();
                            if (!InputComboBox.this.ensurePopup()) {
                                if (InputComboBox.this.comboPopUp == null) {
                                    return;
                                }
                                if (InputComboBox.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                    ((DefaultListViewPopupInsert)InputComboBox.this.comboPopUp.getView()).selectUpperItem();
                                } else {
                                    InputComboBox.this.comboPopUp.hidePopUp(new Object[0]);
                                }
                            }
                        } else if (ke.getKeyCode() == 10) {
                            ke.consume();
                            if (InputComboBox.this.comboPopUp != null) {
                                if (InputComboBox.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                    ((DefaultListViewPopupInsert)InputComboBox.this.comboPopUp.getView()).closeIt(false);
                                } else {
                                    InputComboBox.this.comboPopUp.hidePopUp(new Object[0]);
                                }
                            } else {
                                InputComboBox.this.enterPressed();
                            }
                        } else {
                            String t = "" + ke.getKeyChar();
                            long currentTime = System.currentTimeMillis();
                            long dif = currentTime - InputComboBox.this.lastKeyEventTime;
                            if (dif > keyEventTimeWindow) {
                                InputComboBox.this.lastKeyEvents = t;
                            } else {
                                InputComboBox.this.lastKeyEvents = InputComboBox.this.lastKeyEvents + t;
                            }
                            InputComboBox.this.lastKeyEventTime = currentTime;
                            if (InputComboBox.this.comboPopUp != null && InputComboBox.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                ((DefaultListViewPopupInsert)InputComboBox.this.comboPopUp.getView()).tryToSelectItemStartsWith(InputComboBox.this.lastKeyEvents);
                            } else {
                                InputComboBox.this.tryToSelectItemStartsWith(InputComboBox.this.lastKeyEvents);
                            }
                        }
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void deregisterKeyEvents() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    private void tryToSelectItemStartsWith(String t) {
        block4: {
            long id;
            block5: {
                if (this.inputState != InputComboBoxType.PRICE_AND_UNIT_DOUBLE && this.inputState != InputComboBoxType.PRICE_AND_UNIT_LONG && this.inputState != InputComboBoxType.PRICE_AND_UNIT_INT || this.unitNode == null || this.unitNode.getValue() == null) break block4;
                id = System.currentTimeMillis();
                if (!(this.unitNode.getValue() instanceof UnitComplete)) break block5;
                Node<?> u = null;
                u = this.possibleUnits != null && this.possibleUnits.getChildCount() > 0 ? this.possibleUnits : NodeToolkit.getAffixList(UnitSystemComplete.class);
                UnitConverter c = (UnitConverter)ConverterRegistry.getConverter(UnitConverter.class);
                if (u == null) break block4;
                Iterator it = u.getChilds();
                while (it.hasNext()) {
                    Node dto = (Node)it.next();
                    Node dto2 = null;
                    dto2 = dto.getValue() instanceof UnitSystemComplete ? dto.getChildNamed(UnitSystemComplete_.maxUnit) : dto;
                    String a = c.convert((UnitComplete)dto2.getValue(), dto2, new Object[0]);
                    if (!a.toLowerCase().startsWith(t.toLowerCase())) continue;
                    this.unitNode.setValue(dto2.getValue(), id);
                    return;
                }
                break block4;
            }
            if (this.unitNode.getValue() instanceof CurrencyComplete) {
                Node<?> c = null;
                c = this.possibleUnits != null && this.possibleUnits.getChildCount() > 0 ? this.possibleUnits : NodeToolkit.getAffixList(CurrencyComplete.class);
                if (c != null) {
                    CurrencyConverter con = (CurrencyConverter)ConverterRegistry.getConverter(CurrencyConverter.class);
                    Iterator it = c.getChilds();
                    while (it.hasNext()) {
                        Node dto = (Node)it.next();
                        String a = con.convert((CurrencyComplete)dto.getValue(), dto, new Object[0]);
                        if (!a.toLowerCase().startsWith(t.toLowerCase())) continue;
                        this.unitNode.setValue(dto.getValue(), id);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this) && this.currentState != Button.ButtonState.STATE_FOCUS_LEFT && this.currentState != Button.ButtonState.STATE_FOCUS_RIGHT) {
            if (this.currentState == Button.ButtonState.ERROR) {
                this.newState = Button.ButtonState.OVER;
            } else {
                this.currentState = Button.ButtonState.OVER;
            }
            this.repaint(32L);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            if (this.currentState != Button.ButtonState.STATE_FOCUS_LEFT && this.currentState != Button.ButtonState.STATE_FOCUS_RIGHT) {
                if (this.currentState == Button.ButtonState.ERROR) {
                    this.newState = Button.ButtonState.UP;
                } else {
                    this.currentState = Button.ButtonState.UP;
                }
                this.setCursor(new Cursor(0));
                this.repaint(23L);
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            this.isDown = true;
            Button.pressedItem = this;
            if (this.textField != null && (e.getX() > this.textField.getWidth() && e.getX() < this.getWidth() || this.unitReadOnly == e.getSource())) {
                this.requestFocusInWindow();
                this.showPopup();
            }
        }
    }

    public void setDefaultSorter(Comparator defaultSorter) {
        this.defaultSorter = defaultSorter;
    }

    public Comparator getDefaultSorter() {
        return this.defaultSorter;
    }

    private void initPopup(Node it, Converter vc) {
        if (this.comboPopUp == null) {
            this.comboPopUp = InnerPopUp2.getInnerPopUp();
            this.comboPopUp.setAttributes(null, false, false, "");
            if (this.defaultSorter != null && this.defaultSorter instanceof ConfiguratableComparator) {
                ((ConfiguratableComparator)this.defaultSorter).setAttribute(this.defaultSorterUserObject);
            }
            DefaultListViewPopupInsert v = new DefaultListViewPopupInsert(it, vc, this, this.defaultSorter);
            v.setSorter(this.defaultSorter);
            this.comboPopUp.setView(v);
            if (this.unitNode instanceof ProxyNode) {
                v.selectCurrentSelection(((ProxyNode)this.unitNode).getRefNode());
            } else {
                v.selectCurrentSelection(this.unitNode);
            }
            this.comboPopUp.showPopUp(this.getWidth() - this.defaultUnitWidth, this.getHeight(), this.defaultUnitWidth - 5, v.getDefaultEntryHeight() * 7, this, this, PopupType.INPUTCOMBO);
            if ((this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) && this.unitNode != null && this.unitNode.getValue() != null) {
                String name = "";
                if (this.unitNode.getValue() instanceof UnitComplete) {
                    Converter c = ConverterRegistry.getConverter(UnitConverter.class);
                    name = (String)c.convert(this.unitNode.getValue(), this.unitNode, new Object[0]);
                    v.tryToSelectItemStartsWith(name);
                } else if (this.unitNode.getValue() instanceof CurrencyComplete) {
                    Converter con = ConverterRegistry.getConverter(CurrencyConverter.class);
                    name = (String)con.convert(this.unitNode.getValue(), this.unitNode, new Object[0]);
                    v.tryToSelectItemStartsWith(name);
                }
            }
        }
    }

    private void closePopup() {
        if (this.comboPopUp != null) {
            this.comboPopUp.hidePopUp(new Object[0]);
        }
    }

    private void showPopup() {
        if ((this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) && this.unitNode != null && this.unitNode.getValue() != null) {
            if (this.unitNode.getValue() instanceof UnitComplete) {
                ViewNode u = null;
                if (this.possibleUnits != null && this.possibleUnits.getChildCount() > 0) {
                    u = this.possibleUnits;
                } else {
                    ArrayList<Node<UnitComplete>> list = new ArrayList<Node<UnitComplete>>();
                    if (NodeToolkit.getAffixList(UnitSystemComplete.class) != null) {
                        Iterator it = NodeToolkit.getAffixList(UnitSystemComplete.class).getChilds();
                        while (it.hasNext()) {
                            Node sys = (Node)it.next();
                            UnitToolkit.generateUnitView((Node<UnitComplete>)sys.getChildNamed(UnitSystemComplete_.maxUnit), null, list, true);
                        }
                    }
                    u = new ViewNode("list");
                    u.addChildren(list);
                }
                this.initPopup((Node)u, ConverterRegistry.getConverter(UnitConverter.class));
            } else if (this.unitNode.getValue() instanceof CurrencyComplete) {
                Node<?> c = null;
                c = this.possibleUnits == null ? NodeToolkit.getAffixList(CurrencyComplete.class) : this.possibleUnits;
                this.initPopup(c, ConverterRegistry.getConverter(CurrencyConverter.class));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            Button.pressedItem = null;
            this.isDown = false;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.currentState != Button.ButtonState.DISABLED) {
            SelectionManager.getSelectionManager().focusGained(this);
            if (e.getSource() == this) {
                Button.pressedItem = this;
                this.registerKeyEvents();
                this.setState(Button.ButtonState.STATE_FOCUS_RIGHT);
                if (this.visibleContainer != null) {
                    this.visibleContainer.scrollTo(this);
                }
            } else if (this.textField != null && e.getSource() == this.textField.getTextField()) {
                Button.pressedItem = this.textField.getTextField();
                this.setState(Button.ButtonState.STATE_FOCUS_LEFT);
                if (!this.isDown && this.visibleContainer != null) {
                    this.visibleContainer.scrollTo(this);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.currentState != Button.ButtonState.DISABLED) {
            if (this.currentState == Button.ButtonState.STATE_FOCUS_RIGHT) {
                this.deregisterKeyEvents();
            }
            if (this.textField == null || e.getOppositeComponent() != this && e.getOppositeComponent() != this.textField.getTextField()) {
                this.closePopup();
                this.setState(Button.ButtonState.UP);
            }
            this.repaint(32L);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.comboPopUp != null) {
            this.comboPopUp = null;
        }
        if (xargs != null) {
            Node n = (Node)xargs[0];
            if (this.unitNode instanceof Node) {
                this.unitNode.setValue(n.getValue(), System.currentTimeMillis());
            }
            this.unitNode.commit();
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        if (activTextColor == null) {
            activTextColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
            disabledTextColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        }
    }

    public static int getPreferredWidth(Component c, InputComboBoxType inputState) {
        InputComboBox.ensureMinUnitWidth(c);
        if (inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
            int tw = minUnitWidth_editable;
            tw = minUnitWidth_editable + minAmountWidth;
            return tw;
        }
        int tw = minUnitWidth;
        return tw += minAmountWidth;
    }

    public static int getPreferredUnitWidth(Component c) {
        InputComboBox.ensureMinUnitWidth(c);
        return minUnitWidth;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.textField != null) {
            this.textField.requestFocusInWindowNow();
        }
    }

    public void setUseMaxKommaStellen(boolean b) {
        if (this.textField != null && this.textField instanceof NumberTextField) {
            ((NumberTextField)this.textField).setUseMaxDecimals(b);
        }
    }

    public void setMaxKommaStellen(int i) {
        if (this.textField != null && this.textField instanceof NumberTextField) {
            ((NumberTextField)this.textField).setMaxKommaStellen(i);
        }
    }

    public void addTextFieldListener(TextFieldListener l) {
        if (this.textField != null) {
            this.textField.addTextFieldListener(l);
        }
    }

    public void removeTextFieldListener(TextFieldListener l) {
        if (this.textField != null) {
            this.textField.removeTextFieldListener(l);
        }
    }

    public void updateAdditional() {
        if (this.unitReadOnly != null) {
            this.unitReadOnly.updateString();
        }
    }

    private void enterPressed() {
        for (EnterListener l : this.enterListener) {
            l.enterPressed(this);
        }
    }

    @Override
    public void addEnterListener(EnterListener listener) {
        this.enterListener.add(listener);
    }

    @Override
    public void removeEnterListener(EnterListener listener) {
        this.enterListener.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enterPressed();
    }

    public void setNextFocusComponent(Focusable element) {
        if (this.textField != null) {
            this.textField.setNextFocusComponent(element);
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    static {
        minUnitWidth_editable = -1;
        minUnitWidth = -1;
        minAmountWidth = -1;
        keyEventTimeWindow = 500L;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT) {
                int aTw = InputComboBox.this.defaultUnitWidth;
                int cw = 0;
                int ch = 0;
                if (InputComboBox.this.textField != null) {
                    InputComboBox.this.textField.setLocation(0, 0);
                    InputComboBox.this.textField.setSize(parent.getWidth() - aTw, (int)InputComboBox.this.textField.getPreferredSize().getHeight());
                    cw = InputComboBox.this.textField.getX() + InputComboBox.this.textField.getWidth();
                    ch = InputComboBox.this.textField.getY() - 1;
                }
                if (InputComboBox.this.textReadOnly != null) {
                    InputComboBox.this.textReadOnly.setLocation(0, 0);
                    InputComboBox.this.textReadOnly.setSize(parent.getWidth() - aTw, (int)InputComboBox.this.textReadOnly.getPreferredSize().getHeight());
                    cw = InputComboBox.this.textReadOnly.getX() + InputComboBox.this.textReadOnly.getWidth();
                    ch = InputComboBox.this.textReadOnly.getY() - 1;
                }
                InputComboBox.this.unitReadOnly.setLocation(cw + 7, ch);
                InputComboBox.this.unitReadOnly.setSize(aTw, (int)InputComboBox.this.unitReadOnly.getPreferredSize().getHeight());
            } else {
                int aTw = InputComboBox.this.defaultUnitWidth;
                int cw = 0;
                int ch = 0;
                if (InputComboBox.this.textField != null) {
                    InputComboBox.this.textField.setLocation(0, 0);
                    InputComboBox.this.textField.setSize(minAmountWidth, (int)InputComboBox.this.textField.getPreferredSize().getHeight());
                    cw = InputComboBox.this.textField.getX() + InputComboBox.this.textField.getWidth();
                    ch = InputComboBox.this.textField.getY() - 1;
                }
                if (InputComboBox.this.textReadOnly != null) {
                    InputComboBox.this.textReadOnly.setLocation(0, 0);
                    InputComboBox.this.textReadOnly.setSize(parent.getWidth() - aTw, (int)InputComboBox.this.textReadOnly.getPreferredSize().getHeight());
                    cw = InputComboBox.this.textReadOnly.getX() + InputComboBox.this.textReadOnly.getWidth();
                    ch = InputComboBox.this.textReadOnly.getY() - 1;
                }
                InputComboBox.this.unitReadOnly.setLocation(cw + 5, ch);
                InputComboBox.this.unitReadOnly.setSize(aTw, (int)InputComboBox.this.unitReadOnly.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int tw = InputComboBox.this.defaultUnitWidth + InputComboBox.this.skin.getImage11(InputComboBox.this.currentState).getWidth() + InputComboBox.this.skin.getImage21(InputComboBox.this.currentState).getWidth() + InputComboBox.this.skin.getImage31(InputComboBox.this.currentState).getWidth();
            tw = InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_DOUBLE || InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_LONG || InputComboBox.this.inputState == InputComboBoxType.PRICE_AND_UNIT_INT ? InputComboBox.this.defaultUnitWidth + minAmountWidth : InputComboBox.this.defaultUnitWidth + minAmountWidth + 5;
            return new Dimension(tw, InputComboBox.this.skin.getImage11(InputComboBox.this.currentState).getHeight());
        }
    }

    public static enum InputComboBoxType {
        PRICE_AND_UNIT_LONG(3),
        PRICE_AND_UNIT_DOUBLE(11),
        PRICE_AND_UNIT_INT(15),
        PRICE_LONG(5),
        PRICE_INT(7),
        PRICE_DOUBLE(13),
        NONE(9);

        private int number;

        private InputComboBoxType(int i) {
            this.number = i;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

