/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.CalendarButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DateChooser
extends JPanelFadable
implements AttributeListener,
ButtonListener,
NodeListener,
Focusable,
Validatable,
InnerPopUpListener2,
UIStateLoadable,
Nodable {
    private static final long serialVersionUID = 1L;
    private TextField inputField;
    private CalendarButton calendarIcon;
    private boolean isPersistable = true;
    private boolean withNeverExpires;
    private TitledItem<CheckBox> none;
    private CheckBox filterCheckbox;
    private boolean isTimestamp;
    private static int text_icon_gap;
    private static int prefWidth;
    private static int prefWidth_with_never;
    private java.util.Date selectedDate;
    private long unDoId;
    private ArrayList<DateChooserListener> listeners = new ArrayList();
    private String cId;
    private Date defaultDate;
    private boolean isSharedDate = false;
    private Node node;
    private boolean invert;
    private InnerPopUp2 currentPopup;

    public DateChooser(Node node) {
        this();
        this.setNode(node);
    }

    public DateChooser(Node node, boolean shareDate) {
        this(node);
        this.isSharedDate = shareDate;
    }

    public DateChooser() {
        this.inputField = new DateTimeTextField(TextFieldType.DATE){

            @Override
            public void fireInjected() {
                DateChooser.this.fireEvent(true);
            }
        };
        this.inputField.setProgress(1.0f);
        this.calendarIcon = new CalendarButton();
        this.attributeChanged("All attributes changed");
        this.setLayout(new DateChooserLayout1());
        this.setOpaque(false);
        this.calendarIcon.addButtonListener(this);
        this.add(this.inputField);
        this.add(this.calendarIcon);
    }

    public void setNeverExpires(boolean b) {
        this.setNeverExpires(b, "None");
    }

    public boolean isInnerComponent(Component component) {
        if (this.currentPopup != null) {
            return this.currentPopup.isInnerComponent(component);
        }
        return false;
    }

    public void setNeverExpires(boolean b, String name) {
        this.withNeverExpires = b;
        if (this.withNeverExpires) {
            this.none = new TitledItem<CheckBox>(new CheckBox(), "", TitledItem.TitledItemOrientation.EAST);
            this.none.getElement().addButtonListener(this);
            this.add(this.none);
        } else if (this.none != null) {
            this.none.kill();
        }
    }

    public boolean isNeverExpires() {
        return this.withNeverExpires;
    }

    public void setIsTimestamp(boolean b) {
        this.isTimestamp = b;
    }

    @Override
    public String getPersistString() {
        String t = "";
        DateConverter c = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
        t = c.convert((Object)this.selectedDate, null, new Object[0]);
        return t;
    }

    @Override
    public void loadState(String state, String id) {
        DateConverter c = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
        Date d = null;
        d = state == null || state.isEmpty() ? new Date(System.currentTimeMillis()) : (Date)c.inverseConvert((Object)state, null);
        if (d == null) {
            d = new Date(System.currentTimeMillis());
        }
        if (this.node != null) {
            this.node.setValue((Object)new Date(d.getTime()), 0L);
        }
        this.fireEvent(false);
    }

    @Override
    public String getID() {
        return this.getCId();
    }

    public void setNode(Node n) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.inputField.setNode(this.node);
            if (this.node.getValue() != null) {
                this.setSelectedDate((java.util.Date)this.node.getValue());
            }
            this.node.addNodeListener((NodeListener)this);
        }
    }

    public long getUnDoId() {
        return this.unDoId;
    }

    public void setUnDoId(long unDoId) {
        this.unDoId = unDoId;
    }

    public void setCId(String id) {
        this.cId = id;
    }

    public String getCId() {
        return this.cId;
    }

    public Date getDefaultDate() {
        return this.defaultDate;
    }

    public void setDefaultDate(Date defaultDate) {
        this.defaultDate = defaultDate;
    }

    public void setMinimumDate(java.util.Date d) {
        this.validateMinimumDate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.selectedDate = null;
        this.listeners.clear();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = null;
        this.inputField.kill();
        this.inputField = null;
        this.calendarIcon.kill();
        this.calendarIcon = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.invert) {
            this.inputField.setEnabled(!(!isEnabled || this.none != null && !this.none.getElement().isChecked() || this.filterCheckbox != null && !this.filterCheckbox.isChecked()));
            this.calendarIcon.setEnabled(isEnabled && (this.none != null ? this.none.getElement().isChecked() : this.filterCheckbox == null || this.filterCheckbox.isChecked()));
            if (this.none != null) {
                this.none.setEnabled(isEnabled);
            }
        } else {
            this.inputField.setEnabled(isEnabled && (this.none == null || !this.none.getElement().isChecked()));
            this.calendarIcon.setEnabled(isEnabled && (this.none == null || !this.none.getElement().isChecked()));
            if (this.none != null) {
                this.none.setEnabled(isEnabled);
            }
        }
    }

    public void addDateChooserListener(DateChooserListener l) {
        this.listeners.add(l);
    }

    public void removeDateChooserListener(DateChooserListener l) {
        this.listeners.remove(l);
    }

    private void fireEvent(boolean isSilent) {
        for (DateChooserListener l : this.listeners) {
            l.dateChanged(this, this.selectedDate);
        }
        boolean isUnDoSet = true;
        if (this.unDoId == 0L) {
            isUnDoSet = false;
            this.unDoId = System.currentTimeMillis();
        }
        if (!isSilent && this.node != null && this.node instanceof Node) {
            this.node.setValue((Object)this.selectedDate, this.unDoId);
        }
        if (!isUnDoSet) {
            this.unDoId = System.currentTimeMillis();
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public java.util.Date getSelectedDate() {
        Date d;
        if (this.node != null && this.node.getValue() instanceof Date && (d = (Date)this.node.getValue()) != null) {
            return d;
        }
        return this.selectedDate;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.withNeverExpires) {
            return new Dimension((int)(this.calendarIcon.getPreferredSize().getWidth() * 5.0 + this.none.getPreferredSize().getWidth()), (int)this.calendarIcon.getPreferredSize().getHeight());
        }
        return new Dimension((int)this.calendarIcon.getPreferredSize().getWidth() * 5, (int)this.calendarIcon.getPreferredSize().getHeight());
    }

    public void setSelectedDate(java.util.Date selectedDate) {
        this.selectedDate = selectedDate == null ? new java.util.Date(System.currentTimeMillis()) : selectedDate;
        if (this.inputField != null && this.inputField.getNode() != null && this.inputField.getNode().getValue() != null && !this.inputField.getNode().getValue().equals(this.selectedDate)) {
            this.inputField.getNode().removeNodeListener((NodeListener)this);
            this.inputField.getNode().setValue((Object)this.selectedDate, System.currentTimeMillis());
            this.inputField.getNode().addNodeListener((NodeListener)this);
        }
        this.validateInfinityDate();
        this.validateMinimumDate();
    }

    public void validateInners() {
        this.validateInfinityDate();
    }

    private void validateInfinityDate() {
        if (this.invert) {
            boolean b = true;
            if (this.none != null) {
                b = this.none.getElement().isChecked();
            } else if (this.filterCheckbox != null) {
                b = this.filterCheckbox.isChecked();
            }
            if (this.inputField != null) {
                this.inputField.setEnabled(b);
                this.calendarIcon.setEnabled(b);
                this.inputField.getTextField().setVisible(b);
            }
        } else {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(this.selectedDate.getTime());
            int d = c.get(5);
            int m = c.get(2);
            int y = c.get(1);
            if (d == 6 && m == 6 && y == 6666) {
                if (this.none == null) {
                    this.setNeverExpires(true);
                }
                if (this.inputField != null) {
                    this.none.getElement().setChecked(true);
                    this.inputField.setEnabled(false);
                    this.calendarIcon.setEnabled(false);
                    this.inputField.getTextField().setVisible(false);
                }
            } else {
                if (this.none != null) {
                    this.none.getElement().setChecked(false);
                }
                if (this.inputField != null) {
                    this.inputField.getTextField().setVisible(true);
                }
            }
            if (this.none != null) {
                if (this.inputField != null) {
                    this.inputField.setEnabled(!this.none.getElement().isChecked());
                    this.calendarIcon.setEnabled(!this.none.getElement().isChecked());
                }
            } else if (this.inputField != null) {
                this.inputField.setEnabled(this.isEnabled());
                this.calendarIcon.setEnabled(this.isEnabled());
            }
        }
    }

    private void validateMinimumDate() {
        this.setValid();
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            text_icon_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_textfield_icon_gap"));
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.none != null && source == this.none.getElement()) {
            if (this.invert) {
                if (this.none.getElement().isChecked()) {
                    this.setSelectedDate(new Date(System.currentTimeMillis()));
                } else {
                    this.setSelectedDate(CalendarUtil.getInfinityDate());
                }
            } else if (this.none.getElement().isChecked()) {
                this.setSelectedDate(CalendarUtil.getInfinityDate());
            } else {
                this.setSelectedDate(new Date(System.currentTimeMillis()));
            }
            this.fireEvent(false);
        } else if (this.filterCheckbox != null && this.filterCheckbox == source) {
            if (this.invert) {
                if (this.filterCheckbox.isChecked()) {
                    this.setSelectedDate(new Date(System.currentTimeMillis()));
                } else {
                    this.setSelectedDate(CalendarUtil.getInfinityDate());
                }
            } else if (this.filterCheckbox.isChecked()) {
                this.setSelectedDate(CalendarUtil.getInfinityDate());
            } else {
                this.setSelectedDate(new Date(System.currentTimeMillis()));
            }
            this.fireEvent(false);
        } else {
            if (this.selectedDate == null) {
                this.selectedDate = new Date(System.currentTimeMillis());
            }
            this.currentPopup = InnerPopUp2.getInnerPopUp();
            this.currentPopup.setAttributes(null, false, false, Words.DATE);
            DateChooserPopup widget = new DateChooserPopup(this.selectedDate);
            int prefH = (int)widget.getPreferredSize().getHeight();
            this.currentPopup.setView(widget);
            this.currentPopup.showPopUp(x, y, 300, ++prefH, this, source, PopupType.NORMAL);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (node != null && node.getValue() != null) {
            this.setSelectedDate((java.util.Date)node.getValue());
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.inputField);
        CheckedListAdder.addToList(a, this.calendarIcon);
        CheckedListAdder.addToList(a, this.none);
        return a;
    }

    @Override
    public void setInvalid() {
        this.inputField.setInvalid();
    }

    @Override
    public void setValid() {
        if (this.inputField != null) {
            this.inputField.setValid();
        }
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        DateChooserPopup view = (DateChooserPopup)source.getView();
        if (!this.isSharedDate) {
            this.setSelectedDate(CalendarUtil.getDateWithoutTime((long)view.getSelectedDate().getTimeInMillis(), (boolean)this.isTimestamp));
        } else if (this.isTimestamp) {
            this.setSelectedDate(new Timestamp(view.getSelectedDate().getTimeInMillis()));
        } else {
            this.setSelectedDate(new Date(view.getSelectedDate().getTimeInMillis()));
        }
        this.fireEvent(false);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.inputField.setVisibleContainer(pane);
        this.calendarIcon.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    private static void ensurePrefWidth(Component c) {
        if (prefWidth == -1) {
            String t = AttributeLoader.getAttributeLoader().getAttribute("datechooser_min_text");
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            Skin3Field skin = (Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin();
            Skin1Field skinIcon = (Skin1Field)DefaultSkins.CalendarOpenIcon.createDynamicSkin();
            int image = skin.getImageLeft(Button.ButtonState.UP).getWidth() + skin.getImageRight(Button.ButtonState.UP).getWidth();
            int alphanuerics = c.getFontMetrics(f).stringWidth(t);
            prefWidth = alphanuerics + image + text_icon_gap + skinIcon.getImage(Button.ButtonState.UP).getWidth() + 8;
            prefWidth_with_never = prefWidth + CheckBox.getPreferredWidth() + 15;
        }
    }

    public static int getPreferredWidth(Component c, boolean withNever) {
        DateChooser.ensurePrefWidth(c);
        if (withNever) {
            return prefWidth_with_never + 2;
        }
        return prefWidth;
    }

    public void setUncheckable() {
        if (this.none != null) {
            this.none.setEnabled(false);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.withNeverExpires) {
            this.none.requestFocusInWindowNow();
        } else if (this.inputField != null) {
            this.inputField.requestFocusInWindowNow();
        }
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    public void disbableNeverText() {
        if (this.none != null) {
            this.none.setTitleText("");
        }
    }

    public void setInvert(boolean b) {
        this.invert = b;
    }

    public static Date getFirstDayOfMonthDate(long currentTimeMillis) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(currentTimeMillis);
        c.set(5, 1);
        return new Date(c.getTimeInMillis());
    }

    public static Date getLastDayOfMonthDate(long currentTimeMillis) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(currentTimeMillis);
        c.set(5, 28);
        return new Date(c.getTimeInMillis());
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void setCheckboxEnabled() {
        if (this.filterCheckbox == null) {
            this.filterCheckbox = new CheckBox();
            this.filterCheckbox.addButtonListener(this);
            this.add(this.filterCheckbox);
        }
    }

    public boolean isCheckboxEnabled() {
        return this.filterCheckbox != null;
    }

    public void setCommitOnFocusLost(boolean b) {
        this.inputField.setCommitOnFocusLost(b);
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    static {
        prefWidth = -1;
    }

    private class DateChooserLayout1
    extends DefaultLayout {
        private DateChooserLayout1() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            if (DateChooser.this.none != null) {
                DateChooser.this.none.setLocation((int)((double)w - DateChooser.this.none.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - ((CheckBox)DateChooser.this.none.getElement()).getPreferredSize().getHeight()) / 2);
                DateChooser.this.none.setSize(DateChooser.this.none.getPreferredSize());
                DateChooser.this.calendarIcon.setLocation((int)((double)DateChooser.this.none.getX() - (DateChooser.this.calendarIcon.getPreferredSize().getWidth() + (double)text_icon_gap)), 0);
                DateChooser.this.calendarIcon.setSize(DateChooser.this.calendarIcon.getPreferredSize());
                DateChooser.this.inputField.setLocation(0, 0);
                DateChooser.this.inputField.setSize(w - (2 * text_icon_gap + DateChooser.this.none.getWidth() + DateChooser.this.calendarIcon.getWidth()), (int)DateChooser.this.inputField.getPreferredSize().getHeight());
            } else {
                int cx = 0;
                if (DateChooser.this.filterCheckbox != null) {
                    DateChooser.this.filterCheckbox.setLocation(0, (int)(((double)parent.getHeight() - DateChooser.this.filterCheckbox.getPreferredSize().getHeight()) / 2.0));
                    DateChooser.this.filterCheckbox.setSize(DateChooser.this.filterCheckbox.getPreferredSize());
                    cx = DateChooser.this.filterCheckbox.getWidth() + 3;
                }
                DateChooser.this.calendarIcon.setLocation((int)((double)w - DateChooser.this.calendarIcon.getPreferredSize().getWidth()), 0);
                DateChooser.this.calendarIcon.setSize(DateChooser.this.calendarIcon.getPreferredSize());
                DateChooser.this.inputField.setLocation(cx, 0);
                DateChooser.this.inputField.setSize(w - (DateChooser.this.calendarIcon.getWidth() + text_icon_gap + DateChooser.this.inputField.getX()), (int)DateChooser.this.inputField.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

