/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.buttons.BackButton;
import ch.icit.pegasus.client.gui.utils.datechooser.buttons.FFButton;
import ch.icit.pegasus.client.gui.utils.datechooser.buttons.NextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.buttons.RWButton;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateChooserPopup
extends PopUpInsert
implements LafListener,
AttributeListener,
MouseListener,
MouseMotionListener,
ButtonListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private static Color foreground_used;
    private static Color foreground_unused;
    private static Color foreground_daytype;
    private static Color foreground_kw;
    private static Color line_color;
    private static Color foreground_disabled;
    private Skin9Field skin;
    private static int prefWidth;
    private static BufferedImage image_normal_activ;
    private static BufferedImage image_normal_activ_disabled;
    private static BufferedImage image_selected;
    private static BufferedImage image_disabled;
    private static BufferedImage image_over;
    private static Font font_title;
    private static Font font_days;
    private static Font font_date;
    private static Font selected_date_font;
    private TextLabel title;
    private String[] months = new String[12];
    private String[] days = new String[8];
    private Calendar currentDate;
    private Calendar selectedDate;
    private PeriodComplete chooseableRange;
    private NextButton nextButton;
    private BackButton backButton;
    private FFButton ffButton;
    private RWButton rwButton;
    private static int horizontal_border;
    private static int vertical_border;
    private static int horizontal_icon_gap;
    private static int vertical_button_line_gap;
    private static int vertical_line_days_gap;
    private static int vertical_days_dates_gap;
    private static int vertical_dates_dates_gap;
    private static int horizontal_days_inset;
    private static int horizontal_days_kw_gap;
    private int selectedX = -1;
    private int selectedY = -1;
    private int maxY = Integer.MIN_VALUE;
    private InnerPopUp2 popUp;
    private boolean isDragging;
    private int overSelectedY = -1;
    private int overSelectedX = -1;
    private boolean hasSkin;

    public DateChooserPopup(Date currentDate) {
        this.currentDate = TimeUtil.createCalendar();
        if (currentDate != null) {
            this.currentDate.setTimeInMillis(currentDate.getTime());
        }
        this.selectedDate = TimeUtil.createCalendar();
        if (currentDate != null) {
            this.selectedDate.setTimeInMillis(currentDate.getTime());
        }
        this.setLayout(new DateChooserWidgetLayout());
        this.setOpaque(false);
        this.nextButton = new NextButton();
        this.backButton = new BackButton();
        this.ffButton = new FFButton();
        this.rwButton = new RWButton();
        this.title = new TextLabel();
        this.lafAttributeChanged("All attribues changed");
        this.months[0] = Words.JANUARY;
        this.months[1] = Words.FEBRUARY;
        this.months[2] = Words.MARCH;
        this.months[3] = Words.APRIL;
        this.months[4] = Words.MAI;
        this.months[5] = Words.JUNE;
        this.months[6] = Words.JULY;
        this.months[7] = Words.AUGUST;
        this.months[8] = Words.SEPTEMBER;
        this.months[9] = Words.OCTOBER;
        this.months[10] = Words.NOVEMBER;
        this.months[11] = Words.DECEMBER;
        this.days[0] = Words.MO;
        this.days[1] = Words.TU;
        this.days[2] = Words.WE;
        this.days[3] = Words.TH;
        this.days[4] = Words.FR;
        this.days[5] = Words.SA;
        this.days[6] = Words.SO;
        this.days[7] = Words.CW;
        this.attributeChanged("All attributes changed");
        this.updateView();
        this.nextButton.addButtonListener(this);
        this.backButton.addButtonListener(this);
        this.ffButton.addButtonListener(this);
        this.rwButton.addButtonListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.skin = (Skin9Field)DefaultSkins.ContainerBorder.createDynamicSkin();
        this.add(this.nextButton);
        this.add(this.backButton);
        this.add(this.ffButton);
        this.add(this.rwButton);
        this.add(this.title);
    }

    public void enableSkin(boolean useSkin) {
        this.hasSkin = useSkin;
        this.repaint(32L);
    }

    @Override
    public Dimension getPreferredSize() {
        int mH = 0;
        mH += vertical_border + this.ffButton.getHeight() + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize();
        mH += vertical_days_dates_gap;
        mH += 6 * font_date.getSize();
        mH += 6 * vertical_dates_dates_gap;
        return new Dimension(prefWidth, mH += vertical_border);
    }

    public Calendar getSelectedDate() {
        return this.selectedDate;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        g2.setColor(line_color);
        g2.drawLine(this.rwButton.getX(), this.rwButton.getY() + this.rwButton.getHeight() + vertical_button_line_gap, this.ffButton.getX() + this.ffButton.getWidth(), this.rwButton.getY() + this.rwButton.getHeight() + vertical_button_line_gap);
        g2.setFont(font_days);
        g2.setColor(foreground_daytype);
        int rWidth = prefWidth - (2 * horizontal_border + 2 * horizontal_days_inset + horizontal_days_kw_gap);
        int xSpace = rWidth / 8;
        int currentX = horizontal_border + horizontal_days_inset;
        int currentY = this.rwButton.getY() + this.rwButton.getHeight() + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize();
        for (int i = 0; i < this.days.length; ++i) {
            if (i + 1 == this.days.length) {
                currentX += horizontal_days_kw_gap;
            }
            int stringlen = g2.getFontMetrics().stringWidth(this.days[i]);
            int px = (xSpace - stringlen) / 2;
            g2.drawString(this.days[i], currentX + px, currentY);
            currentX += xSpace;
        }
        Calendar pCal = TimeUtil.createCalendar();
        pCal.set(this.currentDate.get(1), this.currentDate.get(2), 1);
        while (pCal.get(7) != 2) {
            pCal.set(5, pCal.get(5) - 1);
        }
        boolean isFinished = false;
        currentX = horizontal_border + horizontal_days_inset;
        currentY += vertical_days_dates_gap + font_date.getSize();
        int count = 0;
        int row = 0;
        int tempAdd = 0;
        while (!isFinished) {
            int type = -1;
            int subType = -1;
            if (type == -1 && pCal.get(2) == this.currentDate.get(2) && count != 7) {
                type = 3;
            } else if (pCal.get(2) == this.currentDate.get(2) && count != 7) {
                subType = 3;
            } else if (count == 7) {
                currentX += horizontal_days_kw_gap;
                type = 5;
            } else if (type == -1) {
                type = 7;
            } else {
                subType = 7;
            }
            String pstr = "" + pCal.get(5);
            if (type == 5) {
                int tp = pCal.get(3) - 1;
                if (tp == 0) {
                    tp = 52;
                }
                pstr = "" + tp;
            }
            int strlen = g2.getFontMetrics().stringWidth(pstr);
            int px = (xSpace - strlen) / 2;
            BufferedImage currentImage = null;
            if (type != 5 && type != 11 && count == this.selectedX && row == this.selectedY) {
                currentImage = image_selected;
                subType = 13;
            } else if (type != 5 && type != 11 && !this.isDragging && pCal.get(5) == this.selectedDate.get(5) && pCal.get(2) == this.selectedDate.get(2) && pCal.get(1) == this.selectedDate.get(1)) {
                currentImage = image_selected;
                subType = 13;
            } else if (type == 3) {
                currentImage = image_normal_activ;
            } else if (type == 11) {
                currentImage = subType == 3 ? image_normal_activ_disabled : image_disabled;
            }
            if (type != 11 && type != 5 && count == this.overSelectedX && row == this.overSelectedY) {
                currentImage = image_over;
            }
            if (currentImage != null) {
                g2.drawImage(currentImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, currentY - (g2.getFont().getSize() + vertical_dates_dates_gap / 2 - 1)), null);
            }
            g2.setFont(font_date);
            switch (type) {
                case 3: {
                    g2.setColor(foreground_used);
                    break;
                }
                case 5: {
                    g2.setColor(foreground_kw);
                    break;
                }
                case 7: {
                    g2.setColor(foreground_unused);
                    break;
                }
                case 11: {
                    g2.setColor(foreground_disabled);
                }
            }
            if (subType == 13) {
                g2.setFont(selected_date_font);
            }
            g2.drawString(pstr, currentX + px + tempAdd, currentY);
            if (++count == 8) {
                currentX = horizontal_border + horizontal_days_inset;
                currentY += g2.getFont().getSize() + vertical_dates_dates_gap;
                ++row;
                if (pCal.get(2) > this.currentDate.get(2) || pCal.get(1) > this.currentDate.get(1)) {
                    isFinished = true;
                }
                count = 0;
            } else {
                currentX += xSpace;
                pCal.set(5, pCal.get(5) + 1);
                if (currentY > this.maxY) {
                    this.maxY = currentY;
                }
            }
            if (subType == 13) {
                tempAdd = 1;
                continue;
            }
            tempAdd = 0;
        }
        this.paintChildren(g2);
    }

    private void updateView() {
        this.title.setText(this.getTitleString(this.currentDate));
        this.validate();
        this.repaint(32L);
    }

    private String getTitleString(Calendar currentDate) {
        Calendar cal = currentDate;
        String ret = "";
        switch (cal.get(2)) {
            case 0: {
                ret = this.months[0];
                break;
            }
            case 1: {
                ret = this.months[1];
                break;
            }
            case 2: {
                ret = this.months[2];
                break;
            }
            case 3: {
                ret = this.months[3];
                break;
            }
            case 4: {
                ret = this.months[4];
                break;
            }
            case 5: {
                ret = this.months[5];
                break;
            }
            case 6: {
                ret = this.months[6];
                break;
            }
            case 7: {
                ret = this.months[7];
                break;
            }
            case 8: {
                ret = this.months[8];
                break;
            }
            case 9: {
                ret = this.months[9];
                break;
            }
            case 10: {
                ret = this.months[10];
                break;
            }
            case 11: {
                ret = this.months[11];
            }
        }
        ret = ret + " " + cal.get(1);
        return ret;
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
        this.title.setFont(font_title);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_horizontal_border"));
            vertical_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_vertial_border"));
            horizontal_icon_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_horizontal_icon_gap"));
            vertical_button_line_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_vertical_button_line_gap"));
            vertical_line_days_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_vertical_line_days_gap"));
            vertical_days_dates_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_vertical_days_dates_gap"));
            vertical_dates_dates_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_vertical_dates_dates_gap"));
            horizontal_days_inset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_horizontal_days_inset"));
            horizontal_days_kw_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("calendar_widget_horizontal_days_kw_gap"));
            this.setSize(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDragged(e);
    }

    private void closeDateChooser() {
        if (this.popUp != null) {
            this.popUp.hidePopUp(this.getValues(PopupAction.OK_FOREGROUND));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
        Calendar pCal = TimeUtil.createCalendar();
        pCal.set(this.currentDate.get(1), this.currentDate.get(2), 1);
        while (pCal.get(7) != 2) {
            pCal.set(5, pCal.get(5) - 1);
        }
        boolean isFinished = false;
        int count = 0;
        int row = 0;
        while (!isFinished) {
            if (count == this.selectedX && row == this.selectedY) {
                this.selectedDate.set(pCal.get(1), pCal.get(2), pCal.get(5));
                isFinished = true;
                this.closeDateChooser();
                continue;
            }
            if (++count == 8) {
                ++row;
                if (pCal.get(2) > this.currentDate.get(2) || pCal.get(1) > this.currentDate.get(1)) {
                    isFinished = true;
                }
                count = 0;
                continue;
            }
            pCal.set(5, pCal.get(5) + 1);
        }
        this.selectedX = -1;
        this.selectedY = -1;
        this.updateView();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.overSelectedX = -1;
        this.overSelectedY = -1;
        this.isDragging = true;
        int rWidth = this.getWidth() - (2 * horizontal_border + 2 * horizontal_days_inset + horizontal_days_kw_gap);
        int xSpace = rWidth / 8;
        if (e.getX() >= horizontal_border + horizontal_days_inset && e.getX() < this.getWidth() - (1 + horizontal_border + xSpace + horizontal_days_kw_gap + horizontal_days_inset) && e.getY() >= vertical_border + this.ffButton.getHeight() - 1 + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize() + vertical_days_dates_gap && e.getY() < this.maxY) {
            int ex = e.getX() - (horizontal_border + horizontal_days_inset);
            int ey = e.getY() - (vertical_border + this.ffButton.getHeight() - 1 + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize() + vertical_days_dates_gap);
            int fx = ex / xSpace;
            int fy = ey / (font_date.getSize() + vertical_dates_dates_gap);
            this.selectedX = fx;
            this.selectedY = fy;
            this.repaint(32L);
            return;
        }
        this.selectedX = -1;
        this.selectedY = -1;
        this.repaint(32L);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isDragging) {
            int rWidth = this.getWidth() - (2 * horizontal_border + 2 * horizontal_days_inset + horizontal_days_kw_gap);
            int xSpace = rWidth / 8;
            if (e.getX() >= horizontal_border + horizontal_days_inset && e.getX() < this.getWidth() - (1 + horizontal_border + xSpace + horizontal_days_kw_gap + horizontal_days_inset) && e.getY() >= vertical_border + this.ffButton.getHeight() - 1 + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize() + vertical_days_dates_gap && e.getY() < this.maxY) {
                int ex = e.getX() - (horizontal_border + horizontal_days_inset);
                int ey = e.getY() - (vertical_border + this.ffButton.getHeight() - 1 + vertical_button_line_gap + vertical_line_days_gap + font_days.getSize() + vertical_days_dates_gap);
                int fx = ex / xSpace;
                int fy = ey / (font_date.getSize() + vertical_dates_dates_gap);
                this.overSelectedX = fx;
                this.overSelectedY = fy;
                this.repaint(32L);
                return;
            }
            this.overSelectedX = -1;
            this.overSelectedY = -1;
            this.repaint(32L);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.nextButton) {
            int cmonth = this.currentDate.get(2);
            int d = this.currentDate.get(5);
            if (d > 28) {
                d = 28;
            }
            this.currentDate.set(5, d);
            this.currentDate.set(2, cmonth + 1);
        } else if (source == this.backButton) {
            int cmonth = this.currentDate.get(2);
            int d = this.currentDate.get(5);
            if (d > 28) {
                d = 28;
            }
            this.currentDate.set(5, d);
            this.currentDate.set(2, cmonth - 1);
        } else if (source == this.ffButton) {
            int cyear = this.currentDate.get(1);
            this.currentDate.set(1, cyear + 1);
        } else if (source == this.rwButton) {
            int cyear = this.currentDate.get(1);
            this.currentDate.set(1, cyear - 1);
        }
        this.maxY = Integer.MIN_VALUE;
        this.updateView();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.selectedDate};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return c == this;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        this.popUp = ip;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public void loadImages() {
        if (image_disabled == null) {
            image_disabled = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_disabled"));
            image_normal_activ = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_normal_activ"));
            image_normal_activ_disabled = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_normal_activ_disabled"));
            image_selected = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_selected"));
            image_over = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_over"));
            foreground_used = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_dates_used"));
            foreground_unused = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_dates_unused"));
            foreground_daytype = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_daytype"));
            foreground_kw = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_kw"));
            foreground_disabled = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_date_disabled"));
            font_title = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("calendar_font_size_title"), LafLoader.getLafLoader().getAttribute("calendar_font_type_title"));
            font_days = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("calendar_font_size_daytype"), LafLoader.getLafLoader().getAttribute("calendar_font_type_daytype"));
            font_date = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("calendar_font_size_dates"), LafLoader.getLafLoader().getAttribute("calendar_font_type_dates"));
            selected_date_font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("calendar_font_size_dates"), LafLoader.getLafLoader().getAttribute("calendar_selected_date_font_type"));
            line_color = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_line_color"));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void clearImages() {
        image_disabled = null;
        this.loadImages();
    }

    static {
        prefWidth = 300;
    }

    private class DateChooserWidgetLayout
    extends DefaultLayout {
        private DateChooserWidgetLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            DateChooserPopup.this.rwButton.setLocation(horizontal_border, vertical_border);
            DateChooserPopup.this.backButton.setLocation(horizontal_border + DateChooserPopup.this.rwButton.getWidth() + horizontal_icon_gap, vertical_border);
            DateChooserPopup.this.ffButton.setLocation(w - (horizontal_border + DateChooserPopup.this.ffButton.getWidth()), vertical_border);
            DateChooserPopup.this.nextButton.setLocation(DateChooserPopup.this.ffButton.getX() - (horizontal_icon_gap + DateChooserPopup.this.nextButton.getWidth()), vertical_border);
            DateChooserPopup.this.title.setLocation((int)((double)w - DateChooserPopup.this.title.getPreferredSize().getWidth()) / 2, vertical_border);
            DateChooserPopup.this.title.setSize(DateChooserPopup.this.title.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

