/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class TitledDayTimePeriodChooser
extends JPanelFadable
implements Focusable,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dateChooser;
    private TextField fromDayTime;
    private TextField toDayTime;
    private TextLabel title1;
    private final ArrowConnectorIcon connector;
    private boolean isPersistable = true;
    private final boolean withDateChooser;
    int aMinDateWidth = 110;
    int aMinTimeWidth = 50;
    int aGap = 10;
    private String id;

    public TitledDayTimePeriodChooser(Node<Date> startDate, Node<Date> endDate, String t1, String t2, boolean withDateChooser) {
        this.withDateChooser = withDateChooser;
        this.setOpaque(false);
        if (withDateChooser) {
            this.dateChooser = new TitledItem<DateChooser>(new DateChooser(startDate, true), t1, TitledItem.TitledItemOrientation.NORTH);
            this.title1 = new TextLabel(t2);
        }
        this.fromDayTime = new DateTimeTextField(TextFieldType.DAYTIME);
        this.toDayTime = new DateTimeTextField(TextFieldType.DAYTIME);
        this.setStartDateNode(startDate);
        this.setEndDateNode(endDate);
        this.fromDayTime.validate();
        this.toDayTime.validate();
        if (t2 == null) {
            t2 = Words.DELIVERY_BETWEEN;
        }
        this.connector = new ArrowConnectorIcon();
        this.setLayout(new Layout());
        if (this.dateChooser != null) {
            this.dateChooser.setProgress(1.0f);
            this.title1.setProgress(1.0f);
        }
        this.fromDayTime.setProgress(1.0f);
        this.toDayTime.setProgress(1.0f);
        this.connector.setProgress(1.0f);
        if (this.dateChooser != null) {
            this.add(this.dateChooser);
            this.add(this.title1);
        }
        this.add(this.fromDayTime);
        this.add(this.connector);
        this.add(this.toDayTime);
    }

    public void setEndDateNode(Node<Date> endDate) {
        this.toDayTime.setNode((Node)endDate);
    }

    public void setStartDateNode(Node<Date> startDate) {
        this.fromDayTime.setNode((Node)startDate);
    }

    public void setNode(Node<PeriodComplete> node) {
        this.setStartDateNode((Node<Date>)node.getChildNamed(PeriodComplete_.startDate));
        this.setEndDateNode((Node<Date>)node.getChildNamed(PeriodComplete_.endDate));
    }

    @Override
    public String getPersistString() {
        String d = "";
        if (this.dateChooser != null) {
            d = this.dateChooser.getElement().getPersistString();
        }
        d = d + "<>";
        d = d + this.fromDayTime.getPersistString();
        d = d + "><";
        d = d + this.toDayTime.getPersistString();
        return d;
    }

    @Override
    public void loadState(String state, String id) {
        String fp;
        String[] a = state.split("<>");
        if (this.dateChooser != null && !(fp = a[0]).isEmpty()) {
            this.dateChooser.getElement().loadState(fp, null);
        }
        String sp = a[1];
        String[] b = sp.split("><");
        this.fromDayTime.loadState(b[0], null);
        this.toDayTime.loadState(b[1], null);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dateChooser != null) {
            this.dateChooser.kill();
            this.dateChooser = null;
        }
        this.fromDayTime.kill();
        this.fromDayTime = null;
        this.toDayTime.kill();
        this.toDayTime = null;
    }

    public Node<Date> getDateStartNode() {
        if (this.withDateChooser) {
            return this.dateChooser.getElement().getNode();
        }
        return this.fromDayTime.getNode();
    }

    public Node getTimeStartNode() {
        return this.fromDayTime.getNode();
    }

    public Node getTimeEndNode() {
        return this.toDayTime.getNode();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.dateChooser);
        CheckedListAdder.addToList(a, this.fromDayTime);
        CheckedListAdder.addToList(a, this.toDayTime);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.dateChooser != null) {
            this.dateChooser.setEnabled(isEnabled);
        }
        this.fromDayTime.setEnabled(isEnabled);
        this.toDayTime.setEnabled(isEnabled);
        this.connector.setEnabled(isEnabled);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.dateChooser != null) {
            this.dateChooser.getElement().setVisibleContainer(pane);
        }
        this.fromDayTime.setVisibleContainer(pane);
        this.toDayTime.setVisibleContainer(pane);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.withDateChooser) {
            this.dateChooser.requestFocusInWindowNow();
        } else {
            this.fromDayTime.requestFocusInWindowNow();
        }
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int currentY = 0;
            if (TitledDayTimePeriodChooser.this.dateChooser != null) {
                TitledDayTimePeriodChooser.this.dateChooser.setLocation(0, 0);
                TitledDayTimePeriodChooser.this.dateChooser.setSize(TitledDayTimePeriodChooser.this.aMinDateWidth, (int)TitledDayTimePeriodChooser.this.dateChooser.getPreferredSize().getHeight());
                currentX = TitledDayTimePeriodChooser.this.dateChooser.getX() + TitledDayTimePeriodChooser.this.dateChooser.getWidth() + TitledDayTimePeriodChooser.this.aGap;
                currentY = (int)((double)(TitledDayTimePeriodChooser.this.dateChooser.getY() + TitledDayTimePeriodChooser.this.dateChooser.getHeight()) - TitledDayTimePeriodChooser.this.fromDayTime.getPreferredSize().getHeight());
            }
            TitledDayTimePeriodChooser.this.fromDayTime.setLocation(currentX, currentY);
            TitledDayTimePeriodChooser.this.fromDayTime.setSize(TitledDayTimePeriodChooser.this.aMinTimeWidth, (int)TitledDayTimePeriodChooser.this.fromDayTime.getPreferredSize().getHeight());
            if (TitledDayTimePeriodChooser.this.title1 != null) {
                TitledDayTimePeriodChooser.this.title1.setLocation(TitledDayTimePeriodChooser.this.fromDayTime.getX(), 0);
                TitledDayTimePeriodChooser.this.title1.setSize(TitledDayTimePeriodChooser.this.title1.getPreferredSize());
            }
            int cY = (TitledDayTimePeriodChooser.this.fromDayTime.getHeight() - TitledDayTimePeriodChooser.this.connector.getHeight()) / 2;
            TitledDayTimePeriodChooser.this.connector.setLocation(TitledDayTimePeriodChooser.this.fromDayTime.getX() + TitledDayTimePeriodChooser.this.fromDayTime.getWidth() + TitledDayTimePeriodChooser.this.aGap, TitledDayTimePeriodChooser.this.fromDayTime.getY() + cY);
            TitledDayTimePeriodChooser.this.connector.setSize(TitledDayTimePeriodChooser.this.connector.getPreferredSize());
            TitledDayTimePeriodChooser.this.toDayTime.setLocation(TitledDayTimePeriodChooser.this.connector.getX() + TitledDayTimePeriodChooser.this.connector.getWidth() + TitledDayTimePeriodChooser.this.aGap, TitledDayTimePeriodChooser.this.fromDayTime.getY());
            TitledDayTimePeriodChooser.this.toDayTime.setSize(TitledDayTimePeriodChooser.this.aMinTimeWidth, (int)TitledDayTimePeriodChooser.this.toDayTime.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int w = 0;
            if (TitledDayTimePeriodChooser.this.dateChooser != null) {
                h = (int)TitledDayTimePeriodChooser.this.dateChooser.getPreferredSize().getHeight();
                w = (int)((double)(TitledDayTimePeriodChooser.this.aMinDateWidth + TitledDayTimePeriodChooser.this.aGap + TitledDayTimePeriodChooser.this.aMinTimeWidth + TitledDayTimePeriodChooser.this.aGap) + TitledDayTimePeriodChooser.this.connector.getPreferredSize().getWidth() + (double)TitledDayTimePeriodChooser.this.aGap + (double)TitledDayTimePeriodChooser.this.aMinTimeWidth);
            } else {
                h = (int)((double)h + TitledDayTimePeriodChooser.this.toDayTime.getPreferredSize().getHeight());
                w = (int)((double)(TitledDayTimePeriodChooser.this.aMinTimeWidth + TitledDayTimePeriodChooser.this.aGap) + TitledDayTimePeriodChooser.this.connector.getPreferredSize().getWidth() + (double)TitledDayTimePeriodChooser.this.aGap + (double)TitledDayTimePeriodChooser.this.aMinTimeWidth);
            }
            return new Dimension(w, h);
        }
    }
}

