/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.file;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.FileReferenceWriteBack;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DownloadPopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileChooserPanel
extends DefaultPanel
implements ButtonListener,
Nodable,
Validatable {
    private static final long serialVersionUID = 1L;
    private TextLabel choosenFile;
    private TextButton chooseFile;
    private TextButton showFile;
    private Node<PegasusFileComplete> node;
    private boolean isReadOnly;
    private boolean pdfOnly;
    private FileReferenceWriteBack run;
    private DeleteButton removeFile;
    private String fileType = "PDF";

    public FileChooserPanel(Node<PegasusFileComplete> node) {
        this(node, true);
    }

    public FileChooserPanel(Node<PegasusFileComplete> node, boolean pdfOnly) {
        this(false, Words.CHOOSE, Words.SHOW, pdfOnly);
        this.setNode(node);
    }

    public FileChooserPanel(boolean withShow) {
        this(withShow, Words.CHOOSE, Words.SHOW, true);
    }

    public FileChooserPanel(boolean withShow, String chooseText, String showText, boolean pdfOnly) {
        this(withShow, true, chooseText, showText, pdfOnly);
    }

    public FileChooserPanel(boolean withShow, boolean withChoose, String chooseText, String showText, boolean pdfOnly) {
        this.pdfOnly = pdfOnly;
        this.choosenFile = new TextLabel();
        this.choosenFile.setReadOnlyTextField(true);
        this.removeFile = new DeleteButton();
        this.removeFile.addButtonListener(this);
        this.setLayout(new Layout());
        if (withShow) {
            this.showFile = new TextButton(showText != null ? showText : Words.SHOW);
            this.showFile.addButtonListener(this);
            this.add(this.showFile);
        }
        this.chooseFile = new TextButton(chooseText != null ? chooseText : Words.CHOOSE);
        this.chooseFile.addButtonListener(this);
        this.add(this.chooseFile);
        this.add(this.choosenFile);
        this.add(this.removeFile);
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.chooseFile);
        CheckedListAdder.addToList(a, this.showFile);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = isEnabled && !this.isReadOnly;
        this.chooseFile.setEnabled(b);
        this.choosenFile.setEnabled(b);
        if (this.showFile != null) {
            boolean selected = false;
            selected = this.node.getValue() != null ? ((PegasusFileComplete)this.node.getValue()).getLocalFile() != null || ((PegasusFileComplete)this.node.getValue()).getUri() != null : false;
            this.showFile.setEnabled(selected);
            this.removeFile.setEnabled(selected);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.chooseFile.kill();
        this.chooseFile = null;
        this.choosenFile.kill();
        this.choosenFile = null;
        if (this.showFile != null) {
            this.showFile.kill();
        }
        this.showFile = null;
        this.removeFile.kill();
        this.removeFile = null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.chooseFile.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.chooseFile.requestFocusInWindowNow();
    }

    public boolean isFileChooserOpen() {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.chooseFile) {
            File f = FileChooserUtil.loadFile();
            if (f != null) {
                this.processFileSelection(f, true);
            }
        } else if (source == this.showFile) {
            this.processFileShow();
        } else if (source == this.removeFile) {
            this.node.setValue(null, 0L);
            this.setNode(this.node);
        }
    }

    private void processFileShow() {
        if (this.node.getValue() == null && ((PegasusFileComplete)this.node.getValue()).getLocalFile() != null) {
            InnerPopupFactory.showErrorDialog("No Specification selected", (Component)this);
            return;
        }
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        pop.setAttributes(this, false, true, "Article Specification");
        DownloadPopupInsert r = new DownloadPopupInsert(this.node, false);
        pop.setView(r);
        pop.showPopUpWithinScreenMiddle(-1, -1, null, this, PopupType.NORMAL);
        r.startLoad();
    }

    private void processFileSelection(File file, boolean justSelected) {
        if (this.pdfOnly && justSelected && file != null && !file.getName().toLowerCase().endsWith(this.fileType.toLowerCase())) {
            InnerPopupFactory.showErrorDialog("Specification must be a " + this.fileType.toUpperCase(), (Component)this);
            this.setEnabled(this.isEnabled());
            return;
        }
        if (this.node.getValue() == null) {
            PegasusFileComplete ref = new PegasusFileComplete();
            ref.setClientOId(Long.valueOf(ADTO.getNextId()));
            this.node.setValue((Object)ref, 0L);
        }
        if (justSelected && file != null) {
            ((PegasusFileComplete)this.node.getValue()).setLocalFile(file);
        }
        String fileName = "-";
        String folderName = "";
        if (((PegasusFileComplete)this.node.getValue()).getLocalFile() != null) {
            File f = ((PegasusFileComplete)this.node.getValue()).getLocalFile();
            fileName = f.getAbsolutePath();
            folderName = f.getAbsolutePath();
        } else if (((PegasusFileComplete)this.node.getValue()).getFileName() != null) {
            fileName = ((PegasusFileComplete)this.node.getValue()).getFileName();
            folderName = ((PegasusFileComplete)this.node.getValue()).getFileName();
        }
        if (justSelected && file != null) {
            ((PegasusFileComplete)this.node.getValue()).setFileName(fileName);
        }
        if (justSelected) {
            MainFrame.setDefaultPath(folderName);
        }
        this.choosenFile.setText(fileName);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (this.node == null) {
            return;
        }
        this.processFileSelection(null, false);
        this.setWriteBackAlgorithm(new FileReferenceWriteBack(){

            @Override
            public void writeBack(PegasusFileComplete reference) {
                FileChooserPanel.this.node.removeExistingValues();
                FileChooserPanel.this.node.setValue((Object)reference, System.currentTimeMillis());
            }
        });
    }

    public Node<PegasusFileComplete> getNode() {
        return this.node;
    }

    @Override
    public void setValid() {
        this.chooseFile.setValid();
    }

    @Override
    public void setInvalid() {
        this.chooseFile.setInvalid();
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public void setWriteBackAlgorithm(FileReferenceWriteBack run) {
        this.run = run;
    }

    public List<RemoteCommitter> commitFile() {
        if (this.node != null && this.node.getValue() != null && ((PegasusFileComplete)this.node.getValue()).getId() == null) {
            if (((PegasusFileComplete)this.node.getValue()).getLocalFile() == null) {
                this.node.setValue(null, 0L);
                return null;
            }
            ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
            FileCommitter c = new FileCommitter(((PegasusFileComplete)this.node.getValue()).getLocalFile(), FileCategoryE.IMPORT);
            c.setWriteBackAlgorithm(this.run);
            a.add(c);
            return a;
        }
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int offset = (int)FileChooserPanel.this.chooseFile.getPreferredSize().getWidth();
            if (FileChooserPanel.this.showFile != null) {
                offset = (int)((double)offset + (5.0 + FileChooserPanel.this.showFile.getPreferredSize().getWidth()));
            }
            FileChooserPanel.this.chooseFile.setLocation(parent.getWidth() - offset, 0);
            FileChooserPanel.this.chooseFile.setSize(FileChooserPanel.this.chooseFile.getPreferredSize());
            FileChooserPanel.this.choosenFile.setLocation(0, 0);
            FileChooserPanel.this.choosenFile.setSize((int)((double)FileChooserPanel.this.chooseFile.getX() - (5.0 + FileChooserPanel.this.removeFile.getPreferredSize().getWidth() + 5.0)), (int)FileChooserPanel.this.choosenFile.getPreferredSize().getHeight());
            FileChooserPanel.this.removeFile.setLocation(FileChooserPanel.this.choosenFile.getX() + FileChooserPanel.this.choosenFile.getWidth() + 5, FileChooserPanel.this.chooseFile.getY());
            FileChooserPanel.this.removeFile.setSize(FileChooserPanel.this.removeFile.getPreferredSize());
            if (FileChooserPanel.this.showFile != null) {
                FileChooserPanel.this.showFile.setLocation(FileChooserPanel.this.chooseFile.getX() + FileChooserPanel.this.chooseFile.getWidth() + 5, FileChooserPanel.this.chooseFile.getY());
                FileChooserPanel.this.showFile.setSize(FileChooserPanel.this.showFile.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h2;
            int h = (int)FileChooserPanel.this.chooseFile.getPreferredSize().getHeight();
            if (h < (h2 = (int)FileChooserPanel.this.choosenFile.getPreferredSize().getHeight())) {
                h = h2;
            }
            int w = (int)FileChooserPanel.this.chooseFile.getPreferredSize().getWidth();
            w += 5;
            return new Dimension(w += 100, h);
        }
    }
}

