/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.filterchain;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilterChainConfiguration {
    private List<String[]> properties = new ArrayList<String[]>();
    private static String currentPath;

    public FilterChainConfiguration() {
        File f;
        if (currentPath == null && !(f = new File(currentPath = System.getProperty("user.home") + File.separator + ".catit" + File.separator)).exists()) {
            f.mkdirs();
            f.setWritable(true);
        }
    }

    public void addProperty(String name, String value) {
        String[] t = new String[]{name, value};
        this.properties.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilterChainConfiguration loadConfiguration(String currentScreen, UserLight currentUser, String currentServer, String currentCustomer) {
        FilterChainConfiguration c = new FilterChainConfiguration();
        String t = currentPath + "" + currentCustomer + "_" + currentScreen + "_" + currentUser.getUserName() + "_config.catit";
        File f = new File(t);
        if (f.exists()) {
            try (BufferedReader input = new BufferedReader(new FileReader(f));){
                String line = null;
                while ((line = input.readLine()) != null) {
                    String[] a = line.split("%");
                    if (a.length != 2) continue;
                    c.addProperty(a[0], a[1]);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return c;
        }
        return null;
    }

    public static void saveConfiguration(String currentScreen, UserLight currentUser, FilterChainConfiguration conf, String currentServer, String currentCustomer) {
        if (conf == null) {
            return;
        }
        Iterator<String[]> it = conf.getProperties().iterator();
        String t = "";
        String linefeed = System.getProperty("line.separator");
        while (it.hasNext()) {
            String[] e = it.next();
            t = t + e[0] + "%" + e[1];
            if (e[1] == null) {
                return;
            }
            if (!it.hasNext()) continue;
            t = t + linefeed;
        }
        String fn = currentCustomer + "_" + currentScreen + "_" + currentUser.getUserName() + "_config.catit";
        FilterChainConfiguration.writeFile(t, fn);
    }

    private static void writeFile(String t, String path) {
        String p = currentPath + path;
        File f = new File(p);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (FileWriter out = new FileWriter(f);){
            BufferedWriter output = new BufferedWriter(out);
            output.write(t);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public List<String[]> getProperties() {
        return this.properties;
    }

    public static void removeDefaultConfiguration(UserLight currentUser, String serverName, String customerName) {
        String t = "";
        String fn = customerName + "_" + MainFrame.class.getName() + "_" + currentUser.getUserName() + "_config.catit";
        FilterChainConfiguration.deleteFile(t, fn);
    }

    private static void deleteFile(String t, String fn) {
        String p = currentPath + fn;
        File f = new File(p);
        if (f.exists()) {
            f.delete();
        }
    }

    public static PeriodComplete getDefaultSearchPeriod() {
        long now = System.currentTimeMillis();
        long s = now - 604800000L;
        long e = now + 604800000L;
        Converter c = ConverterRegistry.getConverter(DateConverter.class);
        Date sd = new Date(s);
        Date ed = new Date(e);
        return new PeriodComplete(sd, ed);
    }

    public static String getDefaultSearchPeriodString() {
        long now = System.currentTimeMillis();
        long s = now - 604800000L;
        long e = now + 604800000L;
        Converter c = ConverterRegistry.getConverter(DateConverter.class);
        Date sd = new Date(s);
        Date ed = new Date(e);
        String t = (String)c.convert((Object)sd, null, new Object[0]);
        t = t + "<>";
        t = t + c.convert((Object)ed, null, new Object[0]);
        t = t + "<>true";
        return t;
    }

    public static Date readDate(String v) {
        return Date.valueOf(v);
    }

    public static String createDateString(Date d) {
        return d.toString();
    }
}

