/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class CustomFocusCyclePolicy
extends FocusTraversalPolicy {
    private ArrayList<Component> order;
    private Component currentFocusComp;

    public static FocusTraversalPolicy revalidateFocusCyclePolicy(List<Component> a, JComponent comp) {
        FocusTraversalPolicy policy = comp.getFocusTraversalPolicy();
        if (!(policy instanceof CustomFocusCyclePolicy)) {
            policy = new CustomFocusCyclePolicy();
            comp.setFocusTraversalPolicyProvider(true);
            comp.setFocusTraversalPolicy(policy);
        }
        ((CustomFocusCyclePolicy)policy).revalidateFocusCycle(a);
        return policy;
    }

    public void revalidateFocusCycle(List<Component> orderA) {
        if (this.currentFocusComp != null && !orderA.contains(this.currentFocusComp)) {
            int count = this.order.indexOf(this.currentFocusComp);
            ++count;
            Component aForewardBound = this.currentFocusComp;
            while (!orderA.contains(aForewardBound) && count < this.order.size()) {
                aForewardBound = this.order.get(count);
                ++count;
            }
            if (!orderA.contains(aForewardBound)) {
                aForewardBound = null;
            }
            count = this.order.indexOf(this.currentFocusComp);
            --count;
            Component aBackwardBound = this.currentFocusComp;
            while (!orderA.contains(aBackwardBound) && count >= 0) {
                aBackwardBound = this.order.get(count);
                --count;
            }
            if (!orderA.contains(aBackwardBound)) {
                aBackwardBound = null;
            }
            if (aForewardBound != null && aBackwardBound != null) {
                int s = orderA.indexOf(aBackwardBound);
                int e = orderA.indexOf(aForewardBound);
                if (e - s > 1) {
                    Component c = orderA.get(e - 1);
                    c.requestFocusInWindow();
                } else {
                    Component c = orderA.get(e);
                    c.requestFocusInWindow();
                }
            } else if (aForewardBound != null) {
                aForewardBound.requestFocusInWindow();
            } else if (aBackwardBound != null) {
                aBackwardBound.requestFocusInWindow();
            }
        }
        this.order = new ArrayList();
        this.order.addAll(orderA);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        if (this.order.size() == 0) {
            this.currentFocusComp = null;
            return null;
        }
        int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
        this.currentFocusComp = this.order.get(idx);
        return this.currentFocusComp;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        if (this.order.size() == 0) {
            this.currentFocusComp = null;
            return null;
        }
        int idx = this.order.indexOf(aComponent) - 1;
        if (idx < 0) {
            idx = this.order.size() - 1;
        }
        this.currentFocusComp = this.order.get(idx);
        return this.currentFocusComp;
    }

    public void kill() {
        if (this.order != null) {
            this.order.clear();
            this.order = null;
        }
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.order.size() > 0) {
            this.currentFocusComp = this.order.get(0);
            return this.currentFocusComp;
        }
        this.currentFocusComp = null;
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        if (this.order != null && this.order.size() > 0) {
            this.currentFocusComp = this.order.get(this.order.size() - 1);
            return this.currentFocusComp;
        }
        this.currentFocusComp = null;
        return null;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        if (this.order != null && this.order.size() > 0) {
            this.currentFocusComp = this.order.get(0);
            return this.currentFocusComp;
        }
        this.currentFocusComp = null;
        return null;
    }
}

