/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.icons;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ArrowConnectorIcon
extends JPanelFadable
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private static BufferedImage right;
    private static BufferedImage left;
    private static BufferedImage up;
    private static BufferedImage down;
    private int orientation;

    public ArrowConnectorIcon(int orientation) {
        this.orientation = orientation;
        this.lafAttributeChanged("All attribues changed");
        this.setProgress(1.0f);
    }

    public ArrowConnectorIcon() {
        this(4);
    }

    @Override
    public Dimension getPreferredSize() {
        switch (this.orientation) {
            case 1: 
            case 3: {
                return new Dimension(up != null ? up.getWidth() : 0, up != null ? up.getHeight() : 0);
            }
            case 2: 
            case 4: {
                return new Dimension(right != null ? right.getWidth() : 0, right != null ? right.getHeight() : 0);
            }
        }
        return new Dimension();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        BufferedImage i = null;
        switch (this.orientation) {
            case 4: {
                i = right;
                break;
            }
            case 2: {
                i = left;
                break;
            }
            case 1: {
                i = up;
                break;
            }
            case 3: {
                i = down;
            }
        }
        g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    public static int getPreferredWidth() {
        return ArrowConnectorIcon.getPreferredWidth(4);
    }

    public static int getPreferredWidth(int orientation) {
        switch (orientation) {
            case 1: 
            case 3: {
                return AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_up")).getWidth();
            }
            case 2: 
            case 4: {
                return AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_right")).getWidth();
            }
        }
        return 0;
    }

    @Override
    public void loadImages() {
        if (right == null) {
            right = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_right"));
            left = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_left"));
            up = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_up"));
            down = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_down"));
        }
    }

    @Override
    public void clearImages() {
        right = null;
        left = null;
        up = null;
        down = null;
        this.loadImages();
    }
}

