/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image;

import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.FileDownloader;
import ch.icit.pegasus.client.gui.table.commiter.FileReferenceWriteBack;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.image.ImageFileChooserPopupInsert;
import ch.icit.pegasus.client.gui.utils.image.ImagePreviewPopupInset;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class ImageChooser
extends JPanelFadable
implements ButtonListener,
InnerPopUpListener2,
Focusable,
MutableFocusContainer,
Nodable {
    private static final long serialVersionUID = 1L;
    private TextButton choose;
    private TextButton preview;
    private TextButton downloadImage;
    private DeleteButton deleteImage;
    private Node<PegasusFileComplete> imageNode;
    private File currentFile;
    private FileReferenceWriteBack run;
    private BufferedImage currentImage;
    private boolean isImageSet;
    private boolean isEditable = true;
    private MutableFocusContainerListener listener;
    private InnerPopUp2 currentPopup;
    private boolean isShowingFileChooser;

    public ImageChooser(Node image, boolean isEditable) {
        this();
        this.isEditable = isEditable;
        this.setNode(image);
    }

    public ImageChooser(Node image) {
        this(image, true);
    }

    public ImageChooser() {
        this.setOpaque(false);
        this.choose = new TextButton(Words.CHOOSE);
        this.preview = new TextButton(Words.PREVIEW);
        this.downloadImage = new TextButton(Words.DOWNLOAD);
        this.deleteImage = new DeleteButton();
        this.deleteImage.addButtonListener(this);
        this.choose.addButtonListener(this);
        this.preview.addButtonListener(this);
        this.downloadImage.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.choose);
        this.add(this.preview);
        this.add(this.downloadImage);
        this.add(this.deleteImage);
    }

    @Override
    public Node<?> getNode() {
        return this.imageNode;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.choose.setEnabled(isEnabled && this.isEditable);
        this.preview.setEnabled(isEnabled && this.imageNode != null ? this.imageNode.getValue() != null : false);
        this.downloadImage.setEnabled(this.preview.isEnabled());
        this.deleteImage.setEnabled(isEnabled && this.preview.isEnabled() && this.isEditable);
    }

    public void setWriteBackAlgorithm(FileReferenceWriteBack run) {
        this.run = run;
    }

    public List<RemoteCommitter> commitImage() {
        if (this.imageNode != null) {
            Node n = this.imageNode.getChildNamed(DtoFieldConstants.oldOne);
            PegasusFileComplete toDelete = null;
            if (n != null) {
                toDelete = (PegasusFileComplete)n.getValue();
            }
            if (this.isImageSet) {
                ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
                FileCommitter c = new FileCommitter(this.currentFile, FileCategoryE.PICTURE);
                c.setWriteBackAlgorithm(this.run);
                a.add(c);
                return a;
            }
        }
        return null;
    }

    public void setNode(Node node) {
        this.imageNode = node;
        if (this.imageNode != null && this.imageNode.getValue() != null) {
            this.isImageSet = true;
            if (((PegasusFileComplete)this.imageNode.getValue()).getLocalFile() != null) {
                this.currentFile = ((PegasusFileComplete)this.imageNode.getValue()).getLocalFile();
            }
        } else {
            this.isImageSet = false;
        }
        this.preview.setEnabled(this.isImageSet);
        this.deleteImage.setEnabled(this.isImageSet);
        this.choose.setEnabled(true & this.isEditable);
        this.downloadImage.setEnabled(this.isImageSet);
        this.setWriteBackAlgorithm(new FileReferenceWriteBack(){

            @Override
            public void writeBack(PegasusFileComplete reference) {
                ImageChooser.this.imageNode.removeExistingValues();
                ImageChooser.this.imageNode.setValue((Object)reference, System.currentTimeMillis());
            }
        });
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        if (this.currentFile != null) {
            this.currentFile = null;
        }
        this.deleteImage.kill();
        this.choose.kill();
        this.preview.kill();
        this.downloadImage.kill();
        this.choose = null;
        this.preview = null;
        this.deleteImage = null;
        this.downloadImage = null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.preview) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.preview, true, true, Words.IMAGE_PREVIEW);
            popUp.hideCancelButton();
            popUp.setView(new ImagePreviewPopupInset(this.currentImage, this.imageNode));
            popUp.showPopUp(x, y, 300, 300, this, this.preview, PopupType.FRAMELESS);
            this.currentPopup = popUp;
        } else if (source == this.downloadImage) {
            final FileDownloader id = new FileDownloader((PegasusFileComplete)this.imageNode.getValue());
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    File downloadedFile = null;
                    if (id != null) {
                        id.download(null);
                        downloadedFile = id.getDownloadedFile();
                    }
                    if (downloadedFile != null) {
                        ImageChooser.this.isShowingFileChooser = true;
                        File fileName = null;
                        try {
                            fileName = FileChooserUtil.saveFile(".png");
                            FileUtils.copyFile((File)downloadedFile, (File)fileName);
                        }
                        catch (Exception t) {
                            InnerPopupFactory.showErrorDialog(t, (Component)ImageChooser.this);
                        }
                        InnerPopupFactory.showMessageDialog("Image downloaded", ImageChooser.this);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return null;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.deleteImage) {
            if (this.imageNode != null) {
                InnerPopupFactory.showDesicionPopup("Delete Image", "Are you sure to delete current Image?", this.deleteImage, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        ImageChooser.this.imageNode.setValue(null, 0L);
                        ImageChooser.this.setEnabled(ImageChooser.this.isEnabled());
                    }
                }, -1, -1, PopupType.NORMAL);
            }
        } else if (source == this.choose) {
            this.isShowingFileChooser = true;
            File fileName = null;
            try {
                fileName = FileChooserUtil.loadFile();
            }
            catch (Exception t) {
                InnerPopupFactory.showErrorDialog(t, (Component)this);
            }
            if (fileName != null) {
                this.currentFile = fileName;
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.choose, false, true, Words.CHOOSE_IMAGE);
                boolean error = false;
                String msg = "";
                try {
                    this.currentImage = ImageIO.read(this.currentFile);
                    this.currentFile = ImageChooser.scaleImage(this.currentImage);
                    this.currentImage = ImageIO.read(this.currentFile);
                }
                catch (IOException e) {
                    error = true;
                    msg = e.getMessage();
                }
                catch (Exception e) {
                    error = true;
                    msg = e.getMessage();
                }
                if (error) {
                    InnerPopupFactory.showErrorDialog("Unable to load image, Please rechoose again", (Component)this);
                } else {
                    boolean hadFileBefore = false;
                    if (this.imageNode.getValue() != null && ((PegasusFileComplete)this.imageNode.getValue()).getId() != null) {
                        hadFileBefore = true;
                    }
                    PegasusFileComplete r = new PegasusFileComplete();
                    r.setClientOId(Long.valueOf(ADTO.getNextId()));
                    r.setLocalFile(this.currentFile);
                    r.setUri(this.currentFile.toURI());
                    r.setCategory(FileCategoryE.PICTURE);
                    DTONode nNode = new DTONode();
                    nNode.setValue((Object)r, 0L);
                    popUp.setView(new ImageFileChooserPopupInsert((Node<PegasusFileComplete>)nNode, this.imageNode, hadFileBefore));
                    popUp.showPopUp(x, y, -1, -1, this, this.choose, PopupType.FRAMELESS);
                }
            } else if (this.getParent() != null) {
                if (this.getParent().getParent() != null) {
                    if (this.getParent().getParent().getParent() != null) {
                        if (this.getParent().getParent().getParent().getParent() != null) {
                            this.getParent().getParent().getParent().getParent().repaint(32L);
                        } else {
                            this.getParent().getParent().getParent().repaint(32L);
                        }
                    } else {
                        this.getParent().getParent().repaint(32L);
                    }
                } else {
                    this.getParent().repaint(32L);
                }
            } else {
                this.repaint(32L);
            }
            this.isShowingFileChooser = false;
        }
    }

    private static File scaleImage(BufferedImage currentImage) throws ClientRemoteException {
        BufferedImage nImage = GraphicsUtils.scaleImage(currentImage);
        if (currentImage != null) {
            currentImage.flush();
            currentImage = null;
        }
        currentImage = nImage;
        if (nImage != null) {
            nImage.flush();
            nImage = null;
        }
        if (currentImage != null) {
            File f = null;
            try {
                f = File.createTempFile("rescaleImg", ".png");
                ImageIO.write((RenderedImage)currentImage, "PNG", f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return f;
        }
        return null;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs != null && xargs.length >= 1) {
            boolean b;
            if (this.currentImage != null) {
                this.currentImage.flush();
                this.currentImage = null;
            }
            if (xargs.length >= 3 && (b = ((Boolean)xargs[2]).booleanValue()) && this.imageNode.getChildNamed(DtoFieldConstants.oldOne) == null) {
                PegasusFileComplete r = (PegasusFileComplete)this.imageNode.getValue();
                PegasusFileComplete cr = new PegasusFileComplete(r.getId());
                cr.setCategory(r.getCategory());
                cr.setDescription(r.getDescription());
                cr.setUri(r.getUri());
                DTONode n = new DTONode();
                n.setValue((Object)cr, 0L);
                n.setName(DtoFieldConstants.oldOne);
                this.imageNode.addChild((Node)n, 0L);
            }
            this.currentImage = (BufferedImage)xargs[0];
            if (xargs.length > 1 && this.currentFile != null && !this.currentFile.equals(xargs[1])) {
                this.currentFile = (File)xargs[1];
                PegasusFileComplete f = new PegasusFileComplete();
                f.setCategory(FileCategoryE.PICTURE);
                f.setClientOId(Long.valueOf(ADTO.getNextId()));
                f.setLocalFile(this.currentFile);
                this.imageNode.removeExistingValues();
                this.imageNode.setValue((Object)f, 0L);
            }
            if (this.preview != null) {
                this.preview.setEnabled(this.imageNode.getValue() != null);
                this.isImageSet = this.preview.isEnabled();
            }
            if (this.listener != null) {
                this.listener.focusCycleChanged(this);
            }
            if (this.preview != null) {
                this.preview.requestFocusInWindowNow();
            }
        } else if (this.preview != null && this.preview.isEnabled()) {
            this.preview.requestFocusInWindowNow();
        }
        if (!this.isKilled()) {
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.choose);
        if (this.imageNode != null && this.imageNode.getValue() != null) {
            CheckedListAdder.addToList(a, this.preview);
            CheckedListAdder.addToList(a, this.deleteImage);
        }
        return a;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.choose.requestFocusInWindowNow();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = null;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = listener;
    }

    public boolean isInnerComponent(Component c) {
        if (this.isShowingFileChooser) {
            return true;
        }
        if (this.currentPopup != null) {
            return this.currentPopup.isInnerComponent(c);
        }
        return false;
    }

    public void enablePreviewAnyWay(boolean isEnabled) {
        this.preview.setEnabled(isEnabled && this.imageNode != null ? this.imageNode.getValue() != null : false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            w -= 15;
            w = (int)((double)w - ImageChooser.this.deleteImage.getPreferredSize().getWidth());
            ImageChooser.this.choose.setLocation(0, (int)(((double)parent.getHeight() - ImageChooser.this.choose.getPreferredSize().getHeight()) / 2.0));
            ImageChooser.this.choose.setSize(w / 3, (int)ImageChooser.this.choose.getPreferredSize().getHeight());
            ImageChooser.this.preview.setLocation(ImageChooser.this.choose.getWidth() + 5, (int)(((double)parent.getHeight() - ImageChooser.this.preview.getPreferredSize().getHeight()) / 2.0));
            ImageChooser.this.preview.setSize(w / 3, (int)ImageChooser.this.preview.getPreferredSize().getHeight());
            ImageChooser.this.downloadImage.setLocation(ImageChooser.this.preview.getX() + ImageChooser.this.preview.getWidth() + 5, (int)(((double)parent.getHeight() - ImageChooser.this.downloadImage.getPreferredSize().getHeight()) / 2.0));
            ImageChooser.this.downloadImage.setSize(w / 3, (int)ImageChooser.this.downloadImage.getPreferredSize().getHeight());
            ImageChooser.this.deleteImage.setLocation(ImageChooser.this.downloadImage.getX() + ImageChooser.this.downloadImage.getWidth() + 5, (int)(((double)parent.getHeight() - ImageChooser.this.deleteImage.getPreferredSize().getHeight()) / 2.0));
            ImageChooser.this.deleteImage.setSize(ImageChooser.this.deleteImage.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)(ImageChooser.this.choose.getPreferredSize().getWidth() * 2.0 + 10.0 + ImageChooser.this.deleteImage.getPreferredSize().getWidth());
            if (ImageChooser.this.downloadImage != null) {
                w += 10;
                w = (int)((double)w + ImageChooser.this.downloadImage.getPreferredSize().getWidth());
            }
            return new Dimension(w, (int)ImageChooser.this.preview.getPreferredSize().getHeight());
        }
    }
}

