/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image;

import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImagePreviewPainter {
    public void paint(Graphics2D g2, int x, int y, int w, int h, SystemSettingsComplete settings, BufferedImage currentImage) {
        this.paint(g2, x, y, w, h, settings, currentImage, false);
    }

    public void paint(Graphics2D g2, int x, int y, int w, int h, SystemSettingsComplete settings, BufferedImage currentImage, boolean fit) {
        int preferredImageWidth = settings.getPreferredHorizontalImage_size();
        int preferredImageHeight = settings.getPreferredVericalImage_size();
        if (fit) {
            preferredImageWidth = w;
            preferredImageHeight = h;
        }
        int dx = x;
        int dy = y;
        int mw = w - dx * 2;
        int mh = h - dy;
        int tw = mw;
        int th = mh;
        double fw = (double)mw / (double)preferredImageWidth;
        double fh = (double)mh / (double)preferredImageHeight;
        if (fw < fh) {
            mw = (int)((double)preferredImageWidth * fw);
            mh = (int)((double)preferredImageHeight * fw);
        } else {
            mw = (int)((double)preferredImageWidth * fh);
            mh = (int)((double)preferredImageHeight * fh);
        }
        int tx = dx + (tw - mw) / 2;
        int ty = dy + (th - mh) / 2;
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRect(tx, ty, mw - 1, mh - 1);
        int iw = 0;
        int ih = 0;
        if (currentImage != null) {
            iw = currentImage.getWidth();
            ih = currentImage.getHeight();
        } else {
            iw = w;
            ih = h;
        }
        double ifx = (double)mw / (double)iw;
        double ify = (double)mh / (double)ih;
        double ofx = (double)iw / (double)preferredImageWidth;
        double ofy = (double)ih / (double)preferredImageHeight;
        double uf = 0.0;
        if (ofx < 1.0 || ofy < 1.0) {
            if (ofx > ofy) {
                ifx *= ofx;
                ify *= ofx;
            } else {
                ifx *= ofy;
                ify *= ofy;
            }
        }
        if (ifx < ify) {
            uf = ifx;
            iw = (int)((double)iw * ifx);
            ih = (int)((double)ih * ifx);
        } else {
            uf = ify;
            iw = (int)((double)iw * ify);
            ih = (int)((double)ih * ify);
        }
        if (iw != mw || ih != mh || currentImage == null) {
            int cw = mw;
            int ch = mh;
            g2.translate(tx, ty);
            Shape backclip = g2.getClip();
            g2.clipRect(0, 0, cw, ch);
            if (cw % 2 != 0) {
                ++cw;
            }
            if (ch % 2 != 0) {
                ++ch;
            }
            Shape hatch = DrawToolkit.createHatchTexture(cw, ch, 0.5235987755982988, 5);
            g2.draw(hatch);
            g2.setClip(backclip);
            g2.translate(-tx, -ty);
        }
        if (currentImage != null) {
            AffineTransform aff = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, tx, ty);
            aff.scale(uf, uf);
            g2.drawImage(currentImage, aff, null);
        }
    }
}

