/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image;

import ch.icit.pegasus.client.gui.table.commiter.FileDownloader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.loading.ImageDownloadProgressbar;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.image.ImagePreviewPainter;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.SwingUtilities;

public class ImagePreviewPopupInset
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage currentImage;
    private ImageDownloadProgressbar progress;
    private FileDownloader id;
    private ImagePreviewPainter painter;
    private TitledItem<CheckBox> fitImage;
    private SystemSettingsComplete settings;
    private boolean isProgress = false;
    private TextLabel msg;
    private boolean wasException;

    public ImagePreviewPopupInset(BufferedImage image, Node imageNode) {
        this.currentImage = image;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixList(SystemSettingsComplete.class).getValue();
        this.painter = new ImagePreviewPainter();
        this.fitImage = new TitledItem<CheckBox>(new CheckBox(), "Fit Image (Preview only)", TitledItem.TitledItemOrientation.WEST);
        this.fitImage.getElement().setChecked(true);
        this.fitImage.getElement().addButtonListener(this);
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.setLayout(new Layout());
        this.add(this.fitImage);
        this.isProgress = false;
        if (this.currentImage == null && imageNode != null && imageNode.getValue() != null) {
            this.progress = new ImageDownloadProgressbar(null, this);
            this.progress.stateChanged("Download Image");
            this.id = new FileDownloader((PegasusFileComplete)imageNode.getValue());
            final ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    if (ImagePreviewPopupInset.this.id != null) {
                        ImagePreviewPopupInset.this.id.download(ImagePreviewPopupInset.this.progress);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return null;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            this.isProgress = true;
            this.add((Component)this.progress, -1);
            this.progress.start();
            this.progress.fadeIn();
            this.validate();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreadSafeLoader.run(run);
                }
            });
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.painter.paint(g2, 5, 5, this.getWidth(), (int)((double)this.getHeight() - (this.fitImage.getPreferredSize().getHeight() + 10.0)), this.settings, this.currentImage, this.fitImage.getElement().isChecked());
        this.paintChildren(g2);
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        if (this.progress != null) {
            this.progress.kill();
            this.progress = null;
        }
        if (this.fitImage != null) {
            this.fitImage.kill();
            this.fitImage = null;
        }
        this.id = null;
        this.painter = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    public void imageDownloaded(BufferedImage image) {
        this.currentImage = image;
        if (this.currentImage != null) {
            if (this.currentImage.getWidth() > 0 && this.currentImage.getHeight() > 0) {
                this.isProgress = false;
            } else if (!this.wasException) {
                this.exception("Image is broken. Please upload again.");
            }
        } else if (!this.wasException) {
            this.exception("Unable to load image. Please upload again.");
        }
    }

    private void exception(String text) {
        if (this.msg == null) {
            this.msg = new TextLabel(text);
            this.msg.setLineWrap(true, this.getWidth());
            this.msg.setProgress(1.0f);
            this.add((Component)this.msg, 0);
        } else {
            this.msg.setText(text);
        }
    }

    public void exceptionOccured(Exception exception) {
        this.wasException = true;
        this.exception("Unable to load image. " + (exception != null && exception.getMessage() != null ? exception.getMessage() : "Please upload again."));
        this.revalidate();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.repaint(32L);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ImagePreviewPopupInset.this.msg != null) {
                ImagePreviewPopupInset.this.msg.setLocation((int)((double)parent.getWidth() - ImagePreviewPopupInset.this.msg.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - ImagePreviewPopupInset.this.msg.getPreferredSize().getHeight()) / 2.0));
                ImagePreviewPopupInset.this.msg.setSize(ImagePreviewPopupInset.this.msg.getPreferredSize());
            } else {
                ImagePreviewPopupInset.this.fitImage.setLocation(5, (int)((double)parent.getHeight() - (ImagePreviewPopupInset.this.fitImage.getPreferredSize().getHeight() + 5.0)));
                ImagePreviewPopupInset.this.fitImage.setSize(ImagePreviewPopupInset.this.fitImage.getPreferredSize());
            }
            if (ImagePreviewPopupInset.this.isProgress) {
                ImagePreviewPopupInset.this.progress.setLocation((int)(((double)parent.getWidth() - ImagePreviewPopupInset.this.progress.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - ImagePreviewPopupInset.this.progress.getPreferredSize().getHeight()) / 2);
                ImagePreviewPopupInset.this.progress.setSize(ImagePreviewPopupInset.this.progress.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

