/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.language;

import ch.icit.pegasus.client.converter.MultiLanguageTextLanguageCodeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.util.MultilanguageTextComplete;
import ch.icit.pegasus.server.core.dtos.util.MultilanguageTypeE;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public abstract class MultiLanguageEditorObject<T extends Component>
extends JPanel
implements ItemListener,
Nodable {
    private static final long serialVersionUID = 1089270379922949275L;
    protected ComboBox languageSelector;
    private Node<MultilanguageTextComplete> selectedLanguage;
    private ListNode<List<MultilanguageTextComplete>, MultilanguageTextComplete> list;
    private T item;
    private MultilanguageTypeE type;

    public MultiLanguageEditorObject(ListNode<List<MultilanguageTextComplete>, MultilanguageTextComplete> list, Node<MultilanguageTextComplete> selectedLanguage, MultilanguageTypeE foreignType) {
        this.setOpaque(false);
        this.selectedLanguage = selectedLanguage;
        this.list = list;
        this.type = foreignType;
        this.languageSelector = new ComboBox((Node)selectedLanguage, (Node)list, ConverterRegistry.getConverter(MultiLanguageTextLanguageCodeConverter.class));
        this.languageSelector.addItemListener(this);
        this.item = this.getNewEditorElement();
        this.languageSelector.selectItem(this.selectedLanguage);
        this.setLayout(new Layout());
        this.add((Component)this.languageSelector, 0);
        this.add((Component)this.item, 0);
    }

    public T getItem() {
        return this.item;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.languageSelector) {
            this.newLanguageSelected((Node<MultilanguageTextComplete>)((Node)e.getItem()));
            this.selectedLanguage = (Node)e.getItem();
        }
    }

    protected abstract T getNewEditorElement();

    protected abstract void newLanguageSelected(Node<MultilanguageTextComplete> var1);

    @Override
    public void setNode(Node<?> node) {
        ListNode list = (ListNode)node;
        HashSet<LanguageCodeComplete> usedLanuages = new HashSet<LanguageCodeComplete>();
        Iterator it = ((List)list.getValue()).iterator();
        while (it.hasNext()) {
            MultilanguageTextComplete lc = (MultilanguageTextComplete)it.next();
            if (usedLanuages.contains(lc.getLanguageCode())) {
                it.remove();
                continue;
            }
            if (lc.getText() != null && !lc.getText().isEmpty()) {
                usedLanuages.add(lc.getLanguageCode());
                continue;
            }
            it.remove();
        }
        list.updateNode();
        Node codesNode = NodeToolkit.getAffixList(LanguageCodeComplete.class);
        if (codesNode != null && codesNode.getValue() != null) {
            List codes = (List)codesNode.getValue();
            for (LanguageCodeComplete code : codes) {
                if (usedLanuages.contains(code)) continue;
                MultilanguageTextComplete t = new MultilanguageTextComplete();
                t.setClientOId(Long.valueOf(ADTO.getNextId()));
                t.setLanguageCode(code);
                t.setText("");
                t.setForeignType(this.type);
                list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)t, true, false), 0L);
            }
        }
        list.commit();
        this.languageSelector.setPossibleValues((Node)list);
        if (list.getChildCount() > 0) {
            this.languageSelector.setSelectedItem(list.getChildAt(0));
        }
    }

    @Override
    public Node<?> getNode() {
        return this.list;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return MultiLanguageEditorObject.this.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            MultiLanguageEditorObject.this.languageSelector.setLocation(0, 0);
            MultiLanguageEditorObject.this.languageSelector.setSize(MultiLanguageEditorObject.this.languageSelector.getPreferredSize());
            MultiLanguageEditorObject.this.item.setLocation(MultiLanguageEditorObject.this.languageSelector.getX() + MultiLanguageEditorObject.this.languageSelector.getWidth() + 5, 0);
            MultiLanguageEditorObject.this.item.setSize(parent.getWidth() - MultiLanguageEditorObject.this.item.getX(), parent.getHeight() - MultiLanguageEditorObject.this.item.getY());
        }
    }
}

