/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.layout.simple;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class RowLayout
extends DefaultLayout {
    private int preferredHeight;
    private int preferredWidth;
    private int minWidth = 0;
    private int minHeight = 0;
    private int horizontalBorder = 10;
    private int verticalBorder = 10;
    private int inner_horizontalBorder = 4;
    private int inner_verticalBorder = 4;

    public RowLayout() {
        this.setHorizontalBorder(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border")));
        this.setVerticalBorder(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_vertical_border")));
        this.setInner_horizontalBorder(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border")));
        this.setInner_verticalBorder(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_vertical_border")));
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        Dimension d = null;
        this.preferredWidth = this.getHorizontalBorder();
        this.preferredHeight = this.getVerticalBorder();
        this.minWidth = 0;
        this.minHeight = 0;
        for (int i = 0; i < nComps; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            d = c.getPreferredSize();
            this.preferredWidth += d.width;
            this.preferredHeight += this.getInner_verticalBorder();
            this.preferredHeight += d.height;
            if (c.getMaximumSize() != null) {
                this.minWidth = Math.max(c.getMinimumSize().width, this.minWidth);
            }
            this.minHeight = this.preferredHeight;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x = 0;
        int y = insets.top;
        int nComps = parent.getComponentCount();
        int previousWidth = this.getHorizontalBorder();
        int previousHeight = this.getVerticalBorder();
        for (int i = nComps - 1; i >= 0; --i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            c.setLocation(x, y += previousHeight + this.getInner_verticalBorder());
            c.setSize(d);
            previousWidth = d.width;
            previousHeight = d.height;
        }
    }

    public int getHorizontalBorder() {
        return this.horizontalBorder;
    }

    public void setHorizontalBorder(int horizontalBorder) {
        this.horizontalBorder = horizontalBorder;
    }

    public int getVerticalBorder() {
        return this.verticalBorder;
    }

    public void setVerticalBorder(int verticalBorder) {
        this.verticalBorder = verticalBorder;
    }

    public int getInner_horizontalBorder() {
        return this.inner_horizontalBorder;
    }

    public void setInner_horizontalBorder(int inner_horizontalBorder) {
        this.inner_horizontalBorder = inner_horizontalBorder;
    }

    public int getInner_verticalBorder() {
        return this.inner_verticalBorder;
    }

    public void setInner_verticalBorder(int inner_verticalBorder) {
        this.inner_verticalBorder = inner_verticalBorder;
    }
}

