/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.numericstepper;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonStateListener;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.numericstepper.BottomButton;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepperListener;
import ch.icit.pegasus.client.gui.utils.numericstepper.TopButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.Skin2Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.NumericStepperSkin;
import ch.icit.pegasus.client.gui.utils.textfield.JTextField2;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.DebugToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumericStepper
extends JPanelFadable
implements LafListener,
ButtonListener,
DocumentListener,
NodeListener,
FocusListener,
MouseListener,
ButtonStateListener,
Focusable,
Nodable {
    private static final long serialVersionUID = 1L;
    private Button.ButtonState state = Button.ButtonState.UP;
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;
    private int type;
    public static final int TYPE_INT = 3;
    public static final int TYPE_DOUBLE = 5;
    private long editorUnDoId;
    private List<NumericStepperListener> listeners = new ArrayList<NumericStepperListener>();
    private String cId;
    private Integer defaultV;
    private Button upButton;
    private Button downButton;
    private int defaultWidth = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("numeric_stepper_default_width"));
    private double inkrement = 1.0;
    private DecimalFormat format;
    private Skin2Field skin;
    private IntTextField inputField;
    private Node node;
    private VisibleContainer visibleContainer;
    private boolean isDown;

    public NumericStepper(Node node, long id, int type) {
        this(id, type);
        this.setNode(node);
    }

    public NumericStepper(Node node, long id) {
        this(node, id, 3);
    }

    public NumericStepper(Node node, int type) {
        this(node, System.currentTimeMillis(), type);
    }

    public NumericStepper(Node node) {
        this(node, 3);
    }

    public NumericStepper(long id) {
        this(id, 3);
    }

    public NumericStepper(long id, int type) {
        this.format = type == 5 ? FormatterRegistry.getDecimalFormat("0.###") : FormatterRegistry.getDecimalFormat("#");
        this.editorUnDoId = id;
        this.getFader().setDisableWhenHidden(true);
        this.type = type;
        this.upButton = new TopButton();
        this.downButton = new BottomButton();
        this.downButton.addButtonListener(this);
        this.upButton.addButtonListener(this);
        this.downButton.addButtonStateListener(this);
        this.upButton.addButtonStateListener(this);
        this.upButton.setCreateContinuesEvents(true);
        this.downButton.setCreateContinuesEvents(true);
        this.inputField = new IntTextField(0);
        this.inputField.setOpaque(false);
        this.inputField.setBorder(BorderFactory.createEmptyBorder());
        this.inputField.getDocument().addDocumentListener(this);
        this.skin = SkinRegistry.getSkin(NumericStepperSkin.class);
        this.lafAttributeChanged("All attribues changed");
        this.setOpaque(false);
        this.setLayout(new NumericStepperLayout());
        this.addMouseListener(this);
        this.inputField.addMouseListener(this);
        this.addFocusListener(this);
        this.inputField.addFocusListener(this);
        this.add(this.upButton);
        this.add(this.downButton);
        this.add(this.inputField);
    }

    public NumericStepper(int type) {
        this(System.currentTimeMillis(), type);
    }

    public NumericStepper() {
        this(3);
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
    }

    public double getInkrement() {
        return this.inkrement;
    }

    public void setInkrement(double inkrement) {
        this.inkrement = inkrement;
    }

    public void setNode(Node IReadableNode) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = IReadableNode;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            if (this.node.getValue() != null) {
                this.valueChanged(this.node);
            }
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public long getEditorUnDoId() {
        return this.editorUnDoId;
    }

    public String getcId() {
        return this.cId;
    }

    public void setcId(String cId) {
        this.cId = cId;
    }

    public Integer getDefaultV() {
        return this.defaultV;
    }

    public void setDefaultV(Integer defaultV) {
        this.defaultV = defaultV;
    }

    public void setEditorUnDoId(long editorUnDoId) {
        this.editorUnDoId = editorUnDoId;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.upButton.setEnabled(isEnabled);
        this.downButton.setEnabled(isEnabled);
        this.inputField.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.listeners.clear();
        this.listeners = null;
        this.upButton.kill();
        this.upButton = null;
        this.downButton.kill();
        this.downButton = null;
        this.format = null;
        this.inputField.getDocument().removeDocumentListener(this);
        this.remove(this.inputField);
        this.inputField = null;
        this.format = null;
        this.skin = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = null;
    }

    public JTextField getTextField() {
        return this.inputField;
    }

    public Object getInputNr() {
        return this.inputField.getValue();
    }

    public void setInputNr(int v) {
        this.inputField.getDocument().removeDocumentListener(this);
        this.inputField.setText(this.format.format(v));
        this.inputField.getDocument().addDocumentListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.defaultWidth, this.skin.getImage1(this.state).getHeight());
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, this.skin.getImage1(this.state).getHeight());
        this.validate();
    }

    public void addNumericStepperListener(NumericStepperListener l) {
        this.listeners.add(l);
    }

    public void removeNumericStepperListener(NumericStepperListener l) {
        this.listeners.remove(l);
    }

    private void fireEvent() {
        if (this.inputField.getText().equals("")) {
            return;
        }
        if (this.node != null) {
            boolean isUnDoIdSet = true;
            if (this.editorUnDoId == 0L) {
                isUnDoIdSet = false;
                this.editorUnDoId = System.currentTimeMillis();
            }
            Object i = null;
            if (this.type == 3) {
                i = this.inputField.getValue();
            } else if (this.type == 5) {
                i = Double.valueOf(this.inputField.getText().trim());
            }
            if (this.node instanceof Node) {
                if (this.node.setValueSilent(i, false, this.editorUnDoId, new NodeListener[]{this})) {
                    for (NumericStepperListener l : this.listeners) {
                        l.valueChanged(this);
                    }
                } else {
                    this.valueChanged(this.node);
                }
            }
            if (!isUnDoIdSet) {
                this.editorUnDoId = 0L;
            }
        } else {
            for (NumericStepperListener l : this.listeners) {
                l.valueChanged(this);
            }
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.inputField.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_textfield_font_size"), LafLoader.getLafLoader().getAttribute("default_textfield_font_type")));
        this.inputField.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_foreground")));
        this.inputField.setDisabledTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color")));
        this.inputField.setCaretColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_caret_color")));
        this.inputField.setSelectedTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selected_text_color")));
        this.inputField.setSelectionColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selection_color")));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth() - this.upButton.getWidth(), this.state);
        this.paintChildren(g2);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.upButton) {
            if (this.type == 5) {
                Double val = null;
                if (this.inputField.getValue() == null) {
                    val = 0.0;
                } else if (this.inputField.getValue() instanceof Integer) {
                    Integer a = (Integer)this.inputField.getValue();
                    val = a.doubleValue();
                } else {
                    val = (Double)this.inputField.getValue();
                }
                double d = val + this.inkrement;
                if (d > this.maxValue) {
                    d = this.maxValue;
                }
                this.inputField.setText(this.format.format(d));
            } else {
                Integer val = (Integer)this.inputField.getValue();
                int d = (int)((double)val.intValue() + this.inkrement);
                if ((double)d > this.maxValue) {
                    d = (int)this.maxValue;
                }
                this.inputField.setText(this.format.format(d));
            }
        } else if (this.type == 3) {
            Integer val = (Integer)this.inputField.getValue();
            double d = (double)val.intValue() - this.inkrement;
            if (d < this.minValue) {
                d = this.minValue;
            }
            this.inputField.setText(this.format.format(d));
        } else {
            Double val = null;
            if (this.inputField.getValue() == null) {
                val = 0.0;
            } else if (this.inputField.getValue() instanceof Integer) {
                Integer a = (Integer)this.inputField.getValue();
                val = a.doubleValue();
            } else {
                val = (Double)this.inputField.getValue();
            }
            int d = (int)(val - this.inkrement);
            if ((double)d < this.minValue) {
                d = (int)this.minValue;
            }
            this.inputField.setText(this.format.format(d));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (this.node == null && this.inputField == null) {
            node.removeNodeListener((NodeListener)this);
            return;
        }
        if (this.type == 5) {
            if (this.node != null) {
                double i = (Double)this.node.getValue();
                if (!this.inputField.getText().equals("" + i)) {
                    this.inputField.getDocument().removeDocumentListener(this);
                    this.inputField.setText(this.format.format(i));
                    this.inputField.getDocument().addDocumentListener(this);
                }
            }
        } else if (this.node != null && this.node.getValue() != null) {
            int i = (Integer)this.node.getValue();
            if (!this.inputField.getText().equals("" + i)) {
                this.inputField.getDocument().removeDocumentListener(this);
                this.inputField.setText(this.format.format(i));
                this.inputField.getDocument().addDocumentListener(this);
            }
        }
    }

    public void setState(Button.ButtonState newState) {
        this.changeState(newState);
    }

    private void changeState(Button.ButtonState newState) {
        this.state = newState;
        this.repaint(32L);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            SelectionManager.getSelectionManager().focusGained(this);
            this.changeState(Button.ButtonState.FOCUS);
            this.inputField.setSelectionStart(0);
            this.inputField.setSelectionEnd(this.inputField.getText().length());
            if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.changeState(Button.ButtonState.UP);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this) && this.state != Button.ButtonState.FOCUS) {
            this.changeState(Button.ButtonState.OVER);
            this.setCursor(new Cursor(2));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.FOCUS) {
            this.changeState(Button.ButtonState.UP);
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = true;
            Button.pressedItem = this;
            if (e.getSource() == this) {
                this.inputField.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = false;
            Button.pressedItem = null;
        }
    }

    @Override
    public void buttonStateChanged(Button source) {
        switch (source.getState()) {
            case DISABLED: {
                this.changeState(Button.ButtonState.DISABLED);
                break;
            }
            case FOCUS: {
                this.changeState(Button.ButtonState.FOCUS);
                break;
            }
            case OVER: {
                if (this.state == Button.ButtonState.FOCUS) break;
                this.changeState(Button.ButtonState.OVER);
                break;
            }
            case UP: {
                if (this.state == Button.ButtonState.FOCUS) break;
                this.changeState(Button.ButtonState.UP);
                break;
            }
            case HORIZONTAL: 
            case LEFT: 
            case RIGHT: 
            case STATE_COLAPSED_OVER: 
            case STATE_COLAPSED_UP: 
            case DOWN: 
            case ERROR: 
            case STATE_EXPANDED: 
            case STATE_FOCUS_LEFT: 
            case STATE_FOCUS_RIGHT: 
            case STATE_NOTSELECTED: 
            case STATE_SELECTED: 
            case STATE_WARRNING: 
            case VERTICAL: {
                DebugToolkit.unsupportedStateException(this.getClass(), this.getName(), (Object)this.state, "buttonStateChanged");
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.inputField);
        return a;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.inputField.requestFocusInWindow();
    }

    public boolean isSwingOnly() {
        return true;
    }

    class IntTextField
    extends JTextField2 {
        public IntTextField(int defValue) {
            super("" + defValue);
        }

        @Override
        protected Document createDefaultModel() {
            return new IntTextDocument();
        }

        @Override
        public boolean isValid() {
            try {
                Double.parseDouble(this.getText());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
            catch (NullPointerException e1) {
                return false;
            }
        }

        public Object getValue() {
            if (NumericStepper.this.type == 5) {
                try {
                    return Double.valueOf(this.getText());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                catch (NullPointerException e1) {
                    return 0;
                }
            }
            if (NumericStepper.this.type == 3) {
                try {
                    return Integer.valueOf(this.getText());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                catch (NullPointerException e1) {
                    return 0;
                }
            }
            return 0;
        }
    }

    private class IntTextDocument
    extends PlainDocument {
        private IntTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String oldString = this.getText(0, this.getLength());
            String newString = oldString.substring(0, offs) + str + oldString.substring(offs);
            try {
                if (NumericStepper.this.type == 3) {
                    int i = Integer.parseInt(newString + "0");
                    if ((double)(i /= 10) > NumericStepper.this.maxValue) {
                        return;
                    }
                    if ((double)i < NumericStepper.this.minValue) {
                        return;
                    }
                } else if (NumericStepper.this.type == 5) {
                    double d = Double.parseDouble(newString + "0");
                    if ((d /= 10.0) > NumericStepper.this.maxValue) {
                        return;
                    }
                    if (d < NumericStepper.this.minValue) {
                        return;
                    }
                }
                super.insertString(offs, str, a);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class NumericStepperLayout
    extends DefaultLayout {
        private NumericStepperLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            NumericStepper.this.inputField.setLocation(NumericStepper.this.skin.getImage1(NumericStepper.this.state).getWidth(), 3);
            NumericStepper.this.inputField.setSize(w - (int)(NumericStepper.this.upButton.getPreferredSize().getWidth() + (double)NumericStepper.this.skin.getImage1(NumericStepper.this.state).getWidth()), NumericStepper.this.skin.getImage1(NumericStepper.this.state).getHeight() - 6);
            NumericStepper.this.upButton.setLocation((int)((double)w - NumericStepper.this.upButton.getPreferredSize().getWidth()), 0);
            NumericStepper.this.upButton.setSize(NumericStepper.this.upButton.getPreferredSize());
            NumericStepper.this.downButton.setLocation((int)((double)w - NumericStepper.this.downButton.getPreferredSize().getWidth()), NumericStepper.this.upButton.getHeight());
            NumericStepper.this.downButton.setSize(NumericStepper.this.downButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

