/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.pagination;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanelListener;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class PaginationPanel
extends JPanelFadable
implements ItemListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private ComboBox pageChooser;
    private List<PaginationPanelListener> listener = new ArrayList<PaginationPanelListener>();
    private static Color background;
    private static Color lineColor;
    private static Color lineColor2;
    private ArrowButton nextPage;
    private ArrowButton previousPage;
    private TextLabel pageCount;
    private boolean withBorders = true;
    private int min = -1;
    private int max = -1;
    private int currentPage = -1;

    public PaginationPanel() {
        if (background == null) {
            background = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
        }
        if (lineColor == null) {
            lineColor = new Color(26, 26, 26);
        }
        if (lineColor2 == null) {
            lineColor2 = new Color(102, 102, 102);
        }
        this.pageChooser = new ComboBox(false);
        this.pageCount = new TextLabel();
        this.pageCount.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.pageCount.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.nextPage = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right);
        this.previousPage = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Left);
        this.nextPage.setToolTipText(null);
        this.previousPage.setToolTipText(null);
        this.nextPage.addButtonListener(this);
        this.previousPage.addButtonListener(this);
        this.currentPage = this.min;
        this.pageChooser.setProgress(1.0f);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.add(this.previousPage);
        this.add(this.nextPage);
        this.add(this.pageChooser);
        this.add(this.pageCount);
    }

    public void setWithBorders(boolean b) {
        this.withBorders = b;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        g2.setColor(background);
        g2.fillRoundRect(0, -2, this.getWidth(), this.getHeight() + 2, 5, 5);
        if (this.withBorders) {
            g2.setColor(lineColor);
            g2.drawRoundRect(1, -2, this.getWidth() - 3, this.getHeight(), 5, 5);
            g2.setColor(lineColor2);
            g2.drawRoundRect(0, -2, this.getWidth() - 1, this.getHeight() + 1, 5, 5);
            if (this.previousPage != null) {
                g2.drawLine(this.previousPage.getX() + this.previousPage.getWidth() + 2, -2, this.previousPage.getX() + this.previousPage.getWidth() + 2, this.getHeight() - 2);
            }
            if (this.nextPage != null) {
                g2.drawLine(this.nextPage.getX() - 3, -2, this.nextPage.getX() - 3, this.getHeight() - 2);
            }
        }
        super.paint(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.pageChooser.setEnabled(isEnabled & this.pageChooser.getItemCount() > 1);
        this.pageCount.setEnabled(isEnabled);
        if (!isEnabled) {
            this.nextPage.setEnabled(isEnabled);
            this.previousPage.setEnabled(isEnabled);
        } else {
            this.ensureArrowButtonState();
        }
    }

    public void setCurrentPage(int cv) {
        this.currentPage = cv;
        this.currentPage = this.ensureCurrentPage(this.currentPage);
        this.pageChooser.removeItemListener(this);
        this.pageChooser.setSelectedIndex(this.currentPage - 1);
        this.pageChooser.addItemListener(this);
        this.ensureArrowButtonState();
    }

    public void setMinMaxPages(int min, int max) {
        if (this.min != min || this.max != max) {
            this.min = min;
            this.max = max;
            this.pageChooser.removeAllItems();
            this.pageChooser.removeItemListener(this);
            this.pageCount.setText("/ " + max);
            for (int i = this.min; i <= this.max; ++i) {
                this.pageChooser.addItem("" + i);
            }
            this.currentPage = this.ensureCurrentPage(this.currentPage);
            --this.currentPage;
            this.pageChooser.setSelectedIndex(this.currentPage);
            this.pageChooser.setEnabled(this.pageChooser.getItemCount() > 1);
            this.pageChooser.addItemListener(this);
            this.ensureArrowButtonState();
        }
    }

    private int ensureCurrentPage(int a) {
        if (this.min > a) {
            a = this.min;
        }
        if (this.max < this.currentPage) {
            a = this.max;
        }
        return a;
    }

    private void ensureArrowButtonState() {
        this.previousPage.setEnabled(this.min != this.currentPage);
        this.nextPage.setEnabled(this.max != this.currentPage);
    }

    public void addPaginationListener(PaginationPanelListener l) {
        this.listener.add(l);
    }

    public void remotePaginationListener(PaginationPanelListener l) {
        this.listener.remove(l);
    }

    private void fireEvent(int currentValue) {
        for (PaginationPanelListener l : this.listener) {
            l.pageChanged(this, currentValue);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.listener.clear();
        this.listener = null;
        this.pageChooser.kill();
        this.nextPage.kill();
        this.previousPage.kill();
        this.pageCount.kill();
        this.pageChooser = null;
        this.nextPage = null;
        this.previousPage = null;
        this.pageCount = null;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int currentValue = this.pageChooser.getSelectedIndex();
            this.currentPage = currentValue + 1;
            this.fireEvent(currentValue);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.nextPage) {
            ++this.currentPage;
            this.fireEvent(this.currentPage);
        } else if (source == this.previousPage) {
            --this.currentPage;
            this.fireEvent(this.currentPage);
        }
    }

    public void updateElement(String string, String string2) {
        int i = 1;
        if (string2 != null) {
            try {
                i = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.currentPage = i;
    }

    public boolean isInnerComponent(Component c) {
        if (this.pageChooser != null && this.pageChooser.getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.pageChooser.getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)(5.0 + PaginationPanel.this.previousPage.getPreferredSize().getWidth());
            w += 5;
            w = (int)((double)w + PaginationPanel.this.pageChooser.getPreferredSize().getWidth());
            w += 5;
            w = (int)((double)w + PaginationPanel.this.pageCount.getPreferredSize().getWidth());
            w += 5;
            w = (int)((double)w + PaginationPanel.this.nextPage.getPreferredSize().getWidth());
            int tw = 250;
            if ((w += 5) < tw) {
                tw = w;
            }
            return new Dimension(tw, 26);
        }

        @Override
        public void layoutContainer(Container parent) {
            PaginationPanel.this.previousPage.setLocation(5, (int)(((double)parent.getHeight() - PaginationPanel.this.previousPage.getPreferredSize().getHeight()) / 2.0) - 1);
            PaginationPanel.this.previousPage.setSize(PaginationPanel.this.previousPage.getPreferredSize());
            PaginationPanel.this.pageChooser.setLocation(PaginationPanel.this.previousPage.getX() + PaginationPanel.this.previousPage.getWidth() + 6, (int)(((double)parent.getHeight() - PaginationPanel.this.pageChooser.getPreferredSize().getHeight()) / 2.0) - 1);
            PaginationPanel.this.pageChooser.setSize(PaginationPanel.this.pageChooser.getPreferredSize());
            PaginationPanel.this.pageCount.setLocation(PaginationPanel.this.pageChooser.getX() + PaginationPanel.this.pageChooser.getWidth() + 3, (int)(((double)parent.getHeight() - PaginationPanel.this.pageCount.getPreferredSize().getHeight()) / 2.0) - 1);
            PaginationPanel.this.pageCount.setSize(PaginationPanel.this.pageCount.getPreferredSize());
            PaginationPanel.this.nextPage.setLocation(PaginationPanel.this.pageCount.getX() + PaginationPanel.this.pageCount.getWidth() + 6, (int)(((double)parent.getHeight() - PaginationPanel.this.nextPage.getPreferredSize().getHeight()) / 2.0) - 1);
            PaginationPanel.this.nextPage.setSize(PaginationPanel.this.nextPage.getPreferredSize());
        }
    }
}

