/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ContactPanel;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ContactListEditPanel
extends DefaultPanel
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private Table2 table = new Table2(true, "Add Contact", false, false);
    private ScrollPane scrollPane;
    private VerticalSeparator sep1;
    private ContactPanel editPanel;

    public ContactListEditPanel(Node<List<ContactComplete>> list) {
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ContactComplete c = new ContactComplete();
                c.setStandalone(Boolean.valueOf(true));
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                ContactListEditPanel.this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(list);
        this.table.getModel().addTableSelectionListener(this);
        this.sep1 = new VerticalSeparator();
        this.editPanel = new ContactPanel(true);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        JPanel p = new JPanel();
        p.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        p.setLayout(new ViewPortLayout());
        p.add(this.editPanel);
        this.scrollPane.setViewportView(p);
        this.setLayout(new Layout());
        this.editPanel.setEnabled(false);
        this.editPanel.setProgress(1.0f);
        this.add(this.table);
        this.add(this.sep1);
        this.add(this.scrollPane);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.scrollPane.setEnabled(isEnabled);
        this.editPanel.setEnabled(isEnabled & this.editPanel.getNode() != null);
        this.sep1.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.scrollPane.kill();
        this.editPanel.kill();
        this.sep1.kill();
        this.table = null;
        this.scrollPane = null;
        this.editPanel = null;
        this.sep1 = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.table.getFocusComponents();
        if (this.editPanel.isEnabled()) {
            a.addAll(this.editPanel.getFocusComponents());
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
        this.editPanel.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel != null) {
            this.editPanel.setNode(panel.getModel().getNode());
            this.editPanel.setEnabled(true);
        } else {
            this.editPanel.setNode(null);
            this.editPanel.setEnabled(false);
        }
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return ContactListEditPanel.this.editPanel.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            ContactListEditPanel.this.editPanel.setLocation(10, 0);
            ContactListEditPanel.this.editPanel.setSize(parent.getWidth() - 20, parent.getHeight());
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setSelectable(true);
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(StandaloneContactConverter.class));
            this.name.addNodeToTextLabel(m.getNode().getChildNamed(ContactComplete_.firstName));
            this.name.addNodeToTextLabel(m.getNode().getChildNamed(ContactComplete_.lastName));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.add(this.name);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.delete.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.name.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(500, 700);
        }

        @Override
        public void layoutContainer(Container parent) {
            ContactListEditPanel.this.table.setLocation(0, 0);
            ContactListEditPanel.this.table.setSize(200, parent.getHeight());
            ContactListEditPanel.this.sep1.setLocation(ContactListEditPanel.this.table.getWidth(), 0);
            ContactListEditPanel.this.sep1.setSize((int)ContactListEditPanel.this.sep1.getPreferredSize().getWidth(), parent.getHeight());
            ContactListEditPanel.this.scrollPane.setLocation(ContactListEditPanel.this.sep1.getX() + ContactListEditPanel.this.sep1.getWidth(), 0);
            ContactListEditPanel.this.scrollPane.setSize(parent.getWidth() - ContactListEditPanel.this.scrollPane.getX(), parent.getHeight());
        }
    }
}

