/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.DateUnitEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayout;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayoutConstraints;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete_;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;

public class DateDurationPanel
extends DefaultPanel
implements Nodable {
    private static final long serialVersionUID = 1L;
    private NumberTextField fixAmount;
    private ComboBox unit;
    private Node<?> node;
    private Node<?> valueNode;
    private Node<?> unitNode;

    public DateDurationPanel() {
        this.setLayout(new CreepyLayout());
        this.fixAmount = new NumberTextField(null, TextFieldType.DOUBLE);
        this.unit = new ComboBox(null, StaticEnumServiceManager.getAllDateDurations(), ConverterRegistry.getConverter(DateUnitEConverter.class));
        this.unit.setPreferredSize(new Dimension(80, 0));
        this.unit.setProgress(1.0f);
        this.fixAmount.setProgress(1.0f);
        this.add((Component)this.fixAmount, new CreepyLayoutConstraints(1.0, 0.0, 0, 0));
        this.add((Component)this.unit, new CreepyLayoutConstraints(0.0, 0.0, 1, 0));
    }

    public DateDurationPanel(Node<DateDurationComplete> node) {
        this();
        this.setNode(node);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> o = this.fixAmount.getFocusComponents();
        CheckedListAdder.addToList(o, this.unit);
        return o;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.fixAmount.setEnabled(isEnabled);
        this.unit.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.fixAmount.kill();
        this.fixAmount = null;
        this.unit.kill();
        this.unit = null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.fixAmount.setVisibleContainer(pane);
        this.unit.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.fixAmount.requestFocusInWindowNow();
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.fixAmount.setNode(node.getChildNamed(DateDurationComplete_.duration));
        this.unit.setNode(node.getChildNamed(DateDurationComplete_.unit));
    }

    public void setNode(Node<?> valueNode, Node<?> unitNode) {
        this.valueNode = valueNode;
        this.unitNode = unitNode;
        this.fixAmount.setNode((Node)valueNode);
        this.unit.setNode((Node)unitNode);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }
}

