/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightStatisticsReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightStatisticsConfigPanel
extends JPanelFadable
implements Focusable,
ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> showByCustomer = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_BY_CUSTOMER, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByHaulTypeCust = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_HAULTYPE, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByCategoryCust = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CATEGORY, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> showByDate = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_BY_DATE, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByHaulTypeDate = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_HAULTYPE, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByCategoryDate = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CATEGORY, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> showByHaul = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_BY_HAUL_TYPE, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByCategoryHaul = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CATEGORY, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> showByCategory = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_CATEGORY, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> splitByHaulCategory = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_HAULTYPE, TitledItem.TitledItemOrientation.EAST);

    public FlightStatisticsConfigPanel() {
        this.showByCustomer.getElement().setChecked(true);
        this.splitByHaulTypeCust.getElement().setChecked(true);
        this.splitByCategoryCust.getElement().setChecked(true);
        this.showByDate.getElement().setChecked(true);
        this.showByHaul.getElement().setChecked(true);
        this.showByCategory.getElement().setChecked(true);
        this.showByCustomer.getElement().addButtonListener(this);
        this.showByDate.getElement().addButtonListener(this);
        this.showByHaul.getElement().addButtonListener(this);
        this.showByCategory.getElement().addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.showByCustomer);
        this.add(this.splitByHaulTypeCust);
        this.add(this.splitByCategoryCust);
        this.add(this.showByDate);
        this.add(this.splitByHaulTypeDate);
        this.add(this.splitByCategoryDate);
        this.add(this.showByHaul);
        this.add(this.splitByCategoryHaul);
        this.add(this.showByCategory);
        this.add(this.splitByHaulCategory);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean isCustomer = this.showByCustomer.getElement().isChecked() && enabled;
        boolean isDate = this.showByDate.getElement().isChecked() && enabled;
        boolean isHaul = this.showByHaul.getElement().isChecked() && enabled;
        boolean isCat = this.showByCategory.getElement().isChecked() && enabled;
        this.showByCustomer.setEnabled(enabled);
        this.splitByHaulTypeCust.setEnabled(isCustomer);
        this.splitByCategoryCust.setEnabled(isCustomer);
        this.showByDate.setEnabled(enabled);
        this.splitByHaulTypeDate.setEnabled(isDate);
        this.splitByCategoryDate.setEnabled(isDate);
        this.showByHaul.setEnabled(enabled);
        this.splitByCategoryHaul.setEnabled(isHaul);
        this.showByCategory.setEnabled(enabled);
        this.splitByHaulCategory.setEnabled(isCat);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.showByCustomer);
        CheckedListAdder.addToList(a, this.splitByHaulTypeCust);
        CheckedListAdder.addToList(a, this.splitByCategoryCust);
        CheckedListAdder.addToList(a, this.showByDate);
        CheckedListAdder.addToList(a, this.splitByHaulTypeDate);
        CheckedListAdder.addToList(a, this.splitByCategoryDate);
        CheckedListAdder.addToList(a, this.showByHaul);
        CheckedListAdder.addToList(a, this.splitByCategoryHaul);
        CheckedListAdder.addToList(a, this.showByCategory);
        CheckedListAdder.addToList(a, this.splitByHaulCategory);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.showByCustomer.requestFocusInWindowNow();
    }

    public boolean isByCustomer() {
        return this.showByCustomer.getElement().isChecked();
    }

    public boolean isByCustomerAndHaul() {
        return this.splitByHaulTypeCust.getElement().isChecked();
    }

    public boolean isByCustomerAndCategory() {
        return this.splitByCategoryCust.getElement().isChecked();
    }

    public boolean isByDate() {
        return this.showByDate.getElement().isChecked();
    }

    public boolean isByDateAndHaul() {
        return this.splitByHaulTypeDate.getElement().isChecked();
    }

    public boolean isByDateAndCategory() {
        return this.splitByCategoryDate.getElement().isChecked();
    }

    public boolean isByHaul() {
        return this.showByHaul.getElement().isChecked();
    }

    public boolean isByHaulAndCategory() {
        return this.splitByCategoryHaul.getElement().isChecked();
    }

    public boolean isByCategory() {
        return this.showByCategory.getElement().isChecked();
    }

    public boolean isByCategoryAndHaul() {
        return this.splitByHaulCategory.getElement().isChecked();
    }

    public FlightStatisticsReportConfiguration createConfiguration() {
        FlightStatisticsReportConfiguration config = new FlightStatisticsReportConfiguration();
        config.setShowByCustomer(Boolean.valueOf(this.isByCustomer()));
        config.setShowByCustomerSplitByCategory(Boolean.valueOf(this.isByCustomerAndCategory()));
        config.setShowByCustomerSplitByHaulType(Boolean.valueOf(this.isByCustomerAndHaul()));
        config.setShowByDate(Boolean.valueOf(this.isByDate()));
        config.setShowByDateSplitByHaulType(Boolean.valueOf(this.isByDateAndHaul()));
        config.setShowByDateSplitByCategory(Boolean.valueOf(this.isByDateAndCategory()));
        config.setShowByHaulType(Boolean.valueOf(this.isByHaul()));
        config.setShowByHaulTypeSplitByCategory(Boolean.valueOf(this.isByHaulAndCategory()));
        config.setShowByCategory(Boolean.valueOf(this.isByCategory()));
        config.setShowByCategorySplitByHaulType(Boolean.valueOf(this.isByCategoryAndHaul()));
        return config;
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 5;
            int h = 0;
            h = (int)((double)h + FlightStatisticsConfigPanel.this.showByCustomer.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByCategoryCust.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + FlightStatisticsConfigPanel.this.showByCustomer.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByCategoryCust.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + FlightStatisticsConfigPanel.this.showByCustomer.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + FlightStatisticsConfigPanel.this.showByCustomer.getPreferredSize().getHeight());
            h = (int)((double)h + FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getPreferredSize().getHeight());
            return new Dimension((int)((double)border + FlightStatisticsConfigPanel.this.splitByCategoryHaul.getPreferredSize().getWidth()), h += border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            FlightStatisticsConfigPanel.this.showByCustomer.setLocation(0, 0);
            FlightStatisticsConfigPanel.this.showByCustomer.setSize(FlightStatisticsConfigPanel.this.showByCustomer.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByHaulTypeCust.setLocation(border, FlightStatisticsConfigPanel.this.showByCustomer.getY() + FlightStatisticsConfigPanel.this.showByCustomer.getHeight());
            FlightStatisticsConfigPanel.this.splitByHaulTypeCust.setSize(FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByCategoryCust.setLocation(border, FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getY() + FlightStatisticsConfigPanel.this.splitByHaulTypeCust.getHeight());
            FlightStatisticsConfigPanel.this.splitByCategoryCust.setSize(FlightStatisticsConfigPanel.this.splitByCategoryCust.getPreferredSize());
            FlightStatisticsConfigPanel.this.showByDate.setLocation(0, FlightStatisticsConfigPanel.this.splitByCategoryCust.getY() + FlightStatisticsConfigPanel.this.splitByCategoryCust.getHeight() + border);
            FlightStatisticsConfigPanel.this.showByDate.setSize(FlightStatisticsConfigPanel.this.showByDate.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByHaulTypeDate.setLocation(border, FlightStatisticsConfigPanel.this.showByDate.getY() + FlightStatisticsConfigPanel.this.showByDate.getHeight());
            FlightStatisticsConfigPanel.this.splitByHaulTypeDate.setSize(FlightStatisticsConfigPanel.this.splitByHaulTypeDate.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByCategoryDate.setLocation(border, FlightStatisticsConfigPanel.this.splitByHaulTypeDate.getY() + FlightStatisticsConfigPanel.this.splitByHaulTypeDate.getHeight());
            FlightStatisticsConfigPanel.this.splitByCategoryDate.setSize(FlightStatisticsConfigPanel.this.splitByCategoryDate.getPreferredSize());
            FlightStatisticsConfigPanel.this.showByHaul.setLocation(0, FlightStatisticsConfigPanel.this.splitByCategoryDate.getY() + FlightStatisticsConfigPanel.this.splitByCategoryDate.getHeight() + border);
            FlightStatisticsConfigPanel.this.showByHaul.setSize(FlightStatisticsConfigPanel.this.showByHaul.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByCategoryHaul.setLocation(border, FlightStatisticsConfigPanel.this.showByHaul.getY() + FlightStatisticsConfigPanel.this.showByHaul.getHeight());
            FlightStatisticsConfigPanel.this.splitByCategoryHaul.setSize(FlightStatisticsConfigPanel.this.splitByCategoryHaul.getPreferredSize());
            FlightStatisticsConfigPanel.this.showByCategory.setLocation(0, FlightStatisticsConfigPanel.this.splitByCategoryHaul.getY() + FlightStatisticsConfigPanel.this.splitByCategoryHaul.getHeight() + border);
            FlightStatisticsConfigPanel.this.showByCategory.setSize(FlightStatisticsConfigPanel.this.showByCategory.getPreferredSize());
            FlightStatisticsConfigPanel.this.splitByHaulCategory.setLocation(border, FlightStatisticsConfigPanel.this.showByCategory.getY() + FlightStatisticsConfigPanel.this.showByCategory.getHeight());
            FlightStatisticsConfigPanel.this.splitByHaulCategory.setSize(FlightStatisticsConfigPanel.this.splitByHaulCategory.getPreferredSize());
        }
    }
}

