/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class HorizontalCombinedView
extends JPanelKillable
implements Focusable,
MutableFocusContainer,
MutableFocusContainerListener {
    private static final long serialVersionUID = 1L;
    private List<Component> comps = new ArrayList<Component>();
    private int horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border"));
    private int fixComp = -1;
    private MutableFocusContainerListener listener;

    public HorizontalCombinedView(Component ... components) {
        this.setOpaque(false);
        this.setLayout(new Layout());
        for (int i = 0; i < components.length; ++i) {
            this.add(components[i]);
            this.comps.add(components[i]);
        }
    }

    public void setHorizontalBorder(int h) {
        this.horizontal_border = h;
    }

    public int getFixComp() {
        return this.fixComp;
    }

    public void setFixComp(int fixComp) {
        this.fixComp = fixComp;
    }

    public Component getInnerComponent(int index) {
        return this.comps.get(index);
    }

    public int getInnerComponentCount() {
        return this.comps.size();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (Component c : this.comps) {
            c.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (Component c : this.comps) {
            if (!(c instanceof Killable)) continue;
            ((Killable)((Object)c)).kill();
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component c : this.comps) {
            if (!(c instanceof Focusable) || !c.isEnabled()) continue;
            CheckedListAdder.addToList(a, (Focusable)((Object)c));
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        for (Component c : this.comps) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).setVisibleContainer(pane);
        }
    }

    public List<Component> getHorizontalComponents() {
        return this.comps;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        for (Component c : this.comps) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).requestFocusInWindowNow();
        }
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = null;
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.listener.focusCycleChanged(this);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int w = parent.getWidth() - (HorizontalCombinedView.this.comps.size() - 1) * HorizontalCombinedView.this.horizontal_border;
            if (HorizontalCombinedView.this.fixComp == -1) {
                w /= HorizontalCombinedView.this.comps.size();
                for (Component c : HorizontalCombinedView.this.comps) {
                    c.setLocation(currentX, (int)((double)parent.getHeight() - c.getPreferredSize().getHeight()) / 2);
                    c.setSize(w, (int)c.getPreferredSize().getHeight());
                    currentX += c.getWidth() + HorizontalCombinedView.this.horizontal_border;
                }
            } else {
                int tw = (int)((Component)HorizontalCombinedView.this.comps.get(HorizontalCombinedView.this.fixComp)).getPreferredSize().getWidth();
                w -= tw;
                w /= HorizontalCombinedView.this.comps.size() - 1;
                int coutn = 0;
                for (Component c : HorizontalCombinedView.this.comps) {
                    c.setLocation(currentX, (int)((double)parent.getHeight() - c.getPreferredSize().getHeight()) / 2);
                    if (coutn == HorizontalCombinedView.this.fixComp) {
                        c.setSize((int)c.getPreferredSize().getWidth(), (int)c.getPreferredSize().getHeight());
                    } else {
                        c.setSize(w, (int)c.getPreferredSize().getHeight());
                    }
                    currentX += c.getWidth() + HorizontalCombinedView.this.horizontal_border;
                    ++coutn;
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int w = 0;
            for (Component c : HorizontalCombinedView.this.comps) {
                if ((double)h < c.getPreferredSize().getHeight()) {
                    h = (int)c.getPreferredSize().getHeight();
                }
                w = (int)((double)w + (c.getPreferredSize().getWidth() + 5.0));
            }
            return new Dimension(w, h);
        }
    }
}

