/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.NodeFilter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ArrayList2;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class MappingTable2D<SOURCE, TARGET>
extends JPanelFadable
implements Focusable {
    private static final long serialVersionUID = 1L;
    private Skin9Field skin;
    private final List<TextLabel> sourceService = new ArrayList<TextLabel>();
    private final Map<TextLabel, JComponent> innerComponent = new HashMap<TextLabel, JComponent>();
    private final ArrayList2<EditorLabel> mappedTo = new ArrayList2();
    private NodeFilter<SOURCE, TARGET> nodeFilter;
    private AnimationListener animationListener;
    private TextLabel title1;
    private TextLabel title2;
    private Class<? extends Converter<? super SOURCE, ?>> defaultEntryConverter;
    private Class<? extends Converter<TARGET, String>> defaultEntryConverter2;
    private String titleOne;
    private String titleTwo;
    private int verticalSpace;
    private int minVerticalSpace = 10;
    private List<Node<SOURCE>> source;
    private List<Node<TARGET>> mappingTo;
    private int currentIndex = 0;

    public static <T> List<Node<T>> createList(Node<T> r) {
        return MappingTable2D.createList(r, null);
    }

    public static <T> List<Node<T>> createList(Node<T> r, String cateringAttributeName) {
        ArrayList<Node<T>> ret = new ArrayList<Node<T>>();
        Iterator it = r.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (cateringAttributeName == null) {
                ret.add(n);
                continue;
            }
            Node child = n.getChildNamed(new String[]{cateringAttributeName});
            if (child != null) {
                if (!Boolean.TRUE.equals(child.getValue())) continue;
                ret.add(n);
                continue;
            }
            ret.add(n);
        }
        return ret;
    }

    public static <T> List<T> createList2(Node<T> r) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (r != null) {
            Iterator it = r.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                ret.add(n.getValue());
            }
        }
        return ret;
    }

    public MappingTable2D(Class<? extends Converter<? super SOURCE, ?>> defaultEClass, Class<? extends Converter<TARGET, String>> defaultEClass2, String t1, String t2) {
        this.titleOne = t1;
        this.titleTwo = t2;
        this.defaultEntryConverter = defaultEClass;
        this.defaultEntryConverter2 = defaultEClass2;
        this.skin = (Skin9Field)DefaultSkins.ContainerBorder.createDynamicSkin();
        this.setLayout(new Layout());
        this.setOpaque(false);
    }

    public MappingTable2D(Class<? extends Converter<SOURCE, ?>> defaultEClass, Class<? extends Converter<TARGET, String>> defaultEClass2, String t1, String t2, List<Node<SOURCE>> source, List<Node<TARGET>> mappingTo) {
        this(defaultEClass, defaultEClass2, t1, t2);
        this.setData(source, mappingTo);
    }

    public void setNodeFilter(NodeFilter<SOURCE, TARGET> f) {
        this.nodeFilter = f;
    }

    public JComponent getInnerComponent(TextLabel sourceLabel) {
        return null;
    }

    public void setListener(AnimationListener listner) {
        this.animationListener = listner;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        this.paintChildren(g2);
    }

    public boolean isInnerComponent(Component c) {
        return false;
    }

    private boolean addScheduled(int index) {
        if (this.source.size() <= this.currentIndex) {
            if (this.animationListener != null) {
                this.animationListener.animationFinished(false);
            }
            this.revalidate();
            return true;
        }
        Node<SOURCE> c = this.source.get(this.currentIndex);
        TextLabel t = new TextLabel(c, ConverterRegistry.getConverter(this.defaultEntryConverter));
        t.setEnabled(this.isEnabled());
        this.sourceService.add(t);
        JComponent r = this.getInnerComponent(t);
        if (r != null) {
            this.innerComponent.put(t, r);
            this.add(r);
        }
        this.add(t);
        if (t.getPreferredSize().getWidth() > (double)this.verticalSpace) {
            this.verticalSpace = (int)t.getPreferredSize().getWidth();
        }
        if (t.getPreferredSize().getHeight() > (double)this.minVerticalSpace) {
            this.minVerticalSpace = (int)t.getPreferredSize().getHeight();
        }
        EditorLabel s = new EditorLabel(c, new Node(), this.defaultEntryConverter2);
        s.setEnabled(this.isEnabled());
        this.mappedTo.add(s);
        s.setProgress(1.0f);
        String text = t.getText();
        this.findSelection(c, text, this.mappingTo, s.getTextLabel(), this.source);
        if (s.getPreferredSize().getHeight() > (double)this.minVerticalSpace) {
            this.minVerticalSpace = (int)s.getPreferredSize().getHeight();
        }
        this.add(s);
        this.validateMappingSorting();
        ++this.currentIndex;
        if (this.currentIndex >= this.source.size()) {
            if (this.animationListener != null) {
                this.animationListener.animationFinished(false);
            }
            this.revalidate();
            return true;
        }
        this.revalidate();
        return false;
    }

    public void setData(List<Node<SOURCE>> source, List<Node<TARGET>> mappingTo) {
        for (TextLabel t : this.sourceService) {
            t.kill();
        }
        this.sourceService.clear();
        for (EditorLabel b : this.mappedTo) {
            b.kill();
        }
        this.mappedTo.clear();
        this.source = source;
        this.mappingTo = mappingTo;
        this.currentIndex = 0;
        if (this.title1 == null) {
            this.title1 = new TextLabel(this.titleOne);
            this.title2 = new TextLabel(this.titleTwo);
            this.add(this.title1);
            this.add(this.title2);
        }
        this.validate();
    }

    public void startDownload() {
        int tw = (int)this.title1.getPreferredSize().getWidth();
        if (tw > this.verticalSpace) {
            this.verticalSpace = tw;
        }
        if ((tw = (int)this.title2.getPreferredSize().getWidth()) > this.verticalSpace) {
            this.verticalSpace = tw;
        }
        while (!this.addScheduled(this.currentIndex)) {
        }
    }

    public void findSelection(Node<SOURCE> currentNode, String text, List<Node<TARGET>> mappingList, TextLabel currentCombo, List<Node<SOURCE>> sources) {
    }

    private void validateMappingSorting() {
    }

    public Map<SOURCE, TARGET> getInvertedMappingTable() {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        int count = 0;
        for (TextLabel l : this.sourceService) {
            if (this.mappedTo.size() - 1 < count) continue;
            EditorLabel b = (EditorLabel)this.mappedTo.get(count);
            Object org = null;
            if (b.getTextLabel().getNode() != null) {
                org = b.getTextLabel().getNode().getValue();
            }
            if (org != null) {
                Object orgC = org;
                Object destC = l.getNode().getValue();
                map.put(destC, orgC);
            }
            ++count;
        }
        return map;
    }

    public Map<TARGET, SOURCE> getMappingTable() {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        int count = 0;
        for (TextLabel l : this.sourceService) {
            if (this.mappedTo.size() - 1 < count) continue;
            EditorLabel b = (EditorLabel)this.mappedTo.get(count);
            Object org = null;
            if (b.getTextLabel().getNode() != null) {
                org = b.getTextLabel().getNode().getValue();
            }
            if (org != null) {
                Object orgC = org;
                Object destC = l.getNode().getValue();
                map.put(orgC, destC);
            }
            ++count;
        }
        return map;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (TextLabel l : this.sourceService) {
            l.kill();
        }
        for (EditorLabel c : this.mappedTo) {
            c.kill();
        }
        this.sourceService.clear();
        this.mappedTo.clear();
        if (this.title1 != null) {
            this.title1.kill();
            this.title2.kill();
        }
        this.title1 = null;
        this.title2 = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (EditorLabel c : this.mappedTo) {
            c.setEnabled(isEnabled);
        }
        for (TextLabel l : this.sourceService) {
            l.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class EditorLabel
    extends DefaultPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel label;
        private EditButton editButton;
        private final Node<SOURCE> source;

        public EditorLabel(Node<SOURCE> source, Node<TARGET> target, Class<? extends Converter> converterClass) {
            this.label = new TextLabel(target, ConverterRegistry.getConverter(converterClass));
            this.editButton = new EditButton();
            this.editButton.addButtonListener(this);
            this.source = source;
            this.setLayout(new InnerLayout());
            this.add(this.label);
            this.add(this.editButton);
        }

        public TextLabel getTextLabel() {
            return this.label;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.editButton);
            return a;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.editButton.setVisibleContainer(pane);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.editButton.requestFocusInWindowNow();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.label.setEnabled(isEnabled);
            this.editButton.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.label != null) {
                this.label.kill();
            }
            this.label = null;
            if (this.editButton != null) {
                this.editButton.kill();
            }
            this.editButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, "Target Mapping");
            popUp.setView(new PositionChoosePopupInsert(this.label.getNode(), MappingTable2D.this.mappingTo, MappingTable2D.this.defaultEntryConverter2, MappingTable2D.this.nodeFilter));
            popUp.showPopUp(x, y, 300, -1, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs != null) {
                        if (xargs[0] instanceof Node) {
                            if (EditorLabel.this.label != null) {
                                EditorLabel.this.label.setNode((Node)xargs[0]);
                            }
                        } else if (EditorLabel.this.label != null) {
                            EditorLabel.this.label.disableNodes();
                            EditorLabel.this.label.setNode((Node)null);
                            EditorLabel.this.label.updateString();
                        }
                    }
                }
            }, source, PopupType.NORMAL);
        }

        private class PositionChoosePopupInsert
        extends PopUpInsert {
            private static final long serialVersionUID = 1L;
            private final TitledItem<TextField> filterField = new TitledItem<TextField>(new TextField(), "Filter", TitledItem.TitledItemOrientation.NORTH);
            private final TitledItem<ComboBox> combo;
            private final List<Node<TARGET>> possibleValues;
            private final Node<SOURCE> dataNode;

            public PositionChoosePopupInsert(Node<SOURCE> dataNode, List<Node<TARGET>> possibleValues, Class<?> defaultConverter, NodeFilter<SOURCE, TARGET> filter) {
                this.filterField.getElement().addTextFieldListener(new TextFieldListener(){

                    @Override
                    public void valueChanged(AbstractTextField field) {
                        PositionChoosePopupInsert.this.filterSelectableNodes();
                    }
                });
                ComboBox gb = new ComboBox();
                Converter c = ConverterRegistry.getConverter((Class)MappingTable2D.this.defaultEntryConverter2);
                this.possibleValues = possibleValues;
                this.dataNode = dataNode;
                for (Node n : possibleValues) {
                    n.setConverter(c);
                }
                gb.initModel(possibleValues.toArray(new Node[0]));
                gb.addItem("");
                boolean found = false;
                if (dataNode != null) {
                    for (Node d : possibleValues) {
                        if (!d.getValue().equals(dataNode.getValue())) continue;
                        found = true;
                        gb.setSelectedItem(d);
                    }
                }
                if (!found) {
                    gb.setSelectedItem("");
                }
                this.combo = new TitledItem<ComboBox>(gb, "Choose Target Position", TitledItem.TitledItemOrientation.NORTH);
                this.setLayout(new BorderLayout());
                this.add(this.filterField, "North");
                this.add(this.combo, "Center");
            }

            private void filterSelectableNodes() {
                ArrayList newValues = new ArrayList();
                String searchText = this.filterField.getElement().getText();
                String[] texts = searchText.split(" ");
                if (StringUtil.isBlank((String)searchText)) {
                    newValues.addAll(this.possibleValues);
                } else {
                    for (Node value : this.possibleValues) {
                        boolean bl = true;
                        String formattedValue = value.getFormattedValue().toString();
                        System.out.println("filter for possible values: " + formattedValue + " with " + value.getConverter().getClass().getSimpleName());
                        for (String text : texts) {
                            if (formattedValue.toLowerCase().contains(text.toLowerCase())) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        newValues.add(value);
                    }
                }
                this.combo.getElement().initModel(newValues.toArray(new Node[0]));
                this.combo.getElement().addItem("");
                boolean found = false;
                if (this.dataNode != null) {
                    for (Node node : newValues) {
                        if (!node.getValue().equals(this.dataNode.getValue())) continue;
                        found = true;
                        this.combo.getElement().setSelectedItem(node);
                    }
                }
                if (!found) {
                    this.combo.getElement().setSelectedItem("");
                }
            }

            @Override
            public boolean tryToGrabFocus() {
                return true;
            }

            @Override
            public List<Component> getFocusComponents() {
                ArrayList<Component> a = new ArrayList<Component>();
                CheckedListAdder.addToList(a, this.combo);
                return a;
            }

            @Override
            public boolean isClosableWithEnter() {
                return true;
            }

            @Override
            public Object[] getValues(PopupAction isOK) {
                if (isOK == PopupAction.CANCEL) {
                    return null;
                }
                Object[] o = new Object[]{this.combo.getElement().getSelectedItem()};
                return o;
            }

            @Override
            public boolean isInnerComponent(Component c) {
                if (this.combo != null && this.combo.getElement().getCurrentPopUp() != null) {
                    for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                        if (!currentC.equals(this.combo.getElement().getCurrentPopUp())) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, 25);
            }

            @Override
            public void layoutContainer(Container parent) {
                EditorLabel.this.editButton.setLocation((int)((double)parent.getWidth() - (EditorLabel.this.editButton.getPreferredSize().getWidth() + 5.0)), (int)(((double)parent.getHeight() - EditorLabel.this.editButton.getPreferredSize().getHeight()) / 2.0));
                EditorLabel.this.editButton.setSize(EditorLabel.this.editButton.getPreferredSize());
                EditorLabel.this.label.setLocation(0, (int)(((double)parent.getHeight() - EditorLabel.this.label.getPreferredSize().getHeight()) / 2.0));
                EditorLabel.this.label.setSize(parent.getWidth() - (EditorLabel.this.editButton.getWidth() + 10), (int)EditorLabel.this.label.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            int count = 0;
            int middleX = parent.getWidth() / 2 + border;
            if (MappingTable2D.this.title1 != null) {
                MappingTable2D.this.title1.setLocation(border, border);
                MappingTable2D.this.title1.setSize(MappingTable2D.this.verticalSpace, (int)MappingTable2D.this.title1.getPreferredSize().getHeight());
                MappingTable2D.this.title2.setLocation(middleX, border);
                MappingTable2D.this.title2.setSize(MappingTable2D.this.verticalSpace, (int)MappingTable2D.this.title2.getPreferredSize().getHeight());
                int currentY = MappingTable2D.this.title1.getY() * 2 + MappingTable2D.this.title1.getHeight();
                for (TextLabel l : MappingTable2D.this.sourceService) {
                    l.setLocation(border, (int)((double)currentY + ((double)MappingTable2D.this.minVerticalSpace - l.getPreferredSize().getHeight()) / 2.0));
                    l.setSize(l.getPreferredSize());
                    if (MappingTable2D.this.mappedTo.size() > count) {
                        EditorLabel b = (EditorLabel)MappingTable2D.this.mappedTo.get(count);
                        b.setLocation(middleX, (int)((double)currentY + ((double)MappingTable2D.this.minVerticalSpace - b.getPreferredSize().getHeight()) / 2.0));
                        b.setSize(parent.getWidth() - (b.getX() + border), (int)b.getPreferredSize().getHeight());
                    }
                    currentY += MappingTable2D.this.minVerticalSpace;
                    JComponent r = (JComponent)MappingTable2D.this.innerComponent.get(l);
                    if (r != null) {
                        r.setLocation(border + 10, currentY);
                        r.setSize(parent.getWidth() - 2 * (border + 10), (int)r.getPreferredSize().getHeight());
                        currentY += r.getHeight();
                    }
                    ++count;
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 5;
            if (MappingTable2D.this.title1 == null) {
                return new Dimension(0, (MappingTable2D.this.sourceService.size() + 1) * MappingTable2D.this.minVerticalSpace);
            }
            int h = border;
            h = (int)((double)h + MappingTable2D.this.title1.getPreferredSize().getHeight());
            h += MappingTable2D.this.sourceService.size() * MappingTable2D.this.minVerticalSpace;
            return new Dimension(0, h += border);
        }
    }
}

