/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.report.ProductManHourReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ProductManHourExportConfigurationPanel
extends DefaultPanel
implements ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<ComboBox> tender;
    private TextLabel grouping;
    private TitledItem<CheckBox> showGroups;
    private TitledItem<CheckBox> showComponents;
    private TextLabel calculation;
    private TitledItem<CheckBox> includeProductCosts;
    private TitledItem<CheckBox> includeGroupCosts;
    private TitledItem<CheckBox> includeItemCosts;
    private TextLabel timeCostDetails;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<CheckBox> showTime;
    private TitledItem<CheckBox> splitTimeCost;
    private TitledItem<CheckBox> showProductTimeCost;
    private TitledItem<CheckBox> showGroupTimeCost;
    private TitledItem<CheckBox> showItemTimeCost;
    private RDProvider provider;

    public ProductManHourExportConfigurationPanel() {
        RDProvider provider;
        this.provider = provider = new RDProvider(HUDToolkit.getCurrentAccessRight(ProductAccess.MODULE_PRODUCT, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ComboBox b = new ComboBox();
        b.addItem(Words.PRODUCTIVE);
        if (this.provider.isWritable("printExternalCostFactSheet") && Boolean.TRUE.equals(settings.getUseProductTenderScenario())) {
            b.addItem(Words.TENDER);
            b.addItem(Words.ALL);
        }
        this.tender = new TitledItem<ComboBox>(b, Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
        this.grouping = new TextLabel("Product Detail Level");
        this.showGroups = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_GROUPS, TitledItem.TitledItemOrientation.EAST);
        this.showComponents = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_COMPONENTS, TitledItem.TitledItemOrientation.EAST);
        this.calculation = new TextLabel("Calculation Configuration");
        this.includeProductCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCT, TitledItem.TitledItemOrientation.EAST);
        this.includeGroupCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROUP, TitledItem.TitledItemOrientation.EAST);
        this.includeItemCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT, TitledItem.TitledItemOrientation.EAST);
        this.timeCostDetails = new TextLabel("Time/Cost Details");
        this.showTime = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_TIME, TitledItem.TitledItemOrientation.EAST);
        this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_COSTS, TitledItem.TitledItemOrientation.EAST);
        this.splitTimeCost = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT, TitledItem.TitledItemOrientation.EAST);
        this.showProductTimeCost = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCT, TitledItem.TitledItemOrientation.EAST);
        this.showGroupTimeCost = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_GROUP, TitledItem.TitledItemOrientation.EAST);
        this.showItemTimeCost = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_COMPONENT, TitledItem.TitledItemOrientation.EAST);
        this.splitTimeCost.getElement().addButtonListener(this);
        this.setLayout(new Layout());
        this.showGroups.getElement().setChecked(true);
        this.includeGroupCosts.getElement().setChecked(true);
        this.showTime.getElement().setChecked(true);
        this.showCosts.getElement().setChecked(false);
        this.setEnabled(this.isEnabled());
        this.add(this.dueDate);
        this.add(this.tender);
        this.add(this.grouping);
        this.add(this.showGroups);
        this.add(this.showComponents);
        this.add(this.calculation);
        this.add(this.includeProductCosts);
        this.add(this.includeGroupCosts);
        this.add(this.includeItemCosts);
        this.add(this.timeCostDetails);
        this.add(this.showTime);
        this.add(this.showCosts);
        this.add(this.splitTimeCost);
        this.add(this.showProductTimeCost);
        this.add(this.showGroupTimeCost);
        this.add(this.showItemTimeCost);
    }

    public ProductManHourReportConfiguration createConfig() {
        ProductManHourReportConfiguration c = new ProductManHourReportConfiguration(null);
        c.setDueDate(new Date(this.dueDate.getElement().getSelectedDate().getTime()));
        if (this.tender.getElement().getSelectedItem().equals(Words.ALL)) {
            c.setShowTender(Boolean.valueOf(true));
            c.setShowProductiv(Boolean.valueOf(true));
        } else if (this.tender.getElement().getSelectedItem().equals(Words.TENDER)) {
            c.setShowTender(Boolean.valueOf(true));
            c.setShowProductiv(Boolean.valueOf(false));
        } else if (this.tender.getElement().getSelectedItem().equals(Words.PRODUCTIVE)) {
            c.setShowProductiv(Boolean.valueOf(true));
            c.setShowTender(Boolean.valueOf(false));
        }
        boolean canViewTender = this.provider.isWritable("printExternalCostFactSheet");
        c.setShowTender(Boolean.valueOf(c.getShowTender() != false && canViewTender));
        c.setShowGroups(Boolean.valueOf(this.showGroups.getElement().isChecked()));
        c.setShowComponents(Boolean.valueOf(this.showComponents.getElement().isChecked()));
        c.setIncludeProductTime(Boolean.valueOf(this.includeProductCosts.getElement().isChecked()));
        c.setIncludeGroupTime(Boolean.valueOf(this.includeGroupCosts.getElement().isChecked()));
        c.setIncludeComponentTime(Boolean.valueOf(this.includeItemCosts.getElement().isChecked()));
        c.setShowTime(Boolean.valueOf(this.showTime.getElement().isChecked()));
        c.setShowCosts(Boolean.valueOf(this.showCosts.getElement().isChecked()));
        c.setSplitTime(Boolean.valueOf(this.splitTimeCost.getElement().isChecked()));
        c.setShowProductTime(Boolean.valueOf(this.showProductTimeCost.getElement().isChecked()));
        c.setShowGroupTime(Boolean.valueOf(this.showGroupTimeCost.getElement().isChecked()));
        c.setShowComponentTime(Boolean.valueOf(this.showItemTimeCost.getElement().isChecked()));
        boolean canViewCosts = this.provider.isWritable("showProductionCosts");
        c.setShowCosts(Boolean.valueOf(c.getShowCosts() != false && canViewCosts));
        return c;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.dueDate);
        CheckedListAdder.addToList(a, this.tender);
        CheckedListAdder.addToList(a, this.showGroups);
        CheckedListAdder.addToList(a, this.showComponents);
        CheckedListAdder.addToList(a, this.includeProductCosts);
        CheckedListAdder.addToList(a, this.includeGroupCosts);
        CheckedListAdder.addToList(a, this.includeItemCosts);
        CheckedListAdder.addToList(a, this.showTime);
        CheckedListAdder.addToList(a, this.showCosts);
        CheckedListAdder.addToList(a, this.splitTimeCost);
        CheckedListAdder.addToList(a, this.showProductTimeCost);
        CheckedListAdder.addToList(a, this.showGroupTimeCost);
        CheckedListAdder.addToList(a, this.showItemTimeCost);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean e = isEnabled && this.splitTimeCost.getElement().isChecked();
        this.showProductTimeCost.setEnabled(e);
        this.showGroupTimeCost.setEnabled(e);
        this.showItemTimeCost.setEnabled(e);
        e = isEnabled && this.provider.isWritable("showProductionCosts");
        this.showCosts.setEnabled(e);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class Layout
    extends DefaultLayout {
        int border = 10;

        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.dueDate.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.tender.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.grouping.getPreferredSize().getHeight());
            h += this.border / 2;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showGroups.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showComponents.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.calculation.getPreferredSize().getHeight());
            h += this.border / 2;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.includeProductCosts.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.includeGroupCosts.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.includeItemCosts.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.timeCostDetails.getPreferredSize().getHeight());
            h += this.border / 2;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showTime.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showCosts.getPreferredSize().getHeight());
            h += this.border / 2;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.splitTimeCost.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showProductTimeCost.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showGroupTimeCost.getPreferredSize().getHeight());
            h += this.border / 4;
            h = (int)((double)h + ProductManHourExportConfigurationPanel.this.showItemTimeCost.getPreferredSize().getHeight());
            return new Dimension(0, h += this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductManHourExportConfigurationPanel.this.dueDate.setLocation(0, 0);
            ProductManHourExportConfigurationPanel.this.dueDate.setSize(ProductManHourExportConfigurationPanel.this.dueDate.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.tender.setLocation(0, ProductManHourExportConfigurationPanel.this.dueDate.getY() + ProductManHourExportConfigurationPanel.this.dueDate.getHeight() + this.border);
            ProductManHourExportConfigurationPanel.this.tender.setSize(200, (int)ProductManHourExportConfigurationPanel.this.tender.getPreferredSize().getHeight());
            int cy = ProductManHourExportConfigurationPanel.this.tender.getY() + ProductManHourExportConfigurationPanel.this.tender.getHeight();
            ProductManHourExportConfigurationPanel.this.grouping.setLocation(0, cy + this.border);
            ProductManHourExportConfigurationPanel.this.grouping.setSize(ProductManHourExportConfigurationPanel.this.grouping.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showGroups.setLocation(0, ProductManHourExportConfigurationPanel.this.grouping.getY() + ProductManHourExportConfigurationPanel.this.grouping.getHeight() + this.border / 2);
            ProductManHourExportConfigurationPanel.this.showGroups.setSize(ProductManHourExportConfigurationPanel.this.showGroups.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showComponents.setLocation(0, ProductManHourExportConfigurationPanel.this.showGroups.getY() + ProductManHourExportConfigurationPanel.this.showGroups.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.showComponents.setSize(ProductManHourExportConfigurationPanel.this.showComponents.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.calculation.setLocation(0, ProductManHourExportConfigurationPanel.this.showComponents.getY() + ProductManHourExportConfigurationPanel.this.showComponents.getHeight() + this.border);
            ProductManHourExportConfigurationPanel.this.calculation.setSize(ProductManHourExportConfigurationPanel.this.calculation.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.includeProductCosts.setLocation(0, ProductManHourExportConfigurationPanel.this.calculation.getY() + ProductManHourExportConfigurationPanel.this.calculation.getHeight() + this.border / 2);
            ProductManHourExportConfigurationPanel.this.includeProductCosts.setSize(ProductManHourExportConfigurationPanel.this.includeProductCosts.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.includeGroupCosts.setLocation(0, ProductManHourExportConfigurationPanel.this.includeProductCosts.getY() + ProductManHourExportConfigurationPanel.this.includeProductCosts.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.includeGroupCosts.setSize(ProductManHourExportConfigurationPanel.this.includeGroupCosts.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.includeItemCosts.setLocation(0, ProductManHourExportConfigurationPanel.this.includeGroupCosts.getY() + ProductManHourExportConfigurationPanel.this.includeGroupCosts.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.includeItemCosts.setSize(ProductManHourExportConfigurationPanel.this.includeItemCosts.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.timeCostDetails.setLocation(0, ProductManHourExportConfigurationPanel.this.includeItemCosts.getY() + ProductManHourExportConfigurationPanel.this.includeItemCosts.getHeight() + this.border);
            ProductManHourExportConfigurationPanel.this.timeCostDetails.setSize(ProductManHourExportConfigurationPanel.this.timeCostDetails.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showTime.setLocation(0, ProductManHourExportConfigurationPanel.this.timeCostDetails.getY() + ProductManHourExportConfigurationPanel.this.timeCostDetails.getHeight() + this.border / 2);
            ProductManHourExportConfigurationPanel.this.showTime.setSize(ProductManHourExportConfigurationPanel.this.showTime.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showCosts.setLocation(0, ProductManHourExportConfigurationPanel.this.showTime.getY() + ProductManHourExportConfigurationPanel.this.showTime.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.showCosts.setSize(ProductManHourExportConfigurationPanel.this.showCosts.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.splitTimeCost.setLocation(0, ProductManHourExportConfigurationPanel.this.showCosts.getY() + ProductManHourExportConfigurationPanel.this.showCosts.getHeight() + this.border / 2);
            ProductManHourExportConfigurationPanel.this.splitTimeCost.setSize(ProductManHourExportConfigurationPanel.this.splitTimeCost.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showProductTimeCost.setLocation(this.border / 2, ProductManHourExportConfigurationPanel.this.splitTimeCost.getY() + ProductManHourExportConfigurationPanel.this.splitTimeCost.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.showProductTimeCost.setSize(ProductManHourExportConfigurationPanel.this.showProductTimeCost.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showGroupTimeCost.setLocation(this.border / 2, ProductManHourExportConfigurationPanel.this.showProductTimeCost.getY() + ProductManHourExportConfigurationPanel.this.showProductTimeCost.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.showGroupTimeCost.setSize(ProductManHourExportConfigurationPanel.this.showGroupTimeCost.getPreferredSize());
            ProductManHourExportConfigurationPanel.this.showItemTimeCost.setLocation(this.border / 2, ProductManHourExportConfigurationPanel.this.showGroupTimeCost.getY() + ProductManHourExportConfigurationPanel.this.showGroupTimeCost.getHeight() + this.border / 4);
            ProductManHourExportConfigurationPanel.this.showItemTimeCost.setSize(ProductManHourExportConfigurationPanel.this.showItemTimeCost.getPreferredSize());
        }
    }
}

