/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class RuntimeInfoPanel
extends Button
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Double[] cpuHistory = new Double[5];
    private int currentPointer = 0;
    private int inset = 25;
    private int inset2 = 90;
    private TimerTask myTask;
    private Timer myTimer;
    private Skin9Field skin = (Skin9Field)DefaultSkins.RuntimeInfoBackground.createDynamicSkin();
    private TextLabel cpuUsage = new TextLabel("00");
    private TextLabel memoryUsage = new TextLabel("00");
    private static final Runtime s_runtime = Runtime.getRuntime();
    private TextLabel nodes;
    private TextLabel nodesText;
    private TextLabel listenerUsage;

    public RuntimeInfoPanel() {
        super(false);
        this.cpuUsage.setFont(new Font("Lucida Grande", 0, 9));
        this.memoryUsage.setFont(this.cpuUsage.getFont());
        this.memoryUsage.setProgress(1.0f);
        this.cpuUsage.setProgress(1.0f);
        this.listenerUsage = new TextLabel("AL: 0000");
        this.listenerUsage.setFont(this.cpuUsage.getFont());
        this.listenerUsage.setProgress(1.0f);
        this.nodes = new TextLabel("00000000");
        this.nodes.setFont(this.cpuUsage.getFont());
        this.nodesText = new TextLabel("Nodes");
        this.nodesText.setFont(this.cpuUsage.getFont());
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.add(this.cpuUsage);
        this.add(this.memoryUsage);
        this.add(this.nodes);
        this.add(this.nodesText);
        this.add(this.listenerUsage);
        this.addButtonListener(this);
        this.createTimer();
    }

    private void createTimer() {
        this.myTask = new TimerTask(){

            @Override
            public void run() {
                RuntimeInfoPanel.this.refreshUsedMemory();
                RuntimeInfoPanel.this.refreshCPU();
                RuntimeInfoPanel.this.refreshNodeCount();
                RuntimeInfoPanel.this.refreshActionListenerCount();
            }
        };
        this.myTimer = new Timer();
        this.myTimer.schedule(this.myTask, 1000L, 2000L);
    }

    private static long usedMemory() {
        long l = s_runtime.totalMemory() - s_runtime.freeMemory();
        l /= 1000L;
        return l /= 1000L;
    }

    public void refreshUsedMemory() {
        final long t = RuntimeInfoPanel.usedMemory();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RuntimeInfoPanel.this.memoryUsage.setText("" + t);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void refreshNodeCount() {
        String g = "";
        g = g + NodeToolkit.treeOfLife.size();
        while (g.length() < 7) {
            g = "0" + g;
        }
        this.nodes.setText(g);
    }

    public void refreshActionListenerCount() {
        String g = AnimationProvider.getMetaString();
        this.listenerUsage.setText(g);
    }

    public void refreshCPU() {
        String t = System.getProperty("os.name");
        if (t.contains("Win")) {
            String t1 = System.getProperty("user.home");
            try {
                int j;
                int c;
                Process p = s_runtime.exec(t1 + "/Process.exe");
                InputStream in = p.getInputStream();
                t1 = "";
                while ((c = in.read()) != -1) {
                    char cc = (char)c;
                    t1 = t1 + cc;
                }
                int i = t1.indexOf("javaw.exe");
                if (i != -1 && (j = t1.indexOf("stal", i)) != -1) {
                    String g = t1.substring(i, j);
                    String[] arr = g.split(" ");
                    double d = Double.valueOf(arr[arr.length - 2]);
                    this.cpuHistory[this.currentPointer] = d;
                    this.ensurePointer();
                    final DecimalFormat form = FormatterRegistry.getDecimalFormat("0.#");
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            RuntimeInfoPanel.this.cpuUsage.setText("" + form.format(RuntimeInfoPanel.this.getAverage()));
                            RuntimeInfoPanel.this.getLayout().layoutContainer(RuntimeInfoPanel.this);
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
            }
            catch (IOException p) {}
        } else {
            try {
                int c;
                Process p = s_runtime.exec("ps -e -o pcpu,cpu,nice,state,cputime,args --sort pcpu | sed '/^ 0.0 /d'");
                InputStream in = p.getInputStream();
                String t1 = "";
                while ((c = in.read()) != -1) {
                    char cc = (char)c;
                    t1 = t1 + cc;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        RuntimeInfoPanel.this.cpuUsage.setText("?");
                        RuntimeInfoPanel.this.getLayout().layoutContainer(RuntimeInfoPanel.this);
                    }
                };
                SwingUtilities.invokeLater(run);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), this.state);
        if (this.state == Button.ButtonState.DOWN) {
            g2.setColor(new Color(56, 56, 56));
        } else if (this.state == Button.ButtonState.OVER) {
            g2.setColor(new Color(40, 40, 40));
        } else {
            g2.setColor(new Color(23, 23, 23));
        }
        g2.fillRect(1, 2, this.getWidth() - 2, 10);
        g2.setColor(new Color(152, 152, 152));
        g2.drawLine(this.inset, 0, this.inset, this.getHeight());
        g2.drawLine(this.inset2, 0, this.inset2, this.getHeight());
        this.paintChildren(g2);
    }

    private void ensurePointer() {
        ++this.currentPointer;
        if (this.currentPointer > this.cpuHistory.length - 1) {
            this.currentPointer = 0;
        }
    }

    private Double getAverage() {
        int c = 0;
        double amount = 0.0;
        for (int i = 0; i < this.cpuHistory.length; ++i) {
            if (this.cpuHistory[i] == null) continue;
            ++c;
            amount += this.cpuHistory[i].doubleValue();
        }
        if (c == 0) {
            return amount;
        }
        return amount / (double)c;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        System.gc();
        this.refreshUsedMemory();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RuntimeInfoPanel.this.memoryUsage.setLocation(5, -2);
            RuntimeInfoPanel.this.memoryUsage.setSize(RuntimeInfoPanel.this.memoryUsage.getPreferredSize());
            RuntimeInfoPanel.this.cpuUsage.setLocation(5, RuntimeInfoPanel.this.memoryUsage.getY() + RuntimeInfoPanel.this.memoryUsage.getHeight() - 7);
            RuntimeInfoPanel.this.cpuUsage.setSize(RuntimeInfoPanel.this.cpuUsage.getPreferredSize());
            RuntimeInfoPanel.this.nodes.setLocation(RuntimeInfoPanel.this.inset + 3, -2);
            RuntimeInfoPanel.this.nodes.setSize((int)RuntimeInfoPanel.this.nodes.getPreferredSize().getWidth(), (int)RuntimeInfoPanel.this.nodes.getPreferredSize().getHeight());
            RuntimeInfoPanel.this.nodesText.setLocation(RuntimeInfoPanel.this.inset + 3, RuntimeInfoPanel.this.memoryUsage.getY() + RuntimeInfoPanel.this.memoryUsage.getHeight() - 7);
            RuntimeInfoPanel.this.nodesText.setSize(RuntimeInfoPanel.this.nodes.getSize());
            RuntimeInfoPanel.this.listenerUsage.setLocation(RuntimeInfoPanel.this.inset2 + 3, -2);
            RuntimeInfoPanel.this.listenerUsage.setSize((int)RuntimeInfoPanel.this.listenerUsage.getPreferredSize().getWidth(), (int)RuntimeInfoPanel.this.listenerUsage.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(200, 24);
        }
    }
}

