/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.CostCalculationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.SupplierConditionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ISpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewBooleanRenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.myway.TablePopupInsert2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.SupplierSpecificationsTable;
import ch.icit.pegasus.client.gui.utils.variant.SupplierConditionVariantAdd;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.BasicArticleAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SupplierConditionPanel
extends JPanelFadable
implements Table2RowSelectionListener,
Focusable {
    private static final long serialVersionUID = 1L;
    private Table2 supplierTable;
    private Table2 supplierCategoryTable;
    private Table2 periodTable;
    private SupplierConditionDetailsPanel detailsPanel;
    private RDProvider provider;
    private VerticalSeparator sep1;
    private VerticalSeparator sep2;
    private VerticalSeparator sep3;
    private RowEditor<?> editor;
    private SystemSettingsComplete settings;

    public SupplierConditionPanel(RowEditor<BasicArticleLight> editor, RDProvider provider, CostCalculationDetailsPanel costPanel, ISpecificationDetailsPanel spec) {
        this.provider = provider;
        this.editor = editor;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.setLayout(new Layout());
        this.createSupplierTable(provider);
        if (this.isCategoryAllow()) {
            this.createSupplierCategoryTable(provider);
        }
        this.createPeriodsTable(provider);
        this.detailsPanel = new SupplierConditionDetailsPanel(editor, provider, costPanel, spec);
        this.sep1 = new VerticalSeparator();
        this.sep2 = new VerticalSeparator();
        this.sep3 = new VerticalSeparator();
        this.add(this.detailsPanel);
        if (this.isCategoryAllow()) {
            this.add(this.supplierCategoryTable);
        }
        this.add(this.supplierTable);
        this.add(this.periodTable);
        this.add(this.sep1);
        this.add(this.sep2);
        this.add(this.sep3);
    }

    private boolean isCategoryAllow() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.supplierTable.setLocked(isEnabled);
        this.periodTable.setLocked(isEnabled);
        if (this.isCategoryAllow()) {
            this.supplierCategoryTable.setLocked(isEnabled);
        }
    }

    public void setNode(Node<?> node) {
        this.supplierTable.getModel().setNode(node.getChildNamed(BasicArticleComplete_.suppliers));
        if (this.supplierTable.getRowCount() > 0) {
            this.preselectSupplier();
            this.preselectCategory();
            this.preselectPeriod();
        }
    }

    public void preselectSupplier() {
        this.supplierTable.getModel().selectRow(this.supplierTable.getRows().get(0), false, true, 3);
    }

    private void preselectCategory() {
        if (this.isCategoryAllow() && this.supplierCategoryTable.getRowCount() > 0) {
            this.supplierCategoryTable.getModel().selectRow(this.supplierCategoryTable.getRows().get(this.supplierCategoryTable.getRowCount() - 1), false, true, 3);
        }
    }

    public void preselectPeriod() {
        if (this.periodTable.getRowCount() > 0) {
            this.periodTable.getModel().selectRow(this.periodTable.getRows().get(this.periodTable.getRowCount() - 1), false, true, 3);
        }
    }

    private void createSupplierCategoryTable(RDProvider provider) {
        this.supplierCategoryTable = new Table2(true, Words.ADD, false, false);
        this.supplierCategoryTable.setProvider(provider);
        this.supplierCategoryTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SupplierConditionPanel.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (SupplierConditionPanel.this.supplierCategoryTable.getModel().getNode() == null) {
                    InnerPopupFactory.showErrorDialog(Words.SELECT_SUPPLIER_FIRST, (Component)SupplierConditionPanel.this.supplierCategoryTable);
                    return;
                }
                BasicArticleLight dto = (BasicArticleLight)SupplierConditionPanel.this.editor.getModel().getNode().getValue();
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                SupplierConditionCategoryComplete categoryComplete = new SupplierConditionCategoryComplete();
                categoryComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                SupplierLight supplier = (SupplierLight)SupplierConditionPanel.this.supplierCategoryTable.getModel().getNode().getParent().getChildNamed(SupplierConditionBaseComplete_.supplier).getValue();
                SupplierConditionComplete condition = SupplierConditionPanel.this.createSupplierConditionComplete(dto, supplier, settings);
                categoryComplete.getConditions().add(condition);
                Node nd = INodeCreator.getDefaultImpl().getNode4DTO((Object)categoryComplete, true, false);
                SupplierConditionPanel.this.supplierCategoryTable.getModel().getNode().addChild(nd, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, Integer.MAX_VALUE, 30));
        columns.add(new TableColumnInfo(Words.TAX_ZONE, null, null, null, "", 30, Integer.MAX_VALUE, 30));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.supplierCategoryTable.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.supplierCategoryTable.setModel(new Table2Model(columns, model -> new SupplierCategoryTableRowImpl(model)));
        this.supplierCategoryTable.getModel().addTableSelectionListener(this);
        this.add(this.supplierCategoryTable);
    }

    private SupplierConditionComplete createSupplierConditionComplete(BasicArticleLight dto, SupplierLight supplier, SystemSettingsComplete settings) {
        SupplierConditionComplete condition = new SupplierConditionComplete();
        condition.setClientOId(Long.valueOf(ADTO.getNextId()));
        condition.setOrderUnit(dto.getMainStoreUnit());
        condition.setMinOrderAmountUnit(dto.getMainStoreUnit());
        condition.setMinOrderAmountIsMandatory(Boolean.valueOf(false));
        condition.setMinOrderAmount(Double.valueOf(0.0));
        condition.setDeliveryTime(Integer.valueOf(1));
        condition.setValidity(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        condition.setShelfLife(null);
        StepPriceCalculationComplete stepPrice = new StepPriceCalculationComplete();
        stepPrice.setClientOId(Long.valueOf(ADTO.getNextId()));
        StepPriceFunctionComplete f0 = new StepPriceFunctionComplete();
        f0.setClientOId(Long.valueOf(ADTO.getNextId()));
        f0.setPrice(new PriceComplete(supplier != null ? supplier.getPaymentCurrency() : settings.getCurrency(), Double.valueOf(0.0)));
        f0.setSequenceNumber(Integer.valueOf(0));
        f0.setUpperLimit(new QuantityComplete(Double.valueOf(0.0), dto.getMainStoreUnit()));
        stepPrice.getSteps().add(f0);
        condition.setStepPrice(stepPrice);
        return condition;
    }

    public void createSupplierTable(RDProvider provider) {
        this.supplierTable = new Table2(true, Words.ADD, false, false);
        this.supplierTable.setProvider(provider);
        this.supplierTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SupplierConditionPanel.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                BasicArticleLight dto = (BasicArticleLight)SupplierConditionPanel.this.editor.getModel().getNode().getValue();
                SupplierConditionBaseComplete base = new SupplierConditionBaseComplete();
                base.setClientOId(Long.valueOf(ADTO.getNextId()));
                SupplierConditionCategoryComplete category = new SupplierConditionCategoryComplete();
                category.setClientOId(Long.valueOf(ADTO.getNextId()));
                SupplierConditionComplete condition = SupplierConditionPanel.this.createSupplierConditionComplete(dto, null, SupplierConditionPanel.this.settings);
                category.getConditions().add(condition);
                base.getSupplierConditionCategory().add(category);
                Node nd = INodeCreator.getDefaultImpl().getNode4DTO((Object)base, true, false);
                SupplierConditionPanel.this.supplierTable.getModel().getNode().addChild(nd, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 30, 30, 30));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.supplierTable.getCellPadding();
        if (!Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType())) {
            int dw = TableColumnInfo.checkColumnWith + this.supplierTable.getCellPadding();
            columns.add(new TableColumnInfo(Words.KNOWN_SUPPLIER, null, null, null, "", dw, dw, dw));
        }
        columns.add(new TableColumnInfo("", null, null, null, "", tw += EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.supplierTable.getInnerCellPadding(), tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        if (!Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType())) {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        }
        this.supplierTable.setModel(new Table2Model(columns, model -> new SupplierTableRowImpl(model)));
        this.supplierTable.getModel().addTableSelectionListener(this);
        this.add(this.supplierTable);
    }

    public void createPeriodsTable(RDProvider provider) {
        boolean canAdd = provider.isWritable(BasicArticleAccess.SUPPLIER_ADD_VARIANT);
        this.periodTable = new Table2(canAdd, Words.ADD, false, false);
        this.periodTable.setProvider(provider);
        this.periodTable.setUseWriteAccessRight(true);
        this.periodTable.setOverrideName(BasicArticleAccess.SUPPLIER_ADD_VARIANT);
        this.periodTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SupplierConditionPanel.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (SupplierConditionPanel.this.periodTable.getModel().getNode() == null) {
                    InnerPopupFactory.showErrorDialog(Words.SELECT_SUPPLIER_CATEGORY_FIRST, (Component)SupplierConditionPanel.this.periodTable);
                    return;
                }
                new SupplierConditionVariantAdd().addVariant(SupplierConditionPanel.this.periodTable.getModel().getNode(), SupplierConditionPanel.this.periodTable.getModel().getNode().getParent());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = DateChooser.getPreferredWidth(this, false) + 2 * this.periodTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.START_DATE, null, null, null, "", dw, dw, dw));
        dw = DateChooser.getPreferredWidth(this, true) + 2 * this.periodTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.END_DATE, null, null, null, "", dw, dw, dw));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.periodTable.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.periodTable.setModel(new Table2Model(columns, model -> new PeriodTableRowImpl(model)));
        this.periodTable.getModel().addTableSelectionListener(this);
        this.add(this.periodTable);
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (sourceTable == this.supplierTable) {
            if (this.isCategoryAllow()) {
                if (panel != null) {
                    this.supplierCategoryTable.getModel().setNode(panel.getModel().getNode().getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory));
                    this.preselectCategory();
                } else {
                    this.supplierCategoryTable.getModel().setNode(null);
                    this.periodTable.getModel().setNode(null);
                    this.detailsPanel.setMasterNode(null);
                }
            } else if (panel != null) {
                this.periodTable.getModel().setNode(panel.getModel().getNode().getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory).getChildAt(0).getChildNamed(SupplierConditionCategoryComplete_.conditions));
            }
        } else if (sourceTable == this.supplierCategoryTable) {
            if (panel != null) {
                this.periodTable.getModel().setNode(panel.getModel().getNode().getChildNamed(SupplierConditionCategoryComplete_.conditions));
                this.preselectPeriod();
            } else {
                this.periodTable.getModel().setNode(null);
                this.detailsPanel.setMasterNode(null);
            }
        } else if (sourceTable == this.periodTable) {
            if (panel != null) {
                this.detailsPanel.setMasterNode(panel.getModel().getNode());
            } else {
                this.detailsPanel.setMasterNode(null);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public SupplierConditionDetailsPanel getConditionPanel() {
        return this.detailsPanel;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w1 = Math.min(250, parent.getWidth() / 4);
            int w2 = Math.min(350, parent.getWidth() / 4);
            int w3 = Math.min(350, parent.getWidth() / 4);
            SupplierConditionPanel.this.supplierTable.setLocation(0, 0);
            SupplierConditionPanel.this.supplierTable.setSize(w1, parent.getHeight());
            SupplierConditionPanel.this.sep1.setLocation(SupplierConditionPanel.this.supplierTable.getX() + SupplierConditionPanel.this.supplierTable.getWidth(), 0);
            SupplierConditionPanel.this.sep1.setSize((int)SupplierConditionPanel.this.sep1.getPreferredSize().getWidth(), parent.getHeight());
            int nx = SupplierConditionPanel.this.sep1.getX() + SupplierConditionPanel.this.sep1.getWidth();
            if (SupplierConditionPanel.this.isCategoryAllow()) {
                SupplierConditionPanel.this.supplierCategoryTable.setLocation(SupplierConditionPanel.this.sep1.getX() + SupplierConditionPanel.this.sep1.getWidth(), 0);
                SupplierConditionPanel.this.supplierCategoryTable.setSize(w2, parent.getHeight());
                SupplierConditionPanel.this.sep2.setLocation(SupplierConditionPanel.this.supplierCategoryTable.getX() + SupplierConditionPanel.this.supplierCategoryTable.getWidth(), 0);
                SupplierConditionPanel.this.sep2.setSize((int)SupplierConditionPanel.this.sep2.getPreferredSize().getWidth(), parent.getHeight());
                nx = SupplierConditionPanel.this.sep2.getX() + SupplierConditionPanel.this.sep2.getWidth();
            }
            SupplierConditionPanel.this.periodTable.setLocation(nx, 0);
            SupplierConditionPanel.this.periodTable.setSize(w3, parent.getHeight());
            SupplierConditionPanel.this.sep3.setLocation(SupplierConditionPanel.this.periodTable.getX() + SupplierConditionPanel.this.periodTable.getWidth(), 0);
            SupplierConditionPanel.this.sep3.setSize((int)SupplierConditionPanel.this.sep3.getPreferredSize().getWidth(), parent.getHeight());
            SupplierConditionPanel.this.detailsPanel.setLocation(SupplierConditionPanel.this.sep3.getX() + SupplierConditionPanel.this.sep3.getWidth(), 0);
            SupplierConditionPanel.this.detailsPanel.setSize(parent.getWidth() - SupplierConditionPanel.this.detailsPanel.getX(), parent.getHeight());
        }
    }

    private class PeriodTableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private DeleteButton delete;
        private boolean deleteVariant;

        public PeriodTableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.deleteVariant = SupplierConditionPanel.this.provider.isWritable(BasicArticleAccess.SUPPLIER_REMOVE_VARIANT);
            this.startDate = new RDDateChooser(SupplierConditionPanel.this.provider);
            this.endDate = new RDDateChooser(SupplierConditionPanel.this.provider);
            this.startDate.setOverrideName(BasicArticleAccess.SUPPLIER_EDIT_VARIANT);
            this.endDate.setOverrideName(BasicArticleAccess.SUPPLIER_EDIT_VARIANT);
            this.endDate.setCheckBoxEnabled();
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.startDate.setNode(this.model.getNode().getChildNamed(new DtoField[]{SupplierConditionComplete_.validity, PeriodComplete_.startDate}));
            this.endDate.setNode(this.model.getNode().getChildNamed(new DtoField[]{SupplierConditionComplete_.validity, PeriodComplete_.endDate}));
            this.setLayout(new PeriodLayout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
            CheckedListAdder.addToList(a, this.delete);
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new DtoField[]{SupplierConditionComplete_.validity, PeriodComplete_.startDate}).getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled && this.deleteVariant);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getParentModel().getNode().removeChild(this.model.getNode(), 0L);
        }

        private class PeriodLayout
        extends DefaultLayout {
            private PeriodLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, PeriodTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = PeriodTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                PeriodTableRowImpl.this.startDate.setLocation(currentX + PeriodTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - PeriodTableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                PeriodTableRowImpl.this.startDate.setSize(w - 2 * PeriodTableRowImpl.this.getCellPadding(), (int)PeriodTableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = PeriodTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                PeriodTableRowImpl.this.endDate.setLocation(currentX + PeriodTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - PeriodTableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                PeriodTableRowImpl.this.endDate.setSize(w - 2 * PeriodTableRowImpl.this.getCellPadding(), (int)PeriodTableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = PeriodTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                PeriodTableRowImpl.this.setControlsX(currentX);
                PeriodTableRowImpl.this.delete.setLocation(currentX + PeriodTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - PeriodTableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                PeriodTableRowImpl.this.delete.setSize(PeriodTableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class SupplierTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private RDSearchTextField2<SupplierLight> supplierSearch;
        private DeleteButton delete;
        private EditButton specifications;
        private CellViewBooleanRenderer knownState;

        public SupplierTableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.supplierSearch = new RDSearchTextField2(SupplierConditionPanel.this.provider, RDSearchTextField2.SearchTypes.SUPPLIER);
            this.supplierSearch.setOverrideName(BasicArticleAccess.SUPPLIER_SUPPLIER);
            this.supplierSearch.setNode(m.getNode().getChildNamed(SupplierConditionBaseComplete_.supplier));
            m.getNode().getChildNamed(SupplierConditionBaseComplete_.supplier).addNodeListener((NodeListener)this);
            if (!Boolean.TRUE.equals(SupplierConditionPanel.this.settings.getCompany().getSolarCompanyType())) {
                this.knownState = new CellViewBooleanRenderer(false, true);
            }
            this.specifications = new EditButton();
            this.specifications.addButtonListener(this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new SupplierLayout());
            this.updateKnownState();
            this.add(this.supplierSearch);
            this.add(this.delete);
            this.add(this.specifications);
            if (this.knownState != null) {
                this.add(this.knownState);
            }
        }

        private void updateKnownState() {
            if (this.knownState != null) {
                Node supplierNode = this.model.getNode().getChildNamed(SupplierConditionBaseComplete_.supplier);
                if (supplierNode.getValue() != null) {
                    this.knownState.setCurrentState(Boolean.TRUE.equals(((SupplierLight)supplierNode.getValue()).getKnownSupplier()));
                } else {
                    this.knownState.setCurrentState(false);
                }
            }
        }

        @Override
        public void kill() {
            super.kill();
            if (this.model != null && this.model.getNode() != null) {
                this.model.getNode().getChildNamed(SupplierConditionBaseComplete_.supplier).removeNodeListener((NodeListener)this);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.supplierSearch.setEnabled(isEnabled);
            boolean deleteEnable = SupplierConditionPanel.this.provider.isWritable(BasicArticleAccess.SUPPLIER_REMOVE);
            this.delete.setEnabled(deleteEnable && isEnabled);
            boolean editSpecifications = SupplierConditionPanel.this.provider.isWritable(BasicArticleAccess.SUPPLIER_SPEC);
            this.specifications.setEnabled(isEnabled && editSpecifications);
            if (this.knownState != null) {
                this.knownState.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.supplierSearch);
            CheckedListAdder.addToList(focusList, this.specifications);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(SupplierConditionBaseComplete_.supplier).getValue();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.specifications) {
                SupplierSpecificationsTable table = new SupplierSpecificationsTable(SupplierConditionPanel.this.provider, (Node<List<SupplierConditionSpecificationComplete>>)this.model.getNode().getChildNamed(SupplierConditionBaseComplete_.specifications));
                InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
                pop.setAttributes(table, true, true, Words.SPECIFICATION);
                pop.setView(new TablePopupInsert2(table));
                pop.showPopUp(x, y, 500, 350, null, this);
            } else {
                this.model.getParentModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        public void valueChanged(Node<?> node) {
            SupplierLight supplier = (SupplierLight)node.getValue();
            Iterator it = this.model.getNode().getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Iterator it2 = n.getChildNamed(SupplierConditionCategoryComplete_.conditions).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node nt = (Node)it2.next();
                    nt.getChildNamed(SupplierConditionComplete_.supplier).setValue((Object)supplier, 0L);
                    SupplierConditionComplete sc = (SupplierConditionComplete)nt.getValue();
                    sc.setSupplier(supplier);
                    for (StepPriceFunctionComplete s : sc.getStepPrice().getSteps()) {
                        s.getPrice().setCurrency(supplier.getPaymentCurrency());
                    }
                    n.updateNode();
                }
            }
            this.updateKnownState();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class SupplierLayout
        extends DefaultLayout {
            private SupplierLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, SupplierTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                SupplierTableRowImpl.this.supplierSearch.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.supplierSearch.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.supplierSearch.setSize(w - 2 * SupplierTableRowImpl.this.getCellPadding(), (int)SupplierTableRowImpl.this.supplierSearch.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                if (SupplierTableRowImpl.this.knownState != null) {
                    SupplierTableRowImpl.this.knownState.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.knownState.getPreferredSize().getHeight()) / 2.0));
                    SupplierTableRowImpl.this.knownState.setSize(SupplierTableRowImpl.this.knownState.getPreferredSize());
                    currentX += w;
                    w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                }
                SupplierTableRowImpl.this.setControlsX(currentX);
                SupplierTableRowImpl.this.specifications.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.specifications.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.specifications.setSize(SupplierTableRowImpl.this.specifications.getPreferredSize());
                SupplierTableRowImpl.this.delete.setLocation(SupplierTableRowImpl.this.specifications.getX() + SupplierTableRowImpl.this.specifications.getWidth() + SupplierTableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.delete.setSize(SupplierTableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class SupplierCategoryTableRowImpl
    extends Table2RowPanel {
        private RDTextField name;
        private RDComboBox taxZone;
        private DeleteButton delete;

        public SupplierCategoryTableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setSelectable(true);
            this.name = new RDTextField(SupplierConditionPanel.this.provider);
            this.name.setOverrideName(SupplierConditionBaseComplete_.supplierConditionCategory);
            this.name.setNode(m.getNode().getChildNamed(SupplierConditionCategoryComplete_.name));
            this.taxZone = new RDComboBox(SupplierConditionPanel.this.provider, ConverterRegistry.getConverter(TaxZoneConverter.class), true);
            this.taxZone.setOverrideName(SupplierConditionBaseComplete_.supplierConditionCategory);
            this.taxZone.setNode(m.getNode().getChildNamed(SupplierConditionCategoryComplete_.taxZone));
            this.taxZone.refreshPossibleValues(NodeToolkit.getAffixList(TaxZoneComplete.class));
            if (SupplierConditionPanel.this.provider.isDeletable(SupplierConditionBaseComplete_.supplierConditionCategory)) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener((source, x, y) -> this.model.getNode().getParent().removeChild(this.model.getNode(), 0L));
            }
            this.setLayout(new Layout());
            this.add(this.name);
            this.add(this.taxZone);
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(SupplierConditionCategoryComplete_.taxZone).getValue();
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, SupplierCategoryTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = SupplierCategoryTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                SupplierCategoryTableRowImpl.this.name.setLocation(SupplierCategoryTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierCategoryTableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                SupplierCategoryTableRowImpl.this.name.setSize(w - 2 * SupplierCategoryTableRowImpl.this.getCellPadding(), (int)SupplierCategoryTableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierCategoryTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                SupplierCategoryTableRowImpl.this.taxZone.setLocation(currentX + SupplierCategoryTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierCategoryTableRowImpl.this.taxZone.getPreferredSize().getHeight()) / 2.0));
                SupplierCategoryTableRowImpl.this.taxZone.setSize(w - 2 * SupplierCategoryTableRowImpl.this.getCellPadding(), (int)SupplierCategoryTableRowImpl.this.taxZone.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierCategoryTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                SupplierCategoryTableRowImpl.this.setControlsX(currentX);
                if (SupplierCategoryTableRowImpl.this.delete != null) {
                    SupplierCategoryTableRowImpl.this.delete.setLocation(currentX + SupplierCategoryTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierCategoryTableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    SupplierCategoryTableRowImpl.this.delete.setSize(SupplierCategoryTableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

