/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels.documentscan;

import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class DocumentScanToolkit {
    public static List<DocumentScanComplete> findDocumentScan(String defaultFolder, DocumentScanTypeE type) {
        File parentFolder = new File(defaultFolder);
        if (!parentFolder.exists()) {
            return new ArrayList<DocumentScanComplete>();
        }
        ArrayList<DocumentScanComplete> scans = new ArrayList<DocumentScanComplete>();
        for (File file : parentFolder.listFiles()) {
            if (!file.getAbsolutePath().endsWith(".pdf")) continue;
            DocumentScanComplete scan = new DocumentScanComplete();
            scan.setClientOId(Long.valueOf(ADTO.getNextId()));
            PegasusFileComplete pdf = new PegasusFileComplete();
            pdf.setLocalFile(file);
            pdf.setCategory(FileCategoryE.DOCUMENT);
            pdf.setFileName(file.getName());
            scan.setCreationDate(new Timestamp(System.currentTimeMillis()));
            scan.setFileData(pdf);
            scan.setType(type);
            scans.add(scan);
        }
        return scans;
    }

    public static ScreenValidationObject validateDocumentNumber(String docId, BasicArticleLight artL) {
        String docTypeChar;
        if (docId.length() >= 5 && (docTypeChar = docId.substring(4, 5)).equals("W")) {
            String errorText = "e-doc is not allowed";
            if (artL != null) {
                errorText = errorText + " (" + artL.getNumber() + " " + artL.getName() + ")";
            }
            return new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, errorText);
        }
        return null;
    }

    public static String readRawTextFromPDF(File pdfFile) {
        PDDocument pdDoc = null;
        COSDocument cosDoc = null;
        File file = pdfFile;
        try {
            PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessReadBufferedFile(file));
            cosDoc = parser.parse().getDocument();
            PDFTextStripper pdfStripper = new PDFTextStripper();
            pdDoc = new PDDocument(cosDoc);
            String parsedText = pdfStripper.getText(pdDoc);
            return parsedText;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (cosDoc != null) {
                    cosDoc.close();
                }
                if (pdDoc != null) {
                    pdDoc.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return "";
        }
    }

    public static void moveScannedFile(SystemSettingsComplete settings, File localFile, Date documentDate, String fileName) {
        try {
            if (Boolean.TRUE.equals(settings.getMoveScannedDocuments())) {
                String originMovePath = settings.getMoveScannedDocumentsSubPath();
                if (Boolean.TRUE.equals(settings.getMoveScannedDocumentsToArchiveStructure())) {
                    int monthOfYear = DateUtil.getMonthOfYear((java.util.Date)documentDate);
                    int year = DateUtil.getYear((java.util.Date)documentDate);
                    String monthString = "" + monthOfYear;
                    if (monthString.length() < 2) {
                        monthString = "0" + monthString;
                    }
                    originMovePath = originMovePath + File.separator + year + File.separator + monthOfYear;
                }
                int i = localFile.getName().indexOf(".");
                String suffix = localFile.getName().substring(i);
                String name = fileName;
                File destFile = new File(originMovePath + File.separator + name + suffix);
                int count = 1;
                while (destFile.exists()) {
                    String newName = name + "_" + count + suffix;
                    String movePath = originMovePath;
                    movePath = movePath + File.separator + newName;
                    destFile = new File(movePath);
                    ++count;
                }
                destFile.getParentFile().mkdirs();
                FileUtils.moveFile((File)localFile, (File)destFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

