/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.attributes.ImageAttributeLoader;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.batch.Batchable;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupContainer;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.skins.ComboBoxPopUpSkin;
import ch.icit.pegasus.client.gui.utils.popup.skins.ErrorSkin;
import ch.icit.pegasus.client.gui.utils.popup.skins.NormalSkin;
import ch.icit.pegasus.client.gui.utils.popup.skins.WarningSkin;
import ch.icit.pegasus.client.gui.utils.skins.Skin13Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class InnerPopUp2
extends JPanelFadable
implements LafListener,
MouseListener,
MouseMotionListener,
ButtonListener,
AnimationListener,
MutableFocusContainerListener {
    private static final long serialVersionUID = 1L;
    private InnerPopUpListener2 listener;
    protected int borderWest;
    protected int borderNorth;
    protected int borderEast;
    protected int borderSouth;
    private boolean isRegistered = false;
    protected int comboBorderWest = 4;
    protected int comboBorderNorth = 3;
    protected int comboBorderEast = 9;
    protected int comboBorderSouth = 0;
    private boolean isResizeDragging;
    private int isRightAlignment;
    int innerGap = 7;
    private int uWestBorder;
    private int uNorthBorder;
    private int uEastBorder;
    private int uSouthBorder;
    private Color extensionLineColor = null;
    private Color extensionBackColor = null;
    private static Color smartAccessBackgroundGradientColorStart;
    private static Color smartAccessBackgroundGradientColorEnd;
    private IPopUpInsert view;
    private Skin13Field skin;
    private Skin9Field skin2;
    private Skin9Field skin3;
    private TypedSkin9Field skin4;
    private PopupType currentType = PopupType.NORMAL;
    private int arrowOffset = 0;
    private TextLabel title = new TextLabel();
    private boolean isTitleAdded = false;
    private int currentState = 5;
    private boolean isDraggingAllowed = false;
    private boolean isResizeAllowed = false;
    private Point backupPoint;
    private Dimension backupDimension;
    private AWTEventListener keyListener;
    private boolean isBlocking = false;
    private Component caller;
    private TextButton okButton;
    private TextButton cancelButton;
    private TextButton previewButton;
    private TextButton runInBackground;
    private HorizontalSeparator sep1;
    private Component invoker;
    private boolean useButtons;
    private boolean isInstanceInUse;
    private int minHeight;
    private int minWidth;
    private boolean isSpecialRequest = true;
    private Timer scheduleTime;
    private boolean isPreview;
    private boolean isNullAtOKAnyWay;
    private boolean requestFocusInLayout;
    private BatchList batchList;

    public static InnerPopUp2 getInnerPopUp() {
        return InnerPopUp2.getInnerPopUp(null);
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public static InnerPopUp2 getInnerPopUp(PopupType type) {
        InnerPopUp2 p = new InnerPopUp2();
        return p;
    }

    public void enablePreviewButton(String text, TextButton.BUTTON_TYPES type) {
        if (this.previewButton == null) {
            this.previewButton = new TablePanelAddSaveButton(type);
            this.previewButton.setText(text);
            this.previewButton.addButtonListener(this);
            this.add(this.previewButton);
        } else {
            this.previewButton.setEnabled(true);
        }
    }

    public void enableBackgroundButton() {
        this.enableBackgroundButton(Words.BACKGROUND, TextButton.BUTTON_TYPES.OK);
    }

    public void enableBackgroundButton(String text, TextButton.BUTTON_TYPES type) {
        if (this.runInBackground == null) {
            this.runInBackground = new TablePanelAddSaveButton(type);
            this.runInBackground.setText(text);
            this.runInBackground.addButtonListener(this);
            this.add((Component)this.runInBackground, 0);
        } else {
            this.runInBackground.setEnabled(true);
        }
    }

    public void enablePreviewButton() {
        this.enablePreviewButton(Words.PREVIEW, TextButton.BUTTON_TYPES.OK);
    }

    public void disablePreviewButton() {
        if (this.previewButton != null) {
            this.previewButton.kill();
            this.previewButton = null;
        }
    }

    public void disableBackgroundButton() {
        if (this.runInBackground != null) {
            this.runInBackground.kill();
            this.runInBackground = null;
        }
    }

    private InnerPopUp2() {
        this.allowResize();
        this.extensionBackColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.extensionLineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_outline"));
        this.getFader().setPermanent(true);
        this.getFader().addAnimationListener(this);
        this.lafAttributeChanged("All attribues changed");
        this.addMouseListener(this);
        this.setDraggingAllowed(true);
        this.borderNorth = AttributesConverter.getInteger4String(ImageAttributeLoader.getImageAttributeLoader().getImageAttribute("popup_13field_skin_north_inset"));
        this.borderSouth = AttributesConverter.getInteger4String(ImageAttributeLoader.getImageAttributeLoader().getImageAttribute("popup_13field_skin_south_inset"));
        this.borderEast = AttributesConverter.getInteger4String(ImageAttributeLoader.getImageAttributeLoader().getImageAttribute("popup_13field_skin_east_inset"));
        this.borderWest = AttributesConverter.getInteger4String(ImageAttributeLoader.getImageAttributeLoader().getImageAttribute("popup_13field_skin_west_inset"));
        this.skin = new NormalSkin();
        this.setOpaque(false);
        this.setLayout(new InnerPopUpLayout());
        this.isTitleAdded = true;
        this.add(this.title);
    }

    public void setRightAlignment(int isAligning) {
        this.isRightAlignment = isAligning;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return new Dimension(0, 0);
    }

    public void hideCancelButton() {
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(false);
            this.cancelButton.setProgress(0.0f);
        }
    }

    public void hideOkButton() {
        if (this.okButton != null) {
            this.okButton.setVisible(false);
            this.okButton.setProgress(0.0f);
        }
    }

    public void setOkButtonText(String t) {
        if (this.okButton != null) {
            this.okButton.setText(t);
        }
    }

    public void setCancelButtonText(String t) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(t);
        }
    }

    public void requestFocusOnOkButton() {
        this.okButton.requestFocusInWindow();
    }

    public void requestFocusOnCancelButton() {
        this.cancelButton.requestFocusInWindow();
    }

    public void enableOKButton(boolean isEnabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(isEnabled);
        }
        if (this.previewButton != null) {
            this.previewButton.setEnabled(isEnabled);
        }
        if (this.runInBackground != null) {
            this.runInBackground.setEnabled(isEnabled);
        }
    }

    public void enableCancelButton(boolean isEnabled) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(isEnabled);
        }
    }

    public void enableButtons(boolean b) {
        if (this.runInBackground != null) {
            this.runInBackground.kill();
            this.runInBackground = null;
        }
        if (b) {
            if (this.okButton == null) {
                this.okButton = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.OK);
                this.okButton.addButtonListener(this);
                this.okButton.setProgress(1.0f);
            } else {
                this.okButton.setVisible(true);
                this.okButton.setProgress(1.0f);
            }
            if (this.cancelButton == null) {
                this.cancelButton = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.CANCEL);
                this.cancelButton.addButtonListener(this);
                this.cancelButton.setProgress(1.0f);
            } else {
                this.cancelButton.setVisible(true);
                this.cancelButton.setProgress(1.0f);
            }
            if (this.sep1 == null) {
                this.sep1 = new HorizontalSeparator();
            }
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.add((Component)this.okButton, 0);
            this.add((Component)this.cancelButton, 0);
            this.add((Component)this.sep1, 0);
        } else {
            if (this.okButton != null) {
                this.okButton.removeButtonListener(this);
                this.okButton.kill();
                this.okButton = null;
            }
            if (this.cancelButton != null) {
                this.cancelButton.removeButtonListener(this);
                this.cancelButton.kill();
                this.cancelButton = null;
            }
            if (this.sep1 != null) {
                this.sep1.kill();
                this.sep1 = null;
            }
        }
        this.useButtons = b;
    }

    public IPopUpInsert getView() {
        return this.view;
    }

    public void setPopupTitle(String t) {
        this.title.setText(t);
    }

    private void setDraggingAllowed(boolean isAllowed) {
        if (isAllowed != this.isDraggingAllowed) {
            if (isAllowed) {
                this.addMouseMotionListener(this);
            } else {
                this.removeMouseMotionListener(this);
            }
            this.isDraggingAllowed = isAllowed;
        }
    }

    private void registerKeyEvents() {
        if (!this.isRegistered) {
            this.keyListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (keyEvent.getID() == 401) {
                        if (keyEvent.getKeyCode() == 27) {
                            if (!keyEvent.isConsumed()) {
                                InnerPopUp2.this.hidePopUp(new Object[0]);
                            }
                        } else if (keyEvent.getKeyCode() == 10 && InnerPopUp2.this.view != null && !InnerPopUp2.this.isButtonFocus() && InnerPopUp2.this.view.isClosableWithEnter() && !keyEvent.isConsumed()) {
                            if (InnerPopUp2.this.runInBackground != null && InnerPopUp2.this.runInBackground.isEnabled()) {
                                InnerPopUp2.this.view.enterPressed(PopupAction.OK_BACKGROUND);
                            } else {
                                InnerPopUp2.this.view.enterPressed(PopupAction.OK_FOREGROUND);
                            }
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
            this.isRegistered = true;
        }
    }

    private boolean isButtonFocus() {
        return this.useButtons && (this.okButton.hasFocus() || this.cancelButton.hasFocus());
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    private void deregister() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
        this.isRegistered = false;
    }

    private void deregisterKeyEvents() {
        List<Component> a;
        if (this.isSpecialRequest && this.invoker != null && this.invoker instanceof Focusable && (a = ((Focusable)((Object)this.invoker)).getFocusComponents()) != null && a.size() > 0 && a.get(0) != null) {
            a.get(0).requestFocusInWindow();
        }
        Button.pressedItem = null;
        this.deregister();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.skin != null) {
            this.skin.paint(g2, this.getWidth(), this.getHeight(), this.currentState, this.arrowOffset);
        } else if (this.skin2 != null) {
            if (this.currentType == PopupType.SEARCHBOX) {
                if (this.currentState == 1) {
                    this.skin2.paint(g2, 0, 0, this.getWidth(), this.getHeight() - this.innerGap, Button.ButtonState.UP);
                } else {
                    g2.translate(0, this.innerGap);
                    this.skin2.paint(g2, 0, 0, this.getWidth(), this.getHeight() - this.innerGap, Button.ButtonState.UP);
                    g2.translate(0, -this.innerGap);
                }
                this.paintQuadric(g2);
            } else {
                this.skin2.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
            }
        } else if (this.skin3 != null) {
            this.skin3.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        } else if (this.skin4 != null) {
            if (this.currentType == PopupType.SEARCHBOX) {
                if (this.currentState == 1) {
                    this.skin4.paint(g2, this.getWidth(), this.getHeight() - this.innerGap, Button.ButtonState.UP, this.currentState);
                } else {
                    g2.translate(0, this.innerGap);
                    this.skin4.paint(g2, this.getWidth(), this.getHeight() - this.innerGap, Button.ButtonState.UP, this.currentState);
                    g2.translate(0, -this.innerGap);
                }
                this.paintQuadric(g2);
            } else {
                this.skin4.paint(g2, this.getWidth(), this.getHeight(), Button.ButtonState.UP, this.currentState);
            }
        }
        if (this.getResizeAllowed()) {
            DrawToolkit.drawResizeCorner(g2, this, 13, 13);
        }
        if (this.currentType == PopupType.SMARTACCES) {
            GradientPaint gradient = new GradientPaint(this.uWestBorder - 1, this.uNorthBorder - 1, smartAccessBackgroundGradientColorStart, 0.0f, this.getHeight() - (this.uNorthBorder - 1), smartAccessBackgroundGradientColorEnd, true);
            g2.setPaint(gradient);
            g2.fill(new RoundRectangle2D.Double(this.uWestBorder - 1, this.uNorthBorder - 1, this.getWidth() - (this.uWestBorder + this.uEastBorder - 2), this.getHeight() - (this.uNorthBorder + this.uSouthBorder - 2), 6.0, 6.0));
        }
        this.paintChildren(g2);
    }

    public int getCurrentState() {
        return this.currentState;
    }

    private void paintQuadric(Graphics2D g2) {
        Point textPos = SwingUtilities.convertPoint(this.invoker, new Point(0, 0), this);
        if (this.currentState == 1) {
            CubicCurve2D.Double cL = new CubicCurve2D.Double();
            int currentX = (int)(textPos.getX() + 5.0);
            int x1 = 0;
            int y1 = this.getHeight() - this.innerGap;
            int x2 = currentX;
            int y2 = this.getHeight() - 1;
            int cx1 = currentX / 2;
            cx1 -= cx1 / 2;
            int cy1 = this.getHeight() - 1;
            int cx2 = currentX / 2;
            cx2 += cx2 / 2;
            int cy2 = this.getHeight() - this.innerGap;
            ((CubicCurve2D)cL).setCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
            CubicCurve2D.Double cR = new CubicCurve2D.Double();
            currentX = (int)(textPos.getX() + (double)this.invoker.getWidth()) - 6;
            int currentW = this.getWidth() - 9;
            x1 = currentX;
            y1 = this.getHeight() - 1;
            x2 = currentW;
            y2 = this.getHeight() - this.innerGap;
            cx2 = (currentW - currentX) / 2;
            cx2 += cx2 / 2;
            cy2 = this.getHeight() - 1;
            cx1 = (currentW - currentX) / 2;
            cx1 -= cx1 / 2;
            cy1 = this.getHeight() - this.innerGap;
            ((CubicCurve2D)cR).setCurve(x1, y1, cx1 += currentX, cy1, cx2 += currentX, cy2, x2, y2);
            GeneralPath p = new GeneralPath();
            p.moveTo(((CubicCurve2D)cL).getX1(), ((CubicCurve2D)cL).getY1());
            p.append(cL, true);
            p.append(new Line2D.Double(((CubicCurve2D)cL).getX2(), ((CubicCurve2D)cL).getY2(), ((CubicCurve2D)cR).getX1(), ((CubicCurve2D)cR).getY1()), true);
            p.append(cR, true);
            p.append(new Line2D.Double(((CubicCurve2D)cR).getX2(), ((CubicCurve2D)cR).getY2(), ((CubicCurve2D)cL).getX1(), ((CubicCurve2D)cL).getY1()), true);
            p.closePath();
            g2.setColor(this.extensionBackColor);
            g2.fill(p);
            g2.setColor(this.extensionLineColor);
            g2.draw(cL);
            g2.setColor(this.extensionLineColor);
            g2.draw(cR);
        } else {
            CubicCurve2D.Double cL = new CubicCurve2D.Double();
            int currentX = (int)(textPos.getX() + 5.0);
            int x1 = 0;
            int y1 = this.innerGap;
            int x2 = currentX;
            int y2 = 0;
            int cx1 = currentX / 2;
            cx1 -= cx1 / 2;
            int cy1 = 0;
            int cx2 = currentX / 2;
            cx2 += cx2 / 2;
            int cy2 = this.innerGap;
            ((CubicCurve2D)cL).setCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
            CubicCurve2D.Double cR = new CubicCurve2D.Double();
            currentX = (int)(textPos.getX() + (double)this.invoker.getWidth()) - 6;
            int currentW = this.getWidth() - 9;
            x1 = currentX;
            y1 = 0;
            x2 = currentW;
            y2 = this.innerGap;
            cx1 = (currentW - currentX) / 2;
            cx1 -= cx1 / 2;
            cy1 = this.innerGap;
            cx2 = (currentW - currentX) / 2;
            cx2 += cx2 / 2;
            cy2 = 0;
            ((CubicCurve2D)cR).setCurve(x1, y1, cx1 += currentX, cy1, cx2 += currentX, cy2, x2, y2);
            GeneralPath p = new GeneralPath();
            p.moveTo(((CubicCurve2D)cL).getX1(), ((CubicCurve2D)cL).getY1());
            p.append(cL, true);
            p.append(new Line2D.Double(((CubicCurve2D)cL).getX2(), ((CubicCurve2D)cL).getY2(), ((CubicCurve2D)cR).getX1(), ((CubicCurve2D)cR).getY1()), true);
            p.append(cR, true);
            p.append(new Line2D.Double(((CubicCurve2D)cR).getX2(), ((CubicCurve2D)cR).getY2(), ((CubicCurve2D)cL).getX1(), ((CubicCurve2D)cL).getY1()), true);
            p.closePath();
            g2.setColor(this.extensionBackColor);
            g2.fill(p);
            g2.setColor(this.extensionLineColor);
            g2.draw(cL);
            g2.setColor(this.extensionLineColor);
            g2.draw(cR);
        }
    }

    public void hidePopUp(Object ... o) {
        if (this.view != null) {
            this.view.popupClosed();
        }
        this.deregisterKeyEvents();
        this.isNullAtOKAnyWay = false;
        MainFrame.closePopup(this);
        Object[] com = o;
        if (com != null && com.length == 0) {
            com = null;
        }
        if (this.listener != null) {
            this.listener.popUpClosed(this, com);
            this.listener = null;
        }
        this.fadeOut(true);
    }

    public void setListener(InnerPopUpListener2 listener) {
        this.listener = listener;
    }

    public void setView(IPopUpInsert view) {
        this.setView(view, null);
    }

    public void setView(IPopUpInsert view, BatchList<?, ?> batchList) {
        if (this.view != null && !this.view.isKilled()) {
            try {
                this.view.kill();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.view = null;
        }
        this.disablePreviewButton();
        this.disableBackgroundButton();
        this.batchList = batchList;
        this.view = view;
        if (view != null) {
            this.view.setInnerPopUp(this);
        }
        if (batchList != null && this.view instanceof Batchable) {
            this.enableBackgroundButton();
        }
        if (this.view instanceof MutableFocusContainer) {
            ((MutableFocusContainer)((Object)this.view)).addFocusCycleChangeListener(this);
        }
        this.isNullAtOKAnyWay = false;
        if (view != null) {
            this.view = view;
            this.add((Component)((Object)this.view));
        }
    }

    private void setCaller(Component caller) {
        this.caller = caller;
    }

    public Component getCaller() {
        return this.caller;
    }

    public boolean isInnerComponent(Component c) {
        if (c == this) {
            return true;
        }
        if (this.view == null) {
            return false;
        }
        return this.view.isInnerComponent(c);
    }

    public boolean isCaller(Component c) {
        return c == this.caller;
    }

    private void allowResize() {
        this.setResizeAllowed(true);
    }

    public void setAttributes(Component caller, boolean areButtonsEnabled, boolean isBlocking, String popupTitle) {
        this.setCaller(caller);
        this.enableButtons(areButtonsEnabled);
        this.setBlocking(isBlocking);
        this.setPopupTitle(popupTitle);
    }

    public void showPopUpWithinScreenMiddle(int w, int h, InnerPopUpListener2 listener, Component invoker) {
        this.showPopUpWithinScreenMiddle(w, h, listener, invoker, PopupType.NORMAL);
    }

    public void showPopUpWithinScreenMiddle(final int w, final int h, final InnerPopUpListener2 listener, Component invoker, final PopupType type) {
        Container c;
        for (c = (Container)invoker; c != null && !(c instanceof PopupContainer); c = c.getParent()) {
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (c != null) {
                int x = (c.getWidth() - w) / 2;
                int y = (c.getHeight() - h) / 2;
                ((PopupContainer)((Object)c)).showShadow();
                this.showPopUp(x, y, w, h, listener, c, type, false, true);
            }
        } else {
            final Container fc = c;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (fc != null) {
                        int x = (fc.getWidth() - w) / 2;
                        int y = (fc.getHeight() - h) / 2;
                        ((PopupContainer)((Object)fc)).showShadow();
                        InnerPopUp2.this.showPopUp(x, y, w, h, listener, fc, type, false, true);
                    }
                }
            });
        }
    }

    public void showPopUp(int x, int y, int w, int h, InnerPopUpListener2 listener, Component invoker, PopupType type, boolean translate) {
        this.showPopUp(x, y, w, h, listener, invoker, type, translate, false);
    }

    public void showPopUp(int x, int y, int w, int h, InnerPopUpListener2 listener, Component invoker, PopupType type, boolean translate, boolean is9Field) {
        Container c;
        int nx = x;
        int ny = y;
        this.invoker = invoker;
        this.currentType = type;
        if (is9Field) {
            this.skin = null;
            this.skin2 = null;
            this.skin3 = null;
            this.skin4 = null;
            if (type == PopupType.FATAL) {
                this.skin3 = (Skin9Field)DefaultSkins.PopupInMiddleErrorBackground.createDynamicSkin();
                this.skin2 = (Skin9Field)DefaultSkins.PopupInMiddleErrorBackground.createDynamicSkin();
            } else if (type == PopupType.WARNING) {
                this.skin3 = (Skin9Field)DefaultSkins.PopupInMiddleWarningBackground.createDynamicSkin();
                this.skin2 = (Skin9Field)DefaultSkins.PopupInMiddleWarningBackground.createDynamicSkin();
            } else if (type == PopupType.NORMAL) {
                this.skin3 = (Skin9Field)DefaultSkins.PopupInMiddleNormalBackground.createDynamicSkin();
            }
            if (!this.isTitleAdded) {
                this.isTitleAdded = true;
                this.add(this.title);
            }
        } else {
            switch (type) {
                case FATAL: 
                case WARNING: {
                    this.skin = null;
                    this.skin2 = (Skin9Field)DefaultSkins.PopupInMiddleErrorBackground.createDynamicSkin();
                    this.skin3 = null;
                    this.skin = type == PopupType.FATAL ? (Skin13Field)SkinRegistry.getSkin(ErrorSkin.class) : (Skin13Field)SkinRegistry.getSkin(WarningSkin.class);
                    if (this.isTitleAdded) break;
                    this.isTitleAdded = true;
                    this.add(this.title);
                    break;
                }
                case NORMAL: 
                case FRAMELESS: {
                    this.skin = null;
                    this.skin2 = null;
                    this.skin3 = null;
                    this.skin = SkinRegistry.getSkin(NormalSkin.class);
                    if (this.isTitleAdded) break;
                    this.isTitleAdded = true;
                    this.add(this.title);
                    break;
                }
                case INPUTCOMBO: 
                case COMBO: 
                case SEARCHBOX: {
                    this.skin = null;
                    this.skin3 = null;
                    this.skin4 = SkinRegistry.getSkin(ComboBoxPopUpSkin.class);
                    if (!this.isTitleAdded) break;
                    this.isTitleAdded = false;
                    this.remove(this.title);
                    break;
                }
                case SMARTACCES: {
                    this.skin = null;
                    this.skin2 = null;
                    this.skin3 = (Skin9Field)DefaultSkins.PopupSubmoduleBackground.createDynamicSkin();
                    if (!this.isTitleAdded) break;
                    this.isTitleAdded = false;
                    this.remove(this.title);
                }
            }
        }
        MainFrame.openPopup(this);
        for (c = (Container)invoker; c != null && !(c instanceof PopupContainer); c = c.getParent()) {
        }
        if (c != null && c != invoker) {
            Point screenPoint = SwingUtilities.convertPoint(invoker, new Point(x, y), c);
            nx = (int)screenPoint.getX();
            ny = (int)screenPoint.getY();
        }
        if (c == null) {
            return;
        }
        int cw = w;
        int ch = h;
        if (cw == -1) {
            cw = (int)this.view.getPreferredSize().getWidth();
        }
        if (this.isTitleAdded && (double)cw < this.title.getPreferredSize().getWidth()) {
            cw = (int)this.title.getPreferredSize().getWidth();
        }
        if (ch == -1) {
            ch = (int)this.view.getPreferredSize().getHeight();
        }
        if (type != PopupType.SEARCHBOX && type != PopupType.INPUTCOMBO && type != PopupType.COMBO && type != PopupType.SMARTACCES) {
            ch += 10;
        }
        if (this.useButtons) {
            ch = (int)((double)ch + (20.0 + this.okButton.getPreferredSize().getHeight()));
            if (this.getPreferredSize().getWidth() > (double)cw) {
                cw = (int)this.getPreferredSize().getWidth();
            }
        }
        int maxHeight = 0;
        Component ic = invoker;
        while (ic.getParent() != null) {
            ic = ic.getParent();
        }
        if (ic != null) {
            maxHeight = ic.getHeight() - 50;
        }
        if (ch > maxHeight) {
            ch = maxHeight;
        }
        if (type == PopupType.INPUTCOMBO) {
            this.uWestBorder = this.comboBorderWest;
            this.uNorthBorder = this.comboBorderNorth;
            this.uEastBorder = this.comboBorderEast;
            this.uSouthBorder = this.comboBorderSouth;
            --this.uNorthBorder;
            this.uWestBorder -= 3;
            this.uSouthBorder += 11;
        } else if (type == PopupType.COMBO) {
            this.uWestBorder = this.comboBorderWest;
            this.uNorthBorder = this.comboBorderNorth;
            this.uEastBorder = this.comboBorderEast;
            this.uSouthBorder = this.comboBorderSouth;
            this.uSouthBorder += 11;
            --this.uWestBorder;
        } else if (type == PopupType.SEARCHBOX) {
            this.uWestBorder = this.comboBorderWest;
            this.uNorthBorder = this.comboBorderNorth;
            this.uEastBorder = this.comboBorderEast;
            this.uSouthBorder = this.comboBorderSouth;
            --this.uNorthBorder;
            this.uWestBorder -= 3;
            this.uSouthBorder += 12;
        } else if (type == PopupType.FRAMELESS) {
            this.uWestBorder = this.borderWest;
            this.uNorthBorder = this.borderNorth;
            this.uEastBorder = this.borderEast;
            this.uSouthBorder = this.borderSouth;
        } else if (type == PopupType.SMARTACCES) {
            this.uWestBorder = this.borderWest - 8;
            this.uNorthBorder = this.borderNorth - 21;
            this.uEastBorder = this.borderEast - 2;
            this.uSouthBorder = this.borderSouth - 2;
        } else if (this.view.usePictureBorder()) {
            this.uWestBorder = this.skin.getImage31().getWidth();
            this.uNorthBorder = this.skin.getImage11().getHeight();
            this.uEastBorder = this.skin.getImage11().getWidth();
            this.uSouthBorder = this.skin.getImage33().getHeight();
        } else {
            this.uWestBorder = this.borderWest + 5;
            this.uNorthBorder = this.borderNorth + 5;
            this.uEastBorder = this.borderEast + 5;
            this.uSouthBorder = this.borderSouth + 5;
        }
        if (type == PopupType.SEARCHBOX || type == PopupType.FATAL || type == PopupType.INPUTCOMBO || type == PopupType.COMBO || type == PopupType.WARNING) {
            if (this.skin2 != null) {
                this.setSize(cw + 8, ch + (this.skin2.getImage31(Button.ButtonState.UP).getHeight() + this.skin2.getImage33(Button.ButtonState.UP).getHeight()) - 20);
            } else if (this.skin4 != null) {
                this.setSize(cw + 8, ch + (this.skin4.getImage31(Button.ButtonState.UP, 5).getHeight() + this.skin4.getImage33(Button.ButtonState.UP, 5).getHeight()) - 20);
            }
        } else if (type == PopupType.SEARCHBOX) {
            if (this.skin2 != null) {
                this.setSize(cw + 8, this.innerGap + ch + (this.skin2.getImage31(Button.ButtonState.UP).getHeight() + this.skin2.getImage33(Button.ButtonState.UP).getHeight()) - 20);
            } else if (this.skin4 != null) {
                this.setSize(cw + 8, this.innerGap + ch + (this.skin4.getImage31(Button.ButtonState.UP, 5).getHeight() + this.skin4.getImage33(Button.ButtonState.UP, 5).getHeight()) - 20);
            }
        } else if (type == PopupType.SMARTACCES) {
            this.setSize(cw + 8, ch + (this.skin3.getImage31(Button.ButtonState.UP).getHeight() + this.skin3.getImage33(Button.ButtonState.UP).getHeight()) - 12);
        } else if (is9Field) {
            this.setSize(cw + (this.skin3.getImage11(Button.ButtonState.UP).getWidth() + this.skin3.getImage31(Button.ButtonState.UP).getWidth()), ch + (this.skin3.getImage31(Button.ButtonState.UP).getHeight() + this.skin3.getImage33(Button.ButtonState.UP).getHeight()));
        } else {
            this.setSize(cw + (this.skin.getImage11().getWidth() + this.skin.getImage31().getWidth()), ch + (this.skin.getImage31().getHeight() + this.skin.getImage33().getHeight()));
        }
        this.minWidth = cw;
        this.minHeight = ch;
        this.currentState = this.ensureOrientation(nx, ny, this.getWidth(), this.getHeight(), c, invoker, type);
        if (this.currentState == -1) {
            return;
        }
        this.setPreferredSize(this.getSize());
        if (type == PopupType.COMBO) {
            switch (this.currentState) {
                case 1: {
                    this.uSouthBorder = this.comboBorderSouth;
                    this.uSouthBorder += 2;
                    this.setLocation(nx, ny - this.getHeight());
                    break;
                }
                case 5: {
                    this.setLocation(nx, ny + invoker.getHeight());
                }
            }
        } else if (type == PopupType.INPUTCOMBO) {
            switch (this.currentState) {
                case 1: {
                    this.setLocation(nx + 1, ny - (this.getHeight() + invoker.getHeight()));
                    break;
                }
                case 5: {
                    this.setLocation(nx + 1, ny);
                }
            }
        } else if (type == PopupType.SEARCHBOX) {
            switch (this.currentState) {
                case 1: {
                    this.uNorthBorder = this.comboBorderNorth;
                    this.setLocation(nx, ny - (this.getHeight() + 2));
                    break;
                }
                case 5: {
                    this.setLocation(nx, ny + invoker.getHeight() - 2);
                }
            }
        } else if (type == PopupType.SMARTACCES) {
            switch (this.currentState) {
                case 1: {
                    ny = ny - this.getHeight() < 5 ? 5 : (ny -= this.getHeight() + 2);
                    this.setLocation(nx + invoker.getWidth() - this.getWidth() + 11, ny);
                    break;
                }
                case 5: {
                    this.setLocation(nx + invoker.getWidth() - this.getWidth() + 11, ny);
                }
            }
        } else if (translate) {
            switch (this.currentState) {
                case 1: {
                    this.setLocation(nx - this.getWidth() / 2 + this.arrowOffset, ny - this.getHeight());
                    break;
                }
                case 5: {
                    this.setLocation(nx - this.getWidth() / 2 + this.arrowOffset, ny);
                    break;
                }
                case 3: {
                    this.setLocation(nx, ny - this.getHeight() / 2 - this.arrowOffset);
                    break;
                }
                case 7: {
                    this.setLocation(nx - this.getWidth(), ny - this.getHeight() / 2 - this.arrowOffset);
                }
            }
        } else {
            int dw;
            int dh = this.getHeight() - h;
            if (dh != 0 && dh > 1) {
                ny -= dh / 2;
            }
            if ((dw = this.getWidth() - w) != 0 && dw > 1) {
                nx -= dw / 2;
            }
            this.setLocation(nx, ny);
        }
        this.registerKeyEvents();
        this.listener = listener;
        if (c != null) {
            c.add((Component)this, 0);
            this.setVisible(true);
            this.getFader().fadeIn();
        }
        this.createFocusCycle();
        this.validate();
    }

    public void showPopUp(int x, int y, int w, int h, InnerPopUpListener2 listener, Component invoker) {
        this.showPopUp(x, y, w, h, listener, invoker, PopupType.NORMAL);
    }

    public void showPopUp(int x, int y, int w, int h, InnerPopUpListener2 listener, Component invoker, PopupType type) {
        this.showPopUp(x, y, w, h, listener, invoker, type, true);
    }

    public void rebuildFocusCycle() {
        List<Component> b;
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.view != null && (b = this.view.getFocusComponents()) != null) {
            for (Component c : b) {
                if (!c.isEnabled()) continue;
                a.add(c);
            }
        }
        if (this.runInBackground != null && this.runInBackground.isEnabled()) {
            a.addAll(this.runInBackground.getFocusComponents());
        }
        if (this.useButtons) {
            if (this.okButton.isEnabled()) {
                a.addAll(this.okButton.getFocusComponents());
            }
            if (this.cancelButton.isEnabled()) {
                a.addAll(this.cancelButton.getFocusComponents());
            }
            if (this.previewButton != null && this.previewButton.isEnabled()) {
                a.addAll(this.previewButton.getFocusComponents());
            }
        }
        this.setFocusCycleRoot(true);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    public void createFocusCycle() {
        if (this.currentType != PopupType.SEARCHBOX) {
            this.rebuildFocusCycle();
            boolean b = true;
            if (!b) {
                if (this.runInBackground != null && this.runInBackground.isEnabled()) {
                    this.runInBackground.requestFocusInWindowNow();
                } else if (this.okButton != null && this.okButton.isEnabled()) {
                    this.okButton.requestFocusInWindowNow();
                } else if (this.cancelButton != null && this.cancelButton.isEnabled()) {
                    this.cancelButton.requestFocusInWindowNow();
                }
            } else if (this.view != null) {
                if (this.view.getFocusComponents() != null && this.view.getFocusComponents().size() > 0) {
                    this.requestFocusInLayout = true;
                } else if (this.okButton != null && this.okButton.isEnabled()) {
                    this.okButton.requestFocusInWindowNow();
                } else if (this.cancelButton != null && this.cancelButton.isEnabled()) {
                    this.cancelButton.requestFocusInWindowNow();
                }
            }
        }
    }

    private int ensureOrientation(int x, int y, int w, int h, Container parent, Component invoker, PopupType type) {
        this.arrowOffset = 0;
        if (invoker == null) {
            this.hidePopUp(new Object[0]);
            return -1;
        }
        if (type == PopupType.COMBO || type == PopupType.INPUTCOMBO || type == PopupType.SEARCHBOX || type == PopupType.SMARTACCES) {
            if (y + h + invoker.getHeight() < parent.getHeight()) {
                return 5;
            }
            if (y - h > 0) {
                return 1;
            }
        } else {
            if (x - w > 0 && y + h / 2 < parent.getHeight() && y - h / 2 > 0) {
                return 7;
            }
            if (x + w < parent.getWidth() && y + h / 2 < parent.getHeight() && y - h / 2 > 0) {
                return 3;
            }
            if (y - h > 0 && x - w / 2 > 0 && x + w / 2 < parent.getWidth() && y < parent.getHeight()) {
                return 1;
            }
            if (y + h < parent.getHeight() && x - w / 2 > 0 && x + w / 2 < parent.getWidth()) {
                return 5;
            }
            if (x - w > 0) {
                this.arrowOffset = y + h / 2 - parent.getHeight();
                if (this.arrowOffset > h / 2) {
                    this.arrowOffset = h / 2;
                } else if (this.arrowOffset > h / 2 * -1) {
                    this.arrowOffset = h / 2 * -1;
                    this.arrowOffset += 40;
                }
                return 7;
            }
            if (x + w < parent.getWidth()) {
                if (y + h / 2 > parent.getHeight()) {
                    this.arrowOffset = y + h / 2 - parent.getHeight();
                } else if (y - h / 2 < 0) {
                    this.arrowOffset = -(y - h / 2);
                }
                return 3;
            }
            if (y - h > 0) {
                this.arrowOffset = x - this.getWidth() / 2;
                return 1;
            }
            if (y + h < parent.getHeight()) {
                this.arrowOffset = x - this.getWidth() / 2;
                return 5;
            }
        }
        return 1;
    }

    @Override
    public void lafAttributeChanged(String att) {
        Font defaultFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("popuptitle_font_type"));
        this.title.setFont(defaultFont);
        smartAccessBackgroundGradientColorStart = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("smartaccesspopup_background_gradient_color_start"));
        smartAccessBackgroundGradientColorEnd = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("smartaccesspopup_background_gradient_color_end"));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.backupPoint = new Point(e.getX(), e.getY());
        this.backupDimension = new Dimension(this.getWidth(), this.getHeight());
        if (this.getResizeAllowed() && e.getX() > this.getWidth() - 27 && e.getX() < this.getWidth() - 13 && e.getY() > this.getHeight() - 27 && e.getY() < this.getHeight() - 13) {
            this.isResizeDragging = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isResizeDragging = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.backupPoint == null) {
            return;
        }
        int dx = (int)(this.backupPoint.getX() - (double)e.getX());
        int dy = (int)(this.backupPoint.getY() - (double)e.getY());
        if (this.isResizeDragging) {
            int nw = (int)(this.backupDimension.getWidth() - (double)dx);
            int nh = (int)(this.backupDimension.getHeight() - (double)dy);
            if (nw < this.minWidth) {
                nw = this.minWidth;
            } else if (nw + this.getX() > this.getParent().getWidth()) {
                nw = this.getParent().getWidth() - this.getX();
            }
            if (nh < this.minHeight) {
                nh = this.minHeight;
            } else if (nh + this.getY() > this.getParent().getHeight()) {
                nh = this.getParent().getHeight() - this.getY();
            }
            this.setSize(nw, nh);
            this.validate();
        } else {
            int nx = this.getX() - dx;
            int ny = this.getY() - dy;
            if (nx < 0) {
                nx = 0;
            } else if (nx + this.getWidth() > this.getParent().getWidth()) {
                nx = this.getParent().getWidth() - this.getWidth();
            }
            if (ny < 0) {
                ny = 0;
            } else if (ny + this.getHeight() > this.getParent().getHeight()) {
                ny = this.getParent().getHeight() - this.getHeight();
            }
            this.setLocation(nx, ny);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void fadeOut(boolean destroy) {
        if (this.invoker != null && this.invoker instanceof PopupContainer) {
            ((PopupContainer)((Object)this.invoker)).hideShadow();
        }
        if (this.view != null) {
            this.view.kill();
            this.view = null;
        }
        if (this.getFader() != null) {
            this.getFader().fadeOut(false);
            this.getFader().addAnimationListener(this);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        Container p = this.getParent();
        super.kill();
        if (this.view != null) {
            this.view.kill();
            this.view = null;
        }
        this.disablePreviewButton();
        this.disableBackgroundButton();
        if (p != null) {
            p.repaint(32L);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.isPreview = false;
        if (source == this.okButton) {
            if (this.isNullAtOKAnyWay) {
                this.hidePopUp(new Object[0]);
            } else if (this.view != null) {
                this.view.enterPressed(PopupAction.OK_FOREGROUND);
            } else {
                this.hidePopUp(new Object[0]);
            }
        } else if (source == this.cancelButton) {
            this.hidePopUp(new Object[0]);
        } else if (source == this.previewButton) {
            this.isPreview = true;
            if (this.view != null) {
                this.view.enterPressed(PopupAction.PREVIEW);
            }
        } else if (source == this.runInBackground && this.batchList != null && this.view instanceof Batchable) {
            Batchable b = (Batchable)((Object)this.view);
            BatchJob bj = b.getBatchJob(b.getJob());
            this.batchList.addBatch(bj);
            this.hidePopUp(new Object[0]);
        }
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        if (!wasFadin) {
            this.isInstanceInUse = false;
            this.kill();
        } else {
            this.setProgress(1.0f);
        }
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.rebuildFocusCycle();
    }

    public Color getExtensionColor() {
        return this.extensionBackColor;
    }

    public boolean validateContent() {
        if (this.view != null) {
            return this.view.validateContent();
        }
        return true;
    }

    public void setDoRequestFocus(boolean b) {
        this.isSpecialRequest = b;
    }

    public int getButtonHeight() {
        return (int)(this.okButton.getPreferredSize().getHeight() + 10.0);
    }

    public int getTitleHeight() {
        return (int)(this.title.getPreferredSize().getHeight() + 5.0);
    }

    public void hideScheduled(int i, final String string) {
        if (this.scheduleTime != null) {
            return;
        }
        this.scheduleTime = new Timer(i, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerPopUp2.this.scheduleTime.stop();
                InnerPopUp2.this.scheduleTime = null;
                InnerPopUp2.this.hidePopUp(string);
            }
        });
        this.scheduleTime.setRepeats(false);
        this.scheduleTime.start();
    }

    public void enablePreviewButton(boolean b) {
        if (this.previewButton != null) {
            this.previewButton.setEnabled(b);
        }
    }

    public void enableBackgroundButton(boolean b) {
        if (this.runInBackground != null) {
            this.runInBackground.setEnabled(b);
        }
    }

    public void setOkNullAnyway() {
        this.isNullAtOKAnyWay = true;
    }

    public void setNotOkNullAnyway() {
        this.isNullAtOKAnyWay = false;
    }

    public void setPreviewButtonText(String text) {
        if (this.previewButton != null) {
            this.previewButton.setText(text);
        }
    }

    public boolean getResizeAllowed() {
        return this.isResizeAllowed;
    }

    public void setResizeAllowed(boolean isResizeAllowed) {
        this.isResizeAllowed = isResizeAllowed;
    }

    private class InnerPopUpLayout
    extends DefaultLayout {
        private InnerPopUpLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = 0;
            int yBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_yborder"));
            int xBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_xborder"));
            if (InnerPopUp2.this.isTitleAdded) {
                InnerPopUp2.this.title.setLocation((int)(((double)parent.getWidth() - InnerPopUp2.this.title.getPreferredSize().getWidth()) / 2.0), 7);
                InnerPopUp2.this.title.setSize(InnerPopUp2.this.title.getPreferredSize());
                currentY = InnerPopUp2.this.title.getY() + InnerPopUp2.this.title.getHeight();
            }
            if (InnerPopUp2.this.useButtons) {
                if (InnerPopUp2.this.okButton != null) {
                    InnerPopUp2.this.okButton.setLocation(InnerPopUp2.this.uWestBorder + xBorder, (int)((double)parent.getHeight() - ((double)(InnerPopUp2.this.uSouthBorder + yBorder) + InnerPopUp2.this.okButton.getPreferredSize().getHeight())));
                    InnerPopUp2.this.okButton.setSize(InnerPopUp2.this.okButton.getPreferredSize());
                }
                if (InnerPopUp2.this.cancelButton != null) {
                    int nx = InnerPopUp2.this.okButton.isVisible() ? InnerPopUp2.this.okButton.getX() + InnerPopUp2.this.okButton.getWidth() + xBorder : InnerPopUp2.this.uWestBorder + xBorder;
                    InnerPopUp2.this.cancelButton.setLocation(nx, InnerPopUp2.this.okButton.getY());
                    InnerPopUp2.this.cancelButton.setSize(InnerPopUp2.this.cancelButton.getPreferredSize());
                }
                int bx = parent.getWidth() - InnerPopUp2.this.borderEast;
                if (InnerPopUp2.this.previewButton != null) {
                    InnerPopUp2.this.previewButton.setLocation((int)((double)parent.getWidth() - ((double)(InnerPopUp2.this.borderEast + xBorder) + InnerPopUp2.this.previewButton.getPreferredSize().getWidth())), InnerPopUp2.this.cancelButton.getY());
                    InnerPopUp2.this.previewButton.setSize(InnerPopUp2.this.previewButton.getPreferredSize());
                    bx = InnerPopUp2.this.previewButton.getX();
                }
                if (InnerPopUp2.this.runInBackground != null) {
                    InnerPopUp2.this.runInBackground.setLocation((int)((double)bx - (InnerPopUp2.this.runInBackground.getPreferredSize().getWidth() + (double)xBorder)), InnerPopUp2.this.cancelButton.getY());
                    InnerPopUp2.this.runInBackground.setSize(InnerPopUp2.this.runInBackground.getPreferredSize());
                }
                InnerPopUp2.this.sep1.setLocation(InnerPopUp2.this.borderWest, (int)((double)InnerPopUp2.this.okButton.getY() - ((double)yBorder + InnerPopUp2.this.sep1.getPreferredSize().getHeight())));
                InnerPopUp2.this.sep1.setSize(parent.getWidth() - (InnerPopUp2.this.borderEast + InnerPopUp2.this.borderWest), (int)InnerPopUp2.this.sep1.getPreferredSize().getHeight());
                currentY = InnerPopUp2.this.sep1.getY() - yBorder - currentY;
            } else {
                currentY = parent.getHeight() - (InnerPopUp2.this.uSouthBorder + InnerPopUp2.this.uNorthBorder);
            }
            Component view = (Component)((Object)InnerPopUp2.this.view);
            if (view != null) {
                if (InnerPopUp2.this.currentType == PopupType.SEARCHBOX) {
                    if (InnerPopUp2.this.currentState == 1) {
                        view.setLocation(InnerPopUp2.this.uWestBorder, InnerPopUp2.this.uNorthBorder);
                        view.setSize(parent.getWidth() - (InnerPopUp2.this.uEastBorder + InnerPopUp2.this.uWestBorder), currentY - InnerPopUp2.this.innerGap);
                        view.setPreferredSize(view.getSize());
                    } else if (InnerPopUp2.this.currentState == 5) {
                        view.setLocation(InnerPopUp2.this.uWestBorder, InnerPopUp2.this.uNorthBorder + InnerPopUp2.this.innerGap);
                        view.setSize(parent.getWidth() - (InnerPopUp2.this.uEastBorder + InnerPopUp2.this.uWestBorder), currentY - InnerPopUp2.this.innerGap);
                        view.setPreferredSize(view.getSize());
                    }
                } else if (InnerPopUp2.this.currentType == PopupType.SMARTACCES) {
                    view.setLocation(InnerPopUp2.this.uWestBorder, InnerPopUp2.this.uNorthBorder);
                    view.setSize(parent.getWidth() - (InnerPopUp2.this.uEastBorder + InnerPopUp2.this.uWestBorder), currentY);
                } else if (InnerPopUp2.this.currentType == PopupType.FRAMELESS) {
                    view.setLocation(InnerPopUp2.this.uWestBorder, InnerPopUp2.this.uNorthBorder);
                    view.setSize(parent.getWidth() - (InnerPopUp2.this.uEastBorder + InnerPopUp2.this.uWestBorder), currentY);
                } else {
                    view.setLocation(InnerPopUp2.this.uWestBorder, InnerPopUp2.this.uNorthBorder);
                    view.setSize(parent.getWidth() - (InnerPopUp2.this.uEastBorder + InnerPopUp2.this.uWestBorder) + InnerPopUp2.this.isRightAlignment, currentY);
                }
                currentY = view.getY() + view.getHeight();
            }
            if (InnerPopUp2.this.requestFocusInLayout && view != null) {
                List<Component> a = InnerPopUp2.this.view.getFocusComponents();
                if (a != null && !a.isEmpty()) {
                    Component o = a.get(0);
                    boolean b = o.requestFocusInWindow();
                    if (b) {
                        InnerPopUp2.this.requestFocusInLayout = false;
                    }
                } else if (InnerPopUp2.this.okButton != null) {
                    InnerPopUp2.this.okButton.requestFocusInWindowNow();
                } else if (InnerPopUp2.this.cancelButton != null) {
                    InnerPopUp2.this.cancelButton.requestFocusInWindowNow();
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = 0;
            w = InnerPopUp2.this.useButtons ? (int)((double)(InnerPopUp2.this.uWestBorder + 5) + InnerPopUp2.this.okButton.getPreferredSize().getWidth() + 5.0 + InnerPopUp2.this.cancelButton.getPreferredSize().getWidth()) : 0;
            return new Dimension(w, 0);
        }
    }
}

