/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class AboutPopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private final JLabel errorIcon;
    private final MultiLineTextLabel title;
    private final MultiLineTextLabel server;
    private final MultiLineTextLabel location;
    private final MultiLineTextLabel user;
    private final MultiLineTextLabel icit;
    private final int border = 10;

    public AboutPopupInsert() {
        BufferedImage logo = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_256"));
        this.errorIcon = new JLabel(new ImageIcon(logo));
        this.title = new MultiLineTextLabel();
        this.server = new MultiLineTextLabel();
        this.location = new MultiLineTextLabel();
        this.user = new MultiLineTextLabel();
        this.icit = new MultiLineTextLabel();
        this.title.setText("<html><b>CATIT</b><br/>" + Words.CATERING_MANAGEMENT_SUITE + "</html>");
        this.user.setText("<html>" + Words.USER + ": " + ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getUserName() + "</html>");
        this.location.setText("<html>" + Words.LOCATION + ": " + ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue() + "</html>");
        String serverName = "-";
        String serverUrl = "-";
        try {
            EjbContextFactory.EjbContextConfig orbConfig = EjbContextFactory.getInstance().getOrbConfig();
            serverName = orbConfig.getName();
            serverUrl = orbConfig.getHost();
        }
        catch (IOException orbConfig) {
            // empty catch block
        }
        String protocol = EjbContextFactory.getInstance().getUseWebServices() ? "JAX-WS" : "EJB";
        String applicationServerAndProtocol = EjbContextFactory.getInstance().getApplicationServer() + " over " + protocol;
        this.server.setText("<html>Server: " + serverName + "@" + serverUrl + " [" + applicationServerAndProtocol + "]</html>");
        this.icit.setText("<html>ICIT AG<br/>Grindelstr. 11<br/>CH-8303 Bassersdorf<br/>www.catit.ch</html>");
        this.setLayout(new Layout());
        this.add(this.errorIcon);
        this.add(this.title);
        this.add(this.user);
        this.add(this.location);
        this.add(this.server);
        this.add(this.icit);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enableOKButton(true);
        ip.hideCancelButton();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)AboutPopupInsert.this.errorIcon.getPreferredSize().getHeight();
            return new Dimension(400, 10 + h + 10);
        }

        @Override
        public void layoutContainer(Container parent) {
            AboutPopupInsert.this.errorIcon.setLocation(10, 10);
            AboutPopupInsert.this.errorIcon.setSize(AboutPopupInsert.this.errorIcon.getPreferredSize());
            AboutPopupInsert.this.title.setLocation(AboutPopupInsert.this.errorIcon.getX() + AboutPopupInsert.this.errorIcon.getWidth() + 10 + 10, 50);
            AboutPopupInsert.this.title.setSize(parent.getWidth() - (AboutPopupInsert.this.title.getX() + 10), ((AboutPopupInsert)AboutPopupInsert.this).title.getPreferredSize().height);
            AboutPopupInsert.this.user.setLocation(AboutPopupInsert.this.errorIcon.getX() + AboutPopupInsert.this.errorIcon.getWidth() + 10 + 10, AboutPopupInsert.this.title.getY() + AboutPopupInsert.this.title.getHeight() + 10);
            AboutPopupInsert.this.user.setSize(parent.getWidth() - (AboutPopupInsert.this.user.getX() + 10), ((AboutPopupInsert)AboutPopupInsert.this).user.getPreferredSize().height);
            AboutPopupInsert.this.location.setLocation(AboutPopupInsert.this.errorIcon.getX() + AboutPopupInsert.this.errorIcon.getWidth() + 10 + 10, AboutPopupInsert.this.user.getY() + AboutPopupInsert.this.user.getHeight() + 10);
            AboutPopupInsert.this.location.setSize(parent.getWidth() - (AboutPopupInsert.this.location.getX() + 10), ((AboutPopupInsert)AboutPopupInsert.this).location.getPreferredSize().height);
            AboutPopupInsert.this.server.setLocation(AboutPopupInsert.this.errorIcon.getX() + AboutPopupInsert.this.errorIcon.getWidth() + 10 + 10, AboutPopupInsert.this.location.getY() + AboutPopupInsert.this.location.getHeight() + 10);
            AboutPopupInsert.this.server.setSize(parent.getWidth() - (AboutPopupInsert.this.server.getX() + 10), ((AboutPopupInsert)AboutPopupInsert.this).server.getPreferredSize().height);
            AboutPopupInsert.this.icit.setLocation(AboutPopupInsert.this.errorIcon.getX() + AboutPopupInsert.this.errorIcon.getWidth() + 10 + 10, AboutPopupInsert.this.server.getY() + AboutPopupInsert.this.server.getHeight() + 10);
            AboutPopupInsert.this.icit.setSize(parent.getWidth() - (AboutPopupInsert.this.icit.getX() + 10), ((AboutPopupInsert)AboutPopupInsert.this).icit.getPreferredSize().height);
        }
    }
}

