/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.Resource;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.print.PrinterLocalToolkit;
import ch.icit.pegasus.client.print.PrinterToolkitConfiguration;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;

public abstract class DefaultScrollablePrintPopupInsert
extends ScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    protected TitledItem<TextLabel> title;
    protected HorizontalSeparator sep1;
    protected TitledItem<ComboBox> printer;
    protected TitledItem<TextField> copies;
    private boolean isShowPrintDialog;
    protected RadioButtonBox box;
    protected TitledItem<CheckBox> showPrintDialog;
    protected TitledItem<RadioButton> asPDF;
    protected TitledItem<RadioButton> asRTF;
    protected HorizontalSeparator sep2;
    protected Node configNode;
    private final boolean isRTFSupported;
    private final boolean isChoosePrinter;

    public abstract String getTitleString();

    public abstract String getTitleValue();

    public abstract boolean withSecondSeparator();

    public DefaultScrollablePrintPopupInsert(boolean isChoosePrinter) {
        this(isChoosePrinter, true);
    }

    public DefaultScrollablePrintPopupInsert(boolean isChoosePrinter, boolean isRTF) {
        this.isChoosePrinter = isChoosePrinter;
        this.isRTFSupported = isRTF;
        APrintConfigurationComplete<?> conf = this.getPrintConfiguration();
        if (conf != null) {
            this.configNode = INodeCreator.getDefaultImpl().getNode4DTO(conf, false, false);
        }
    }

    public abstract APrintConfigurationComplete<?> getPrintConfiguration();

    protected boolean isShowPrintDialog() {
        if (this.isShowPrintDialog) {
            return this.showPrintDialog.getElement().isChecked();
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.stopPrinting();
        super.remoteObjectLoaded(node);
        this.tryToClose();
    }

    @Override
    public final boolean tryToGrabFocus() {
        if (this.printer != null && this.printer.isEnabled()) {
            this.printer.getElement().requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public void removeInheritedComponents() {
        if (this.title != null) {
            this.title.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.isChoosePrinter) {
            this.printer.setVisible(false);
            this.copies.setVisible(false);
            if (this.isShowPrintDialog) {
                this.showPrintDialog.setVisible(false);
            }
            if (this.sep2 != null) {
                this.sep2.setVisible(false);
            }
        }
        if (this.asPDF != null && this.asRTF != null) {
            this.box.setVisible(false);
            this.asPDF.setVisible(false);
            this.asRTF.setVisible(false);
        }
    }

    public void showInheritedComponents() {
        if (this.title != null) {
            this.title.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.isChoosePrinter) {
            this.printer.setVisible(true);
            this.copies.setVisible(true);
            if (this.isShowPrintDialog) {
                this.showPrintDialog.setVisible(true);
            }
            if (this.sep2 != null) {
                this.sep2.setVisible(true);
            }
        }
        if (this.asPDF != null && this.asRTF != null) {
            this.box.setVisible(true);
            this.asPDF.setVisible(true);
            this.asRTF.setVisible(true);
        }
    }

    private void fillPrinters() {
        List l = PrinterToolkit.getAvailablePrinters();
        for (PrintService t : l) {
            this.printer.getElement().addItem(PrinterToolkit.convertPrintServiceToString((PrintService)t));
        }
        PrintService s = PrinterLocalToolkit.getStandardPrinter((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        if (s != null) {
            this.printer.getElement().setSelectedItem(PrinterToolkit.convertPrintServiceToString((PrintService)s));
        }
    }

    protected PrintService getSelectedPrinter() {
        if (this.printer != null && this.printer.getElement() != null && this.printer.getElement().getSelectedItem() != null) {
            String pn = (String)this.printer.getElement().getSelectedItem();
            PrintService t = PrinterToolkit.converterStringToPrintService((String)pn);
            return t;
        }
        return null;
    }

    public void createComponents() {
        if (this.title == null) {
            this.title = new TitledItem<TextLabel>(new TextLabel(this.getTitleValue()), this.getTitleString(), TitledItem.TitledItemOrientation.NORTH);
            this.sep1 = new HorizontalSeparator();
            if (this.isChoosePrinter) {
                this.printer = new TitledItem<ComboBox>(new ComboBox(), Words.PRINTER, TitledItem.TitledItemOrientation.NORTH);
                this.copies = new TitledItem<TextField>(new TextField(), Words.COPIES, TitledItem.TitledItemOrientation.NORTH);
                this.copies.getElement().setText("1");
                if (this.isShowPrintDialog) {
                    this.showPrintDialog = new TitledItem<CheckBox>(new CheckBox(this.configNode != null ? this.configNode.getChildNamed(DtoFieldConstants.withPrintDialog) : null), "Show Print Dialog", TitledItem.TitledItemOrientation.EAST);
                }
                if (this.withSecondSeparator()) {
                    this.sep2 = new HorizontalSeparator();
                }
                this.fillPrinters();
            }
            if (this.isRTFSupported) {
                this.box = new RadioButtonBox();
                this.box.setOrientation(0);
                this.asPDF = new TitledItem<RadioButton>(new RadioButton(), "as PDF", TitledItem.TitledItemOrientation.EAST);
                this.asPDF.getElement().setChecked(true);
                this.asRTF = new TitledItem<RadioButton>(new RadioButton(), "as RTF (Preview only)", TitledItem.TitledItemOrientation.EAST);
                this.box.addBox(this.asPDF, this.asPDF.getElement());
                this.box.addBox(this.asRTF, this.asRTF.getElement());
                this.getViewContainer().add(this.box);
            }
            this.getViewContainer().add(this.title);
            this.getViewContainer().add(this.sep1);
            if (this.isChoosePrinter) {
                this.getViewContainer().add(this.printer);
                this.getViewContainer().add(this.copies);
                if (this.isShowPrintDialog) {
                    this.getViewContainer().add(this.showPrintDialog);
                }
                if (this.sep2 != null) {
                    this.getViewContainer().add(this.sep2);
                }
            }
        } else {
            this.title.setVisible(true);
            this.sep1.setVisible(true);
            if (this.isChoosePrinter) {
                this.printer.setVisible(true);
                this.copies.setVisible(true);
                if (this.withSecondSeparator()) {
                    this.sep2.setVisible(true);
                }
                if (this.isShowPrintDialog) {
                    this.showPrintDialog.setVisible(true);
                }
            }
            if (this.isRTFSupported) {
                this.box.setVisible(true);
                this.asPDF.setVisible(true);
                this.asRTF.setVisible(true);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.printer != null && this.printer.getElement().getItemCount() > 0) {
            if (this.isChoosePrinter) {
                a.addAll(this.printer.getFocusComponents());
                if (this.copies.isEnabled()) {
                    a.addAll(this.copies.getFocusComponents());
                }
                if (this.isShowPrintDialog) {
                    a.addAll(this.showPrintDialog.getFocusComponents());
                }
            }
            if (this.isRTFSupported) {
                a.addAll(this.asPDF.getFocusComponents());
                a.addAll(this.asRTF.getFocusComponents());
            }
        }
        return a;
    }

    @Override
    protected int layoutInheritedComponents(Component parent) {
        super.layoutInheritedComponents(parent);
        if (this.title != null) {
            this.title.setLocation(this.border, 0);
            this.title.setSize(parent.getWidth() - 2 * this.border, (int)this.title.getPreferredSize().getHeight());
            this.sep1.setLocation(this.border, this.title.getY() + this.title.getHeight() + this.border);
            this.sep1.setSize(parent.getWidth() - 2 * this.border, 1);
            if (this.isChoosePrinter) {
                this.printer.setLocation(this.border, this.sep1.getY() + this.sep1.getHeight() + this.border);
                this.printer.setSize((parent.getWidth() - 3 * this.border) / 3 * 2, (int)this.printer.getPreferredSize().getHeight());
                this.copies.setLocation(this.printer.getX() + this.printer.getWidth() + this.border, this.printer.getY());
                this.copies.setSize((parent.getWidth() - 3 * this.border) / 3, (int)this.copies.getPreferredSize().getHeight());
                int cy = this.copies.getY() + this.copies.getHeight() + this.border;
                if (this.isShowPrintDialog) {
                    this.showPrintDialog.setLocation(this.border, this.copies.getY() + this.copies.getHeight() + this.border);
                    this.showPrintDialog.setSize(parent.getWidth() - 2 * this.border, (int)this.showPrintDialog.getPreferredSize().getHeight());
                    cy = this.showPrintDialog.getY() + this.showPrintDialog.getHeight() + this.border;
                }
                if (this.isRTFSupported) {
                    this.box.setLocation(this.border, cy);
                    this.box.setSize(parent.getWidth() - 2 * this.border, (int)this.box.getPreferredSize().getHeight());
                    cy = this.box.getY() + this.box.getHeight() + this.border;
                }
                if (this.sep2 != null) {
                    this.sep2.setLocation(this.border, cy);
                    this.sep2.setSize(parent.getWidth() - 2 * this.border, 1);
                    cy = this.sep2.getY() + this.sep2.getHeight();
                }
                return cy;
            }
            return this.sep1.getY() + this.sep1.getHeight();
        }
        return 0;
    }

    protected int getInheritedComponentsHeight() {
        int h = 0;
        if (this.title != null) {
            h = (int)this.title.getPreferredSize().getHeight();
            h += this.border;
            h = (int)((double)h + this.sep1.getPreferredSize().getHeight());
            if (this.isChoosePrinter) {
                h += this.border;
                h = (int)((double)h + this.printer.getPreferredSize().getHeight());
                h += this.border;
                if (this.isShowPrintDialog) {
                    h = (int)((double)h + this.showPrintDialog.getPreferredSize().getHeight());
                }
                if (this.isRTFSupported) {
                    h = (int)((double)h + (this.box.getPreferredSize().getHeight() + (double)this.border));
                }
                if (this.sep2 != null) {
                    h += this.border;
                    h = (int)((double)h + this.sep2.getPreferredSize().getHeight());
                }
            }
        }
        return h;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.title != null) {
            this.title.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.printer != null) {
            this.printer.kill();
        }
        if (this.copies != null) {
            this.copies.kill();
        }
        if (this.sep2 != null) {
            this.sep2.kill();
        }
        if (this.showPrintDialog != null) {
            this.showPrintDialog.kill();
        }
        if (this.asPDF != null) {
            this.asPDF.kill();
        }
        if (this.asRTF != null) {
            this.asRTF.kill();
        }
        if (this.box != null) {
            this.box.kill();
        }
        this.title = null;
        this.sep1 = null;
        this.printer = null;
        this.copies = null;
        this.sep2 = null;
        this.showPrintDialog = null;
        this.asPDF = null;
        this.asRTF = null;
        this.box = null;
    }

    protected void stopPrinting() {
        if (this.isShowPrintDialog && this.showPrintDialog.getElement().isChecked()) {
            MainFrame.isTempRelease = false;
        }
    }

    protected void writeDefaultValues() {
        PrintService p;
        if (this.configNode != null && (p = this.getSelectedPrinter()) != null) {
            this.configNode.getChildNamed(DtoFieldConstants.printer).setValue((Object)this.getSelectedPrinter(), 0L);
            this.configNode.getChildNamed(DtoFieldConstants.reportPreview).setValue((Object)this.popup.isPreview(), 0L);
            this.configNode.getChildNamed(DtoFieldConstants.target).setValue((Object)this.getTarget(), 0L);
            String t = this.copies.getElement().getText();
            int v = 1;
            try {
                v = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                v = 1;
            }
            this.configNode.getChildNamed(DtoFieldConstants.copies).setValue((Object)v, 0L);
        }
        this.writeDefaultPrinter();
    }

    private void writeDefaultPrinter() {
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        PrinterToolkitConfiguration c = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser);
        if (c == null) {
            c = new PrinterToolkitConfiguration();
        }
        if (this.isChoosePrinter && this.printer != null && this.printer.getElement().getSelectedItem() != null) {
            c.updateProperty("printer", (String)this.printer.getElement().getSelectedItem());
            PrinterToolkitConfiguration.saveConfiguration((UserLight)currentUser, (PrinterToolkitConfiguration)c);
        }
    }

    private Resource.TargetFormat getTarget() {
        if (this.isRTFSupported && this.asRTF != null && this.asRTF.getElement().isChecked()) {
            return Resource.TargetFormat.RTF;
        }
        return Resource.TargetFormat.PDF;
    }

    protected void startPrinting2() {
        this.printed = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.writeDefaultValues();
        if (this.configNode != null) {
            this.configNode.commit();
        }
        this.removeInheritedComponents();
        this.ensureAnimation();
    }

    @Override
    protected void startPrinting() {
        if (this.isShowPrintDialog && this.showPrintDialog.getElement().isChecked()) {
            MainFrame.isTempRelease = true;
        }
        this.startPrinting2();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.printer != null && this.printer.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.printer.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }
}

