/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DownloadPopupInsert
extends LoadablePopupInsert
implements FileTransferListener {
    private static final long serialVersionUID = 1L;
    private Node<PegasusFileComplete> file2Load;
    private File loadedFile;
    private boolean save;

    public DownloadPopupInsert(Node<PegasusFileComplete> file, boolean save) {
        this.file2Load = file;
        this.save = save;
    }

    public void startLoad() {
        this.showAnimation(Words.DOWNLOAD_FILE);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                File f = FileTransferUtil.download((PegasusFileComplete)((PegasusFileComplete)DownloadPopupInsert.this.file2Load.getValue()), (FileTransferListener[])new FileTransferListener[]{DownloadPopupInsert.this});
                DownloadPopupInsert.this.loadedFile = f;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (DownloadPopupInsert.this.save) {
                            DownloadPopupInsert.this.showSaveDialog();
                        } else {
                            DownloadPopupInsert.this.showPreview();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        DownloadPopupInsert.this.exceptionOccurred((Exception)((Object)exception));
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showSaveDialog() {
        File fileName;
        if (MainFrame.isTempRelease) {
            return;
        }
        MainFrame.isTempRelease = true;
        String prefix = this.loadedFile != null ? FilenameUtils.getExtension((String)this.loadedFile.getName()) : null;
        File file = fileName = this.loadedFile != null ? FileChooserUtil.saveFile(prefix) : null;
        if (fileName != null) {
            File selectedFile = fileName;
            this.writeFile(selectedFile);
        } else {
            this.popup.hidePopUp(new Object[0]);
        }
        MainFrame.isTempRelease = false;
    }

    private void writeFile(File targetFile) {
        this.moveFile(this.loadedFile, targetFile);
    }

    private void moveFile(File source, File destination) {
        try {
            try {
                Files.move(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.closeMe();
            }
            catch (IOException ex) {
                this.exceptionOccurred(ex);
            }
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    private void closeMe() {
        this.popup.hidePopUp(new Object[0]);
    }

    private void showPreview() {
        try {
            PrintPopupToolkit.previewFile(this.loadedFile);
            this.popup.hidePopUp(new Object[0]);
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    public void statusChanged(File file, FileTransferState state) {
        String t = Words.DOWNLOAD_FILE;
        double percent = (double)(state.getTransferred() > 0L ? state.getTransferred() : 1L) / (double)(state.getSize() > 0L ? state.getSize() : 1L) * 100.0;
        int p = (int)percent;
        t = t + " " + p + "%";
        this.showAnimation(t);
    }

    public void exceptionOccurred(Exception exception) {
        InnerPopupFactory.showErrorDialog(exception, (Component)this);
        this.closeMe();
    }
}

