/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.PurchaseReceivingScreenTableBasedSubModule;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class OPRPCheckPopUpInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private BasicArticleLight article;
    private PurchaseOrderPositionComplete position;
    private PurchaseReceivingScreenTableBasedSubModule module;
    private final boolean fromReceiveModule;
    private ParameterObject parameterObject;
    private final boolean showStateButtons;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private Color backgroundColor;
    protected MultiLineTextLabel label;
    private TextLabel articleConfiguration;
    private HorizontalSeparator sep1;
    private LoadingAnimation loadingAnimation;
    private TitledItem<TextField> chargeNo;
    private TitledItem<TextLabel> noCharge;
    private TitledItem<TextLabel> noExpiryDate;
    private TitledItem<DateChooser> expiryDate;
    private TitledItem<ComboBox> truckType;
    private TitledItem<ComboBox> truckCondition;
    private TitledItem<CheckBox> externalCondition;
    private TitledItem<TextField> temperature;
    private TitledItem<ComboBox> articleCondition;
    private TitledItem<CheckBox> specificationOk;
    private TitledItem<CheckBoxRO> chilled;
    private TitledItem<CheckBoxRO> frozen;
    private TitledItem<CheckBoxRO> halalState;
    private TextButton stateOk;
    private TextButton stateNotOk;
    private boolean fillDefaults;

    public OPRPCheckPopUpInsert(String text, PurchaseReceivingScreenTableBasedSubModule module, ParameterObject parameterObject, boolean fromReceiveModule) {
        this(text, module, parameterObject, fromReceiveModule, true, true);
    }

    public OPRPCheckPopUpInsert(String text, PurchaseReceivingScreenTableBasedSubModule module, ParameterObject parameterObject, boolean fromReceiveModule, boolean showStateButtons, boolean showTemperatureCheck) {
        this.module = module;
        this.fromReceiveModule = fromReceiveModule;
        this.fillDefaults = true;
        this.showStateButtons = showStateButtons;
        this.initLayout();
        this.initMultiLabelThings(text, parameterObject);
    }

    public OPRPCheckPopUpInsert(BasicArticleLight article, PurchaseOrderPositionComplete position, String text, ParameterObject parameterObject, boolean fromReceiveModule) {
        this(article, position, text, parameterObject, fromReceiveModule, true);
    }

    public OPRPCheckPopUpInsert(BasicArticleLight article, PurchaseOrderPositionComplete position, String text, ParameterObject parameterObject, boolean fromReceiveModule, boolean showStateButtons) {
        this.article = article;
        this.position = position;
        this.fromReceiveModule = fromReceiveModule;
        this.fillDefaults = false;
        this.showStateButtons = showStateButtons;
        this.initLayout();
        this.initMultiLabelThings(text, parameterObject);
    }

    private void doSaveHACCPSpotCheck() {
        if (this.showStateButtons) {
            this.stateNotOk.fadeOut(true);
            this.stateOk.fadeOut(true);
        }
        if (this.articleConfiguration != null) {
            this.articleConfiguration.fadeOut(true);
        }
        if (this.sep1 != null) {
            this.sep1.fadeOut(true);
        }
        this.truckType.fadeOut(true);
        this.truckCondition.fadeOut(true);
        this.externalCondition.fadeOut(true);
        this.articleCondition.fadeOut(true);
        this.specificationOk.fadeOut(true);
        if (this.noCharge != null) {
            this.noCharge.fadeOut(true);
        }
        if (this.chargeNo != null) {
            this.chargeNo.fadeOut(true);
        }
        if (this.chilled != null) {
            this.chilled.fadeOut(true);
        }
        if (this.frozen != null) {
            this.frozen.fadeOut(true);
        }
        if (this.temperature != null) {
            this.temperature.fadeOut(true);
        }
        if (this.halalState != null) {
            this.halalState.fadeOut(true);
        }
        if (this.expiryDate != null) {
            this.expiryDate.fadeOut(true);
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.fadeOut(true);
        }
        if (this.fromReceiveModule) {
            this.popup.enableOKButton(true);
            this.label.setText("OPRP Check done");
            return;
        }
        this.ensureAnimation("Save OPRP Check");
        this.loadingAnimation.fadeIn();
        this.popup.enableOKButton(false);
        this.saveData();
    }

    protected void ensureAnimation(String current) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(current);
            this.viewPort.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        if (this.label != null) {
            this.label.fadeOut(false);
        }
    }

    private boolean checkChargeNumber() {
        String articleNumber;
        if (!Boolean.TRUE.equals(this.parameterObject.hasCharge.getValue())) {
            return true;
        }
        String value = (String)this.parameterObject.chargeNo.getValue();
        if (this.article.getName().equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        if (("" + this.article.getNumber()).equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        if (this.position != null && (articleNumber = this.position.getSupplierCondition().getArticleNumber()).equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        return true;
    }

    protected void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
        if (this.label != null) {
            this.label.fadeIn();
        }
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setLayout(new InnerLayout());
    }

    private void initMultiLabelThings(String text, ParameterObject parameterObject) {
        this.parameterObject = parameterObject;
        this.label = new MultiLineTextLabel();
        this.label.getFader().setPermanent(true);
        this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.backgroundColor);
        this.viewPort = new Port();
        this.viewPort.setLayout(new ViewPortLayout());
        if (!this.fillDefaults) {
            this.articleConfiguration = new TextLabel(Words.ARTICLE + " " + Words.CONFIGURATION);
            this.sep1 = new HorizontalSeparator();
            if (!Boolean.TRUE.equals(parameterObject.hasCharge.getValue())) {
                this.noCharge = new TitledItem<TextLabel>(new TextLabel(), "ChargeNo", TitledItem.TitledItemOrientation.WEST);
                this.noCharge.getElement().setNode((Node)parameterObject.noChargeText);
            } else {
                this.chargeNo = new TitledItem<TextField>(new TextField(), "ChargeNo", TitledItem.TitledItemOrientation.WEST);
                this.chargeNo.getElement().setNode((Node)parameterObject.chargeNo);
            }
            this.chilled = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Chilled", TitledItem.TitledItemOrientation.WEST);
            this.chilled.getElement().setNode(parameterObject.chilledState);
            this.frozen = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Frozen", TitledItem.TitledItemOrientation.WEST);
            this.frozen.getElement().setNode(parameterObject.frozenState);
            this.halalState = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Halal", TitledItem.TitledItemOrientation.WEST);
            this.halalState.getElement().setNode(parameterObject.halalState);
            if (Boolean.TRUE.equals(parameterObject.noExpiryDate.getValue())) {
                this.noExpiryDate = new TitledItem<TextLabel>(new TextLabel(), "Expiry Text", TitledItem.TitledItemOrientation.WEST);
                this.noExpiryDate.getElement().setNode((Node)parameterObject.expiryText);
            } else {
                this.expiryDate = new TitledItem<DateChooser>(new DateChooser(), "Expiry Date", TitledItem.TitledItemOrientation.WEST);
                this.expiryDate.getElement().setNode((Node)parameterObject.expiryDate);
            }
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("K");
        l.add("T");
        l.add("AC");
        l.add("OK");
        this.truckType = new TitledItem<ComboBox>(new ComboBox(parameterObject.truckType, INodeCreator.getDefaultImpl().createNodes(l, false), ConverterRegistry.getConverter(StringConverter.class), true), "Truck Type", TitledItem.TitledItemOrientation.WEST);
        this.truckType.getElement().setSelectedItem(parameterObject.truckType);
        l = new ArrayList();
        l.add("1");
        l.add("2");
        l.add("3");
        l.add("4");
        l.add("5");
        this.truckCondition = new TitledItem<ComboBox>(new ComboBox(parameterObject.truckCondition, INodeCreator.getDefaultImpl().createNodes(l, false), ConverterRegistry.getConverter(StringConverter.class), true), "Truck Condition", TitledItem.TitledItemOrientation.WEST);
        this.truckCondition.getElement().setSelectedItem(parameterObject.truckCondition);
        this.externalCondition = new TitledItem<CheckBox>(new CheckBox(), "External Package", TitledItem.TitledItemOrientation.WEST);
        this.externalCondition.getElement().setNode(parameterObject.externalPackage);
        l = new ArrayList();
        l.add("F");
        l.add("C");
        this.articleCondition = new TitledItem<ComboBox>(new ComboBox(parameterObject.articleCondition, INodeCreator.getDefaultImpl().createNodes(l, false), ConverterRegistry.getConverter(StringConverter.class), true), "Article Condition", TitledItem.TitledItemOrientation.WEST);
        this.articleCondition.getElement().setNode((Node)parameterObject.articleCondition);
        this.specificationOk = new TitledItem<CheckBox>(new CheckBox(), "Specification Ok", TitledItem.TitledItemOrientation.WEST);
        this.specificationOk.getElement().setNode(parameterObject.specificationOk);
        boolean frozenArticle = ArticleToolkit.isFrozenArticle(this.article);
        boolean chilledArticle = ArticleToolkit.isChilledArticle(this.article);
        if (frozenArticle || chilledArticle || this.fillDefaults) {
            this.temperature = new TitledItem<TextField>(new TextField(null, TextFieldType.DOUBLE), "Temperature [\u00b0C]", TitledItem.TitledItemOrientation.WEST);
            this.temperature.getElement().setNode((Node)parameterObject.temperature);
        }
        if (this.showStateButtons) {
            this.stateOk = new TextButton("Ok");
            this.stateNotOk = new TextButton("Not Ok");
            this.stateOk.addButtonListener((source, x, y) -> {
                parameterObject.okState.setValue((Object)true, 0L);
                parameterObject.spotCheckDone.setValue((Object)true, 0L);
                if (this.fillDefaults) {
                    for (Table2RowPanel row : this.module.getRows()) {
                        PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive rec = (PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive)row;
                        PurchaseOrderPositionComplete position = (PurchaseOrderPositionComplete)rec.getModel().getNode().getValue(PurchaseOrderPositionComplete.class);
                        boolean closedPosition = position.getState() == OrderStateE.CLOSED;
                        boolean notDelivered = Boolean.TRUE.equals(position.getNotDelivered());
                        if (closedPosition || notDelivered) continue;
                        ParameterObject logEntry = rec.getHACCPLogEntry2();
                        boolean expiryDateSet = false;
                        if (!Boolean.TRUE.equals(logEntry.noExpiryDate.getValue()) && logEntry.getDTO().getExpiryDate() != null) {
                            expiryDateSet = true;
                        }
                        if (!Boolean.TRUE.equals(logEntry.hasCharge.getValue()) && (Boolean.TRUE.equals(logEntry.noExpiryDate.getValue()) || expiryDateSet)) {
                            logEntry.spotCheckDone.setValue(parameterObject.spotCheckDone.getValue(), 0L);
                        }
                        logEntry.articleCondition.setValue(parameterObject.articleCondition.getValue(), 0L);
                        logEntry.externalPackage.setValue(parameterObject.externalPackage.getValue(), 0L);
                        logEntry.okState.setValue(parameterObject.okState.getValue(), 0L);
                        logEntry.specificationOk.setValue(parameterObject.specificationOk.getValue(), 0L);
                        logEntry.temperature.setValue(parameterObject.temperature.getValue(), 0L);
                        logEntry.truckCondition.setValue(parameterObject.truckCondition.getValue(), 0L);
                        logEntry.truckType.setValue(parameterObject.truckType.getValue(), 0L);
                        rec.refreshQualityButton();
                    }
                    this.doSaveHACCPSpotCheck();
                } else {
                    if (!this.checkChargeNumber()) {
                        InnerPopupFactory.showErrorDialog("Review Charge Number. Article Number, Name and Supplier Article Numbers are not allowed", (Component)this);
                        return;
                    }
                    if (!this.validateBeforeSaveData()) {
                        return;
                    }
                    this.doSaveHACCPSpotCheck();
                }
            });
            this.stateNotOk.addButtonListener((source, x, y) -> {
                if (!this.validateBeforeSaveData()) {
                    return;
                }
                if (!this.fillDefaults && !this.checkChargeNumber()) {
                    InnerPopupFactory.showErrorDialog("Review Charge Number. Article Number, Name and Supplier Article Numbers are not allowed", (Component)this);
                    return;
                }
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "OPRP deviation comment");
                Node node = new Node();
                popUp.setView(new EnterMessagePopupInsert(node));
                InnerPopUpListener2 listener2 = (source1, xargs) -> {
                    if (xargs != null) {
                        parameterObject.spotCheckDone.setValue((Object)true, 0L);
                        parameterObject.okState.setValue((Object)false, 0L);
                        parameterObject.comment.setValue(node.getValue(), 0L);
                        if (this.fillDefaults) {
                            for (Table2RowPanel row : this.module.getRows()) {
                                PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive rec = (PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive)row;
                                PurchaseOrderPositionComplete position = (PurchaseOrderPositionComplete)rec.getModel().getNode().getValue(PurchaseOrderPositionComplete.class);
                                boolean closedPosition = position.getState() == OrderStateE.CLOSED;
                                boolean notDelivered = Boolean.TRUE.equals(position.getNotDelivered());
                                if (closedPosition || notDelivered) continue;
                                ParameterObject logEntry = rec.getHACCPLogEntry2();
                                boolean expiryDateSet = false;
                                if (!Boolean.TRUE.equals(logEntry.noExpiryDate.getValue()) && logEntry.getDTO().getExpiryDate() != null) {
                                    expiryDateSet = true;
                                }
                                if (!Boolean.TRUE.equals(logEntry.hasCharge.getValue()) && (Boolean.TRUE.equals(logEntry.noExpiryDate.getValue()) || expiryDateSet)) {
                                    logEntry.spotCheckDone.setValue(parameterObject.spotCheckDone.getValue(), 0L);
                                }
                                logEntry.articleCondition.setValue(parameterObject.articleCondition.getValue(), 0L);
                                logEntry.externalPackage.setValue(parameterObject.externalPackage.getValue(), 0L);
                                logEntry.okState.setValue(parameterObject.okState.getValue(), 0L);
                                logEntry.specificationOk.setValue(parameterObject.specificationOk.getValue(), 0L);
                                logEntry.temperature.setValue(parameterObject.temperature.getValue(), 0L);
                                logEntry.truckCondition.setValue(parameterObject.truckCondition.getValue(), 0L);
                                logEntry.truckType.setValue(parameterObject.truckType.getValue(), 0L);
                                logEntry.comment.setValue(parameterObject.comment.getValue(), 0L);
                                rec.refreshQualityButton();
                            }
                            this.doSaveHACCPSpotCheck();
                        } else {
                            this.doSaveHACCPSpotCheck();
                        }
                    }
                };
                popUp.showPopUp(x, y, 400, 400, listener2, source, PopupType.NORMAL);
            });
        }
        int width = (int)(this.temperature != null ? this.temperature.getTitle().getPreferredSize().getWidth() : this.externalCondition.getTitle().getPreferredSize().getWidth());
        width += 10;
        if (this.chargeNo != null) {
            this.chargeNo.setColumnWidth(width);
        }
        if (this.noCharge != null) {
            this.noCharge.setColumnWidth(width);
        }
        this.truckType.setColumnWidth(width);
        this.truckCondition.setColumnWidth(width);
        this.externalCondition.setColumnWidth(width);
        this.specificationOk.setColumnWidth(width);
        this.articleCondition.setColumnWidth(width);
        if (this.temperature != null) {
            this.temperature.setColumnWidth(width);
        }
        if (this.halalState != null) {
            this.halalState.setColumnWidth(width);
        }
        if (this.expiryDate != null) {
            this.expiryDate.setColumnWidth(width);
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.setColumnWidth(width);
        }
        if (this.chilled != null) {
            this.chilled.setColumnWidth(width);
        }
        if (this.frozen != null) {
            this.frozen.setColumnWidth(width);
        }
        this.setText(text);
        this.viewPort.add(this.label);
        if (!this.fillDefaults) {
            this.viewPort.add(this.articleConfiguration);
            this.viewPort.add(this.sep1);
            if (this.chargeNo != null) {
                this.viewPort.add(this.chargeNo);
            }
            if (this.noCharge != null) {
                this.viewPort.add(this.noCharge);
            }
        }
        this.viewPort.add(this.truckType);
        this.viewPort.add(this.truckCondition);
        this.viewPort.add(this.externalCondition);
        this.viewPort.add(this.specificationOk);
        this.viewPort.add(this.articleCondition);
        if (this.temperature != null) {
            this.viewPort.add(this.temperature);
        }
        if (this.halalState != null) {
            this.viewPort.add(this.halalState);
        }
        if (this.expiryDate != null) {
            this.viewPort.add(this.expiryDate);
        }
        if (this.noExpiryDate != null) {
            this.viewPort.add(this.noExpiryDate);
        }
        if (this.chilled != null) {
            this.viewPort.add(this.chilled);
        }
        if (this.frozen != null) {
            this.viewPort.add(this.frozen);
        }
        if (this.showStateButtons) {
            this.viewPort.add(this.stateNotOk);
            this.viewPort.add(this.stateOk);
        }
        this.scrollPane.setViewportView(this.viewPort);
        this.add(this.scrollPane);
        this.invalidate();
        this.validate();
        this.setEnabled(true);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
        if (this.articleConfiguration != null) {
            this.articleConfiguration.kill();
            this.articleConfiguration = null;
        }
        if (this.sep1 != null) {
            this.sep1.kill();
            this.sep1 = null;
        }
        if (this.chargeNo != null) {
            this.chargeNo.kill();
            this.chargeNo = null;
        }
        if (this.noCharge != null) {
            this.noCharge.kill();
            this.noCharge = null;
        }
        if (this.truckType != null) {
            this.truckType.kill();
            this.truckType = null;
        }
        if (this.truckCondition != null) {
            this.truckCondition.kill();
            this.truckCondition = null;
        }
        if (this.externalCondition != null) {
            this.externalCondition.kill();
            this.externalCondition = null;
        }
        if (this.specificationOk != null) {
            this.specificationOk.kill();
            this.specificationOk = null;
        }
        if (this.articleCondition != null) {
            this.articleCondition.kill();
            this.articleCondition = null;
        }
        if (this.temperature != null) {
            this.temperature.kill();
            this.temperature = null;
        }
        if (this.halalState != null) {
            this.halalState.kill();
            this.halalState = null;
        }
        if (this.expiryDate != null) {
            this.expiryDate.kill();
            this.expiryDate = null;
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.kill();
            this.noExpiryDate = null;
        }
        if (this.chilled != null) {
            this.chilled.kill();
            this.chilled = null;
        }
        if (this.frozen != null) {
            this.frozen.kill();
            this.frozen = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.label != null) {
            this.label.setEnabled(enabled && this.showStateButtons);
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.setEnabled(enabled && this.showStateButtons);
        }
        if (this.articleConfiguration != null) {
            this.articleConfiguration.setEnabled(enabled && this.showStateButtons);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(enabled && this.showStateButtons);
        }
        if (this.chargeNo != null) {
            this.chargeNo.setEnabled(enabled && this.showStateButtons);
        }
        if (this.noCharge != null) {
            this.noCharge.setEnabled(enabled && this.showStateButtons);
        }
        if (this.truckType != null) {
            this.truckType.setEnabled(enabled && this.showStateButtons);
        }
        if (this.truckCondition != null) {
            this.truckCondition.setEnabled(enabled && this.showStateButtons);
        }
        if (this.externalCondition != null) {
            this.externalCondition.setEnabled(enabled && this.showStateButtons);
        }
        if (this.specificationOk != null) {
            this.specificationOk.setEnabled(enabled && this.showStateButtons);
        }
        if (this.articleCondition != null) {
            this.articleCondition.setEnabled(enabled && this.showStateButtons);
        }
        if (this.temperature != null) {
            boolean frozenArticle = ArticleToolkit.isFrozenArticle(this.article);
            boolean chilledArticle = ArticleToolkit.isChilledArticle(this.article);
            this.temperature.setEnabled(enabled && this.showStateButtons && (frozenArticle || chilledArticle || this.fillDefaults));
        }
        if (this.halalState != null) {
            this.halalState.setEnabled(enabled && this.showStateButtons);
        }
        if (this.expiryDate != null) {
            this.expiryDate.setEnabled(enabled && this.showStateButtons);
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.setEnabled(enabled && this.showStateButtons);
        }
        if (this.chilled != null) {
            this.chilled.setEnabled(enabled && this.showStateButtons);
        }
        if (this.frozen != null) {
            this.frozen.setEnabled(enabled && this.showStateButtons);
        }
    }

    public void setText(String t) {
        if (this.label != null) {
            this.label.setLabelText(t);
        }
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[1];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private boolean validateBeforeSaveData() {
        String tempText;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String string = tempText = this.temperature != null ? this.temperature.getElement().getText() : "";
        if (this.fillDefaults) {
            if (StringUtil.isBlank((String)tempText)) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is set"));
            } else {
                try {
                    Double.valueOf(tempText);
                }
                catch (Exception e) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is a number"));
                }
            }
        } else {
            String chargeText = "";
            chargeText = !Boolean.TRUE.equals(this.parameterObject.hasCharge.getValue()) ? this.noCharge.getElement().getText() : this.chargeNo.getElement().getText();
            boolean chilledArticle = ArticleToolkit.isChilledArticle(this.article);
            boolean frozenArticle = ArticleToolkit.isFrozenArticle(this.article);
            if (chilledArticle || frozenArticle) {
                if (Boolean.TRUE.equals(this.parameterObject.hasCharge.getValue()) && StringUtil.isBlank((String)chargeText)) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Charge is set"));
                }
                if (this.temperature != null) {
                    if (StringUtil.isBlank((String)tempText)) {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is set"));
                    } else {
                        try {
                            Double.valueOf(tempText);
                        }
                        catch (Exception e) {
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is a number"));
                        }
                    }
                }
            }
        }
        if (validationObjects.isEmpty()) {
            return true;
        }
        InnerPopupFactory.showErrorDialog(validationObjects, "Ensure OPRP Check is complete", (Component)this);
        return false;
    }

    private void saveData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                if (OPRPCheckPopUpInsert.this.fillDefaults) {
                    for (Table2RowPanel row : OPRPCheckPopUpInsert.this.module.getRows()) {
                        PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive rec = (PurchaseReceivingScreenTableBasedSubModule.TableRowPoReceive)row;
                        if (!rec.isRowQualityValidForSave()) continue;
                        ParameterObject paraObject = rec.getHACCPLogEntry2();
                        PurchaseOrderPositionHACCPLogComplete dto = paraObject.getDTO();
                        dto.setHaccpSystem(Boolean.valueOf(false));
                        ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).saveOPRPCheck(new ArticleChargeReference(((ArticleChargeLight)paraObject.charge.getValue()).getId()), dto);
                    }
                } else {
                    PurchaseOrderPositionHACCPLogComplete dto = OPRPCheckPopUpInsert.this.parameterObject.getDTO();
                    dto.setHaccpSystem(Boolean.valueOf(false));
                    ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).saveOPRPCheck(new ArticleChargeReference(((ArticleChargeLight)((OPRPCheckPopUpInsert)OPRPCheckPopUpInsert.this).parameterObject.charge.getValue()).getId()), dto);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        OPRPCheckPopUpInsert.this.hideAnimation();
                        OPRPCheckPopUpInsert.this.popup.enableOKButton(true);
                        OPRPCheckPopUpInsert.this.label.setText("OPRP Check saved");
                    }

                    public void errorOccurred(ClientException exception) {
                        OPRPCheckPopUpInsert.this.hideAnimation();
                        OPRPCheckPopUpInsert.this.popup.enableOKButton(true);
                        OPRPCheckPopUpInsert.this.label.setText("OPRP Check not saved");
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)OPRPCheckPopUpInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)OPRPCheckPopUpInsert.this.scrollPane.getWidth() - OPRPCheckPopUpInsert.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)OPRPCheckPopUpInsert.this.label.getPreferredSize().getHeight() + OPRPCheckPopUpInsert.this.border;
            if (!OPRPCheckPopUpInsert.this.fillDefaults) {
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.articleConfiguration.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.chilled.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.frozen.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.halalState.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.sep1.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
                h = OPRPCheckPopUpInsert.this.chargeNo != null ? (int)((double)h + (OPRPCheckPopUpInsert.this.chargeNo.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2))) : (int)((double)h + (OPRPCheckPopUpInsert.this.noCharge.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
                if (OPRPCheckPopUpInsert.this.expiryDate != null) {
                    h = (int)((double)h + (OPRPCheckPopUpInsert.this.expiryDate.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
                }
                if (OPRPCheckPopUpInsert.this.noExpiryDate != null) {
                    h = (int)((double)h + (OPRPCheckPopUpInsert.this.noExpiryDate.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
                }
            }
            h = (int)((double)h + (OPRPCheckPopUpInsert.this.truckType.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (OPRPCheckPopUpInsert.this.truckCondition.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (OPRPCheckPopUpInsert.this.externalCondition.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            if (OPRPCheckPopUpInsert.this.temperature != null) {
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.temperature.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            }
            h = (int)((double)h + (OPRPCheckPopUpInsert.this.articleCondition.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (OPRPCheckPopUpInsert.this.specificationOk.getPreferredSize().getHeight() + (double)(OPRPCheckPopUpInsert.this.border / 2)));
            if (OPRPCheckPopUpInsert.this.showStateButtons) {
                h = (int)((double)h + (OPRPCheckPopUpInsert.this.stateOk.getPreferredSize().getHeight() + (double)OPRPCheckPopUpInsert.this.border));
            }
            if (OPRPCheckPopUpInsert.this.loadingAnimation != null && (double)h < OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) {
                h = (int)OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight();
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            OPRPCheckPopUpInsert.this.label.setLocation(0, 0);
            OPRPCheckPopUpInsert.this.label.setSize(parent.getWidth(), (int)OPRPCheckPopUpInsert.this.label.getPreferredSize().getHeight());
            if (OPRPCheckPopUpInsert.this.loadingAnimation != null) {
                OPRPCheckPopUpInsert.this.loadingAnimation.setSize(OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
                OPRPCheckPopUpInsert.this.loadingAnimation.setLocation((parent.getWidth() - OPRPCheckPopUpInsert.this.loadingAnimation.getWidth()) / 2, (parent.getHeight() - OPRPCheckPopUpInsert.this.loadingAnimation.getHeight()) / 2);
            } else {
                int currentY = OPRPCheckPopUpInsert.this.label.getY() + OPRPCheckPopUpInsert.this.label.getHeight() + OPRPCheckPopUpInsert.this.border;
                if (!OPRPCheckPopUpInsert.this.fillDefaults) {
                    OPRPCheckPopUpInsert.this.articleConfiguration.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.label.getY() + OPRPCheckPopUpInsert.this.label.getHeight() + OPRPCheckPopUpInsert.this.border);
                    OPRPCheckPopUpInsert.this.articleConfiguration.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.articleConfiguration.getPreferredSize().getHeight());
                    OPRPCheckPopUpInsert.this.chilled.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.articleConfiguration.getY() + OPRPCheckPopUpInsert.this.articleConfiguration.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                    OPRPCheckPopUpInsert.this.chilled.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.chilled.getPreferredSize().getHeight());
                    OPRPCheckPopUpInsert.this.frozen.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.chilled.getY() + OPRPCheckPopUpInsert.this.chilled.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                    OPRPCheckPopUpInsert.this.frozen.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.frozen.getPreferredSize().getHeight());
                    OPRPCheckPopUpInsert.this.halalState.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.frozen.getY() + OPRPCheckPopUpInsert.this.frozen.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                    OPRPCheckPopUpInsert.this.halalState.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.halalState.getPreferredSize().getHeight());
                    OPRPCheckPopUpInsert.this.sep1.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.halalState.getY() + OPRPCheckPopUpInsert.this.halalState.getHeight() + OPRPCheckPopUpInsert.this.border);
                    OPRPCheckPopUpInsert.this.sep1.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.sep1.getPreferredSize().getHeight());
                    if (OPRPCheckPopUpInsert.this.chargeNo != null) {
                        OPRPCheckPopUpInsert.this.chargeNo.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.sep1.getY() + OPRPCheckPopUpInsert.this.sep1.getHeight() + OPRPCheckPopUpInsert.this.border);
                        OPRPCheckPopUpInsert.this.chargeNo.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.chargeNo.getPreferredSize().getHeight());
                        currentY = OPRPCheckPopUpInsert.this.chargeNo.getY() + OPRPCheckPopUpInsert.this.chargeNo.getHeight();
                    } else {
                        OPRPCheckPopUpInsert.this.noCharge.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.sep1.getY() + OPRPCheckPopUpInsert.this.sep1.getHeight() + OPRPCheckPopUpInsert.this.border);
                        OPRPCheckPopUpInsert.this.noCharge.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.noCharge.getPreferredSize().getHeight());
                        currentY = OPRPCheckPopUpInsert.this.noCharge.getY() + OPRPCheckPopUpInsert.this.noCharge.getHeight();
                    }
                    if (OPRPCheckPopUpInsert.this.expiryDate != null) {
                        OPRPCheckPopUpInsert.this.expiryDate.setLocation(OPRPCheckPopUpInsert.this.border, currentY + OPRPCheckPopUpInsert.this.border / 2);
                        OPRPCheckPopUpInsert.this.expiryDate.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.expiryDate.getPreferredSize().getHeight());
                        currentY = OPRPCheckPopUpInsert.this.expiryDate.getY() + OPRPCheckPopUpInsert.this.expiryDate.getHeight();
                    } else {
                        OPRPCheckPopUpInsert.this.noExpiryDate.setLocation(OPRPCheckPopUpInsert.this.border, currentY + OPRPCheckPopUpInsert.this.border / 2);
                        OPRPCheckPopUpInsert.this.noExpiryDate.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.noExpiryDate.getPreferredSize().getHeight());
                        currentY = OPRPCheckPopUpInsert.this.noExpiryDate.getY() + OPRPCheckPopUpInsert.this.noExpiryDate.getHeight();
                    }
                }
                OPRPCheckPopUpInsert.this.truckType.setLocation(OPRPCheckPopUpInsert.this.border, currentY + OPRPCheckPopUpInsert.this.border / 2);
                OPRPCheckPopUpInsert.this.truckType.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.truckType.getPreferredSize().getHeight());
                OPRPCheckPopUpInsert.this.truckCondition.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.truckType.getY() + OPRPCheckPopUpInsert.this.truckType.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                OPRPCheckPopUpInsert.this.truckCondition.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.truckCondition.getPreferredSize().getHeight());
                OPRPCheckPopUpInsert.this.externalCondition.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.truckCondition.getY() + OPRPCheckPopUpInsert.this.truckCondition.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                OPRPCheckPopUpInsert.this.externalCondition.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.externalCondition.getPreferredSize().getHeight());
                currentY = OPRPCheckPopUpInsert.this.externalCondition.getY() + OPRPCheckPopUpInsert.this.externalCondition.getHeight();
                if (OPRPCheckPopUpInsert.this.temperature != null) {
                    OPRPCheckPopUpInsert.this.temperature.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.externalCondition.getY() + OPRPCheckPopUpInsert.this.externalCondition.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                    OPRPCheckPopUpInsert.this.temperature.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.temperature.getPreferredSize().getHeight());
                    currentY = OPRPCheckPopUpInsert.this.temperature.getY() + OPRPCheckPopUpInsert.this.temperature.getHeight();
                }
                OPRPCheckPopUpInsert.this.articleCondition.setLocation(OPRPCheckPopUpInsert.this.border, currentY + OPRPCheckPopUpInsert.this.border / 2);
                OPRPCheckPopUpInsert.this.articleCondition.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.articleCondition.getPreferredSize().getHeight());
                OPRPCheckPopUpInsert.this.specificationOk.setLocation(OPRPCheckPopUpInsert.this.border, OPRPCheckPopUpInsert.this.articleCondition.getY() + OPRPCheckPopUpInsert.this.articleCondition.getHeight() + OPRPCheckPopUpInsert.this.border / 2);
                OPRPCheckPopUpInsert.this.specificationOk.setSize(parent.getWidth() - 2 * OPRPCheckPopUpInsert.this.border, (int)OPRPCheckPopUpInsert.this.specificationOk.getPreferredSize().getHeight());
                currentY = OPRPCheckPopUpInsert.this.specificationOk.getY() + OPRPCheckPopUpInsert.this.specificationOk.getHeight();
                if (OPRPCheckPopUpInsert.this.showStateButtons) {
                    if (OPRPCheckPopUpInsert.this.stateOk != null && OPRPCheckPopUpInsert.this.stateOk.getFader() != null && OPRPCheckPopUpInsert.this.stateOk.getFader().isFaded()) {
                        OPRPCheckPopUpInsert.this.stateOk.setLocation(5, currentY + OPRPCheckPopUpInsert.this.border);
                        OPRPCheckPopUpInsert.this.stateOk.setSize(OPRPCheckPopUpInsert.this.stateOk.getPreferredSize());
                    }
                    if (OPRPCheckPopUpInsert.this.stateNotOk != null && OPRPCheckPopUpInsert.this.stateNotOk.getFader() != null && OPRPCheckPopUpInsert.this.stateNotOk.getFader().isFaded()) {
                        OPRPCheckPopUpInsert.this.stateNotOk.setLocation((int)((double)parent.getWidth() - (5.0 + OPRPCheckPopUpInsert.this.stateNotOk.getPreferredSize().getWidth())), currentY + OPRPCheckPopUpInsert.this.border);
                        OPRPCheckPopUpInsert.this.stateNotOk.setSize(OPRPCheckPopUpInsert.this.stateNotOk.getPreferredSize());
                    }
                }
            }
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(OPRPCheckPopUpInsert.this.backgroundColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (OPRPCheckPopUpInsert.this.loadingAnimation != null) {
                OPRPCheckPopUpInsert.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                OPRPCheckPopUpInsert.this.loadingAnimation.setSize(OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
            }
            if (OPRPCheckPopUpInsert.this.scrollPane != null) {
                OPRPCheckPopUpInsert.this.scrollPane.setLocation(0, 0);
                OPRPCheckPopUpInsert.this.scrollPane.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension();
            if (OPRPCheckPopUpInsert.this.userPrefHeight != null) {
                d.setSize(d.getWidth(), (double)OPRPCheckPopUpInsert.this.userPrefHeight.intValue());
            } else if (OPRPCheckPopUpInsert.this.viewPort != null) {
                d.setSize(d.getWidth(), OPRPCheckPopUpInsert.this.viewPort.getPreferredSize().getHeight());
            } else {
                d.setSize(d.getWidth(), (double)(OPRPCheckPopUpInsert.this.loadingAnimation.getHeight() + 10));
            }
            if (OPRPCheckPopUpInsert.this.userPrefWidth != null) {
                d.setSize((double)OPRPCheckPopUpInsert.this.userPrefWidth.intValue(), d.getHeight());
            } else if (OPRPCheckPopUpInsert.this.viewPort != null) {
                d.setSize(OPRPCheckPopUpInsert.this.viewPort.getPreferredSize().getWidth(), d.getHeight());
            } else {
                d.setSize(OPRPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth() + 10.0, d.getHeight());
            }
            return d;
        }
    }

    public static class ParameterObject {
        public Node<Boolean> hasCharge = new Node();
        public Node<String> noChargeText = new Node();
        public Node<String> chargeNo = new Node();
        public Node<Boolean> noExpiryDate = new Node();
        public Node<String> expiryText = new Node();
        public Node<Date> expiryDate = new Node();
        public Node<String> truckType = new Node();
        public Node<String> truckCondition = new Node();
        public Node<Boolean> externalPackage = new Node();
        public Node<Double> temperature = new Node();
        public Node<String> articleCondition = new Node();
        private Node<Boolean> specificationOk = new Node();
        public Node<Boolean> chilledState = new Node();
        public Node<Boolean> frozenState = new Node();
        public Node<Boolean> halalState = new Node();
        public Node<Boolean> okState = new Node();
        public Node<String> comment = new Node();
        public Node<Boolean> spotCheckDone = new Node();
        public Node<ArticleChargeLight> charge = new Node();

        public ParameterObject(String chargeNo, String truckType, String truckCondition, Boolean chilledState, Boolean frozenState, String articleCond, Double temperature, Boolean halalState, Date expiryDate, Boolean okState, String comment, ArticleChargeLight charge, boolean noExpiryDate, String noExpiryText, boolean hasCharge, String noChargeText, Boolean externalPackageOk, Boolean specStateOk) {
            this.halalState.setValue((Object)halalState, 0L);
            this.chilledState.setValue((Object)chilledState, 0L);
            this.frozenState.setValue((Object)frozenState, 0L);
            this.truckType.setValue((Object)truckType, 0L);
            this.externalPackage.setValue((Object)externalPackageOk, 0L);
            this.specificationOk.setValue((Object)specStateOk, 0L);
            this.articleCondition.setValue((Object)articleCond, 0L);
            this.truckCondition.setValue((Object)truckCondition, 0L);
            this.chargeNo.setValue((Object)chargeNo, 0L);
            this.temperature.setValue((Object)temperature, 0L);
            this.expiryDate.setValue((Object)expiryDate, 0L);
            this.okState.setValue((Object)okState, 0L);
            this.comment.setValue((Object)comment, 0L);
            this.spotCheckDone.setValue((Object)false, 0L);
            this.noExpiryDate.setValue((Object)noExpiryDate, 0L);
            this.expiryText.setValue((Object)noExpiryText, 0L);
            this.hasCharge.setValue((Object)hasCharge, 0L);
            this.noChargeText.setValue((Object)noChargeText, 0L);
        }

        public ParameterObject(PurchaseOrderPositionHACCPLogComplete haccpLog, ArticleChargeLight charge) {
            Node logNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)haccpLog, false, false);
            this.chargeNo = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.chargeNo);
            this.truckType = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.truckType);
            this.truckCondition = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.truckCondition);
            this.chilledState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.chilledState);
            this.frozenState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.frozenState);
            this.temperature = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.temperature);
            this.halalState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.halalState);
            this.expiryDate = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.expiryDate);
            this.okState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.okState);
            this.comment = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.comment);
            this.charge = INodeCreator.getDefaultImpl().getNode4DTO((Object)charge, false, false);
            this.noExpiryDate = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.noExpiryDate);
            this.expiryText = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.expiryText);
            this.hasCharge = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.purchaseCharge);
            this.noChargeText = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.noPurchaseChargeText);
            this.externalPackage = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.externalPackageOk);
            this.specificationOk = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.specificationOk);
            this.articleCondition = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.articleCondition);
            this.truckCondition = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.truckCondition);
        }

        public PurchaseOrderPositionHACCPLogComplete getDTO() {
            PurchaseOrderPositionHACCPLogComplete log = new PurchaseOrderPositionHACCPLogComplete();
            log.setChargeNo((String)this.chargeNo.getValue());
            log.setComment((String)this.comment.getValue());
            log.setExpiryDate((Date)this.expiryDate.getValue());
            log.setHalalState((Boolean)this.halalState.getValue());
            log.setOkState((Boolean)this.okState.getValue());
            log.setTemperature((Double)this.temperature.getValue());
            log.setTruckType((String)this.truckType.getValue());
            log.setChilledState((Boolean)this.chilledState.getValue());
            log.setFrozenState((Boolean)this.frozenState.getValue());
            log.setNoExpiryDate((Boolean)this.noExpiryDate.getValue());
            log.setExpiryText((String)this.expiryText.getValue());
            log.setPurchaseCharge((Boolean)this.hasCharge.getValue());
            log.setNoPurchaseChargeText((String)this.noChargeText.getValue());
            log.setExternalPackageOk((Boolean)this.externalPackage.getValue());
            log.setSpecificationOk((Boolean)this.specificationOk.getValue());
            log.setArticleCondition((String)this.articleCondition.getValue());
            log.setTruckCondition((String)this.truckCondition.getValue());
            log.setCheckDate(new Date(System.currentTimeMillis()));
            log.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            return log;
        }
    }
}

