/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.JLabel;

public abstract class PrintPopupInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected LoadingAnimation animation;
    protected JLabel msg;
    protected boolean printed = false;
    protected Container viewPort;
    protected boolean isError;
    protected String errorMSG;
    protected boolean isAutoCloseDisabled = false;
    protected int border = 10;

    public PrintPopupInsert(boolean itSelf) {
        if (itSelf) {
            this.setViewContainer(this);
        }
    }

    public boolean getIsAutoCloseDisabled() {
        return this.isAutoCloseDisabled;
    }

    public void setIsAutoCloseDisabled(boolean isAutoCloseDisabled) {
        this.isAutoCloseDisabled = isAutoCloseDisabled;
    }

    protected void tryToClose() {
        if (this.printed && !this.isAutoCloseDisabled) {
            Node setN = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
            if (setN == null) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                PrintPopupInsert.this.processSystemSettings((SystemSettingsComplete)node.getValue());
                            }

                            public void errorOccurred(ClientException exception) {
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.processSystemSettings((SystemSettingsComplete)setN.getValue());
            }
        }
    }

    private void processSystemSettings(SystemSettingsComplete settings) {
        if (settings.getAutoClosePrintPopup().booleanValue() && !this.isError && this.popup != null) {
            this.popup.hideScheduled(1000, "Printing finished, Auto close");
        }
    }

    public abstract void removeInheritedComponents();

    public void setViewContainer(Container comp) {
        this.viewPort = comp;
    }

    public Container getViewContainer() {
        return this.viewPort;
    }

    protected String getProgressText() {
        return "Print";
    }

    protected String dogetFinishText() {
        if (this.isError) {
            return "<html>" + this.errorMSG + "</html>";
        }
        return this.getFinishedText();
    }

    protected String getFinishedText() {
        return "<html>" + Words.SUCCESSFUL + "</html>";
    }

    protected void ensureAnimation() {
        this.ensureAnimation(null);
    }

    protected void ensureAnimation(String t) {
        if (t == null) {
            t = this.getProgressText();
        }
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.setProgress(0.0f);
            this.animation.getFader().setPermanent(true);
            this.animation.stateChanged(t);
            this.getViewContainer().add((Component)this.animation, 0);
            this.animation.fadeIn();
            this.animation.start();
        } else {
            this.animation.stateChanged(t);
        }
        this.validate();
    }

    protected void showMessage(String t) {
        if (this.msg == null) {
            this.msg = new JLabel("<html>" + t + "</html>");
            this.msg.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.msg.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.msg);
        } else {
            this.msg.setText("<html>" + t + "</html>");
        }
        this.msg.setVisible(true);
        this.validate();
    }

    protected int layoutInheritedComponents(Component parent) {
        if (this.animation != null) {
            this.animation.setLocation((int)((double)parent.getWidth() - this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - this.animation.getPreferredSize().getHeight()) / 2.0));
            this.animation.setSize(this.animation.getPreferredSize());
        }
        if (this.msg != null) {
            int ax = 0;
            int aw = 0;
            if (this.msg.getPreferredSize().getWidth() > (double)parent.getWidth()) {
                ax = 5;
                aw = parent.getWidth() - 10;
            } else {
                ax = (int)((double)parent.getWidth() - this.msg.getPreferredSize().getWidth()) / 2;
                aw = (int)this.msg.getPreferredSize().getWidth();
            }
            int ay = 0;
            int ah = 0;
            if (this.msg.getPreferredSize().getHeight() > (double)parent.getHeight()) {
                ay = 5;
                ah = parent.getHeight() - 10;
            } else {
                ay = (int)(((double)parent.getHeight() - this.msg.getPreferredSize().getHeight()) / 2.0);
                ah = (int)this.msg.getPreferredSize().getHeight();
            }
            this.msg.setLocation(ax, ay);
            this.msg.setSize(aw, ah);
        }
        return 0;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.printed) {
            super.enterPressed(isOK);
        } else if (this.isError) {
            this.popup.hidePopUp(new Object[0]);
        } else {
            List<ScreenValidationObject> v = this.validateBeforePrint();
            if (v == null || v.isEmpty()) {
                if (isOK == PopupAction.OK_FOREGROUND || isOK == PopupAction.PREVIEW) {
                    this.startPrinting();
                }
            } else {
                InnerPopupFactory.showErrorDialog(v, "Review Print Config", "Print Configuration has some Errors", (Component)this);
            }
        }
    }

    protected void removeAnimation() {
        this.removeAnimation(true);
    }

    protected void removeAnimation(boolean withMSG) {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(false);
            this.animation = null;
        }
        if (withMSG) {
            this.setText(this.dogetFinishText());
            this.popup.setOkButtonText("Close");
        }
        this.validate();
        this.popup.enableOKButton(true);
        this.popup.enablePreviewButton(false);
        this.popup.enableBackgroundButton(false);
    }

    protected void setText(String t) {
        if (this.msg == null) {
            this.msg = new JLabel();
            this.msg.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.msg.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.msg);
        }
        this.msg.setText(t);
        this.msg.setVisible(true);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
        if (this.msg != null) {
            this.remove(this.msg);
            this.msg = null;
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.isError = true;
        this.errorMSG = exception.getCause() instanceof FileNotFoundException ? "Unable to write to File" : (exception.getCause() != null ? exception.getCause().getMessage() : (exception instanceof ClientCreateReportException && exception.getMessage() != null ? exception.getMessage() : (exception instanceof ClientServerCallException && exception.getMessage() != null ? exception.getMessage() : "Unable to create Sheet")));
        this.showMessage(this.errorMSG);
        this.removeAnimation(true);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation();
    }

    protected void startPrinting() {
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation();
        this.printed = true;
    }

    public List<ScreenValidationObject> validateBeforePrint() {
        return null;
    }
}

