/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.export;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.GenericReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericExportAnalysisReportConfigurationWithStyleSheet;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public abstract class AsynchronusAnalysisPopupInsert<T extends IDTO>
extends AnalysisPopupInsert<T> {
    private static final long serialVersionUID = 3974630439355418764L;

    public AsynchronusAnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externOpenTool) {
        super(externOpenTool);
    }

    public AsynchronusAnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable, ReportTypeE reportType) {
        super(externalOpenTool, isExportFormatChoosable, false, reportType);
    }

    public AsynchronusAnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable, boolean withNumber, ReportTypeE reportType, boolean exportTypeSelection) {
        super(externalOpenTool, isExportFormatChoosable, withNumber, reportType, exportTypeSelection);
    }

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Future result;
                AGenericReportConfiguration reportConfiguration;
                AsynchronusAnalysisPopupInsert.this.writeConfigurationValues();
                String callerID = AsynchronusAnalysisPopupInsert.this.generateCallerID();
                ASearchConfiguration searchConfiguration = AsynchronusAnalysisPopupInsert.this.getSearchConfiguration();
                if (searchConfiguration != null && !(searchConfiguration instanceof ADtoSearchConfiguration)) {
                    InnerPopupFactory.showErrorDialog(new Exception("Generic Reports are not supported for EntitySearchConfigurations"), (Component)AsynchronusAnalysisPopupInsert.this);
                }
                if ((reportConfiguration = AsynchronusAnalysisPopupInsert.this.getReportConfiguration()) instanceof GenericExportAnalysisReportConfigurationWithStyleSheet) {
                    ReportFileComplete reportFileComplete = AsynchronusAnalysisPopupInsert.this.getSelectedReport();
                    result = ((GenericReportServiceManager)ServiceManagerRegistry.getService(GenericReportServiceManager.class)).getReportWithReportFile((ADtoSearchConfiguration)AsynchronusAnalysisPopupInsert.this.getSearchConfiguration(), reportConfiguration, reportFileComplete, callerID);
                } else {
                    result = ((GenericReportServiceManager)ServiceManagerRegistry.getService(GenericReportServiceManager.class)).getReport((ADtoSearchConfiguration)AsynchronusAnalysisPopupInsert.this.getSearchConfiguration(), reportConfiguration, callerID);
                }
                while (!result.isDone()) {
                    Thread.sleep(2000L);
                    Tuple progressTuple = ((GenericReportServiceManager)ServiceManagerRegistry.getService(GenericReportServiceManager.class)).getProgressTuple(callerID);
                    if (progressTuple == null || (Long)progressTuple.getS() == 0L) continue;
                    AsynchronusAnalysisPopupInsert.this.ensureAnimation("Processing Data Set " + progressTuple.getS() + " of " + progressTuple.getT());
                }
                AsynchronusAnalysisPopupInsert.this.ensureAnimation("Downloading");
                PegasusFileComplete res = (PegasusFileComplete)result.get();
                if (res == null) {
                    AsynchronusAnalysisPopupInsert.this.nullReturned();
                    return null;
                }
                AsynchronusAnalysisPopupInsert.this.processPegasusFile(res);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AsynchronusAnalysisPopupInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void nullReturned() {
    }

    protected void processPegasusFile(PegasusFileComplete res) throws Exception {
        File f = FileTransferUtil.download((PegasusFileComplete)res, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

            public void statusChanged(File file, FileTransferState state) {
            }

            public void exceptionOccurred(Exception exception) {
                InnerPopupFactory.showErrorDialog(exception, (Component)AsynchronusAnalysisPopupInsert.this);
            }
        }});
        this.processReportFile(f);
    }

    protected void processReportFile(File f) throws IOException {
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            FileUtils.copyFile((File)f, (File)selectedFile);
        } else {
            selectedFile = f;
        }
        if (this.popup.isPreview()) {
            try {
                PrintPopupToolkit.previewFile(selectedFile);
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
    }

    protected abstract AGenericReportConfiguration getReportConfiguration();

    protected String generateCallerID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        String msg = "";
        msg = exception != null && exception.getCause() != null && exception.getCause().getCause() != null ? exception.getCause().getCause().getMessage() : (exception != null && exception.getCause() != null ? exception.getCause().getMessage() : (exception != null ? exception.getMessage() : ""));
        InnerPopupFactory.showErrorDialog(msg, (Component)this);
        this.popup.hidePopUp(new Object[0]);
    }
}

