/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.export;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.PrintPopupInsert;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public abstract class ExcelExportPopupInsert
extends PrintPopupInsert {
    private static final long serialVersionUID = 1L;
    protected TitledItem<TextLabel> title;
    protected HorizontalSeparator sep1;
    protected JLabel textLabel;
    private File selectedFile;
    protected int currentState = this.isFileBased() ? 5 : 3;
    protected static final int STATE_CONFIG = 3;
    protected static final int STATE_CHOOSE_FILE = 5;
    protected static final int STATE_DONE = 7;
    protected static final int STATE_OVERRIDE = 11;

    public abstract boolean withSecondSeparator();

    public ExcelExportPopupInsert(boolean itSelf) {
        this(itSelf, "");
    }

    public ExcelExportPopupInsert(boolean itSelf, String text) {
        super(itSelf);
        this.textLabel = new JLabel(text);
        this.textLabel.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        this.textLabel.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
        this.getViewContainer().add(this.textLabel);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.setOkButtonText(Words.SAVE);
    }

    public boolean isFileBased() {
        return true;
    }

    @Override
    public void removeInheritedComponents() {
        if (this.title != null) {
            this.title.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.textLabel != null) {
            this.textLabel.setVisible(false);
        }
    }

    protected void createComponents() {
        this.title = new TitledItem<TextLabel>(new TextLabel(this.getTitleValue()), this.getTitleString(), TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.getViewContainer().add(this.title);
        this.getViewContainer().add(this.sep1);
    }

    public abstract String getTitleString();

    public abstract String getTitleValue();

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        return a;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_BACKGROUND || isOK == PopupAction.OK_FOREGROUND) {
            switch (this.currentState) {
                case 5: {
                    if (MainFrame.isTempRelease) {
                        return;
                    }
                    MainFrame.isTempRelease = true;
                    this.processOkPressed(isOK);
                    MainFrame.isTempRelease = false;
                    break;
                }
                case 3: 
                case 7: {
                    if (this.msg != null) {
                        this.msg.setVisible(false);
                    }
                    super.enterPressed(isOK);
                }
            }
        } else {
            this.currentState = 7;
            if (this.msg != null) {
                this.msg.setVisible(false);
            }
            super.enterPressed(isOK);
        }
    }

    protected void processOkPressed(PopupAction isOK) {
        try {
            File filename = FileChooserUtil.saveFile(this.getFileEnding());
            if (filename != null) {
                this.setSelectedFile(filename);
                this.currentState = 3;
                if (this.getSelectedFile() != null && this.getSelectedFile().exists()) {
                    this.errorMSG = "File already exists. Do you want to override it?";
                    this.removeInheritedComponents();
                    this.showMessage(this.errorMSG);
                } else {
                    this.enterPressed(isOK);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.tryToClose();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    protected int layoutInheritedComponents(Component parent) {
        super.layoutInheritedComponents(parent);
        if (this.title != null) {
            this.title.setLocation(this.border, 0);
            this.title.setSize(parent.getWidth() - 2 * this.border, (int)this.title.getPreferredSize().getHeight());
            this.sep1.setLocation(0, this.title.getY() + this.title.getHeight() + this.border);
            this.sep1.setSize(parent.getWidth(), 1);
            return this.sep1.getY() + this.sep1.getHeight();
        }
        if (this.textLabel != null) {
            this.layoutTextMessage(parent);
        }
        return 0;
    }

    protected void layoutTextMessage(Component parent) {
        this.textLabel.setLocation((int)(((double)parent.getWidth() - this.textLabel.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - this.textLabel.getPreferredSize().getHeight()) / 2);
        this.textLabel.setSize(this.textLabel.getPreferredSize());
    }

    protected int getInheritedComponentsHeight() {
        int h = 0;
        if (this.title != null) {
            h = (int)this.title.getPreferredSize().getHeight();
            h += this.border;
            h = (int)((double)h + this.sep1.getPreferredSize().getHeight());
        }
        return h;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.title != null) {
            this.title.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.title = null;
        this.sep1 = null;
    }

    @Override
    protected void startPrinting() {
        this.printed = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation();
    }

    @Override
    protected String getFinishedText() {
        if (!this.isError) {
            return "Successfully exported";
        }
        return super.getFinishedText();
    }

    @Override
    protected String getProgressText() {
        return "Exporting, please wait";
    }

    public File getSelectedFile() {
        if (this.popup.isPreview() && this.selectedFile == null) {
            try {
                this.setSelectedFile(File.createTempFile("CATIT_Export", this.getFileEnding()));
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
        return this.selectedFile;
    }

    public String getFileEnding() {
        return ".xlsx";
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
    }
}

