/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.log;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.server.core.dtos.LoggedComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public abstract class LogPopupInsert<T extends LoggedComplete>
extends ScrollablePopupInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> created = new TitledItem<TextLabel>(new TextLabel(), Words.CREATED_BY, TitledItem.TitledItemOrientation.NORTH);
    private TitledItem<TextLabel> updated = new TitledItem<TextLabel>(new TextLabel(), Words.LAST_UPDATED_BY, TitledItem.TitledItemOrientation.NORTH);
    protected T bac;
    private TitledItem<TextLabel> deleted;
    private LoadingAnimation animation;

    public LogPopupInsert(Node<T> currentNode) {
        this(currentNode, currentNode.getValue() instanceof ADeletableDTO);
    }

    public LogPopupInsert(Node<T> currentNode, boolean showDeleted) {
        if (showDeleted) {
            this.deleted = new TitledItem<TextLabel>(new TextLabel(), "Deleted by", TitledItem.TitledItemOrientation.NORTH);
            this.getViewContainer().add(this.deleted);
        }
        this.getViewContainer().add(this.created);
        this.getViewContainer().add(this.updated);
        this.getViewContainer().setLayout(new Layout());
        this.showLoadingAnimation();
        this.reloadData(currentNode);
    }

    private void showLoadingAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.getViewContainer().add(this.animation);
            this.animation.stateChanged(Words.LOAD_DATA);
            this.animation.setVisible(true);
            this.animation.setProgress(1.0f);
        }
        this.animation.start();
        this.created.setVisible(false);
        this.updated.setVisible(false);
        if (this.deleted != null) {
            this.deleted.setVisible(false);
        }
        this.revalidate();
    }

    private void hideLoadingAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
        this.created.setVisible(true);
        this.updated.setVisible(true);
        if (this.deleted != null) {
            this.deleted.setVisible(true);
        }
    }

    public abstract void reloadData(Node<T> var1);

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.created.setEnabled(isEnabled);
        this.updated.setEnabled(isEnabled);
        if (this.deleted != null) {
            this.deleted.setEnabled(isEnabled);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.bac != null && this.bac.getLog() != null) {
            this.created.getElement().setText(((UserConverter)ConverterRegistry.getConverter(UserConverter.class)).convert((UserReference)this.bac.getLog().getCreateUser(), null, new Object[0]) + " at " + ((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)this.bac.getLog().getCreated(), null, new Object[0]));
            this.updated.getElement().setText(((UserConverter)ConverterRegistry.getConverter(UserConverter.class)).convert((UserReference)this.bac.getLog().getUpdateUser(), null, new Object[0]) + " at " + ((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)this.bac.getLog().getUpdated(), null, new Object[0]));
            if (this.deleted != null) {
                ADeletableDTO aDeletableDTO = (ADeletableDTO)this.bac;
                this.deleted.getElement().setText(((UserConverter)ConverterRegistry.getConverter(UserConverter.class)).convert(aDeletableDTO.getDeleteUser(), null, new Object[0]) + " at " + ((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)aDeletableDTO.getDeleteTime(), null, new Object[0]));
            }
        }
        if (this.popup != null) {
            this.popup.enableCancelButton(false);
        }
        this.hideLoadingAnimation();
        super.remoteObjectLoaded(node);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)(LogPopupInsert.this.created.getPreferredSize().getHeight() + LogPopupInsert.this.updated.getPreferredSize().getHeight() + 30.0));
        }

        @Override
        public void layoutContainer(Container parent) {
            if (LogPopupInsert.this.animation != null) {
                LogPopupInsert.this.animation.setLocation((int)(((double)parent.getWidth() - LogPopupInsert.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - LogPopupInsert.this.animation.getPreferredSize().getHeight()) / 2);
                LogPopupInsert.this.animation.setSize(LogPopupInsert.this.animation.getPreferredSize());
            }
            LogPopupInsert.this.created.setLocation(10, 10);
            LogPopupInsert.this.created.setSize(parent.getWidth() - 20, (int)LogPopupInsert.this.created.getPreferredSize().getHeight());
            LogPopupInsert.this.updated.setLocation(10, ((LogPopupInsert)LogPopupInsert.this).created.getLocation().y + ((LogPopupInsert)LogPopupInsert.this).created.getPreferredSize().height + 10);
            LogPopupInsert.this.updated.setSize(parent.getWidth() - 20, (int)LogPopupInsert.this.updated.getPreferredSize().getHeight());
            if (LogPopupInsert.this.deleted != null) {
                LogPopupInsert.this.deleted.setLocation(10, ((LogPopupInsert)LogPopupInsert.this).updated.getLocation().y + ((LogPopupInsert)LogPopupInsert.this).updated.getPreferredSize().height + 10);
                LogPopupInsert.this.deleted.setSize(parent.getWidth() - 20, (int)LogPopupInsert.this.deleted.getPreferredSize().getHeight());
            }
        }
    }
}

