/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MultiPrintPopupInsert
extends ScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    protected TitledItem<TextLabel> title;
    protected HorizontalSeparator sep1;
    protected TitledItem<ComboBox> printer;
    protected TitledItem<TextField> copies;
    private String titleString;
    private String valueString;

    public MultiPrintPopupInsert(String title, String value) {
        this.titleString = title;
        this.valueString = value;
    }

    @Override
    public void removeInheritedComponents() {
        this.title.setVisible(false);
        this.sep1.setVisible(false);
        this.printer.setVisible(false);
        this.copies.setVisible(false);
    }

    public void addInheritedComponents() {
        this.title.setVisible(true);
        this.sep1.setVisible(true);
        this.printer.setVisible(true);
        this.copies.setVisible(true);
    }

    protected void createComponents() {
        this.title = new TitledItem<TextLabel>(new TextLabel(this.valueString), this.titleString, TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.printer = new TitledItem<ComboBox>(new ComboBox(), Words.PRINTER, TitledItem.TitledItemOrientation.NORTH);
        this.copies = new TitledItem<TextField>(new TextField(), Words.COPIES, TitledItem.TitledItemOrientation.NORTH);
        this.printer.setEnabled(false);
        this.copies.setEnabled(false);
        this.getViewContainer().add(this.title);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.printer);
        this.getViewContainer().add(this.copies);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.printer != null && this.printer.getElement().getItemCount() > 0) {
            a.add(this.printer.getElement());
            CheckedListAdder.addToList(a, this.copies);
        }
        return a;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.printer != null && this.printer.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.printer.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected int layoutInheritedComponents(Component parent) {
        super.layoutInheritedComponents(parent);
        if (this.title != null) {
            this.title.setLocation(this.border, 0);
            this.title.setSize(parent.getWidth() - 2 * this.border, (int)this.title.getPreferredSize().getHeight());
            this.sep1.setLocation(this.border, this.title.getY() + this.title.getHeight() + this.border);
            this.sep1.setSize(parent.getWidth() - 2 * this.border, 1);
            this.printer.setLocation(this.border, this.sep1.getY() + this.sep1.getHeight() + this.border);
            this.printer.setSize((parent.getWidth() - 3 * this.border) / 3 * 2, (int)this.printer.getPreferredSize().getHeight());
            this.copies.setLocation(this.printer.getX() + this.printer.getWidth() + this.border, this.printer.getY());
            this.copies.setSize((parent.getWidth() - 3 * this.border) / 3, (int)this.copies.getPreferredSize().getHeight());
            return this.copies.getY() + this.copies.getHeight();
        }
        return 0;
    }

    protected int getInheritedComponentsHeight() {
        int h = 0;
        if (this.title != null) {
            h = (int)this.title.getPreferredSize().getHeight();
            h += this.border;
            h = (int)((double)h + this.sep1.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + this.printer.getPreferredSize().getHeight());
            h += this.border;
        }
        return h;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.title != null) {
            this.title.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.printer != null) {
            this.printer.kill();
        }
        if (this.copies != null) {
            this.copies.kill();
        }
        this.title = null;
        this.sep1 = null;
        this.printer = null;
        this.copies = null;
    }

    protected void startPrinting2() {
        this.printed = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation();
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }
}

