/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.print;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.converter.PrintConfigurationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.Batchable;
import ch.icit.pegasus.client.gui.batch.PrintProcessor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.print.PrinterToolkitConfiguration;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.util.PrinterToolkit;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.print.PrintService;
import org.apache.commons.io.FileUtils;

public abstract class DefaultScrollablePrintPopup2<T extends IDTO>
extends ScrollablePrintPopupInsert
implements ItemListener,
Batchable<T>,
ButtonListener {
    private static final long serialVersionUID = 1L;
    protected TitledItem<TextLabel> title;
    private HorizontalSeparator sep1;
    protected TitledItem<ComboBox> printer;
    protected TitledItem<TextField> copies;
    protected TitledItem<ComboBox> configs;
    protected TitledItem<CheckBox> showPrintDialog;
    private HorizontalSeparator sep2;
    protected RadioButtonBox box;
    protected TitledItem<RadioButton> asPDF;
    protected TitledItem<RadioButton> asXLS;
    private HorizontalSeparator sep3;
    protected RadioButtonBox reportTypeBox;
    private ReportTypeE reportType;
    private HorizontalSeparator sep4;
    private final List<Runnable> loadBeforeShowing = new ArrayList<Runnable>();
    private boolean isChoosePrinter;
    private boolean isChooseConfig;
    private boolean isShowDialog;
    private boolean showSaveFileDialog;
    private boolean isShowExportType;
    private boolean elementsInserted = false;
    protected boolean insertPreviewButton = true;
    protected boolean reportTypesLoaded = false;
    private boolean runJob;
    private boolean pdfType;
    private static final String REPORT_TYPE = "reportType";
    private File selectedFileForSaveAs;

    public abstract String getTitleString();

    public abstract String getTitleValue();

    public DefaultScrollablePrintPopup2(ReportTypeE reportType) {
        this(true, true, true, true, reportType);
    }

    public DefaultScrollablePrintPopup2(boolean isShowDialog, boolean isShowExportType, ReportTypeE exportType) {
        this(true, true, isShowDialog, isShowExportType, exportType);
    }

    public DefaultScrollablePrintPopup2(boolean isShowDialog, boolean isShowExportType, boolean isPDF, ReportTypeE exportType) {
        this(true, true, isShowDialog, isShowExportType, isPDF, exportType);
    }

    public DefaultScrollablePrintPopup2(boolean isChoosePrinter, boolean isChooseConfig, boolean isShowDialog, boolean showExportType, ReportTypeE reportType) {
        this(isChoosePrinter, isChooseConfig, isShowDialog, showExportType, true, reportType);
    }

    public DefaultScrollablePrintPopup2(boolean isChoosePrinter, boolean isChooseConfig, boolean isShowDialog, boolean showExportType, boolean showPdfType, ReportTypeE reportType) {
        this.isChoosePrinter = isChoosePrinter;
        this.isChooseConfig = isChooseConfig;
        this.isShowDialog = isShowDialog;
        this.isShowExportType = showExportType;
        this.reportType = reportType;
        this.pdfType = showPdfType;
    }

    private void loadConfigurationValues() {
        FilterChainConfiguration config = FilterChainConfiguration.loadConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        if (config != null) {
            this.updateConfiguration(config);
            for (String[] s : config.getProperties()) {
                String n = s[0];
                String v = s[1];
                switch (n) {
                    case "reportType": {
                        if (this.reportTypeBox == null) break;
                        this.selectReport(v);
                    }
                }
            }
        }
        this.createFocusCycle();
    }

    @Override
    protected String getProgressText() {
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    public void selectReport(String reportSelection) {
        for (RadioButton rb : this.reportTypeBox.getButtons()) {
            ReportSelection rs = (ReportSelection)rb;
            if (!rs.getUserObject().getFileName().equals(reportSelection)) continue;
            rs.setChecked(true);
        }
    }

    private void createFocusCycle() {
        if (this.popup != null) {
            this.popup.rebuildFocusCycle();
        }
    }

    private void writeConfigurationValues() {
        FilterChainConfiguration conf = this.createFilterChainConfig();
        ReportFileComplete selectedReport = this.getSelectedReport();
        if (conf == null) {
            if (selectedReport != null) {
                conf = new FilterChainConfiguration();
            } else {
                return;
            }
        }
        if (selectedReport != null) {
            conf.addProperty(REPORT_TYPE, "" + selectedReport.getFileName());
        }
        FilterChainConfiguration.saveConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), conf, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
        if (this.popup != null) {
            this.popup.createFocusCycle();
        }
    }

    public abstract void updateConfiguration(FilterChainConfiguration var1);

    public abstract FilterChainConfiguration createFilterChainConfig();

    public void loadBeforeShowing(Runnable run) {
        this.loadBeforeShowing.add(run);
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.reportTypesLoaded) {
            super.enterPressed(isOK);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        if (this.insertPreviewButton) {
            ip.enablePreviewButton();
        }
    }

    protected void setEnabledFromRemoteLoad(boolean isEnabled) {
        if (this.isKilled()) {
            return;
        }
        this.setEnabled(isEnabled);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.title != null) {
            this.title.setEnabled(isEnabled);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(isEnabled);
        }
        if (this.printer != null) {
            this.printer.setEnabled(isEnabled);
        }
        if (this.copies != null) {
            this.copies.setEnabled(isEnabled);
        }
        if (this.configs != null) {
            this.configs.setEnabled(isEnabled);
        }
        if (this.showPrintDialog != null) {
            this.showPrintDialog.setEnabled(isEnabled);
        }
        if (this.sep2 != null) {
            this.sep2.setEnabled(isEnabled);
        }
        if (this.box != null) {
            this.box.setEnabled(isEnabled);
        }
        if (this.asPDF != null) {
            this.asPDF.setEnabled(isEnabled);
        }
        if (this.asXLS != null) {
            this.asXLS.setEnabled(isEnabled);
        }
        if (this.sep3 != null) {
            this.sep3.setEnabled(isEnabled);
        }
        if (this.reportTypeBox != null) {
            this.reportTypeBox.setEnabled(isEnabled);
        }
        if (this.sep4 != null) {
            this.sep4.setEnabled(isEnabled);
        }
    }

    protected ReportFileComplete getSelectedReport() {
        RadioButton b = null;
        if (this.reportTypeBox != null) {
            b = this.reportTypeBox.getSelectedButton() == null ? this.reportTypeBox.getAnyButton() : this.reportTypeBox.getSelectedButton();
        }
        if (b != null) {
            return ((ReportSelection)b).getUserObject();
        }
        return null;
    }

    protected void setSelectedReport(String name) {
        if (this.reportTypeBox != null) {
            List<RadioButton> buttons = this.reportTypeBox.getButtons();
            for (RadioButton butt : buttons) {
                ReportFileComplete r = ((ReportSelection)butt).getUserObject();
                if (!r.getFileName().equals(name)) continue;
                butt.setChecked(true);
                return;
            }
            RadioButton b = null;
            b = this.reportTypeBox.getSelectedButton() == null ? this.reportTypeBox.getAnyButton() : this.reportTypeBox.getSelectedButton();
            b.setChecked(true);
        }
    }

    public ReportingOutputFormatE getOutputFormat() {
        if (this.asXLS != null && this.asXLS.getElement().isChecked()) {
            return ReportingOutputFormatE.XLSX;
        }
        return ReportingOutputFormatE.PDF;
    }

    public PrintProcessor getPrintProcessor() {
        int cps = 1;
        try {
            cps = Integer.valueOf(this.copies.getElement().getText());
        }
        catch (NumberFormatException e) {
            cps = 1;
        }
        PrintProcessor p = new PrintProcessor("", this.getSelectedPrinter(), this.getPrintConfiguration(), this.showPrintDialog != null ? this.showPrintDialog.getElement().isChecked() : false, cps);
        return p;
    }

    public abstract Node<T> getCurrentNode();

    public abstract void insertElements();

    public String getPreferredSelection() {
        return null;
    }

    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return true;
    }

    public void loadReportTypes() {
        if (this.reportType != null || this.loadBeforeShowing != null && !this.loadBeforeShowing.isEmpty()) {
            this.ensureAnimation("Loading Report Data");
            if (this.popup != null) {
                this.popup.enableCancelButton(false);
                this.popup.enableOKButton(false);
                this.popup.enablePreviewButton(false);
            }
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    return DefaultScrollablePrintPopup2.this.loadReportTypesNow();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node == null) {
                                DefaultScrollablePrintPopup2.this.remoteObjectLoaded(node);
                            } else {
                                DefaultScrollablePrintPopup2.this.insertElements();
                                if (DefaultScrollablePrintPopup2.this.reportType != null && DefaultScrollablePrintPopup2.this.reportTypeBox != null) {
                                    List reports = (List)node.getValue();
                                    boolean first = true;
                                    String t = DefaultScrollablePrintPopup2.this.getPreferredSelection();
                                    for (ReportFileComplete r : reports) {
                                        if (!DefaultScrollablePrintPopup2.this.isReportAllowed(r)) continue;
                                        ReportSelection f = new ReportSelection(r);
                                        if (t != null && !first && r.getDescription().startsWith(t)) {
                                            f.setChecked(true);
                                            first = false;
                                        }
                                        DefaultScrollablePrintPopup2.this.reportTypeBox.addBox(new TitledItem<ReportSelection>(f, r.getDescription(), TitledItem.TitledItemOrientation.EAST), f);
                                    }
                                    if (first && DefaultScrollablePrintPopup2.this.reportTypeBox.getAnyButton() != null) {
                                        DefaultScrollablePrintPopup2.this.reportTypeBox.getAnyButton().setChecked(true);
                                    }
                                }
                                DefaultScrollablePrintPopup2.this.removeAnimation(false);
                                DefaultScrollablePrintPopup2.this.addInheritedComponents();
                                if (DefaultScrollablePrintPopup2.this.popup != null) {
                                    DefaultScrollablePrintPopup2.this.popup.enablePreviewButton(true);
                                    DefaultScrollablePrintPopup2.this.popup.enableBackgroundButton(true);
                                    DefaultScrollablePrintPopup2.this.popup.enableCancelButton(true);
                                    DefaultScrollablePrintPopup2.this.popup.enableOKButton(true);
                                }
                            }
                            DefaultScrollablePrintPopup2.this.loadConfigurationValues();
                            DefaultScrollablePrintPopup2.this.reportTypesLoaded = true;
                        }

                        public void errorOccurred(ClientException exception) {
                            DefaultScrollablePrintPopup2.this.errorOccurred(exception);
                            DefaultScrollablePrintPopup2.this.reportTypesLoaded = true;
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.reportTypesLoaded = true;
            this.insertElements();
            this.loadConfigurationValues();
        }
    }

    public boolean previewFile(Node<PegasusFileComplete> node) throws ClientException {
        PegasusFileComplete ref = null;
        if (node.getValue() instanceof PegasusFileComplete) {
            PegasusFileComplete t;
            ref = t = (PegasusFileComplete)node.getValue();
        }
        if (ref != null) {
            return this.processFile(ref);
        }
        return false;
    }

    @Override
    public final boolean tryToGrabFocus() {
        if (this.printer != null && this.printer.isEnabled()) {
            this.printer.getElement().requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node.getValue() instanceof Boolean) {
            boolean succeeded = (Boolean)node.getValue();
            this.runJob = false;
            this.printed = true;
            if (succeeded) {
                this.stopPrinting();
                super.remoteObjectLoaded(node);
                this.tryToClose();
            }
        } else if (node.getValue() instanceof List) {
            this.runJob = false;
            this.printed = true;
            this.errorMSG = ScreenValidationObject.createMessageList((List)((List)node.getValue()));
            this.stopPrinting();
            this.showMessage(this.errorMSG);
            this.removeAnimation(false);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.runJob = false;
        super.errorOccurred(exception);
    }

    public void addInheritedComponents() {
        if (!this.elementsInserted) {
            return;
        }
        for (Component c : this.getViewContainer().getComponents()) {
            c.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        if (!this.elementsInserted) {
            return;
        }
        for (Component c : this.getViewContainer().getComponents()) {
            c.setVisible(false);
        }
    }

    private void fillPrinters() {
        List l = PrinterToolkit.getAvailablePrinters();
        for (PrintService t : l) {
            this.printer.getElement().addItem(PrinterToolkit.convertPrintServiceToString((PrintService)t));
        }
        PrintService s = PrintPopupToolkit.getDefaultPrinter((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        if (s != null) {
            this.printer.getElement().setSelectedItem(PrinterToolkit.convertPrintServiceToString((PrintService)s));
        }
    }

    protected PrintService getSelectedPrinter() {
        if (this.printer != null && this.printer.getElement() != null && this.printer.getElement().getSelectedItem() != null) {
            String pn = (String)this.printer.getElement().getSelectedItem();
            PrintService t = PrinterToolkit.converterStringToPrintService((String)pn);
            return t;
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.printer != null && e.getSource() == this.printer.getElement()) {
            final String ss = (String)this.printer.getElement().getSelectedItem();
            this.ensureAnimation("Load Print Configuration");
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    List list = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getPrintConfigurationForPrinterName(ss).getList();
                    if (list != null) {
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            if (((PrintConfigurationComplete)it.next()).getDeleteUser() == null) continue;
                            it.remove();
                        }
                        Node n = INodeCreator.getDefaultImpl().createNodes(list, false);
                        return n;
                    }
                    return new Node();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (DefaultScrollablePrintPopup2.this.configs != null && node != null) {
                                DefaultScrollablePrintPopup2.this.configs.getElement().refreshPossibleValues(node);
                            }
                            DefaultScrollablePrintPopup2.this.removeAnimation(false, true);
                            DefaultScrollablePrintPopup2.this.setEnabledFromRemoteLoad(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)DefaultScrollablePrintPopup2.this);
                            DefaultScrollablePrintPopup2.this.removeAnimation(false, true);
                            DefaultScrollablePrintPopup2.this.setEnabledFromRemoteLoad(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public void createComponents() {
        this.title = new TitledItem<TextLabel>(new TextLabel(this.getTitleValue()), this.getTitleString(), TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.getViewContainer().add(this.title);
        this.getViewContainer().add(this.sep1);
        if (this.isChoosePrinter) {
            this.printer = new TitledItem<ComboBox>(new ComboBox(), Words.PRINTER, TitledItem.TitledItemOrientation.NORTH);
            this.copies = new TitledItem<TextField>(new TextField(), Words.COPIES, TitledItem.TitledItemOrientation.NORTH);
            this.copies.getElement().setText(this.getNumberOfSavedCopies());
            this.printer.getElement().addItemListener(this);
            this.getViewContainer().add(this.printer);
            this.getViewContainer().add(this.copies);
            this.fillPrinters();
            if (this.isChooseConfig) {
                this.configs = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(PrintConfigurationConverter.class)), "PRINT CONFIG", TitledItem.TitledItemOrientation.NORTH);
                this.getViewContainer().add(this.configs);
            }
            if (this.isShowDialog) {
                this.showPrintDialog = new TitledItem<CheckBox>(new CheckBox(), "Show Print Dialog", TitledItem.TitledItemOrientation.EAST);
                this.getViewContainer().add(this.showPrintDialog);
            }
            this.sep2 = new HorizontalSeparator();
            this.getViewContainer().add(this.sep2);
        }
        if (this.isShowExportType || this.pdfType) {
            this.box = new RadioButtonBox();
            this.box.setOrientation(0);
            if (this.pdfType) {
                this.asPDF = new TitledItem<RadioButton>(new RadioButton(), "PDF", TitledItem.TitledItemOrientation.EAST);
                this.asPDF.getElement().setChecked(true);
                this.asPDF.getElement().addButtonListener(this);
            }
            if (this.isShowExportType) {
                this.asXLS = new TitledItem<RadioButton>(new RadioButton(), "Excel", TitledItem.TitledItemOrientation.EAST);
                this.asXLS.getElement().addButtonListener(this);
            }
            if (this.pdfType) {
                this.box.addBox(this.asPDF, this.asPDF.getElement());
            }
            if (this.isShowExportType) {
                this.box.addBox(this.asXLS, this.asXLS.getElement());
            }
            this.sep3 = new HorizontalSeparator();
            this.getViewContainer().add(this.box);
            this.getViewContainer().add(this.sep3);
            if (this.pdfType) {
                this.asPDF.getElement().setChecked(true);
            } else if (this.isShowExportType) {
                this.asXLS.getElement().setChecked(true);
            }
        }
        if (this.reportType != null) {
            this.reportTypeBox = new RadioButtonBox();
            this.sep4 = new HorizontalSeparator();
            this.getViewContainer().add(this.reportTypeBox);
            this.getViewContainer().add(this.sep4);
        }
        this.elementsInserted = true;
    }

    protected String getNumberOfSavedCopies() {
        return PrintPopupToolkit.getDefaultCopyCount((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    protected void setElementsInserted() {
        this.elementsInserted = true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (!this.elementsInserted) {
            return a;
        }
        if (this.isChoosePrinter) {
            if (this.printer != null && this.printer.getElement().getItemCount() > 0) {
                a.addAll(this.printer.getFocusComponents());
            }
            if (this.copies != null && this.copies.isEnabled()) {
                a.addAll(this.copies.getFocusComponents());
            }
        }
        if (this.isChooseConfig && this.configs != null) {
            a.addAll(this.configs.getFocusComponents());
        }
        if (this.isShowDialog && this.showPrintDialog != null) {
            a.addAll(this.showPrintDialog.getFocusComponents());
        }
        if (this.isShowExportType && this.asPDF != null && this.asXLS != null) {
            a.addAll(this.asPDF.getFocusComponents());
            a.addAll(this.asXLS.getFocusComponents());
        }
        if (this.reportTypeBox != null) {
            CheckedListAdder.addToList(a, this.reportTypeBox);
        }
        return a;
    }

    @Override
    protected int layoutInheritedComponents(Component parent) {
        super.layoutInheritedComponents(parent);
        if (this.title != null) {
            this.title.setLocation(this.border, 0);
            this.title.setSize(parent.getWidth() - 2 * this.border, (int)this.title.getPreferredSize().getHeight());
            this.sep1.setLocation(0, this.title.getY() + this.title.getHeight() + this.border);
            this.sep1.setSize(parent.getWidth(), 1);
            if (this.isChoosePrinter) {
                this.printer.setLocation(this.border, this.sep1.getY() + this.sep1.getHeight() + this.border);
                this.printer.setSize((parent.getWidth() - 3 * this.border) / 3 * 2, (int)this.printer.getPreferredSize().getHeight());
                this.copies.setLocation(this.printer.getX() + this.printer.getWidth() + this.border, this.printer.getY());
                this.copies.setSize((parent.getWidth() - 3 * this.border) / 3, (int)this.copies.getPreferredSize().getHeight());
                int cy = this.copies.getY() + this.copies.getHeight() + this.border;
                if (this.configs != null) {
                    this.configs.setLocation(this.border, cy);
                    this.configs.setSize(parent.getWidth() - 2 * this.border, (int)this.configs.getPreferredSize().getHeight());
                    cy = this.configs.getY() + this.configs.getHeight() + this.border;
                }
                if (this.showPrintDialog != null) {
                    this.showPrintDialog.setLocation(this.border, cy);
                    this.showPrintDialog.setSize(parent.getWidth() - 2 * this.border, (int)this.showPrintDialog.getPreferredSize().getHeight());
                    cy = this.showPrintDialog.getY() + this.showPrintDialog.getHeight() + this.border;
                }
                if (this.sep2 != null) {
                    this.sep2.setLocation(0, cy);
                    this.sep2.setSize(parent.getWidth(), (int)this.sep2.getPreferredSize().getHeight());
                    cy = this.sep2.getY() + this.sep2.getHeight() + this.border;
                }
                if (this.box != null) {
                    this.box.setLocation(this.border, cy);
                    this.box.setSize(parent.getWidth() - 2 * this.border, (int)this.box.getPreferredSize().getHeight());
                    cy = this.box.getY() + this.box.getHeight() + this.border;
                }
                if (this.sep3 != null) {
                    this.sep3.setLocation(0, cy);
                    this.sep3.setSize(parent.getWidth(), (int)this.sep3.getPreferredSize().getHeight());
                    cy = this.sep3.getY() + this.sep3.getHeight() + this.border;
                }
                if (this.reportTypeBox != null) {
                    this.reportTypeBox.setLocation(this.border, cy);
                    this.reportTypeBox.setSize(parent.getWidth() - 2 * this.border, (int)this.reportTypeBox.getPreferredSize().getHeight());
                    cy += this.reportTypeBox.getHeight() + this.border;
                    if (this.sep4 != null) {
                        this.sep4.setLocation(0, cy);
                        this.sep4.setSize(parent.getWidth(), (int)this.sep4.getPreferredSize().getHeight());
                        cy += this.sep4.getHeight();
                    }
                }
                return cy;
            }
            return this.sep1.getY() + this.sep1.getHeight();
        }
        return 0;
    }

    @Override
    protected void removeAnimation(boolean withMSG) {
        this.removeAnimation(withMSG, false);
    }

    protected void removeAnimation(boolean withMSG, boolean fromLoading) {
        if (this.runJob) {
            return;
        }
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(false);
            this.animation = null;
        }
        if (withMSG) {
            this.setText(this.dogetFinishText());
            if (this.popup != null) {
                this.popup.setOkButtonText(Words.CLOSE);
            }
        }
        this.validate();
        if (!fromLoading && this.popup != null) {
            this.popup.enableOKButton(true);
            this.popup.enablePreviewButton(false);
            this.popup.enableBackgroundButton(false);
        }
    }

    protected int getInheritedComponentsHeight() {
        int h = 0;
        if (this.title != null) {
            h = (int)this.title.getPreferredSize().getHeight();
            h += this.border;
            h = (int)((double)h + this.sep1.getPreferredSize().getHeight());
            if (this.printer != null) {
                h += this.border;
                h = (int)((double)h + this.printer.getPreferredSize().getHeight());
                h += this.border;
            }
            if (this.configs != null) {
                h = (int)((double)h + this.configs.getPreferredSize().getHeight());
                h += this.border;
            }
            if (this.showPrintDialog != null) {
                h = (int)((double)h + this.showPrintDialog.getPreferredSize().getHeight());
                h += this.border;
            }
            if (this.sep2 != null) {
                h = (int)((double)h + this.sep2.getPreferredSize().getHeight());
            }
            h += this.border;
            if (this.box != null) {
                h = (int)((double)h + this.box.getPreferredSize().getHeight());
                h += this.border;
            }
            if (this.sep3 != null) {
                h = (int)((double)h + this.sep3.getPreferredSize().getHeight());
                h += this.border;
            }
            if (this.reportTypeBox != null) {
                h = (int)((double)h + this.reportTypeBox.getPreferredSize().getHeight());
                h += this.border;
                if (this.sep4 != null) {
                    h = (int)((double)h + this.sep4.getPreferredSize().getHeight());
                    h += this.border;
                }
            }
        }
        return h;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.elementsInserted && this.title != null) {
            this.title.kill();
            this.sep1.kill();
            if (this.printer != null) {
                this.printer.kill();
            }
            if (this.copies != null) {
                this.copies.kill();
            }
            if (this.configs != null) {
                this.configs.kill();
            }
            if (this.showPrintDialog != null) {
                this.showPrintDialog.kill();
            }
            if (this.sep2 != null) {
                this.sep2.kill();
            }
            if (this.asPDF != null) {
                this.asPDF.kill();
            }
            if (this.asXLS != null) {
                this.asXLS.kill();
            }
            if (this.sep3 != null) {
                this.sep3.kill();
            }
            if (this.box != null) {
                this.box.kill();
            }
            if (this.reportTypeBox != null) {
                this.reportTypeBox.kill();
            }
            if (this.sep4 != null) {
                this.sep4.kill();
            }
        }
        this.title = null;
        this.sep1 = null;
        this.printer = null;
        this.copies = null;
        this.configs = null;
        this.showPrintDialog = null;
        this.sep2 = null;
        this.box = null;
        this.asPDF = null;
        this.asXLS = null;
        this.sep3 = null;
        this.reportTypeBox = null;
        this.sep4 = null;
    }

    protected void stopPrinting() {
        MainFrame.isTempRelease = false;
    }

    @Override
    public void startPrinting() {
        if (this.popup != null) {
            this.popup.enableOKButton(false);
            this.popup.enableCancelButton(false);
        }
        this.removeInheritedComponents();
        this.ensureAnimation();
        if (this.isShowDialog && this.showPrintDialog.getElement().isChecked()) {
            MainFrame.isTempRelease = true;
        }
        if (this.showSaveFileDialog) {
            File file;
            this.selectedFileForSaveAs = file = FileChooserUtil.saveFile("");
        }
        this.runJob = true;
        ThreadSafeLoader.run(this.getJob());
    }

    public boolean getIsPreviewAnyway() {
        return false;
    }

    protected boolean processFile(PegasusFileComplete reference) throws ClientException {
        return this.processFile(reference, this.getCopies());
    }

    protected boolean processFile(PegasusFileComplete reference, int cps) throws ClientException {
        this.writeConfigurationValues();
        if (this.popup != null && this.popup.isPreview() || this.asXLS != null && this.asXLS.getElement().isChecked() || this.getIsPreviewAnyway()) {
            PrintPopupToolkit.previewFile(reference);
        } else {
            MainFrame.isTempRelease = true;
            this.writeDefaultPrinter();
            if (!this.showSaveFileDialog) {
                boolean printed = PrintPopupToolkit.printFile(reference, "", this.getSelectedPrinter(), this.getPrintConfiguration(), this.showPrintDialog != null ? this.showPrintDialog.getElement().isChecked() : false, cps);
                if (!printed) {
                    InnerPopupFactory.showErrorDialog("Unable to print Sheet", (Component)this);
                }
            } else {
                try {
                    File rfile = FileTransferUtil.download((PegasusFileComplete)reference, (FileTransferListener[])new FileTransferListener[0]);
                    FileUtils.copyFile((File)rfile, (File)this.selectedFileForSaveAs);
                }
                catch (IOException e) {
                    throw new ClientGetFromServerException("Unable to save generated Report", null);
                }
                catch (Exception e) {
                    throw new ClientGetFromServerException("Unable to download generated File from Server", null);
                }
            }
        }
        return true;
    }

    private void writeDefaultPrinter() {
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        PrinterToolkitConfiguration c = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser);
        if (c == null) {
            c = new PrinterToolkitConfiguration();
        }
        if (this.isChoosePrinter && this.printer != null && this.printer.getElement().getSelectedItem() != null) {
            c.updateProperty("printer", (String)this.printer.getElement().getSelectedItem());
            PrinterToolkitConfiguration.saveConfiguration((UserLight)currentUser, (PrinterToolkitConfiguration)c);
            if (this.copies.getElement() != null && this.copies.getElement().getText() != null) {
                c.updateProperty("copies", this.copies.getElement().getText());
                PrinterToolkitConfiguration.saveConfiguration((UserLight)currentUser, (PrinterToolkitConfiguration)c);
            }
        }
    }

    protected int getCopies() {
        int i = 1;
        if (this.copies != null) {
            String t = this.copies.getElement().getText();
            try {
                i = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                i = 1;
            }
        }
        return i;
    }

    protected void setNumberOfCopies(int numberOfCopies) {
        if (this.copies != null) {
            this.copies.getElement().setText(Integer.toString(numberOfCopies));
        }
    }

    private PrintConfigurationComplete getPrintConfiguration() {
        if (this.configs != null && this.configs.getElement().getSelectedItem() != null) {
            return (PrintConfigurationComplete)((Node)this.configs.getElement().getSelectedItem()).getValue();
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        Component currentC;
        if (this.printer != null && this.printer.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.printer.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if (this.configs != null && this.configs.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.configs.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isShowSaveFileDialog() {
        return this.showSaveFileDialog;
    }

    public void setShowSaveFileDialog(boolean showSaveFileDialog) {
        this.showSaveFileDialog = showSaveFileDialog;
    }

    @Override
    public BatchJob<T> getBatchJob(ThreadSafeExecutable job) {
        Node l = INodeCreator.getDefaultImpl().getNode4DTO(this.getCurrentNode().getValue(), false, false);
        BatchJob<T> batch = this.createBatchJob(l, job);
        return batch;
    }

    @Override
    public boolean validateContent() {
        return this.getSelectedReport() != null;
    }

    public abstract BatchJob<T> createBatchJob(Node<T> var1, ThreadSafeExecutable var2);

    protected Node<?> loadReportTypesNow() throws ClientGetFromServerException {
        for (Runnable r : this.loadBeforeShowing) {
            r.run();
        }
        if (this.reportType != null) {
            SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(this.reportType);
            List results = r.getResults();
            Collections.sort(results, Ordering.natural().onResultOf((Function)new Function<ReportFileComplete, String>(){

                public String apply(ReportFileComplete input) {
                    return input.getDescription();
                }
            }));
            List reportConfig = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportConfiguration(this.reportType).getList();
            if (reportConfig != null) {
                block6: for (ReportConfigurationComplete rc : reportConfig) {
                    switch (rc.getType()) {
                        case HIDE_DEFAULT: {
                            Iterator it;
                            if (!rc.getShowDefault().booleanValue()) {
                                it = results.iterator();
                                while (it.hasNext()) {
                                    if (((ReportFileComplete)it.next()).getId() != null) continue;
                                    it.remove();
                                }
                            }
                            if (!rc.getHideReport().booleanValue()) break;
                            it = results.iterator();
                            while (it.hasNext()) {
                                ReportFileComplete report = (ReportFileComplete)it.next();
                                if (!report.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            continue block6;
                        }
                        case MAX_LABEL_ENTRIES: {
                            break;
                        }
                        case REPLACE_IN_LOCATION: {
                            Iterator it = results.iterator();
                            LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                            if (rc.getShowReport().booleanValue() || !location.equals((Object)rc.getLocation())) break;
                            while (it.hasNext()) {
                                ReportFileComplete rfc = (ReportFileComplete)it.next();
                                if (!rfc.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            break;
                        }
                    }
                }
            }
            ListNode i = new ListNode();
            i.setValue((Object)results, 0L);
            return i;
        }
        return new Node();
    }

    public static class ReportSelection
    extends RadioButton {
        private static final long serialVersionUID = 1L;
        private final ReportFileComplete userObject;

        public ReportSelection(ReportFileComplete userObject) {
            this.userObject = userObject;
        }

        public ReportFileComplete getUserObject() {
            return this.userObject;
        }
    }
}

