/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.print;

import ch.icit.pegasus.client.gui.utils.print.PrintPdf;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.print.PrinterToolkitConfiguration;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.util.PrinterToolkit;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.commons.io.FileUtils;

public class PrintPopupToolkit {
    public static PrintService getDefaultPrinter(UserLight currentUser) {
        PrinterToolkitConfiguration config;
        String p = null;
        if (currentUser != null && (config = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser)) != null) {
            p = config.getProperty("printer");
        }
        if (p == null) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        PrintService printer = PrinterToolkit.converterStringToPrintService(p);
        if (printer == null) {
            printer = PrintServiceLookup.lookupDefaultPrintService();
        }
        return printer;
    }

    public static void setDefaultPrinter(UserLight currentUser, String service) {
        PrinterToolkitConfiguration config;
        if (currentUser != null && (config = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser)) != null) {
            if (config.getProperty("printer") != null) {
                config.updateProperty("printer", service);
            } else {
                config.addProperty("printer", service);
            }
        }
    }

    public static String getDefaultCopyCount(UserLight currentUser) {
        PrinterToolkitConfiguration config;
        String p = null;
        if (currentUser != null && (config = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser)) != null) {
            p = config.getProperty("copies");
        }
        if (p == null) {
            return "1";
        }
        return p;
    }

    public static String getDefaultSinglePDF(UserLight currentUser) {
        PrinterToolkitConfiguration config;
        String p = null;
        if (currentUser != null && (config = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser)) != null) {
            p = config.getProperty("singleFile");
        }
        if (p == null) {
            return "";
        }
        return p;
    }

    public static void setDefaultCopyCount(UserLight currentUser, String copies) {
        PrinterToolkitConfiguration config;
        if (currentUser != null && (config = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser)) != null) {
            if (config.getProperty("copies") != null) {
                config.updateProperty("copies", copies);
            } else {
                config.addProperty("copies", copies);
            }
        }
    }

    public static void previewFile(PegasusFileComplete file) throws ClientException {
        try {
            File rfile = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
            PrintPopupToolkit.previewFile(rfile);
        }
        catch (IOException e) {
            throw new ClientGetFromServerException("Unable to preview generated Report", null);
        }
        catch (Exception e) {
            throw new ClientGetFromServerException("Unable to download generated File from Server", null);
        }
    }

    public static void downloadFileToFolder(PegasusFileComplete file, File targetDirectory, String targetFileName) throws ClientException {
        try {
            File rfile = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
            String fileName = StringUtil.isBlank((String)targetFileName) ? rfile.getName() : targetFileName;
            FileUtils.copyFile((File)rfile, (File)new File(targetDirectory.getAbsolutePath() + "/" + fileName));
        }
        catch (IOException e) {
            throw new ClientGetFromServerException("Unable to copy generated Report", null);
        }
        catch (Exception e) {
            throw new ClientGetFromServerException("Unable to download generated File from Server", null);
        }
    }

    public PrintService getSelectedPrinter(String name) {
        return PrinterToolkit.converterStringToPrintService((String)name);
    }

    public static boolean printFile(PegasusFileComplete file, String jobName, PrintService printer, PrintConfigurationComplete config, boolean showPrintDialog, int copies) throws ClientException {
        File rfile;
        try {
            rfile = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
        }
        catch (Exception e) {
            throw new ClientException("Unable to download generated Report", (Throwable)e);
        }
        try {
            if (rfile.getAbsolutePath().equals(".xlsx")) {
                throw new ClientException("Unable to print Excel (xlsx) file", null);
            }
            return new PrintPdf().printWithPDFBox(rfile, jobName, showPrintDialog, printer, config, copies);
        }
        catch (Exception e) {
            throw new ClientException("Unable to print generated Report", (Throwable)e);
        }
    }

    public static void previewFile(File f) throws Exception {
        Desktop.getDesktop().open(f);
    }
}

