/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;

public abstract class RDField<V extends JComponent, R extends JComponent>
extends JPanelFadable
implements Focusable,
Stringable,
UIStateLoadable,
Validatable,
Nodable {
    private static final long serialVersionUID = 1L;
    protected V wField;
    protected R rField;
    private boolean defaultValue;
    protected String overrideName;
    protected boolean useSubModuleAccess;
    protected RDProvider provider;
    private Node<?> node;
    protected boolean isEnabled = true;

    public RDField(RDProvider provider) {
        this.setOpaque(false);
        this.provider = provider;
        this.setProgress(1.0f);
        this.setLayout(new Layout());
    }

    public void setOverrideName(String o) {
        this.overrideName = o;
    }

    public void setOverrideName(DtoField o) {
        if (o != null) {
            this.overrideName = o.getFieldName();
        }
    }

    public void setDefaultValue(boolean b) {
        this.defaultValue = b;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.wField != null || this.rField != null) {
            return super.getPreferredSize();
        }
        return this.getNodeLessPreferredSize();
    }

    public abstract Dimension getNodeLessPreferredSize();

    public V getEditor() {
        return this.wField;
    }

    public R getRenderer() {
        return this.rField;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.wField != null && this.wField instanceof Killable) {
            ((Killable)this.wField).kill();
        }
        if (this.rField != null && this.rField instanceof Killable) {
            ((Killable)this.rField).kill();
        }
        this.wField = null;
        this.rField = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.wField != null && this.wField instanceof Focusable) {
            return ((Focusable)this.wField).getFocusComponents();
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.wField != null && this.wField instanceof Focusable) {
            ((Focusable)this.wField).setVisibleContainer(pane);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        if (this.wField != null && this.wField instanceof Focusable) {
            return ((Focusable)this.wField).getSelectDelegationComponent();
        }
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.wField != null && this.wField instanceof Focusable) {
            ((Focusable)this.wField).requestFocusInWindowNow();
        }
    }

    @Override
    public String getStringValue() {
        if (this.wField != null && this.wField instanceof Stringable) {
            return ((Stringable)this.wField).getStringValue();
        }
        return null;
    }

    @Override
    public String getPersistString() {
        if (this.wField != null && this.wField instanceof UIStateLoadable) {
            return ((UIStateLoadable)this.wField).getPersistString();
        }
        return null;
    }

    @Override
    public void loadState(String state, String id) {
        if (this.wField != null && this.wField instanceof UIStateLoadable) {
            ((UIStateLoadable)this.wField).loadState(state, null);
        }
    }

    @Override
    public String getID() {
        if (this.wField != null && this.wField instanceof UIStateLoadable) {
            return ((UIStateLoadable)this.wField).getID();
        }
        return null;
    }

    @Override
    public boolean shouldPersist() {
        if (this.wField != null && this.wField instanceof UIStateLoadable) {
            return ((UIStateLoadable)this.wField).shouldPersist();
        }
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        if (this.wField != null && this.wField instanceof UIStateLoadable) {
            ((UIStateLoadable)this.wField).setShouldPersist(isPersisting);
        }
    }

    public void setUseSubModuleAccessRight(boolean b) {
        this.useSubModuleAccess = b;
    }

    public void ensureAccessState(Node<?> n) {
        String name = "";
        if (n != null) {
            name = n.getName();
        }
        if (this.overrideName != null) {
            name = this.overrideName;
        }
        boolean a = this.defaultValue;
        a = this.provider != null ? (this.useSubModuleAccess ? this.provider.hasSubRight(name) : this.provider.isWritable(name)) : true;
        if (a) {
            if (this.rField != null) {
                if (this.rField instanceof Killable) {
                    ((Killable)this.rField).kill();
                    this.rField = null;
                } else {
                    this.remove((Component)this.rField);
                    this.rField = null;
                }
            }
            if (this.wField == null) {
                this.wField = this.createEditor(n);
                this.add((Component)this.wField);
                if (this.wField instanceof Fadable) {
                    ((Fadable)this.wField).setProgress(0.0f);
                    ((Fadable)this.wField).fadeIn();
                }
            } else if (this.wField instanceof Nodable) {
                ((Nodable)this.wField).setNode(n);
            }
        } else {
            if (this.wField != null) {
                if (this.wField instanceof Killable) {
                    ((Killable)this.wField).kill();
                    this.wField = null;
                } else {
                    this.remove((Component)this.wField);
                    this.wField = null;
                }
            }
            if (this.rField == null) {
                this.rField = this.createRenderer(n);
                this.add((Component)this.rField);
                if (this.rField instanceof Fadable) {
                    ((Fadable)this.rField).setProgress(0.0f);
                    ((Fadable)this.rField).fadeIn();
                }
            } else if (this.rField instanceof Nodable) {
                ((Nodable)this.rField).setNode(n);
            }
        }
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.ensureAccessState(node);
        if (this.wField != null && this.wField instanceof Nodable) {
            ((Nodable)this.wField).setNode(node);
        }
        if (this.rField != null && this.rField instanceof Nodable) {
            ((Nodable)this.rField).setNode(node);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.isEnabled = isEnabled;
        if (this.wField != null) {
            ((JComponent)this.wField).setEnabled(isEnabled);
        }
        if (this.rField != null) {
            ((JComponent)this.rField).setEnabled(isEnabled);
        }
    }

    public void showEditorAnyWay() {
        if (this.wField != null) {
            return;
        }
        if (this.rField != null && this.rField instanceof Killable) {
            ((Killable)this.rField).kill();
        }
        this.wField = this.createEditor(this.getNode());
        this.add((Component)this.wField);
        if (this.wField instanceof Fadable) {
            ((Fadable)this.wField).fadeIn();
        }
    }

    @Override
    public void setValid() {
        if (this.wField != null && this.wField instanceof Validatable) {
            ((Validatable)this.wField).setValid();
        }
    }

    @Override
    public void setInvalid() {
        if (this.wField != null && this.wField instanceof Validatable) {
            ((Validatable)this.wField).setInvalid();
        }
    }

    @Override
    public void setWarning() {
        if (this.wField != null && this.wField instanceof Validatable) {
            ((Validatable)this.wField).setWarning();
        }
    }

    public abstract V createEditor(Node<?> var1);

    public abstract R createRenderer(Node<?> var1);

    public boolean isWritable() {
        return this.wField != null;
    }

    public void processMouseEntered(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseListener) {
            ((MouseListener)this.wField).mouseEntered(transformMouseEvent4Delegation);
        }
    }

    public void processMouseExited(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseListener) {
            ((MouseListener)this.wField).mouseExited(transformMouseEvent4Delegation);
        }
    }

    public void processMousePressed(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseListener) {
            ((MouseListener)this.wField).mousePressed(transformMouseEvent4Delegation);
        }
    }

    public void processMouseReleased(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseListener) {
            ((MouseListener)this.wField).mouseReleased(transformMouseEvent4Delegation);
        }
    }

    public void processMouseDragged(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseMotionListener) {
            ((MouseMotionListener)this.wField).mouseDragged(transformMouseEvent4Delegation);
        }
    }

    public void processMouseClicked(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseListener) {
            ((MouseListener)this.wField).mouseClicked(transformMouseEvent4Delegation);
        }
    }

    public void processMouseMoved(MouseEvent transformMouseEvent4Delegation) {
        if (this.wField != null && this.wField instanceof MouseMotionListener) {
            ((MouseMotionListener)this.wField).mouseMoved(transformMouseEvent4Delegation);
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (RDField.this.wField != null) {
                return ((JComponent)RDField.this.wField).getPreferredSize();
            }
            if (RDField.this.rField != null) {
                return ((JComponent)RDField.this.rField).getPreferredSize();
            }
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (RDField.this.wField != null) {
                ((Component)RDField.this.wField).setLocation(0, 0);
                ((Component)RDField.this.wField).setSize(parent.getSize());
            }
            if (RDField.this.rField != null) {
                ((Component)RDField.this.rField).setLocation(0, 0);
                ((Component)RDField.this.rField).setSize(parent.getSize());
            }
        }
    }
}

