/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Container;
import java.awt.Dimension;

public class RDHtmlEditTextArea
extends RDField<ScrollableTextArea, ScrollableTextArea>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private int maxStringLength = 255;
    private TextButton boldButton;
    private TextButton italicButton;
    private TextButton underlineButton;
    private TextButton previewButton;

    public RDHtmlEditTextArea(RDProvider provider) {
        super(provider);
        this.setLayout(new Layout());
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (this.getEditor() != null) {
            ((ScrollableTextArea)this.getEditor()).setMaxStringLength(maxStringLength);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.isEnabled = isEnabled;
        if (this.wField != null) {
            ((ScrollableTextArea)this.wField).setEnabled(isEnabled);
            this.boldButton.setEnabled(isEnabled);
            this.italicButton.setEnabled(isEnabled);
            this.previewButton.setEnabled(isEnabled);
        }
        if (this.rField != null) {
            ((ScrollableTextArea)this.rField).setEnabled(isEnabled);
        }
    }

    @Override
    public ScrollableTextArea createEditor(Node<?> node) {
        this.createButtons(true);
        ScrollableTextArea s = new ScrollableTextArea(node, true);
        s.setEnabled(this.isEnabled);
        s.getTextArea().setLineWrap(true);
        s.getTextArea().setWrapStyleWord(true);
        s.setMaxStringLength(this.maxStringLength);
        return s;
    }

    @Override
    public ScrollableTextArea createRenderer(Node<?> node) {
        this.createButtons(false);
        ScrollableTextArea s = new ScrollableTextArea(node, false);
        s.setEnabled(this.isEnabled);
        return s;
    }

    private void createButtons(boolean enabled) {
        this.boldButton = new TextButton("B");
        this.boldButton.setEnabled(enabled);
        this.boldButton.setVisible(true);
        this.boldButton.setBold();
        this.boldButton.setMinimalWidth(1);
        this.boldButton.setProgress(1.0f);
        this.boldButton.addButtonListener(this);
        this.add(this.boldButton);
        this.italicButton = new TextButton("I");
        this.italicButton.setEnabled(enabled);
        this.italicButton.setVisible(true);
        this.italicButton.setItalic();
        this.italicButton.setMinimalWidth(1);
        this.italicButton.setProgress(1.0f);
        this.italicButton.addButtonListener(this);
        this.add(this.italicButton);
        this.underlineButton = new TextButton("U");
        this.underlineButton.setEnabled(enabled);
        this.underlineButton.setVisible(true);
        this.underlineButton.setUnderlined();
        this.underlineButton.setMinimalWidth(1);
        this.underlineButton.setProgress(1.0f);
        this.underlineButton.addButtonListener(this);
        this.add(this.underlineButton);
        this.previewButton = new TextButton("Preview");
        this.previewButton.setEnabled(enabled);
        this.previewButton.setVisible(true);
        this.previewButton.setProgress(1.0f);
        this.previewButton.addButtonListener(this);
        this.add(this.previewButton);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.wField != null) {
            if (source == this.boldButton) {
                if (((ScrollableTextArea)this.wField).getSelectedText() != null) {
                    ((ScrollableTextArea)this.wField).setText(this.replaceString(((ScrollableTextArea)this.wField).getText(), ((ScrollableTextArea)this.wField).getSelectedTextStart(), ((ScrollableTextArea)this.wField).getSelectedTextEnd(), ((ScrollableTextArea)this.wField).getSelectedText(), "<b>", "</b>"));
                }
            } else if (source == this.italicButton) {
                if (((ScrollableTextArea)this.wField).getSelectedText() != null) {
                    ((ScrollableTextArea)this.wField).setText(this.replaceString(((ScrollableTextArea)this.wField).getText(), ((ScrollableTextArea)this.wField).getSelectedTextStart(), ((ScrollableTextArea)this.wField).getSelectedTextEnd(), ((ScrollableTextArea)this.wField).getSelectedText(), "<i>", "</i>"));
                }
            } else if (source == this.underlineButton) {
                if (((ScrollableTextArea)this.wField).getSelectedText() != null) {
                    ((ScrollableTextArea)this.wField).setText(this.replaceString(((ScrollableTextArea)this.wField).getText(), ((ScrollableTextArea)this.wField).getSelectedTextStart(), ((ScrollableTextArea)this.wField).getSelectedTextEnd(), ((ScrollableTextArea)this.wField).getSelectedText(), "<u>", "</u>"));
                }
            } else if (source == this.previewButton) {
                InnerPopupFactory.showSimpleMessage("Preview", this.formatToHTML(((ScrollableTextArea)this.wField).getText()), this);
            }
        }
    }

    private String formatToHTML(String text) {
        return text.replaceAll("\\n", "<br/>");
    }

    public String replaceString(String original, int from, int to, String replacement, String startTag, String endTag) {
        String tempText1 = original.subSequence(0, from).toString();
        String tempText2 = original.subSequence(to, original.length()).toString();
        if (replacement.startsWith(startTag) && replacement.endsWith(endTag)) {
            return tempText1 + replacement.replace(startTag, "").replace(endTag, "") + tempText2;
        }
        return tempText1 + startTag + replacement + endTag + tempText2;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (RDHtmlEditTextArea.this.wField != null) {
                return ((ScrollableTextArea)RDHtmlEditTextArea.this.wField).getPreferredSize();
            }
            if (RDHtmlEditTextArea.this.rField != null) {
                return ((ScrollableTextArea)RDHtmlEditTextArea.this.rField).getPreferredSize();
            }
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (RDHtmlEditTextArea.this.wField != null) {
                RDHtmlEditTextArea.this.boldButton.setLocation(0, 0);
                RDHtmlEditTextArea.this.boldButton.setSize(RDHtmlEditTextArea.this.boldButton.getPreferredSize());
                RDHtmlEditTextArea.this.italicButton.setLocation(RDHtmlEditTextArea.this.boldButton.getX() + RDHtmlEditTextArea.this.boldButton.getWidth() + 3, 0);
                RDHtmlEditTextArea.this.italicButton.setSize(RDHtmlEditTextArea.this.italicButton.getPreferredSize());
                RDHtmlEditTextArea.this.underlineButton.setLocation(RDHtmlEditTextArea.this.italicButton.getX() + RDHtmlEditTextArea.this.italicButton.getWidth() + 3, 0);
                RDHtmlEditTextArea.this.underlineButton.setSize(RDHtmlEditTextArea.this.underlineButton.getPreferredSize());
                RDHtmlEditTextArea.this.previewButton.setLocation((int)(parent.getSize().getWidth() - RDHtmlEditTextArea.this.previewButton.getPreferredSize().getWidth()), 0);
                RDHtmlEditTextArea.this.previewButton.setSize(RDHtmlEditTextArea.this.previewButton.getPreferredSize());
                ((ScrollableTextArea)RDHtmlEditTextArea.this.wField).setLocation(0, RDHtmlEditTextArea.this.boldButton.getY() + RDHtmlEditTextArea.this.boldButton.getHeight() + 2);
                ((ScrollableTextArea)RDHtmlEditTextArea.this.wField).setSize((int)parent.getSize().getWidth(), (int)parent.getSize().getHeight() - (RDHtmlEditTextArea.this.boldButton.getY() + RDHtmlEditTextArea.this.boldButton.getHeight() + 2));
            }
            if (RDHtmlEditTextArea.this.rField != null) {
                ((ScrollableTextArea)RDHtmlEditTextArea.this.rField).setLocation(0, 0);
                ((ScrollableTextArea)RDHtmlEditTextArea.this.rField).setSize(parent.getSize());
            }
        }
    }
}

