/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.CateringServiceTypeConverter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.HandlingCostsConverter;
import ch.icit.pegasus.client.converter.ReportNameConverter;
import ch.icit.pegasus.client.converter.SalesPersonConverter;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextFieldFilter;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Dimension;

public class RDSearchComboBox
extends RDField<SearchComboBox, TextLabel> {
    private static final long serialVersionUID = 1L;
    private BoxSearchTypes currenttype;
    private SearchTextField2Listener listener;
    private String id;
    private Object[] additionals;

    public RDSearchComboBox(RDProvider provider, BoxSearchTypes type) {
        super(provider);
        this.currenttype = type;
    }

    public void setFilter(SearchTextFieldFilter filter) {
        ((SearchComboBox)this.getEditor()).setFilter(filter);
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.SearchComboBoxTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public SearchComboBox createEditor(Node<?> node) {
        SearchComboBox b = null;
        switch (this.currenttype) {
            case INVOICE: {
                b = SearchComboBoxFactory.getInvoiceSheetSearchBox(true, node);
                break;
            }
            case HANDLINGCOST: {
                b = SearchComboBoxFactory.getHandlingCostSearchField(true, node);
                break;
            }
            case STORESEARCH: {
                b = SearchComboBoxFactory.getStoreSearchField(true, node);
                break;
            }
            case DELIVERYSLIP: {
                b = SearchComboBoxFactory.getDeliverySlipLayoutSearchBox(true, node);
                break;
            }
            case PURCHASE_LABELS: {
                b = SearchComboBoxFactory.getPurchaseLabelsSearchBox(true, node);
                break;
            }
            case LABELLAYOUT: {
                b = SearchComboBoxFactory.getLabelLayoutSearchBox(true, node);
                break;
            }
            case CUSTOMER: {
                b = SearchComboBoxFactory.getCustomerSearchField(true, node);
                break;
            }
            case SPMLLABELLAYOUT: {
                b = SearchComboBoxFactory.getSpmlLabelLayoutSearchBox(true, node);
                break;
            }
            case STORE_POSITON_SEARCH: {
                b = SearchComboBoxFactory.getStorePositionSearchField(true, node);
                break;
            }
            case SALES_MAN: {
                b = SearchComboBoxFactory.getSalesPersonSearchField(true, node);
                break;
            }
            case CABIN_CLASS: {
                b = SearchComboBoxFactory.getCabinClassSearchField(true, node);
                break;
            }
            case CATERING_SERVICE_TYPE: {
                b = SearchComboBoxFactory.getCateringServiceTypeSearchField(true, node);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Search Box Type found");
            }
        }
        if (this.listener != null) {
            b.addSearchTextFieldListener(this.listener);
        }
        b.setAdditionalSearchField(this.additionals);
        b.setID(this.id);
        b.setEnabled(this.isEnabled);
        return b;
    }

    @Override
    public TextLabel createRenderer(Node<?> node) {
        TextLabel l = new TextLabel();
        switch (this.currenttype) {
            case INVOICE: {
                l.setViewConverter(ConverterRegistry.getConverter(ReportNameConverter.class));
                break;
            }
            case HANDLINGCOST: {
                l.setViewConverter(ConverterRegistry.getConverter(HandlingCostsConverter.class));
                break;
            }
            case STORESEARCH: {
                l.setViewConverter(ConverterRegistry.getConverter(StoreViewConverter.class));
                break;
            }
            case DELIVERYSLIP: 
            case LABELLAYOUT: 
            case SPMLLABELLAYOUT: {
                l.setViewConverter(ConverterRegistry.getConverter(ReportNameConverter.class));
                break;
            }
            case CUSTOMER: {
                l.setViewConverter(ConverterRegistry.getConverter(CustomerConverter.class));
                break;
            }
            case STORE_POSITON_SEARCH: {
                l.setViewConverter(ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
                break;
            }
            case SALES_MAN: {
                l.setViewConverter(ConverterRegistry.getConverter(SalesPersonConverter.class));
                break;
            }
            case CABIN_CLASS: {
                l.setViewConverter(ConverterRegistry.getConverter(CabinClassConverter.class));
                break;
            }
            case CATERING_SERVICE_TYPE: {
                l.setViewConverter(ConverterRegistry.getConverter(CateringServiceTypeConverter.class));
            }
        }
        l.setNode((Node)node);
        l.setReadOnlyTextField(true);
        l.setEnabled(this.isEnabled);
        return l;
    }

    public Object getText() {
        if (this.wField != null) {
            return ((SearchComboBox)this.wField).getText();
        }
        if (this.rField != null) {
            return ((TextLabel)this.rField).getText();
        }
        return "";
    }

    public boolean isItemSelected() {
        if (this.wField != null) {
            return ((SearchComboBox)this.wField).isItemSelected();
        }
        return this.rField != null && ((TextLabel)this.rField).getNode() != null && ((TextLabel)this.rField).getNode().getValue() != null;
    }

    public void addSearchTextFieldListener(SearchTextField2Listener storePositionSearchBox) {
        this.listener = storePositionSearchBox;
        if (this.wField != null) {
            ((SearchComboBox)this.wField).addSearchTextFieldListener(this.listener);
        }
    }

    public void removeSearchTextFieldListener(SearchTextField2Listener storePositionSearchBox) {
        if (this.wField != null) {
            ((SearchComboBox)this.wField).removeSearchTextFieldListener(storePositionSearchBox);
        }
    }

    public boolean isInnerComponent(Component c) {
        if (this.wField != null) {
            return ((SearchComboBox)this.wField).isInnerComponent(c);
        }
        return false;
    }

    public void setID(String id) {
        this.id = id;
        if (this.wField != null) {
            ((SearchComboBox)this.wField).setID(id);
        }
    }

    public void setAdditionalSearchField(Object[] o) {
        this.additionals = o;
        if (this.wField != null) {
            ((SearchComboBox)this.wField).setAdditionalSearchField(this.additionals);
        }
    }

    public void tryToSelectOne(boolean isProxy) {
        if (this.wField != null) {
            ((SearchComboBox)this.wField).tryToSelectOne(isProxy);
        }
    }

    public static enum BoxSearchTypes {
        HANDLINGCOST,
        STORESEARCH,
        DELIVERYSLIP,
        LABELLAYOUT,
        CUSTOMER,
        SPMLLABELLAYOUT,
        STORE_POSITON_SEARCH,
        SALES_MAN,
        PURCHASE_LABELS,
        INVOICE,
        CABIN_CLASS,
        CATERING_SERVICE_TYPE;

    }
}

