/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBoxConfiguration;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.StockCheckInOutGroupSearchTypeE;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class ConfigurableSearchTextField
extends SearchTextField {
    private static final long serialVersionUID = 1L;
    private int comboWidth = 22;
    private int hGap = 3;
    private boolean useUpperCase;
    private MiniComboBox comboBox;

    public ConfigurableSearchTextField() {
        this.setLayout(new Layout());
    }

    public boolean isUseUpperCase() {
        return this.useUpperCase;
    }

    public void setUseUpperCase(boolean useUpperCase) {
        this.useUpperCase = useUpperCase;
    }

    public void setMiniComboBox(MiniComboBox combo) {
        this.comboBox = combo;
        this.add(this.comboBox);
        this.comboBox.setVisible(true);
        this.comboBox.addItemListener(e -> {
            this.fireEvent();
            if (e.getItem() instanceof BasicArticleSearchTypeE) {
                this.changeTitleHeader((BasicArticleSearchTypeE)e.getItem());
            } else if (e.getItem() instanceof StockCheckInOutGroupSearchTypeE) {
                this.changeTitleHeader((StockCheckInOutGroupSearchTypeE)e.getItem());
            } else if (e.getItem() instanceof PurchaseOrderSearchTypeE) {
                this.changeTitleHeader((PurchaseOrderSearchTypeE)e.getItem());
            } else if (e.getItem() instanceof FlightSearchTypeE) {
                this.changeTitleHeader((FlightSearchTypeE)e.getItem());
            } else if (e.getItem() instanceof ProductSearchTypeE) {
                this.changeTitleHeader((ProductSearchTypeE)e.getItem());
            } else {
                throw new IllegalStateException("Current Mini ComboBox type is not supported: " + e.getItem());
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, this.comboWidth + this.hGap, 0, this.getWidth() - 2 * this.hGap - this.comboWidth, this.state);
        this.paintChildren(g2);
    }

    private <E extends Enum<E>> void changeTitleHeader(E selection) {
        if (this.getParent() instanceof TitledItem) {
            String t = "";
            MiniComboBoxConfiguration mcbc = new MiniComboBoxConfiguration(selection);
            t = mcbc.getAlternativeTitle(selection) != null ? mcbc.getAlternativeTitle(selection) : selection.toString();
            if (this.useUpperCase) {
                t = t.toUpperCase();
            }
            ((TitledItem)this.getParent()).setTitleText(t);
        }
    }

    public <E extends Enum<E>> E getSearchType() {
        return (E)((Enum)this.comboBox.getSelectedItem());
    }

    public MiniComboBox getCombobox() {
        return this.comboBox;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.comboBox != null) {
            this.comboBox.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        super.kill();
        if (this.comboBox != null) {
            this.comboBox.kill();
            this.comboBox = null;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (ConfigurableSearchTextField.this.isSearchActive) {
                tailing = (int)ConfigurableSearchTextField.this.loaderAnimation.getPreferredSize().getWidth() + 5;
                ConfigurableSearchTextField.this.loaderAnimation.setLocation(parent.getWidth() - tailing, (int)((double)parent.getHeight() - ConfigurableSearchTextField.this.loaderAnimation.getPreferredSize().getHeight()) / 2);
                ConfigurableSearchTextField.this.loaderAnimation.setSize(ConfigurableSearchTextField.this.loaderAnimation.getPreferredSize());
            }
            ConfigurableSearchTextField.this.comboBox.setLocation(0, 0);
            ConfigurableSearchTextField.this.comboBox.setSize(ConfigurableSearchTextField.this.comboWidth, ConfigurableSearchTextField.this.comboWidth);
            ConfigurableSearchTextField.this.textField.setLocation(ConfigurableSearchTextField.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 + ConfigurableSearchTextField.this.xOffset + ConfigurableSearchTextField.this.comboWidth + 2 * ConfigurableSearchTextField.this.hGap, 3);
            ConfigurableSearchTextField.this.textField.setSize(parent.getWidth() - ConfigurableSearchTextField.this.hGap - ConfigurableSearchTextField.this.comboWidth - (ConfigurableSearchTextField.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + ConfigurableSearchTextField.this.skin.getImageRight(Button.ButtonState.DISABLED).getWidth() + 2 + tailing - 15), ConfigurableSearchTextField.this.skin.getImageMiddle(Button.ButtonState.DISABLED).getHeight() - 6);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (ConfigurableSearchTextField.this.skin == null) {
                ConfigurableSearchTextField.this.skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
            }
            return new Dimension(ConfigurableSearchTextField.this.comboWidth + ConfigurableSearchTextField.this.hGap + ((ConfigurableSearchTextField)ConfigurableSearchTextField.this).textField.getPreferredSize().width, ConfigurableSearchTextField.this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
        }
    }
}

