/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.gui.utils.searchbox.StoreSearchTextFieldFilter;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StorePositionSearchBox
extends JPanelFadable
implements Focusable,
SearchTextField2Listener,
MutableFocusContainer,
NodeListener {
    private static final long serialVersionUID = 1L;
    private RDSearchComboBox storeSearch;
    private RDSearchComboBox positionSearch;
    private boolean dontSelectOne = false;
    private List<StorePositionSearchBoxListener> listeners = new ArrayList<StorePositionSearchBoxListener>();
    private MutableFocusContainerListener listener;
    private String id;
    private StoreEntryTypeE storeSearchType = StoreEntryTypeE.ALL;

    public StorePositionSearchBox() {
        this(false, null);
    }

    public StorePositionSearchBox(Node<StorePositionLight> storePosition) {
        this(false, null);
        this.setNode(storePosition);
    }

    public StorePositionSearchBox(boolean withAll, RDProvider provider) {
        this.setOpaque(false);
        this.storeSearch = new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.STORESEARCH);
        this.positionSearch = new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.STORE_POSITON_SEARCH);
        this.storeSearch.setNode((Node<?>)new DTOProxyNode());
        this.storeSearch.setProgress(1.0f);
        this.positionSearch.setProgress(1.0f);
        this.positionSearch.setEnabled(false);
        this.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.storeSearch);
        this.add(this.positionSearch);
    }

    public void setStoreFilter(StoreEntryTypeE filter) {
        this.storeSearchType = filter;
    }

    private void ensureStoreFilter() {
        Object[] o = new Object[]{this.storeSearchType};
        this.storeSearch.setAdditionalSearchField(o);
    }

    public void setFilter(TransactionType type) {
        this.storeSearch.setFilter(new StoreSearchTextFieldFilter(type));
    }

    public void addSearchListener(StorePositionSearchBoxListener l) {
        this.listeners.add(l);
    }

    public void removeSearchListener(StorePositionSearchBoxListener l) {
        this.listeners.remove(l);
    }

    private void fireEvent() {
        for (StorePositionSearchBoxListener l : this.listeners) {
            l.selectionChanged((SearchComboBox)this.storeSearch.getEditor(), (SearchTextField2)this.positionSearch.getEditor());
        }
    }

    public void setDontSelectNewOne(boolean b) {
        this.dontSelectOne = b;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.storeSearch.setEnabled(isEnabled);
        this.positionSearch.setEnabled(this.storeSearch.isItemSelected() & isEnabled);
    }

    public void setNode(Node<StorePositionLight> storePosition) {
        if (this.storeSearch.getNode() != null) {
            this.storeSearch.getNode().removeNodeListener((NodeListener)this);
        }
        if (this.positionSearch.getNode() != null) {
            this.positionSearch.getNode().removeNodeListener((NodeListener)this);
        }
        this.storeSearch.removeSearchTextFieldListener(this);
        this.positionSearch.removeSearchTextFieldListener(this);
        this.positionSearch.setNode(storePosition);
        if (this.storeSearch.getNode() == null) {
            this.storeSearch.setNode((Node<?>)new DTOProxyNode());
        }
        if (this.storeSearch.getNode() != null) {
            if (storePosition != null && storePosition.getValue() != null) {
                this.storeSearch.getNode().setValue(storePosition.getChildNamed(new String[]{"store"}).getValue(), System.currentTimeMillis());
                this.storeSearch.setNode(this.storeSearch.getNode());
            } else {
                this.storeSearch.setNode((Node<?>)new DTOProxyNode());
            }
        }
        if (storePosition != null) {
            this.ensureAdditionParams(storePosition.getChildNamed(new String[]{"store"}));
        }
        if (this.storeSearch.getNode() != null && this.storeSearch.getNode().getValue() != null) {
            this.positionSearch.setEnabled(true);
        }
        if (this.storeSearch.getNode() != null) {
            this.storeSearch.getNode().addNodeListener((NodeListener)this);
        }
        if (this.positionSearch.getNode() != null) {
            this.positionSearch.getNode().addNodeListener((NodeListener)this);
        }
        this.storeSearch.addSearchTextFieldListener(this);
        this.positionSearch.addSearchTextFieldListener(this);
        this.ensureStoreFilter();
    }

    public Node getNode() {
        return this.positionSearch.getNode();
    }

    public Node<StoreLight> getStoreNode() {
        return this.storeSearch.getNode();
    }

    public Node<StorePositionLight> getPositionNode() {
        return this.positionSearch.getNode();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.storeSearch);
        if (this.storeSearch.isItemSelected()) {
            CheckedListAdder.addToList(a, this.positionSearch);
        }
        return a;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.storeSearch.setVisibleContainer(pane);
        this.positionSearch.setVisibleContainer(pane);
    }

    public StoreEntryTypeE getStoreSearchType() {
        return this.storeSearchType;
    }

    public void setStoreSearchType(StoreEntryTypeE storeSearchType) {
        this.storeSearchType = storeSearchType;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (source == this.storeSearch.getEditor()) {
            StoreLight selectedStore = (StoreLight)n.getValue(StoreLight.class);
            if (selectedStore != null) {
                this.positionSearch.getNode().setValue((Object)selectedStore.getDefaultStorePosition(), 0L);
            } else {
                this.positionSearch.getNode().setValue(null, 0L);
            }
        }
        this.fireEvent();
    }

    private void ensureAdditionParams(Node n) {
        if (n != null && n.getValue() != null) {
            Object[] o = new Object[]{n.getValue(StoreLight.class)};
            this.positionSearch.setEnabled(true);
            this.positionSearch.setAdditionalSearchField(o);
            if (!this.dontSelectOne) {
                StoreLight l = (StoreLight)o[0];
                if (l != null && l.getDefaultStorePosition() != null) {
                    if (this.positionSearch.getNode().getValue() == null) {
                        this.positionSearch.getNode().setValue((Object)l.getDefaultStorePosition(), System.currentTimeMillis());
                        this.positionSearch.getNode().commitThis();
                    }
                } else {
                    this.positionSearch.getNode().setValue(null, System.currentTimeMillis());
                    boolean isProxy = false;
                    if (this.positionSearch.getNode() instanceof ProxyNode) {
                        isProxy = true;
                    }
                    this.positionSearch.tryToSelectOne(isProxy);
                }
            }
            if (this.listener != null) {
                this.listener.focusCycleChanged(this);
            }
        } else if (this.positionSearch.getNode().getValue() != null) {
            this.positionSearch.getNode().setValue(null, 0L);
        }
    }

    public boolean isContentValid() {
        return this.positionSearch.getNode().getValue() != null;
    }

    public void setValid() {
        this.storeSearch.setValid();
        this.positionSearch.setValid();
    }

    public void setOverrideName(String t) {
        this.storeSearch.setOverrideName(t);
        this.positionSearch.setOverrideName(t);
    }

    public void setInValid() {
        this.storeSearch.setInvalid();
        this.positionSearch.setInvalid();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.storeSearch.requestFocusInWindowNow();
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = null;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = listener;
    }

    public void resetValue() {
        this.storeSearch.getNode().setValue(null, 0L);
        this.positionSearch.getNode().setValue(null, 0L);
    }

    public void valueChanged(Node<?> node) {
        if (node == this.positionSearch.getNode()) {
            StorePositionLight sp = (StorePositionLight)node.getValue();
            if (sp != null) {
                this.storeSearch.getNode().setValue((Object)sp.getStore(), 0L);
            }
        } else {
            this.ensureAdditionParams(node);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isInnerComponent(Component c) {
        if (this.storeSearch.isInnerComponent(c)) {
            return true;
        }
        return this.positionSearch.isInnerComponent(c);
    }

    public void setInnerId(String id) {
        if (this.storeSearch != null) {
            this.storeSearch.setID(id);
        }
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = (parent.getWidth() - 5) / 2;
            StorePositionSearchBox.this.storeSearch.setLocation(0, (int)(((double)parent.getHeight() - StorePositionSearchBox.this.storeSearch.getPreferredSize().getHeight()) / 2.0));
            StorePositionSearchBox.this.storeSearch.setSize(w, (int)StorePositionSearchBox.this.storeSearch.getPreferredSize().getHeight());
            StorePositionSearchBox.this.positionSearch.setLocation(StorePositionSearchBox.this.storeSearch.getX() + StorePositionSearchBox.this.storeSearch.getWidth() + 5, (int)((double)parent.getHeight() - StorePositionSearchBox.this.positionSearch.getPreferredSize().getHeight()) / 2);
            StorePositionSearchBox.this.positionSearch.setSize(w, (int)StorePositionSearchBox.this.positionSearch.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)StorePositionSearchBox.this.positionSearch.getPreferredSize().getHeight();
            return new Dimension(0, h);
        }
    }
}

