/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox.objectbased;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.gui.utils.combobox.iconmapper.IconMapperController;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.DefaultListViewPopupInsertObjectBased;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchFieldSearchObjectBasedAlgorithm;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchTextFieldObjectBasedListener;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.JTextField2;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.FlexList;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SearchTextFieldObjectBased
extends JPanelFadable
implements LafListener,
FocusListener,
MouseListener,
Focusable,
InnerPopUpListener2,
KeyListener,
DocumentListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private List<SearchTextFieldObjectBasedListener> listeners = new ArrayList<SearchTextFieldObjectBasedListener>();
    private boolean selectAll;
    private ADTO doNotMerge;
    private boolean isAutoCompletion = false;
    private Point cachedTopParentPosition;
    private boolean isPersistable = true;
    private int cachedPopupOffset;
    private Converter defaultEntryConverter;
    private Converter defaultViewConverter;
    private ActivationAdapter defaultActivationAdapter;
    private Color defaultForeground;
    private Color deletedForeground;
    private SearchFieldSearchObjectBasedAlgorithm searchAlgorithm;
    protected AsynchronLoaderAnimation loaderAnimation;
    private Object[] additionalSearchFields;
    private InnerPopUp2 popUp;
    private Object selectableElement;
    protected int minWidth = 50;
    protected int xOffset = 0;
    private Class iconMapper;
    private boolean isWithALL;
    protected JTextField textField;
    protected Skin3Field skin;
    private String id;
    private String name;
    protected String defaultText;
    protected Button.ButtonState state = Button.ButtonState.UP;
    protected Button.ButtonState paintState = Button.ButtonState.UP;
    protected boolean isSearchActiv;
    private String nextPattern;
    protected VisibleContainer visibleContainer;
    protected boolean isDown;
    private boolean isTrySelectOne;
    private boolean isProxy;
    private boolean isFilterChain;
    private FlexList possibleValues;

    public SearchTextFieldObjectBased() {
        this.skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
        this.textField = new JTextField2();
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setOpaque(false);
        this.loaderAnimation = new AsynchronLoaderAnimation();
        this.loaderAnimation.getFader().setPermanent(true);
        this.loaderAnimation.setProgress(0.0f);
        this.getFader().setDisableWhenHidden(true);
        this.setProgress(1.0f);
        this.setOpaque(false);
        this.lafAttributeChanged("All attribues changed");
        this.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.textField.addFocusListener(this);
        this.setLayout(new SearchTextFieldLayout());
        this.add(this.textField);
        this.add(this.loaderAnimation);
    }

    public void setDoNotMergeDTO(ADTO doNotMerge) {
        this.doNotMerge = doNotMerge;
        if (this.searchAlgorithm != null) {
            this.searchAlgorithm.setNotMergeDTO(doNotMerge);
        }
    }

    public SearchTextFieldObjectBased(boolean isAutoComplitionActiv) {
        this();
        this.setAutoCompletion(isAutoComplitionActiv);
    }

    public void setIsFilterChain(boolean b) {
        this.isFilterChain = b;
    }

    public void setWithALL(boolean isWithALL) {
        this.isWithALL = isWithALL;
    }

    public void setDefaultActivationAdapter(ActivationAdapter adapter) {
        this.defaultActivationAdapter = adapter;
    }

    public void grapAutoFocus() {
        this.textField.requestFocusInWindow();
    }

    public void setSelectiveDelegation(Selectable element) {
        this.selectableElement = element;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public void setIconMapperClass(Class clazz) {
        this.iconMapper = clazz;
    }

    public void setSearchAlgorithm(SearchFieldSearchObjectBasedAlgorithm<?> algo) {
        this.searchAlgorithm = algo;
        if (this.doNotMerge != null) {
            this.searchAlgorithm.setNotMergeDTO(this.doNotMerge);
        }
    }

    public SearchFieldSearchObjectBasedAlgorithm<?> getSearchAlgorithm() {
        return this.searchAlgorithm;
    }

    public void setDefaultViewConverter(Converter con) {
        this.defaultViewConverter = con;
        if (this.textField != null) {
            return;
        }
    }

    public void setDefaultEntryConverter(Converter con) {
        this.defaultEntryConverter = con;
    }

    public void setAdditionalSearchField(Object[] o) {
        this.additionalSearchFields = o;
    }

    public void setValid() {
        if (this.state == Button.ButtonState.ERROR) {
            if (this.textField.hasFocus()) {
                this.setState(Button.ButtonState.FOCUS);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        }
    }

    public void setInValid() {
        this.setState(Button.ButtonState.ERROR);
    }

    public void addSearchTextFieldListener(SearchTextFieldObjectBasedListener l) {
        this.listeners.add(l);
    }

    public void removeSearchTextFieldListener(SearchTextFieldObjectBasedListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionEvent(Object selectedValue) {
        for (SearchTextFieldObjectBasedListener l : this.listeners) {
            l.newValueSelected(this, selectedValue);
        }
    }

    public boolean isInnerComponent(Component c) {
        if (c == this) {
            return true;
        }
        if (c == this.textField) {
            return true;
        }
        if (this.popUp != null) {
            if (c == this.popUp) {
                return true;
            }
            if (this.popUp.isInnerComponent(c)) {
                return true;
            }
        }
        return false;
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (this.possibleValues == null) {
            this.possibleValues = new FlexList();
        }
        this.searchAlgorithm.mergeValues(this.possibleValues, ((SearchResult)node.getValue()).getResults());
        if (this.nextPattern != null) {
            this.sendSearch(this.nextPattern);
            this.nextPattern = null;
        } else {
            this.stopAnimation();
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    protected void filterValueChanged(String t) {
        if (this.popUp == null) {
            if (this.textField.hasFocus() && t.length() >= 0) {
                this.openPopUp();
            } else if (t.length() >= 0) {
                int i = t.indexOf("-");
                if (i != -1) {
                    String tt = t.substring(0, i - 1);
                    this.sendSearch(tt);
                } else {
                    i = t.indexOf("(");
                    if (i != -1) {
                        String tt = t.substring(0, i).trim();
                        this.sendSearch(tt);
                    } else {
                        this.sendSearch(t);
                    }
                }
            }
        }
        if (this.popUp != null && this.searchAlgorithm != null) {
            if (this.isSearchActiv) {
                this.nextPattern = t;
            } else {
                this.startAnimation();
                this.sendSearch(t);
            }
        }
    }

    private void startAnimation() {
        if (!this.isSearchActiv) {
            this.isSearchActiv = true;
            if (this.loaderAnimation == null) {
                this.loaderAnimation = new AsynchronLoaderAnimation();
                this.loaderAnimation.getFader().setPermanent(true);
                this.isSearchActiv = true;
                this.loaderAnimation.setProgress(0.0f);
                this.add((Component)this.loaderAnimation, 0);
                this.invalidate();
                this.validate();
            }
            this.loaderAnimation.startAnimation();
        }
    }

    public void tryToSelectOne(boolean isProxy) {
        this.isTrySelectOne = true;
        this.isProxy = isProxy;
        this.sendSearch("");
    }

    private void stopAnimation() {
        if (this.isSearchActiv) {
            if (this.loaderAnimation != null) {
                this.loaderAnimation.stopAnimation();
            }
            this.isSearchActiv = false;
        }
    }

    private void sendSearch(final String t) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SearchResult n = null;
                ArrayList rets = new ArrayList();
                n = SearchTextFieldObjectBased.this.searchAlgorithm.search(null, SearchTextFieldObjectBased.this.searchAlgorithm.getSearchParameters(t, SearchTextFieldObjectBased.this.additionalSearchFields));
                ViewNode nn = new ViewNode("");
                if (n != null) {
                    nn.setValue(n, 0L);
                } else {
                    nn.setValue(rets, 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SearchTextFieldObjectBased.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    public void setAutoCompletion(boolean isActiv) {
        if (this.isAutoCompletion != isActiv) {
            if (!this.isAutoCompletion && isActiv) {
                this.textField.addKeyListener(this);
                this.textField.getDocument().addDocumentListener(this);
            } else if (this.isAutoCompletion && !isActiv) {
                this.textField.removeKeyListener(this);
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.isAutoCompletion = isActiv;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.popUp != null) {
                ((DefaultListViewPopupInsertObjectBased)this.popUp.getView()).selectUpperItem();
                e.consume();
            } else {
                this.filterValueChanged(this.getText());
            }
        } else if (e.getKeyCode() == 40) {
            if (this.popUp != null) {
                ((DefaultListViewPopupInsertObjectBased)this.popUp.getView()).selectLowerItem();
                e.consume();
            } else {
                this.filterValueChanged(this.getText());
            }
        } else if (e.getKeyCode() == 10 && this.popUp != null) {
            ((DefaultListViewPopupInsertObjectBased)this.popUp.getView()).createSelectionEvent();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.searchAlgorithm != null) {
            this.searchAlgorithm.setNotMergeDTO(null);
        }
        this.remove(this.textField);
        this.textField.removeMouseListener(this);
        this.textField.removeFocusListener(this);
        this.textField.getDocument().removeDocumentListener(this);
        this.textField = null;
        this.skin = null;
        this.removeMouseListener(this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.textField.setEnabled(isEnabled);
        if (!isEnabled) {
            this.setState(Button.ButtonState.DISABLED);
        } else {
            this.setState(Button.ButtonState.UP);
        }
        this.repaint(32L);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.paintState);
        this.paintChildren(g2);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
    }

    private void deletedItemSelected(boolean isDeleted) {
        if (isDeleted) {
            this.textField.setForeground(this.deletedForeground);
        } else {
            this.textField.setForeground(this.defaultForeground);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.popUp != null) {
            this.popUp = null;
            if (xargs != null && xargs.length > 0) {
                Object n = xargs[0];
                if (n != null) {
                    this.fireSelectionEvent(n);
                    this.selectableElement = n;
                    this.textField.getDocument().removeDocumentListener(this);
                    this.setText((String)this.defaultViewConverter.convert(this.selectableElement, null, new Object[0]));
                    this.textField.getDocument().addDocumentListener(this);
                }
            } else {
                this.textField.getDocument().removeDocumentListener(this);
                this.setText("");
                this.textField.getDocument().addDocumentListener(this);
            }
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_foreground")));
        this.textField.setDisabledTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_size"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_type")));
        this.setCaretColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_caret_color")));
        this.setSelectedTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_selected_text_color")));
        this.setSelectionColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_selection_color")));
        this.defaultForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_foreground"));
        this.deletedForeground = Color.red;
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setCaretColor(Color cc) {
        this.textField.setCaretColor(cc);
    }

    public void setSelectedTextColor(Color c) {
        this.textField.setSelectedTextColor(c);
    }

    public void setSelectionColor(Color c) {
        this.textField.setSelectionColor(c);
    }

    public void setSelectionStart(int selectionStart) {
        this.textField.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.textField.setSelectionEnd(selectionEnd);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textField.getDocument().removeDocumentListener(listener);
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    protected void setState(Button.ButtonState state) {
        this.paintState = state;
        this.state = state;
        this.repaint(32L);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.ERROR) {
            SelectionManager.getSelectionManager().focusGained(this);
            if (this.selectAll) {
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(this.textField.getText().length());
            }
            this.setState(Button.ButtonState.FOCUS);
            if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    private void openPopUp() {
        if (this.popUp == null) {
            this.popUp = InnerPopUp2.getInnerPopUp(PopupType.SEARCHBOX);
        }
        if (this.possibleValues == null) {
            this.possibleValues = new FlexList();
        }
        DefaultListViewPopupInsertObjectBased pp = new DefaultListViewPopupInsertObjectBased(this.possibleValues, this.defaultEntryConverter, this);
        pp.setWithALL(this.isWithALL);
        pp.setAlwaysSelected(true);
        pp.setActivationAdapter(this.defaultActivationAdapter);
        if (this.iconMapper != null) {
            pp.setIconMapper(IconMapperController.getIconMapper(this.iconMapper));
        }
        this.popUp.setView(pp);
        this.popUp.setAttributes(this, false, false, "");
        int dw = this.getWidth() - 30;
        if (dw < 200) {
            dw = 200;
        }
        Container top = this;
        while (top.getParent() != null) {
            top = top.getParent();
        }
        int aMaxWidth = 500;
        int aMinWidth = 300;
        Point t = SwingUtilities.convertPoint(this, new Point(this.skin.getImageLeft(this.state).getWidth() + 2, 2), top);
        int dx = -(this.skin.getImageLeft(this.state).getWidth() + 2);
        dw = (this.skin.getImageLeft(this.state).getWidth() + 2) * 2 + this.getWidth();
        if (t.getX() + (double)aMaxWidth < (double)top.getWidth()) {
            dw = aMaxWidth;
        } else {
            int d = (int)((double)top.getWidth() - (t.getX() + (double)aMaxWidth));
            if (t.getX() + (double)d > 0.0) {
                dx += d;
                dx -= 10;
                dw = aMaxWidth;
            } else {
                dw = aMinWidth;
            }
        }
        this.cachedTopParentPosition = new Point(dx, 2);
        this.popUp.showPopUp(dx, 2, dw, 200, this, this, PopupType.SEARCHBOX);
        this.popUp.setDoRequestFocus(false);
    }

    public int getCachedPopupOffset() {
        return this.cachedPopupOffset;
    }

    public Point getCachedTopParentPoint() {
        return this.cachedTopParentPosition;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            int offset = this.textField.getScrollOffset();
            this.setState(Button.ButtonState.UP);
            if (this.popUp != null) {
                this.popUp.hidePopUp(new Object[0]);
            }
            this.textField.scrollRectToVisible(new Rectangle(-offset, 0, this.textField.getWidth(), this.textField.getHeight()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this)) {
            if (this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
                this.setState(Button.ButtonState.OVER);
            }
            this.setCursor(new Cursor(2));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            if (this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
                this.setState(Button.ButtonState.UP);
            }
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            Button.pressedItem = this;
            this.isDown = true;
            if (e.getSource() == this) {
                this.textField.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = false;
            Button.pressedItem = null;
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.textField);
        return a;
    }

    public boolean isItemSelected() {
        return this.selectableElement != null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.textField.requestFocusInWindow();
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    private class SearchTextFieldLayout
    extends DefaultLayout {
        private SearchTextFieldLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (SearchTextFieldObjectBased.this.isSearchActiv) {
                SearchTextFieldObjectBased.this.loaderAnimation.setLocation((int)((double)SearchTextFieldObjectBased.this.getWidth() - (SearchTextFieldObjectBased.this.loaderAnimation.getPreferredSize().getWidth() + 3.0)), (int)(((double)parent.getHeight() - SearchTextFieldObjectBased.this.loaderAnimation.getPreferredSize().getHeight()) / 2.0));
                SearchTextFieldObjectBased.this.loaderAnimation.setSize(SearchTextFieldObjectBased.this.loaderAnimation.getPreferredSize());
                tailing = SearchTextFieldObjectBased.this.loaderAnimation.getWidth() + 5;
            }
            SearchTextFieldObjectBased.this.textField.setLocation(SearchTextFieldObjectBased.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 + SearchTextFieldObjectBased.this.xOffset, 3);
            SearchTextFieldObjectBased.this.textField.setSize(parent.getWidth() - (SearchTextFieldObjectBased.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + SearchTextFieldObjectBased.this.skin.getImageRight(Button.ButtonState.DISABLED).getWidth() + 2 + tailing - 15), SearchTextFieldObjectBased.this.skin.getImageMiddle(Button.ButtonState.DISABLED).getHeight() - 6);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(SearchTextFieldObjectBased.this.minWidth, SearchTextFieldObjectBased.this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
        }
    }
}

