/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.TableRowLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ArticleChargeSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ChargeViewPageableTable
extends PageableTable2 {
    private BasicArticleLight article;

    public ChargeViewPageableTable() {
        super("", false, true, true);
        this.setTitleText(Words.CHARGES);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, (Enum<?>)ArticleChargeSearchConfiguration.ARTICLE_CHARGE_COLUMN.NUMBER, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.35);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.65);
        this.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
    }

    public void setArticle(BasicArticleLight article) {
        this.article = article;
    }

    @Override
    public void fillFilterChain() {
    }

    @Override
    public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
        ArticleChargeSearchConfiguration conf = new ArticleChargeSearchConfiguration();
        if (this.article != null) {
            conf.setArticle((BasicArticleReference)this.article);
            conf.setSortColumn((Enum)ArticleChargeSearchConfiguration.ARTICLE_CHARGE_COLUMN.NUMBER);
            conf.setSortDirection(SortDirection.DESCENDING);
        }
        return conf;
    }

    @Override
    public SearchAlgorithm getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ArticleChargeSearchAlgorithm.class);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel date;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.setLayout(new InnerLayout());
            this.number = new TextLabel(m.getNode().getChildNamed(ArticleChargeComplete_.number));
            this.date = new TextLabel(m.getNode().getChildNamed(ArticleChargeComplete_.creationDate), ConverterRegistry.getConverter(DateConverter.class));
            this.add(this.number);
            this.add(this.date);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.number.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.number.kill();
            this.number = null;
            this.date.kill();
            this.date = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        private class InnerLayout
        extends TableRowLayout {
            private InnerLayout() {
            }

            @Override
            public List<JComponent> getComponentsOrder() {
                ArrayList<JComponent> components = new ArrayList<JComponent>();
                components.add(TableRowImpl.this.number);
                components.add(TableRowImpl.this.date);
                return components;
            }

            @Override
            public Table2RowPanel getTableRowPanel() {
                return TableRowImpl.this;
            }
        }
    }
}

