/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.SupplierPriceOverviewConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class CheapestSupplierTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private BasicArticleComplete article;
    private Node orderNode;

    public CheapestSupplierTable() {
        super(false, Words.ADD, true, false, Words.SUPPLIERS);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 50, 50, 50));
        int td = 2 * this.getCellPadding() + TableColumnInfo.priceColumnWidth;
        columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", td, td, td));
        columns.add(new TableColumnInfo(Words.ORDER_INFO, null, null, null, "", 50, 50, 50));
        columns.add(new TableColumnInfo(Words.COST_INFO, null, null, null, "", 50, 50, 50));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.25);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setDefaultRowHeight(21);
    }

    public BasicArticleComplete getArticle() {
        return this.article;
    }

    public void setArticle(BasicArticleComplete article) {
        this.article = article;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel supplier;
        private TextLabel price;
        private TextLabel orderInfo;
        private TextLabel costInfo;
        private TextLabel articleNumber;
        private PriceComplete selectedPrice;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.supplier = new TextLabel(m.getNode().getChildNamed(SupplierConditionComplete_.supplier), ConverterRegistry.getConverter(SupplierConverter.class));
            this.price = new TextLabel(m.getNode(), ConverterRegistry.getConverter(SupplierPriceOverviewConverter.class));
            this.orderInfo = new TextLabel();
            this.costInfo = new TextLabel();
            this.articleNumber = new TextLabel(m.getNode().getChildNamed(SupplierConditionComplete_.articleNumber));
            this.setLayout(new Layout3());
            this.add(this.supplier);
            this.add(this.price);
            this.add(this.orderInfo);
            this.add(this.costInfo);
            this.add(this.articleNumber);
            this.updateData();
        }

        private void updateData() {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    try {
                        TableRowImpl.this.updatePriceText();
                    }
                    catch (ClientServerCallException e1) {
                        TableRowImpl.this.setPriceText("-");
                    }
                    TableRowImpl.this.updateOrderInfoText();
                    try {
                        TableRowImpl.this.updateCostInfoText();
                    }
                    catch (ClientServerCallException e) {
                        TableRowImpl.this.setCostText("-");
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            CheapestSupplierTable.this.resortTable();
                        }

                        public void errorOccurred(ClientException exception) {
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }

        private void updatePriceText() throws ClientServerCallException {
            SupplierConditionComplete sc = (SupplierConditionComplete)this.model.getNode().getValue();
            String t = "";
            if (sc != null) {
                SupplierLight injectedSupplier = sc.getSupplier();
                Date orderDate = new Date(System.currentTimeMillis());
                QuantityComplete amount = new QuantityComplete(Double.valueOf(0.0), CheapestSupplierTable.this.article.getPriceUnit());
                try {
                    PriceAndUnitComplete a = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)CheapestSupplierTable.this.article, (SupplierReference)injectedSupplier, new DateWrapper(orderDate), amount, Boolean.valueOf(true), sc.getCategoryTaxZone(), sc);
                    if (a != null) {
                        t = a.getPrice().getFormattedPrice() + " " + a.getPrice().getCurrency().getCode() + "/" + a.getUnit().getShortName();
                        this.selectedPrice = a.getPrice();
                    } else {
                        t = "No Contract found";
                        this.selectedPrice = null;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    t = "No Contract found";
                    this.selectedPrice = null;
                }
            }
            this.setPriceText(t);
        }

        private void updateOrderInfoText() {
            SupplierConditionComplete sc = (SupplierConditionComplete)this.model.getNode().getValue();
            String t = "";
            if (sc != null) {
                FormattedDoubleConverter2Decimals c = (FormattedDoubleConverter2Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
                if (sc.getCategoryTaxZone() != null) {
                    t = t + sc.getCategoryTaxZone().getCode() + ", ";
                }
                if (sc.getCategoryComment() != null) {
                    t = t + sc.getCategoryComment() + ", ";
                }
                t = t + "I: " + c.convert((Number)sc.getMinOrderAmount(), null, new Object[0]) + " ";
                UnitComplete unit = sc.getMinOrderAmountUnit() != null ? sc.getMinOrderAmountUnit() : sc.getOrderUnit();
                t = t + unit.getShortName() + ", ";
                t = t + "D: " + sc.getDeliveryTime() + " days";
            }
            this.setOrderText(t);
        }

        private void updateCostInfoText() throws ClientServerCallException {
            SupplierConditionComplete sc = (SupplierConditionComplete)this.model.getNode().getValue();
            String t = "Delivery Costs: ";
            if (sc != null) {
                SupplierComplete supplier = (SupplierComplete)this.model.getNode().getChildNamed(SupplierConditionComplete_.supplier).getValue(SupplierComplete.class);
                if (supplier == null) {
                    SupplierLight sL = (SupplierLight)this.model.getNode().getChildNamed(SupplierConditionComplete_.supplier).getValue(SupplierLight.class);
                    if (sL == null) {
                        t = t + "NONE";
                        this.setCostText(t);
                        return;
                    }
                    supplier = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier(new SupplierReference(sL.getId())).getValue();
                    this.model.getNode().getChildNamed(SupplierConditionComplete_.supplier).setValue((Object)supplier, 0L);
                }
                if (supplier.getCostType() != null) {
                    switch (supplier.getCostType()) {
                        case FIX: {
                            PriceComplete ds = new PriceComplete(supplier.getDeliveryCost());
                            t = t + ds.getFormattedPrice() + " " + ds.getCurrency().getCode();
                            break;
                        }
                        case MINAMOUNT: {
                            t = t + "Min:" + supplier.getMinOrderValue().getFormattedPrice() + " " + supplier.getMinOrderValue().getCurrency().getCode();
                            t = t + ", Cost: " + supplier.getDeliveryCost().getFormattedPrice() + " " + supplier.getDeliveryCost().getCurrency().getCode();
                            break;
                        }
                        case NONE: {
                            t = t + "NONE";
                            break;
                        }
                    }
                }
            } else {
                t = t + "-";
            }
            this.setCostText(t);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.supplier.kill();
            this.price.kill();
            this.orderInfo.kill();
            this.costInfo.kill();
            this.articleNumber.kill();
            this.supplier = null;
            this.price = null;
            this.orderInfo = null;
            this.costInfo = null;
            this.articleNumber = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.selectedPrice;
        }

        private void setCostText(String text) {
            if (this.costInfo != null) {
                this.costInfo.setText(text);
            }
        }

        private void setPriceText(String text) {
            if (this.price != null) {
                this.price.setText(text);
            }
        }

        private void setOrderText(String text) {
            if (this.orderInfo != null) {
                this.orderInfo.setText(text);
            }
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.supplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.supplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplier.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.articleNumber.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleNumber.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.articleNumber.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.orderInfo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orderInfo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.orderInfo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.orderInfo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.costInfo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costInfo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costInfo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costInfo.getPreferredSize().getHeight());
            }
        }
    }
}

