/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.supply.CurrencyExchangeRateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CurrencyExchangeRateComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CurrencyExchangeRateEditTable
extends Table2 {
    private final RDProvider provider;
    private final Node node;

    public CurrencyExchangeRateEditTable(RDProvider provider, Node node) {
        super(true, Words.TABLE_ADD, false, false);
        this.provider = provider;
        this.node = node;
        this.setProvider(provider);
        this.setUseWriteAccessRight(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CurrencyExchangeRateEditTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CurrencyExchangeRateComplete e = new CurrencyExchangeRateComplete();
                e.setClientOId(Long.valueOf(ADTO.getNextId()));
                e.setExchangeRate(Double.valueOf(0.0));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false);
                CurrencyExchangeRateEditTable.this.getModel().getNode().addChild(n, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CURRENCY, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.EXCHANGE_RATE, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        int tw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox currency;
        private TextField rate;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.currency = new ComboBox(m.getNode().getChildNamed(CurrencyExchangeRateComplete_.currency), NodeToolkit.getAffixList(CurrencyComplete.class), ConverterRegistry.getConverter(CurrencyConverter.class), true);
            this.rate = new NumberTextField(m.getNode().getChildNamed(CurrencyExchangeRateComplete_.exchangeRate), TextFieldType.DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.currency);
            this.add(this.rate);
            this.add(this.delete);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (this.currency == c) {
                return true;
            }
            if (this.currency.getCurrentPopUp() != null) {
                for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.currency.getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.rate == c) {
                return true;
            }
            if (this.delete == c) {
                return true;
            }
            return super.isInnerComponent(c);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.rate.getFocusComponents();
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(CurrencyExchangeRateComplete_.currency).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(CurrencyExchangeRateComplete_.exchangeRate).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean b = CurrencyExchangeRateEditTable.this.provider.isWritable("exchangeRates");
            this.currency.setEnabled(isEnabled && b);
            this.rate.setEnabled(isEnabled && b);
            this.delete.setEnabled(isEnabled && b);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.currency.kill();
            this.currency = null;
            this.rate.kill();
            this.rate = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.currency.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.currency.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.currency.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.currency.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.rate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.rate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

