/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.AllergenInfoSheetCustomerConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.supply.AllergenInfoSheetCustomerConfigurationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomerAllergenInfoConfigurationTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public CustomerAllergenInfoConfigurationTable() {
        this(true);
    }

    public CustomerAllergenInfoConfigurationTable(boolean background) {
        super(true, Words.ADD, background, background, Words.ALLERGEN_INFO_CONFIGURATION);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomerAllergenInfoConfigurationTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                AllergenInfoSheetCustomerConfigurationComplete c = new AllergenInfoSheetCustomerConfigurationComplete();
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                c.setAllergenCodeIndexCount(Integer.valueOf(0));
                c.setCabinClassCount(Integer.valueOf(1));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                CustomerAllergenInfoConfigurationTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.HAUL_TYPE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.PAX_CLASS, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 80, 80, 80));
        int tw = 2 * this.getCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo(Words.SHOW_INDEX, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.INDEX_COUNT, null, null, null, "", 80, 80, 80));
        tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox haulType;
        private ComboBox cabinClass;
        private TextField count;
        private CheckBox showIndex;
        private TextField indexCount;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.haulType = new ComboBox(m.getNode().getChildNamed(AllergenInfoSheetCustomerConfigurationComplete_.haulType), NodeToolkit.getAffixList(HaulTypeComplete.class), ConverterRegistry.getConverter(HaulTypeConverter.class), true);
            this.cabinClass = new ComboBox(m.getNode().getChildNamed(AllergenInfoSheetCustomerConfigurationComplete_.cabinClass), NodeToolkit.getAffixList(CabinClassComplete.class), ConverterRegistry.getConverter(CabinClassConverter.class), true);
            this.count = new TextField(m.getNode().getChildNamed(AllergenInfoSheetCustomerConfigurationComplete_.cabinClassCount), TextFieldType.INT);
            this.showIndex = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(AllergenInfoSheetCustomerConfigurationComplete_.printAllergenCodeIndexAfterEachClass));
            this.showIndex.addButtonListener(this);
            this.indexCount = new TextField(m.getNode().getChildNamed(AllergenInfoSheetCustomerConfigurationComplete_.allergenCodeIndexCount), TextFieldType.INT);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.haulType);
            this.add(this.cabinClass);
            this.add(this.count);
            this.add(this.showIndex);
            this.add(this.indexCount);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.haulType.setEnabled(isEnabled);
            this.cabinClass.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            this.showIndex.setEnabled(isEnabled);
            this.indexCount.setEnabled(isEnabled && this.showIndex.isChecked());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.haulType.kill();
            this.cabinClass.kill();
            this.count.kill();
            this.showIndex.kill();
            this.indexCount.kill();
            this.delete.kill();
            this.haulType = null;
            this.cabinClass = null;
            this.count = null;
            this.showIndex = null;
            this.indexCount = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.haulType);
            CheckedListAdder.addToList(a, this.cabinClass);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.showIndex);
            CheckedListAdder.addToList(a, this.indexCount);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.haulType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.haulType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.haulType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.haulType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.showIndex.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.showIndex.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.showIndex.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.showIndex.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.indexCount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.indexCount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.indexCount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.indexCount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

