/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete_;
import ch.icit.pegasus.server.core.dtos.supply.DeliverySlipBoxConfigComplete;
import ch.icit.pegasus.server.core.dtos.supply.DeliverySlipBoxConfigComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeliverySlipConfigurationTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public DeliverySlipConfigurationTable() {
        super(true, Words.ADD, true, true, Words.CONFIGURATION);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                DeliverySlipConfigurationTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DeliverySlipBoxConfigComplete b = new DeliverySlipBoxConfigComplete();
                b.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)b, true, false);
                DeliverySlipConfigurationTable.this.getModel().getNode().addChild(node, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 120, 120, 120));
        int tx = 2 * this.getCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo(Words.SHOW_CHECKBOX, null, null, null, "", tx, tx, tx));
        columns.add(new TableColumnInfo(Words.CABIN_CLASSES, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.6);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField name;
        private List<TitledItem<CheckBox>> cabinClasses;
        private CheckBox withoutClasses;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.cabinClasses = new ArrayList<TitledItem<CheckBox>>();
            this.setLayout(new Layout3());
            this.name = new TextField(m.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.name));
            this.add(this.name);
            this.withoutClasses = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.useWithoutClass));
            Iterator it = NodeToolkit.getAffixList(CabinClassComplete.class).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!Boolean.TRUE.equals(n.getChildNamed(CabinClassComplete_.showSeparatelyOnReports).getValue())) continue;
                TitledItem<CheckBox> checkBox = new TitledItem<CheckBox>(new CheckBox(), ((CabinClassComplete)n.getValue()).getCode(), TitledItem.TitledItemOrientation.WEST);
                checkBox.getElement().setUserObject(n);
                checkBox.setIgnorePrefWidth(true);
                checkBox.getElement().addButtonListener(this);
                Iterator it2 = m.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.usedClasses).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node ncc = (Node)it2.next();
                    if (!ncc.getValue().equals(n.getValue())) continue;
                    checkBox.getElement().setChecked(true);
                }
                this.cabinClasses.add(checkBox);
                this.add(checkBox);
            }
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.add(this.delete);
            this.add(this.withoutClasses);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                CheckBox b = (CheckBox)source;
                Node cc = (Node)source.getUserObject();
                if (b.isChecked()) {
                    this.model.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.usedClasses).addChild(INodeCreator.getDefaultImpl().getNode4DTO(cc.getValue(), true, true), 0L);
                } else {
                    Iterator it = this.model.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.usedClasses).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (!n.getValue().equals(cc.getValue())) continue;
                        this.model.getNode().getChildNamed(DeliverySlipBoxConfigComplete_.usedClasses).removeChild(n, 0L);
                    }
                }
            }
            this.setEnabled(this.isEnabled());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            for (TitledItem<CheckBox> c : this.cabinClasses) {
                c.kill();
            }
            this.cabinClasses.clear();
            this.name.kill();
            this.delete.kill();
            this.withoutClasses.kill();
            this.name = null;
            this.delete = null;
            this.withoutClasses = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.withoutClasses);
            for (TitledItem<CheckBox> c : this.cabinClasses) {
                CheckedListAdder.addToList(a, c);
            }
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.withoutClasses.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.withoutClasses.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.withoutClasses.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.withoutClasses.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                int cx = currentX;
                for (TitledItem cc : TableRowImpl.this.cabinClasses) {
                    cc.setLocation(cx + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - cc.getPreferredSize().getHeight()) / 2.0));
                    cc.setSize(cc.getPreferredSize());
                    cx += cc.getWidth() + TableRowImpl.this.getCellPadding();
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

