/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissCabinMappingComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissCabinMappingComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EdelweissClassMappingTable
extends Table2 {
    public EdelweissClassMappingTable() {
        super(true, Words.ADD, true, true);
        this.setTitleText("Pax Mapping");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                EdelweissClassMappingTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                EdelweissCabinMappingComplete e = new EdelweissCabinMappingComplete();
                e.setClientOId(Long.valueOf(ADTO.getNextId()));
                EdelweissClassMappingTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false), 0L);
                EdelweissClassMappingTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CLASS, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.LIME_FLIGHT_KEY, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode((Node)new ListNode());
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox clazz;
        private TextField limeFlightKey;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
            this.clazz = new ComboBox(this.model.getNode().getChildNamed(EdelweissCabinMappingComplete_.cabinClass), NodeToolkit.getAffixList(CabinClassComplete.class), ConverterRegistry.getConverter(CabinClassConverter.class));
            this.limeFlightKey = new TextField(this.model.getNode().getChildNamed(EdelweissCabinMappingComplete_.limeFlightKey));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.clazz);
            this.add(this.limeFlightKey);
            this.add(this.delete);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.clazz);
            CheckedListAdder.addToList(focusList, this.limeFlightKey);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.clazz.setEnabled(isEnabled);
            this.limeFlightKey.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.clazz.kill();
            this.clazz = null;
            this.limeFlightKey.kill();
            this.limeFlightKey = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.clazz.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.clazz.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.clazz.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.clazz.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.limeFlightKey.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.limeFlightKey.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.limeFlightKey.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.limeFlightKey.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

